//*************************************************************************************
// file 		: SQ7653_SIO_Master.c
// version		: V1.0 2020/07/17
// brief		: SIO0_Master related functions
// note			: SIO0_Master related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"
unsigned char tmpChar;


//*********************************************************************
// name			: SIO0_init()
// brief		: SIO0 initialization
// note			: set SIO0 pins and transfer mode	  
//*********************************************************************

void SIO0_Init(viod){

//--- Master mode (SIOCKS = 000 to 110)-------------------
//====== SIO0 pin configuration initialization ======


//--- SI0(P4.0) ; SO0(P3.7) ; SCK0(3.6)-------
	P4CFGCR |= 0x81;  				    	  // set P4.0 to SI	1 000 0001
	P3CFGCR |= 0xF1;						  // set P3.7 to SO	1 111 0001
	P3CFGCR |= 0xE1;						  // set P3.6 to SCLK	1 110 0001


	PCKEN2_SIO0 = 1;	            	  	  // enable SIO0
    
	SIO0CR1_SIOEDG  = 0;                 	  // set transfer edge to receive data at a rising edge and transmit data at a falling edge
    //SIO0CR1_SIOCKS  = 0x00;                 // set serial clock to fcgck/2^9
    SIO0CR1_SIOCKS  = SIO_CKS_DIV16;          // set serial clock to fcgck/16
    
    SIO0CR1_SIODIR  = 1;                 	  // set transfer format to MSB first
    SIO0CR1_SIOM    = 0x03;              	  // set transfer mode to 8-bit transmit and receive mode
    //SIO0CR1 = 0x0B|(SIO_CKS_DIV512<<4);
}



//*********************************************************************
// name			: SIO0_Start()
// brief		: start SIO
// note			:
//*********************************************************************
void SIO0_Start(viod){
	P1DO_P7 = 0;							  // simulate SS pin in SPI interface to output L

	SIO0CR1_SIOS  = 1;               	  	  // start SIO0
	SIO0CR2_SIOEN = 1;              	  	  // enable SIO0
}


//*********************************************************************
// name			: SIO0_Stop()
// brief		: stop SIO0
// note			:
//*********************************************************************
void SIO0_Stop(void){
	SIO0CR1_SIOS  = 0;               	  	  // SIO0 stops operation 
	SIO0CR2_SIOEN = 0;					  	  // disable SIO0

	P1DO_P7 = 1;							  // simulate SS pin in SPI interface to output H
}


//*********************************************************************
// name			: SIO0_IntEnable()
// brief		: enable SIO0 interrupt
// note			:
//*********************************************************************
void SIO0_IntEnable(void){
	__ASM("DI");							  // disable all maskable interrupts
	
	IER_SIO0_IRQ = 1;						  // enable SIO0 interrupt
	
	__ASM("EI");							  // enable all maskable interrupts
}



//*********************************************************************
// name			: SIO0_ByteSend()
// brief		: SO transmits data
// note			: 
//*********************************************************************
void SIO_ByteSend(unsigned char txdata){
	while(SIO0SR_TBFL == 1);      			  // wait for transmit buffer to be empty
		SIO0BUF = txdata;           		  // put data to transmit buffer
		//__ASM("NOP");						  // no operation
		//  CLR_WDT;                		  // clear the watchdog timer 
        
		SIO0CR1_SIOS = 1;       			  // start SIO
	while(SIO0SR_SEF == 1);           		  // wait for shift operation not in progress   
        tmpChar = SIO0BUF;				      // read data from slave	
}


//*********************************************************************
// name			: SIO_ByteRead()
// brief		: SI receives data
// note			:
//*********************************************************************
unsigned char SIO_ByteRead(){
unsigned char r_data;

		while(SIO0SR_TBFL == 1);	// wait for transmit buffer to be empty
		SIO0BUF = 0xff;				// put dummy data to buffer to generate clock for slave
		tmpChar = SIO0BUF;			// read data from slave
		while(SIO0SR_RENDB == 0);	// wait for no more received data since the last receive data was read out
		r_data = SIO0BUF;		    // read data
	return r_data;
}


//*********************************************************************
// name			: SIO_ReservedStopWait()
// brief		: wait for SIO stop
// note			: make sure transfer not in progress
//*********************************************************************
void SIO_ReservedStopWait(void){

    SIO0CR1_SIOS = 0;                         // SIOS=0: reserved stop

    while( SIO0SR_SIOF == 1 ){                // SIOF: wait for SIO stop(SIOF=0)    
    //  __ASM("NOP");                         // no operation
    }
}


//*********************************************************************
// name			: __interrupt SIO0_IRQ(void)
// brief		: SIO0 interrupt service routine
// note			: 
//*********************************************************************
void __interrupt SIO0_IRQ(void){	
    __ASM("NOP");						     // no operation



}



