//*************************************************************************************
// file			: SQ7653_startup_LVD_SWRST.c
// version		: V1.0 2020/07/17
// brief		: startup program
// note			: 
//**************************************************************************************

/*
 * --------------------------------------------------------------------------
 *   HEADER INCLUDE DEFINITIONS
 * --------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "SQ7653_SFR.h"


/*
 * --------------------------------------------------------------------------
 *   MACRO DEFINITIONS
 * --------------------------------------------------------------------------
 */
 
extern unsigned int  _BaseSP;				/*the starting address of the stacking pointer is generally defined as the the last address of the SRAM*/
extern unsigned int  _RAM_Top;				/*the first address of SRAM*/
extern unsigned int  _RAM_End;				/*the last address of the SRAM*/

extern unsigned char _TDataAddr[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _TDataOrg[];			/* for tiny_data initialize, defined in link command file  */
extern unsigned int  _TDataSize;			/* for tiny_data initialize, defined in link command file  */
extern unsigned char _NDataAddr[];			/* for near_data initialize, defined in link command file  */
extern unsigned char _NDataOrg[];			/* for near_data initialize, defined in link command file  */
extern unsigned int  _NDataSize;			/* for near_data initialize, defined in link command file  */

/*
 * --------------------------------------------------------------------------
 *   FUNCTION DECLARATIONS
 * --------------------------------------------------------------------------
 */

/*#**************************************************************************#*/

/*
 ******************************************************************************
 * NAME				:STARTUP
 *-----------------------------------------------------------------------------
 * DESCRIPTION		:startup routine
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ******************************************************************************
 */
void STARTUP( void )
{
	unsigned int VDD_Lower_DTVT_CNT;		  // number of consecutive times that VDD is below the detection voltage
	unsigned int i,j;
	
	//CLKCR0 = 0x09;						  // for SQ7653 PLL48M divide by 2, For Engineer Sample. 
    CLKCR0 = 0x01;						      // for SQ7653 PLL24M divide by 1, For General.
	VDD_Lower_DTVT_CNT = 0;				  	  // initialize VDD_Lower_DTVT_CNT to 0
//=============================================================================
//  Set CLKCR0	2019-06/12 JH ADD
//=============================================================================
//  ============================================
//  system clock source selectionCLKCR0_SCKSRC                                 
//  ============================================
	
	CLKCR0_SCKSEL = 0x01;			// fsck = 24MHz	 (PLL) //Default
//	CLKCR0_SCKSEL = 0x02;			// fsck = 32KHz	 (LIRC) internal low-speed system clock
//	CLKCR0_SCKSEL = 0x03;			// fsck = 16MHz	 (HXTAL)external high-speed system clock
//	CLKCR0_SCKSEL = 0x06;			// fsck = 32768Hz(LXTAL)external low-speed system clock

//  ============================================
//  low-speed system clock selectionCLKCR0_SCKLF                                 
//  ============================================
//	CLKCR0_SCKLF = 0;				// LIRC  internal low-speed system clock [default]
//	CLKCR0_SCKLF = 1;				// LXTAL external low-speed system clock

//  ============================================
//  high-speed system clock pre-scaling settingCLKCR0_SCKPSC                                 
//  ============================================
//	CLKCR0_SCKPSC = 0x00;			// fsysclk= fsck/1 * PLL not support
//	CLKCR0_SCKPSC = 0x01;			// fsysclk= fsck/2 [default]
//	CLKCR0_SCKPSC = 0x02;			// fsysclk= fsck/4
//	CLKCR0_SCKPSC = 0x03;			// fsysclk= fsck/8
//	CLKCR0_SCKPSC = 0x04;			// fsysclk= fsck/16
//	CLKCR0_SCKPSC = 0x05;			// fsysclk= fsck/32
//	CLKCR0_SCKPSC = 0x06;			// fsysclk= fsck/64
//	CLKCR0_SCKPSC = 0x07;			// fsysclk= fsck/128
	
//=============================================================================
// memory mapping
//=============================================================================
	DMCFG  	 = 0x02; 						  // Code :0x8000~0xFFFF Map to Data: 0x8000~0xFFFF,
	//DMCFG  = 0x00;						  // Code :0x0000~0x7FFF Map to Data: 0x8000~0xFFFF
	
//=============================================================================
// Setting detection voltage (2.85 V  90mV)
//=============================================================================
	
	P0OE_P0 = 1;							  // set P0.0 as output pin
	P0DO_P0 = 0;                              // light on LED1(P0.0)
	for(i=0;i<1500;i++){					  // delayed for a period of time
		for(j=1500;j>0;j--);
	}
	P0DO_P0 = 1;							  // light off LED1(P0.0)
	for(i=0;i<1500;i++){					  // delayed for a period of time
		for(j=1500;j>0;j--);
	}

	
	LVDCR0_LVDCFG   = 0x03;					  // set LVD voltage to 2.85 V  90mV
	LVDCR1_LVDRSTEN = 1;                      // selects the operation mode of voltage detection, 0 : interrupt ; 1 : reset
	LVDCR0_LVDEN    = 1;                	  // enable LVD0
	
	
	while(1){	
		WDCDR = 0x4E;             	  		  // clear the watchdog timer 
		//if(LVDCR0_LVDF == 1 && IFR_LVD0_IRQ == 1){
	    if(LVDCR0_LVDF == 1 ){
			VDD_Lower_DTVT_CNT ++;			  // if LVD is detected (i.e. VDD < the set detection voltage), VDD_Lower_DTVT_CNT is added by one
			if(VDD_Lower_DTVT_CNT >= 50){	
				break;						  // if LVD (i.e., VDD < the set detection voltage) is detected for (50+1) consecutive times, the loop will be released
			}
		}else{
			VDD_Lower_DTVT_CNT = 0;		  	  // if no LVD is detected (i.e., VDD >= the set detection voltage), clear VDD_Lower_DTVT_CNT to 0
		}
		
		if(LVDCR_LVDF == 1){
			LVDCR_LVDF = 1;             	  // if LVD is detected, clear LVD flag
		}			
	}

	LVDCR0_LVDIEN	= 1;                	  // LVD0 Д
	IER_LVD0_IRQ 	= 1;                	  // LVD0 ж
	__ASM("EI");							  // enable all maskable interrupts



//=============================================================================
// initial Registers
//=============================================================================
	__WA = 0x00;
	__BC = 0x00;
	__DE = 0x00;
	__HL = 0x00;
	__IX = 0x00;
	__IY = 0x00;

//=============================================================================
// initial Setting
//=============================================================================	
	__asm("CLR (0x08).5");

//=============================================================================
// Initialize Stack Pointer
//=============================================================================
	__asm(" LD SP,__BaseSP");	//Initialize Stack Pointer

//=============================================================================
// clear status word
//=============================================================================
	__asm(" LD PSW,0x00");

//=============================================================================
// clear RAM
//=============================================================================
	__asm(" LD HL,__RAM_Top");
	__asm(" LD BC,__RAM_End - __RAM_Top");	
	__asm(" LD A,0x00");
	__asm("CLR_RAM:");
	__asm(" LD (HL),A");
	__asm(" INC HL");
	__asm(" DEC BC");
	__asm(" JRS F,CLR_RAM");		/* Clear the RAM */

//=============================================================================
// initialize of tiny_data section
//=============================================================================
	__asm("	LD	IX,__TDataOrg");
	__asm("	LD	IY,__TDataAddr");
	__asm("	LD	A,__TDataSize");
	__asm("	DEC	A");
	__asm("	J	T,non_t_data");
	__asm("move_t_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	A");
	__asm("	J	F,move_t_data");
	__asm("non_t_data:");

//=============================================================================
// initialize of near_data section
//=============================================================================
	__asm("	LD	IX,__NDataOrg");
	__asm("	LD	IY,__NDataAddr");
	__asm("	LD	WA,__NDataSize");
	__asm("	DEC	WA");
	__asm("	J	T,non_n_data");
	__asm("move_n_data:");
	__asm("	LD	C,(IX)");
	__asm("	LD	(IY),C");
	__asm("	INC	IX");
	__asm("	INC	IY");
	__asm("	DEC	WA");
	__asm("	J	F,move_n_data");
	__asm("non_n_data:");


//=============================================================================
// jump to main
//=============================================================================
	main();
	for (;;) {
		;
	}
}

