//SQ7653_LVD example
//*************************************************************************************
// file			: main.c
// version		: V1.0 2020/07/17
// brief		: main program
// description	: LED1 (P0.0) blinks continuously when the VDD voltage is above the set low voltage detection level
//			  when low voltage detection occurs, LED1 (P0.0) turns off and stops blinking
// note			: [Button Configuration] button 1 :  BTN3_in(P1.0) for switching low voltage detection levels  2.85V<--> 3.98V
//			  [LED Configuration]  LED 1  (P0.0)
//
// example		: at the beginning of this program, the low voltage detection level is 2.85V, LED1 will be off; when VDD voltage is higher than 2.85V, LED1 will blink continuously
//			  e.g. when VDD is 3.5V, LED1 is blinking continuously
//            when press button 1, switch the low voltage detection level to 3.98V, LED1 will be off; when VDD voltage is higher than 3.98V, LED1 will blink continuously.
//			  e.g. when VDD is 3.5V, LED1 is off
// reminder		: when using this program, the VDD value must be within the specification voltage of SQ7653
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned char LVD_switch;					  // for switching low voltage detection levels

/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */

/* ---------------------- pin configuration initialization ------------------------ */
    P0OE  = 0x07;                        	  // set P0.0, P0.1 and P0.2 as output pins
    P1OE  = 0x00;                        	  // set P1.0, P1.1 and P1.2 as input pins
	P1PU |= 0x07;                       	  // enable P1.0, P1.1 and P1.2 built-in pull-up resistors
	LED1_out = 1;							  // set LED1 to the light off
	LED2_out = 1;							  // set LED2 to the light off
	LED3_out = 1;							  // set LED3 to the light off
/* ---------------------- LVD initialization ------------------------ */
	LVD_Init();                         	  // initialize LVD
	LVD_IntEnable();                    	  // enable LVD interrupt
	LVD_Start();                        	  // start LVD
	LVD_switch = 1;                	  		  // set LVD_switch to 1
/* ---------------------- EINT initialization ------------------------ */
	EINT_Init();                        	  // initialize EINT
	EINT_IntEnable();                   	  // enable EINT interrupt
/* ---------------------- TBT initialization ------------------------ */
	TBT_Init();                         	  // initialize TBT
	TBT_IntEnable();                    	  // enable TBT interrupt
	TBT_Start();                        	  // start TBT
//-------------------------------------------------------------
    while(1){
		
        if(Push_BTN1_Flag){					  // if external interrupt flag of button is 1
			Push_BTN1_Flag = 0; 	  		  // set external interrupt flag of button 1 to 0
			if(LVD_switch){
				LVD_switch = 0;    	  		  // set LVD_switch to 0
				LVDCR0_LVDEN = 0;			  // disable LVD0
				LVDCR1_LVDCFG = 0x05;    	  // set detection voltage to 3.98V
				LVDCR1_LVDEN = 1;			  // enable LVD1	
			}
			else{
				LVD_switch = 1;    	  		  // set LVD_switch to 1
				LVDCR1_LVDEN = 0;             // disable LVD1
			    LVDCR0_LVDCFG = 0x03;    	  // set detection voltage to 2.85V	
				LVDCR0_LVDEN = 1;			  // enable LVD0 
			}
		}
		//----------------------------------------------------------------
		if(TBT_Int_Flag){       	  		  // if TBT interrupt flag is 1
			TBT_Int_Flag = 0;  	  			  // set TBT interrupt flag to 0

			if((LVDCR0_LVDF == 0) && (LVD_switch == 1)){        	  // if voltage detection flag is 0
				LED1_out = ~LED1_out;   	  // LED1 inverted
			}
			else if((LVDCR0_LVDF == 1) && (LVD_switch == 1))
			{                                 // if voltage detection flag is 1
				LED1_out = 1;           	  // light off LED1
				LVDCR0_LVDF = 1;         	  // clear voltage detection flag
			}
			else if((LVDCR1_LVDF == 0) && (LVD_switch == 0))
			{        	                      // if voltage detection flag is 1
				LED1_out = ~LED1_out;   	  // LED1 inverted
			}
			else{                       	  // if voltage detection flag is 0
				LED1_out = 1;           	  // light off LED1
				LVDCR1_LVDF = 1;         	  // clear voltage detection flag
			}	
		
		}
	}
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n WDT_IRQ(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n SWI_IRQ(void)              // software reset interrupt service routine
{
	SWRST = 0x5a;
	SWRST = 0xa5;
	SWRST = 0xc3;
	SWRST = 0x3c;	
}
/* ------------------- end of interrupt service routine ------------------ */

/* -------------------- SQ7653 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 
void * const IntTbl1[] = {
	OnlyReti,				/* 0xff3a : Reserved		*/									
	OnlyReti,				/* 0xff3c : Reserved		*/									
	OnlyReti,				/* 0xff3e : Reserved		*/									
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : Reserved		*/									
	OnlyReti,				/* 0xff5a : Reserved        */								
	OnlyReti,				/* 0xff5c : Reserved        */									
	OnlyReti,				/* 0xff5e : Reserved        */									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved    	*/
	OnlyReti,				/* 0xff6c : TX2_IRQ			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : RX2_IRQ			*/	//interrupt source:UART2 RX2	
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : Reserved		*/									
	OnlyReti,				/* 0xff78 : Reserved		*/									
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/		
	OnlyReti,		    	/* 0xff82 : EXT9_IRQ		*/	//external interrupt9							
	OnlyReti,	    		/* 0xff84 : EXT8_IRQ		*/	//external interrupt8								
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : Reserved		*/									
	OnlyReti,				/* 0xff8e : Reserved		*/									
	OnlyReti,				/* 0xff90 : TX1_IRQ		    */	//interrupt source:UART1 TX1						
	OnlyReti,				/* 0xff92 : RX1_IRQ		    */	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : TMRA41_IRQ		*/	//interrupt source:counter1 of TMRA4								
	OnlyReti,				/* 0xff9a : TMRA40_IRQ		*/	//interrupt source:counter0 of TMRA4								
	OnlyReti,				/* 0xff9c : TMRA31_IRQ		*/	//interrupt source:counter1 of TMRA3								
	OnlyReti,				/* 0xff9e : TMRA30_IRQ		*/	//interrupt source:counter0 of TMRA3								
	OnlyReti,				/* 0xffa0 : EE_IRQ			*/	//interrupt source:EEPROM						
	OnlyReti,				/* 0xffa2 : EXT7_IRQ		*/	//external interrupt7						
	OnlyReti,				/* 0xffa4 : EXT6_IRQ		*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : EXT5_IRQ		*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : EXT4_IRQ		*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/									
	OnlyReti,				/* 0xffb0 : DIC_IRQ			*/	//interrupt source:DIC							
	OnlyReti,				/* 0xffb2 : CRC_IRQ			*/	//interrupt source:CRC								
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : FMC_IRQ			*/	//interrupt source:FMC								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : CMP_IRQ  		*/	//interrupt source:Comparator								
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,			    /* 0xffce : ADC_IRQ			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : EXT3_IRQ		*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : EXT2_IRQ		*/	//external interrupt2							
	OnlyReti,				/* 0xffd4 : EXT1_IRQ		*/	//external interrupt1								
	EXT0_IRQ,				/* 0xffd6 : EXT0_IRQ		*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : SIO0_IRQ		*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : I2C0_IRQ		*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : TX0_IRQ			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : RX0_IRQ			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : TMRA21_IRQ		*/	//interrupt source:counter1 of TMRA2					
	OnlyReti,				/* 0xffe4 : TMRA20_IRQ		*/	//interrupt source:counter0 of TMRA2								
	OnlyReti,				/* 0xffe6 : TMRA11_IRQ		*/	//interrupt source:counter1 of TMRA1								
	OnlyReti,				/* 0xffe8 : TMRA10_IRQ		*/	//interrupt source:counter0 of TMRA1
	OnlyReti,				/* 0xffea : TMRA01_IRQ		*/	//interrupt source:counter1 of TMRA0							
	OnlyReti,				/* 0xffec : TMRA00_IRQ		*/	//interrupt source:counter0 of TMRA0								
	LVD1_IRQ,			    /* 0xffee : LVD1_IRQ		*/	//interrupt source:low voltage detection1
	TBT_IRQ, 			    /* 0xfff0 : TBT_IRQ			*/	//interrupt source:time base timer						
	OnlyReti,				/* 0xfff2 : Reserved		*/
	OnlyReti,				/* 0xfff4 : Reserved		*/
	LVD0_IRQ,				/* 0xfff6 : LVD0_IRQ		*/	//interrupt source:low voltage detection0							
	WDT_IRQ,				/* 0xfff8 : WDT_IRQ			*/	//non-maskable interrupt source:watchdog timer	
	(void *)0xffff,			/* 0xfffa : Reserved		*/		
	SWI_IRQ,				/* 0xfffc : SWI_IRQ/INTUNDEF*/	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/*----------------- end of SQ7653 interrupt vector -----------------*/

