//*************************************************************************************
// file			: SQ7653_LVD.c
// version		: V1.0 2020/07/17
// brief		: LVD related functions
// note			: LVD related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"


//*********************************************************************
// name			: LVD_Init()
// brief		: LVD initialization
// note			: 
//*********************************************************************
void LVD_Init(){
	LVDCR1_LVDRSTEN = 0;                        // ⵽ LVD  0: Interrupt, 1: Reset.
	LVDCR0_LVDCFG = 0x03;                	    // b'011:͵ѹ 2.85V, (b'000:2V(Ĭֵ))
	//LVDCR1_LVDCFG = 0x05;                     // b'101:͵ѹ 3.98V,
}


//*********************************************************************
// name			: LVD_IntEnable()
// brief		: start LVD interrupt
// note			: 
//*********************************************************************
void LVD_IntEnable(){
	__ASM("DI");
	LVDCR0_LVDIEN = 1;                   	   // LVD0 ж
	IER_LVD0_IRQ  = 1;                         // LVD0 ж
	LVDCR1_LVDIEN = 1;                   	   // LVD1 ж
	IER_LVD1_IRQ  = 1;                         // LVD1 ж
	__ASM("EI");
}


//*********************************************************************
// name			: LVD_Start()
// brief		: start LVD
// note			: 
//*********************************************************************
void LVD_Start(){
	LVDCR0_LVDEN = 1;
	LVDCR1_LVDEN = 1;
}


//*********************************************************************
// name			: LVD_Stop()
// brief		: stop LVD
// note			: 
//*********************************************************************
void LVD_Stop(){
	LVDCR0_LVDEN = 0;                         // LVD0 жر
	//IER_LVD0_IRQ = 1;                       // LVD0 жܹر
	LVDCR1_LVDEN = 0;                         // LVD1 жر
	//IER_LVD1_IRQ = 1; 	                  // LVD1 жܹر
	
}


//*********************************************************************
// name			: __interrupt LVD0_IRQ()
// brief		: LVD0_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt LVD0_IRQ(void){
	__asm("NOP");							  // no operation

}

//*********************************************************************
// name			: __interrupt LVD1_IRQ()
// brief		: LVD1_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt LVD1_IRQ(void){
	__asm("NOP");							  // no operation

}

