//*************************************************************************************
// file 		: SQ7653_EINT.c
// version		: V1.0 2020/07/17
// brief		: EINT related functions
// note			: EINT related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char Push_BTN1_Flag; // external interrupt flag of button 1
//unsigned char Push_BTN2_Flag; // external interrupt flag of button 2

//*********************************************************************
// name			: EINT_Init()
// brief		: external interrupt initialization
// note			: 
//*********************************************************************
void EINT_Init(){
	
	//====== EINT0 ====================================================================================================================
	PCKEN3_EINT0 = 1;                                     // enable EINT0  *this must be enabled first, the relevant staging settings later to be useful
    //====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      //P1.0

	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR0_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR0_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR0_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge
	EINTCR0_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR0_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR0_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16

/*	
	//====== EINT1 ====================================================================================================================
	PCKEN3_EINT1 = 1;                                     // enable EINT1  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT1 to P1.1
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR1_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR1_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR1_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge
	EINTCR1_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR1_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR1_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/


/*
	//====== EINT2 ====================================================================================================================
	PCKEN3_EINT2 = 1;                                     // enable EINT2  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT2 to P1.2
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR2_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR2_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR2_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR2_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR2_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR2_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/


/*
	//====== EINT3 ====================================================================================================================
	PCKEN3_EINT3 = 1;                                     // enable EINT3  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT3 to P1.3
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR3_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR3_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR3_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR3_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR3_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR3_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/	



/*	
	//====== EINT4 ====================================================================================================================
	PCKEN3_EINT4 = 1;                                     // enable EINT4  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT4 to P1.4
    //--- noise canceller related setting -----------------------------------------------------------
	EINTCR4_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR4_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//*****[reminder]*****
	//P3.4 is debug pin by default, 
	//if you want to set it to other function, please disable debug function
	//EINTCR4_INTSEL = 0x03;                              // set EINT4 to P3.4
	//SYSCR0_OCDDIS = 1;								  // disable debug function
	
	//EINTCR4_INTSEL = 0x04;                              // set EINT4 to P4.4
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR4_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR4_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR4_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR4_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16

*/		



/*
	//====== EINT5 ====================================================================================================================
	PCKEN3_EINT5 = 1;                                     // enable EINT5  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT5 to P1.5
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR5_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR5_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR5_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR5_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR5_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR5_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		



/*	
	//====== EINT6 ====================================================================================================================
	PCKEN3_EINT6 = 1;                                     // enable EINT6  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT6 to P1.6
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR6_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR6_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR6_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR6_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR6_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR6_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		



/*	
	//====== EINT7 ====================================================================================================================
	PCKEN3_EINT7 = 1;                                     // enable EINT7  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT7 to P1.7
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR7_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR7_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR7_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR7_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR7_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR7_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		
	


/*	
	//====== EINT8 ====================================================================================================================
	PCKEN4_EINT8 = 1;                                     // enable EINT8  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT8 to P0.7
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR8_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR8_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR8_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR8_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR8_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR8_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		
	

/*	
	//====== EINT9 ====================================================================================================================
	PCKEN4_EINT9 = 1;                                     // enable EINT9  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	                                                      // set EINT9 to P0.6
	//--- noise canceller related setting -----------------------------------------------------------
	EINTCR9_INTLVL = 1;                                   // 1 : signal level "H"
	//EINTCR9_INTLVL = 0;								  // 0 : initial state or signal level "L"
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR9_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR9_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR9_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR9_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		
	


}


//*********************************************************************
// name			: EINT_IntEnable()
// brief		: enable external interrupt
// note			: 
//*********************************************************************
void EINT_IntEnable(){
	__ASM("DI");	                                     // enable all maskable interrupts

	IFR_EXT0_IRQ = 0;                                    // clear EINT0 interrupt flag                                                                             
	IER_EXT0_IRQ = 1;                                    // enable EINT0 interrupt
	
/*
	IFR_EXT1_IRQ = 0;                                    // clear EINT1 interrupt flag
	IER_EXT1_IRQ = 1;                                    // enable EINT1 interrupt
*/
	
/*
	IFR_EXT2_IRQ = 0;                                    // clear EINT2 interrupt flag
	IER_EXT2_IRQ = 1;                                    // enable EINT2 interrupt
*/

/*
	IFR_EXT3_IRQ = 0;                                    // clear EINT3 interrupt flag
	IER_EXT3_IRQ = 1;                                    // enable EINT3 interrupt
*/


/*
	IFR_EXT4_IRQ = 0;                                    // clear EINT4 interrupt flag
	IER_EXT4_IRQ = 1;                                    // enable EINT4 interrupt
*/


/*
	IFR_EXT5_IRQ = 0;                                    // clear EINT5 interrupt flag
	IER_EXT5_IRQ = 1;                                    // enable EINT5 interrupt
*/


/*
	IFR_EXT6_IRQ = 0;                                    // clear EINT6 interrupt flag
	IER_EXT6_IRQ = 1;                                    // enable EINT6 interrupt
*/


/*
	IFR_EXT7_IRQ = 0;                                    // clear EINT7 interrupt flag
	IER_EXT7_IRQ = 1;                                    // enable EINT7 interrupt
*/

/*
	IFR_EXT8_IRQ = 0;                                    // clear EINT8 interrupt flag
	IER_EXT8_IRQ = 1;                                    // enable EINT8 interrupt
*/

/*
	IFR_EXT9_IRQ = 0;                                    // clear EINT9 interrupt flag
	IER_EXT9_IRQ = 1;                                    // enable EINT9 interrupt
*/
	
	__ASM("EI");                                          // enable all maskable interrupts
}


//*********************************************************************
// name			: EINT_Stop()
// brief		: disable external interrupt
// note			: 
//*********************************************************************
void EINT_Stop(){
	IER_EXT0_IRQ = 0;                                        // disable EINT0 interrupt
	//IER_EXT1_IRQ = 0;                                       // disable EINT1 interrupt
	//IER_EXT2_IRQ = 0; 									  // disable EINT2 interrupt
	//IER_EXT3_IRQ = 0; 									  // disable EINT3 interrupt
	//IER_EXT4_IRQ = 0; 									  // disable EINT4 interrupt
	//IER_EXT5_IRQ = 0; 									  // disable EINT5 interrupt
	//IER_EXT6_IRQ = 0; 									  // disable EINT6 interrupt
	//IER_EXT7_IRQ = 0; 									  // disable EINT7 interrupt
    //IER_EXT8_IRQ = 0; 									  // disable EINT8 interrupt
    //IER_EXT9_IRQ = 0; 									  // disable EINT9 interrupt	
}



//*********************************************************************
// name			: __interrupt EXT0_IRQ()
// brief		: IntEXT0 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT0_IRQ(void){
	__asm("NOP");										  // no operation	
	Push_BTN1_Flag = 1;									  // set Push_BTN1_Flag to 1
}

//*********************************************************************
// name			: __interrupt EXT1_IRQ()
// brief		: IntEXT1 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT1_IRQ(void){
	__asm("NOP");										  // no operation	
	//Push_BTN2_Flag = 1;								  // set Push_BTN2_Flag to 1
}

//*********************************************************************
// name			: __interrupt EXT2_IRQ()
// brief		: IntEXT2 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT2_IRQ(void){
	__asm("NOP");								          // no operation						  
}

//*********************************************************************
// name			: __interrupt EXT3_IRQ()
// brief		: IntEXT3 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT3_IRQ(void){
	__asm("NOP");	                                      // no operation
}

//*********************************************************************
// name			: __interrupt EXT4_IRQ()
// brief		: IntEXT4 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT4_IRQ(void){
	__asm("NOP");                                         // no operation
}

//*********************************************************************
// name			: __interrupt EXT5_IRQ()
// brief		: IntEXT5 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT5_IRQ(void){
	__asm("NOP");										  // no operation
}

//*********************************************************************
// name			: __interrupt EXT6_IRQ()
// brief		: IntEXT6 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT6_IRQ(void){
	__asm("NOP");										  // no operation
}

//*********************************************************************
// name			: __interrupt EXT7_IRQ()
// brief		: IntEXT7 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT7_IRQ(void){
	__asm("NOP");										  // no operation
}

//*********************************************************************
// name			: __interrupt EXT8_IRQ()
// brief		: IntEXT7 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT8_IRQ(void){
	__asm("NOP");										  // no operation
}

//*********************************************************************
// name			: __interrupt EXT9_IRQ()
// brief		: IntEXT7 interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT9_IRQ(void){
	__asm("NOP");										  // no operation
}
