//*************************************************************************************
// file			: SQ7653_KWU.c
// version		: V1.0 2020/07/17
// brief		: KWU related functions
// note			: KWU related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"



//******************************************************************************
// name			: KWU_Pin_Select()
// brief		: select KWU pin
// note			: the comment block '//' can be uncommented to set other KWUs
//			  one KWU can be only selected for one pin
//******************************************************************************
void KWU_Pin_Select(void)
{
//====== KWU 0 ======
  KWUSR0_KWU0 = 0x00;                 	  // set KWU pin to P1.0

//====== KWU 1 ======
//KWUSR0_KWU1 = 0x00;                 	  // set KWU pin to P1.1

//====== KWU 2 ======
//KWUSR0_KWU2 = 0x00;                 	  // set KWU pin to P1.2

//====== KWU 3 ======
//KWUSR0_KWU3 = 0x00;                 	  // set KWU pin to P1.3

//====== KWU 4 ======
//KWUSR1_KWU4 = 0x00;                 	  // set KWU pin to P1.4

//====== KWU 5 ======
//KWUSR1_KWU5 = 0x00;                 	  // set KWU pin to P1.5

//====== KWU 6 ======
//KWUSR1_KWU6 = 0x00;                 	  // set KWU pin to P1.6

//====== KWU 7 ======
//KWUSR1_KWU7 = 0x00;                 	  // set KWU pin to P1.7

//====== KWU 8 ======
//KWUSR2_KWU8 = 0x00;                 	  // set KWU pin to P0.7
                                                               
//====== KWU 9 ======                                          
//KWUSR2_KWU9 = 0x00;                 	  // set KWU pin to P0.6

}


//******************************************************************************
// name			: KWU_Enable()
// brief		: initialize and enable KWU
// note			: the comment block '/**/' can be uncommented to set other KWUs
//			  low level release and high level release cannot coexist in the same KWU
//******************************************************************************
void KWU_Enable(void)
{
//====== KWU 0 ======
//--- low level release 

    KWUCR0_KW0LE    = 0; 	 		   	  // KWI0 low level release 
    KWUCR0_KW0EN    = 1;	 	          // enable KWU0
	
//--- high level release
/*     
    KWUCR0_KW0LE    = 1; 
    KWUCR0_KW0EN    = 1;
*/
 
//====== KWU 1 ======
//--- low level release 
/*    
    KWUCR0_KW1LE    = 0;
    KWUCR0_KW1EN    = 1;
*/
 
//--- high level release
/*   
    KWUCR0_KW1LE    = 1; 
    KWUCR0_KW1EN    = 1;
*/
   
//====== KWU 2 ======
//--- low level release 
/* 
    KWUCR0_KW2LE    = 0;
    KWUCR0_KW2EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR0_KW2LE    = 1; 
    KWUCR0_KW2EN    = 1;
*/
    
//====== KWU 3 ======
//--- low level release 
/*    
    KWUCR0_KW3LE    = 0;
    KWUCR0_KW3EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR0_KW3LE    = 1;
    KWUCR0_KW3EN    = 1; 
*/
    
//====== KWU 4 ======
//--- low level release 
/*  
    KWUCR1_KW4LE    = 0;
    KWUCR1_KW4EN    = 1;
*/
 
//--- high level release
/*     
    KWUCR1_KW4LE    = 1;
    KWUCR1_KW4EN    = 1;
*/
    
//====== KWU 5 ======
//--- low level release 
/*  
    KWUCR1_KW5LE    = 0;
    KWUCR1_KW5EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW5LE    = 1;
    KWUCR1_KW5EN    = 1;
*/
    
//====== KWU 6 ======
//--- low level release 
/*     
    KWUCR1_KW6LE    = 0;
    KWUCR1_KW6EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW6LE    = 1;
    KWUCR1_KW6EN    = 1;
*/
    
//====== KWU 7 ======
//--- low level release 
/*  
    KWUCR1_KW7LE    = 0;
    KWUCR1_KW7EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW7LE    = 1;
    KWUCR1_KW7EN    = 1;
*/

//====== KWU 8 ======
//--- low level release 
/*  
    KWUCR1_KW8LE    = 0;
    KWUCR1_KW8EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW8LE    = 1;
    KWUCR1_KW8EN    = 1;
*/

//====== KWU 9 ======
//--- low level release 
/*  
    KWUCR2_KW9LE    = 0;
    KWUCR2_KW9EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR2_KW9LE    = 1;
    KWUCR2_KW9EN    = 1;
*/
}


//*********************************************************************
// name			: KWU_Disable()
// brief		: disable KWU
// note			: the comment block '/**/' can be uncommented to set other KWUs
//*********************************************************************
void KWU_Disable(void)
{

//====== KWU 0 ======   
         
    KWUCR0_KW0EN    = 0; 

    
//====== KWU 1 ======   
/*         
    KWUCR1_KW1EN    = 0; 
*/

//====== KWU 2 ======
/*
    KWUCR0_KW2EN    = 0;
*/

//====== KWU 3 ======   
/*       
    KWUCR0_KW3EN    = 0; 
*/
    
//====== KWU 4 ======   
/*       
    KWUCR1_KW4EN    = 0; 
*/
    
//====== KWU 5 ======   
/*      
    KWUCR1_KW5EN    = 0; 
*/
    
//====== KWU 6 ======   
/*       
    KWUCR1_KW6EN    = 0; 
*/
    
//====== KWU 7 ======   
/*        
    KWUCR1_KW7EN    = 0; 
*/

//====== KWU 8 ======   
/*        
    KWUCR2_KW8EN    = 0; 
*/

//====== KWU 9 ======   
/*        
    KWUCR2_KW9EN    = 0; 
*/
 
}
