//SQ7653_I2C0_Master_EEPROM_24C08 example
//*************************************************************************************
// file			: main.c
// version		: V1.1 (Sep. 4, 20)
// brief		: main program
// description	: 24C08 R/W  example
//			  you can use the IDE to set breakpoints to observe Data Write and Data Read sequence results
// note			: 
//			  1. SDA0(P0.7) connects to 24C08 SDA Pin, 
//				 SCL0(P0.6) connects to 24C08 SCL Pin, 
//	             *the above SDA and SCL must be connected with external pull-up resistors
//            2.
//				 [LED Configuration] LED 1  (P0.0)
//				 [LED Configuration] LED 2  (P0.1)
//				 [LED Configuration] LED 3  (P0.2)
//
//            3. all LEDs will light on during writing data to AT24C08
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned char      iloop;
unsigned char      wBuf[16];    // transmitted data buffer
unsigned char      rBuf[16];    // received data buffer

// initial data in EEPROM
unsigned char      wBufFF[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
							     0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */
//
	Delay_Loop_Init();                       // initialize the delay loop
                                             // need to initialize before to use any delay loop functions

/* ---------------------- pin configuration initialization ------------------------ */
    P0OE  = 0x07;                            // set P0.0, P0.1 and P0.2 as output pins
    P1OE  = 0x00;                            // set P1.0, P1.1 and P1.2 as input pins
	P1PU |= 0x07;                       	 // enable P1.0, P1.1 and P1.2 built-in pull-up resistors

	LED1_to_LED3_turn_off;                   // light off all LEDs
/* ---------------------------------------------------------- */
	// initial write buffer data value
    for( iloop=0; iloop<16; iloop++ ){
        wBuf[iloop]  = 0x10+iloop;
	}
/* ---------------------- I2C0 initialization ------------------------ */ 
    I2C0_Init();							 // set I2C0 to master mode						
//----------------------------------------------------------------

  // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
  //  Master Operation                                                         //
  // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    // Write Sequence FF
    // initial data in EEPROM

        LED1_to_LED3_turn_on;                     // light on all LEDs
        delay_ms(100);
	
        I2C0_Start(0xa0, 0x00);			          // set I2C0 to master mode and I2C0 generate the start condition  
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        
        // write 16-byte data of wBufFF to AT24C08 from address 0x00
        I2C0_Bytes_Write(wBufFF, 16); 	
        I2C0_Stop();						      // I2C0 generate the stop condition
	
        delay_ms(6);                              // wait AT24C08A pgm time >5ms...
 
	    LED1_to_LED3_turn_off;                    // light off all LEDs
        __asm("NOP");					          // no operation, the breakpoint is located here

    //-------------------------------------------------------------------------------------
	//  Read Sequence
    //  read 16-byte data from AT24C08 and start address is 0x00
    	
		I2C0_Start(0xa0, 0x00);			          // set I2C0 to master mode and I2C0 generate the start condition   
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        
        I2C0_ReStart(0xa0);          	          // I2C0 generate the restart condition
	
		// read 16-byte data to rBuf
		I2C0_Bytes_Read(rBuf, 16);
		I2C0_Stop();						      // I2C0 generate the stop condition
		
		__asm("NOP");				              // no operation
		__asm("NOP");				              
		__asm("NOP");				              
		__asm("NOP");				              
		__asm("NOP");					          // no operation, the breakpoint is located here

 	//-------------------------------------------------------------------------------------
    //  Write Sequence
    //  write 3-byte data of wBuf to AT24C08 from address 0x00
  
        LED1_to_LED3_turn_on;                     // light on all LEDs
        delay_ms(100);
		I2C0_Start(0xa0, 0x00);			          // set I2C0 to master mode and I2C0 generate the start condition     
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address

	    // write 3-byte data of wBuf to AT24C08 from address 0x00
		I2C0_Bytes_Write(wBuf, 3);     	          
		I2C0_Stop();						      // I2C0 generate the stop condition
		
        delay_ms(6);                              // wait AT24C08A pgm time >5ms...
		
		LED1_to_LED3_turn_off;                    // light off all LEDs 
		__asm("NOP");					          // no operation, the breakpoint is located here
	
	//-------------------------------------------------------------------------------------
    //  Read Sequence
    //  read 16-byte data from AT24C08 and start address is 0x00

		I2C0_Start(0xa0, 0x00);			          // set I2C0 to master mode and I2C0 generate the start condition    
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address		
        
        I2C0_ReStart(0xa0);          	          // I2C0 generate the restart condition
		
		// read 16-byte data to rBuf
		I2C0_Bytes_Read(rBuf, 16);
		I2C0_Stop();						      // I2C0 generate the stop condition
		
		__asm("NOP");					          // no operation
		__asm("NOP");
		__asm("NOP");
		__asm("NOP");
		__asm("NOP");					          // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
    //  Write Sequence
    //  write data of wBuf to AT24C08 from address 0x06
    
		LED1_to_LED3_turn_on;                     // light on all LEDs
        delay_ms(100);

		I2C0_Start(0xa0, 0x06);			          // set I2C0 to master mode and I2C0 generate the start condition     
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x06: slave start address
	
	    // write 2-byte data of wBuf to AT24C08 from address 0x06
		I2C0_Bytes_Write(wBuf, 2);
		I2C0_Stop();						      // I2C0 generate the stop condition

        delay_ms(6);                              // wait AT24C08A pgm time >5ms...
	
		LED1_to_LED3_turn_off;                    // light off all LEDs
		__asm("NOP");					          // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
    //  Read Sequence
    //  read 16-byte data from AT24C08 and start address is 0x00
    
		I2C0_Start(0xa0, 0x00);			          // set I2C0 to master mode and I2C0 generate the start condition     
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address		
        
        I2C0_ReStart(0xa0);          	          // I2C0 generate the restart condition
		
		// read 16-byte data to rBuf
		I2C0_Bytes_Read(rBuf, 16);
		I2C0_Stop();                              // I2C0 generate the stop condition
		__asm("NOP");					          // no operation, the breakpoint is located here
		

	//-------------------------------------------------------------------------------------
    //  Read Sequence
    //  read data from AT24C08 and start address is 0x05

        I2C0_Start(0xa0, 0x05);			          // set I2C0 to master mode and I2C0 generate the start conditionʹ1ֽ(1byte)(0x05)   
		//..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x05: slave start address        
        
        I2C0_ReStart(0xa0);          	          // I2C0 generate the restart condition
        
        // read 10-byte data from AT24C08 and start address is 0x05
        I2C0_Bytes_Read(rBuf, 10);
        I2C0_Stop();                              // I2C0 generate the stop condition
        __asm("NOP");					          // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
 
    while(1){
        CLR_WDT;						          // clear the watchdog timer 
    }



}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n WDT_IRQ(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n SWI_IRQ(void)              // software reset interrupt service routine
{
	SWRST = 0x5a;
	SWRST = 0xa5;
	SWRST = 0xc3;
	SWRST = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7653 interrupt vector ------------------ */
//  [ж] Ҫжид
//  1. ʹ֮߳жж֮OnlyRetiΪӦж
//  2. Ӧڵַж, ֱӸ
//
//  exampleʹexternal interrupt0, ӦжϱеOnlyRetiΪEXT0_IRQ, 
//        EXT0_IRQ,    /* 0xffd6 : EXT0_IRQ      */      //external interrupt0
//--------------------------------------------------------------//
#pragma section const INT_VECTOR1 
void * const IntTbl1[] = {
	OnlyReti,				/* 0xff3a : Reserved		  */									
	OnlyReti,				/* 0xff3c : Reserved		  */									
	OnlyReti,				/* 0xff3e : Reserved		  */									
	OnlyReti,				/* 0xff40 : Reserved		  */									
	OnlyReti,				/* 0xff42 : Reserved		  */									
	OnlyReti,				/* 0xff44 : Reserved		  */									
	OnlyReti,				/* 0xff46 : Reserved		  */								
	OnlyReti,				/* 0xff48 : Reserved		  */									
	OnlyReti,				/* 0xff4a : Reserved		  */									
	OnlyReti,				/* 0xff4c : Reserved		  */									
	OnlyReti,				/* 0xff4e : Reserved		  */									
	OnlyReti,				/* 0xff50 : Reserved		  */									
	OnlyReti,				/* 0xff52 : Reserved		  */									
	OnlyReti,				/* 0xff54 : Reserved		  */									
	OnlyReti,				/* 0xff56 : Reserved		  */									
	OnlyReti,				/* 0xff58 : Reserved		  */									
	OnlyReti,				/* 0xff5a : Reserved          */								
	OnlyReti,				/* 0xff5c : Reserved          */									
	OnlyReti,				/* 0xff5e : Reserved          */									
	OnlyReti,				/* 0xff60 : Reserved		  */									
	OnlyReti,				/* 0xff62 : Reserved		  */									
	OnlyReti,				/* 0xff64 : Reserved		  */									
	OnlyReti,				/* 0xff66 : Reserved		  */									
	OnlyReti,				/* 0xff68 : Reserved		  */									
	OnlyReti,				/* 0xff6a : Reserved    	  */
	OnlyReti,				/* 0xff6c : TX2_IRQ			  */	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : RX2_IRQ			  */	//interrupt source:UART2 RX2	
	OnlyReti,				/* 0xff70 : Reserved		  */									
	OnlyReti,				/* 0xff72 : Reserved		  */									
	OnlyReti,				/* 0xff74 : Reserved		  */									
	OnlyReti,				/* 0xff76 : Reserved		  */									
	OnlyReti,				/* 0xff78 : Reserved		  */									
	OnlyReti,				/* 0xff7a : Reserved		  */									
	OnlyReti,				/* 0xff7c : Reserved		  */									
	OnlyReti,				/* 0xff7e : Reserved		  */									
	OnlyReti,				/* 0xff80 : Reserved		  */		
	OnlyReti,		    	/* 0xff82 : EXT9_IRQ		  */	//external interrupt9							
	OnlyReti,	    		/* 0xff84 : EXT8_IRQ		  */	//external interrupt8								
	OnlyReti,				/* 0xff86 : Reserved		  */									
	OnlyReti,				/* 0xff88 : Reserved		  */									
	OnlyReti,				/* 0xff8a : Reserved		  */									
	OnlyReti,				/* 0xff8c : Reserved		  */									
	OnlyReti,				/* 0xff8e : Reserved		  */									
	OnlyReti,				/* 0xff90 : TX1_IRQ		      */	//interrupt source:UART1 TX1						
	OnlyReti,				/* 0xff92 : RX1_IRQ		      */	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		  */									
	OnlyReti,				/* 0xff96 : Reserved		  */									
	OnlyReti,				/* 0xff98 : TMRA41_IRQ		  */	//interrupt source:counter1 of TMRA4								
	OnlyReti,				/* 0xff9a : TMRA40_IRQ		  */	//interrupt source:counter0 of TMRA4								
	OnlyReti,				/* 0xff9c : TMRA31_IRQ		  */	//interrupt source:counter1 of TMRA3								
	OnlyReti,				/* 0xff9e : TMRA30_IRQ		  */	//interrupt source:counter0 of TMRA3								
	OnlyReti,				/* 0xffa0 : EE_IRQ			  */	//interrupt source:EEPROM						
	OnlyReti,				/* 0xffa2 : EXT7_IRQ		  */	//external interrupt7						
	OnlyReti,				/* 0xffa4 : EXT6_IRQ		  */	//external interrupt6								
	OnlyReti,				/* 0xffa6 : EXT5_IRQ		  */	//external interrupt5								
	OnlyReti,				/* 0xffa8 : EXT4_IRQ		  */	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		  */									
	OnlyReti,				/* 0xffac : Reserved		  */									
	OnlyReti,				/* 0xffae : Reserved		  */									
	OnlyReti,				/* 0xffb0 : DIC_IRQ			  */	//interrupt source:DIC							
	OnlyReti,				/* 0xffb2 : Reserved		  */						
	OnlyReti,				/* 0xffb4 : Reserved		  */			
	OnlyReti,				/* 0xffb6 : Reserved		  */					
	OnlyReti,				/* 0xffb8 : Reserved		  */								
	OnlyReti,				/* 0xffba : Reserved		  */									
	OnlyReti,				/* 0xffbc : Reserved		  */									
	OnlyReti,				/* 0xffbe : Reserved		  */									
	OnlyReti,				/* 0xffc0 : Reserved		  */									
	OnlyReti,				/* 0xffc2 : Reserved		  */									
	OnlyReti,				/* 0xffc4 : FMC_IRQ			  */	//interrupt source:FMC								
	OnlyReti,				/* 0xffc6 : Reserved		  */					
	OnlyReti,				/* 0xffc8 : CMP_IRQ  		  */	//interrupt source:Comparator								
	OnlyReti,				/* 0xffca : Reserved		  */									
	OnlyReti,				/* 0xffcc : Reserved		  */									
	OnlyReti,			    /* 0xffce : ADC_IRQ			  */	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : EXT3_IRQ		  */	//external interrupt3								
	OnlyReti,				/* 0xffd2 : EXT2_IRQ		  */	//external interrupt2							
	OnlyReti,				/* 0xffd4 : EXT1_IRQ		  */	//external interrupt1								
	OnlyReti,				/* 0xffd6 : EXT0_IRQ		  */	//external interrupt0								
	OnlyReti,				/* 0xffd8 : SIO0_IRQ		  */	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : I2C0_IRQ		  */	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : TX0_IRQ			  */	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : RX0_IRQ			  */	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		  */									
	OnlyReti,				/* 0xffe2 : TMRA21_IRQ		  */	//interrupt source:counter1 of TMRA2					
	OnlyReti,				/* 0xffe4 : TMRA20_IRQ		  */	//interrupt source:counter0 of TMRA2								
	OnlyReti,				/* 0xffe6 : TMRA11_IRQ		  */	//interrupt source:counter1 of TMRA1								
	OnlyReti,				/* 0xffe8 : TMRA10_IRQ		  */	//interrupt source:counter0 of TMRA1
	OnlyReti,				/* 0xffea : TMRA01_IRQ		  */	//interrupt source:counter1 of TMRA0							
	OnlyReti,				/* 0xffec : TMRA00_IRQ		  */	//interrupt source:counter0 of TMRA0								
	OnlyReti,			    /* 0xffee : LVD1_IRQ		  */	//interrupt source:low voltage detection1
	OnlyReti, 			    /* 0xfff0 : TBT_IRQ			  */	//interrupt source:time base timer						
	OnlyReti,				/* 0xfff2 : Reserved		  */
	OnlyReti,				/* 0xfff4 : Reserved		  */
	OnlyReti,				/* 0xfff6 : LVD0_IRQ		  */	//interrupt source:low voltage detection0							
	WDT_IRQ,				/* 0xfff8 : WDT_IRQ			  */	//non-maskable interrupt source:watchdog timer	
	(void *)0xffff,			/* 0xfffa : Reserved		  */		
	SWI_IRQ,				/* 0xfffc : SWI_IRQ/INTUNDEF  */	//non-maskable		
	STARTUP					/* 0xfffe : RESET		      */	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7653 interrupt vector ---------------------- */

