//*************************************************************************************
// 	: SQ7653_Delay_Loop.c
// 汾		: V1.0 (Sep. 3, 20)
// 		: SQ7653_Delay_Loop ʹú
// 
// ע		: 1. غ㼯ڱӳ
//          : 2. delay_ms()ϵͳʱԴΪPLLϵͳƵΪ24MHz12MHz6MHz
//            3. delay_100us()ϵͳʱԴΪPLLϵͳƵΪ24MHz
//
// ע		: ʹLoopȦӳ٣
//            ΪȷӳӦãʹTimerʱӳٹܡ
//**************************************************************************************
#include "main.h"

volatile  unsigned int  Delay_base_ms;
volatile  unsigned int  Delay_base_100us;

//*********************************************************************
//    : Delay_Loop_Init()
//  : ʱȦʼ
// ֵ	: none
// شֵ	: none
//
// ע     : ϵͳƵлDelay LoopСλĴ
//*********************************************************************
void Delay_Loop_Init(){

   /* Tips:
       // ϵͳʱԴΪPLLϵͳƵΪ24MHz12MHz6MHz
       // ϵͳʱԴƵҪʹñDelay_Loop_Init()
       // ͷļDelay Loop1msloop
    */

	if(CLKCR0_SCKSEL != PLL){
	return;
	
	}

	switch(CLKCR0_SCKPSC){
	    case PLL_24M:							// ϵͳƵΪPLL 24M Hz
        Delay_base_ms = f24m_1ms_t;
		Delay_base_100us = f24m_100us_t;
        break;
			
        case PLL_12M:							// ϵͳƵΪPLL 12M Hz
        Delay_base_ms = f12m_1ms_t;
	
        break;
			
        case PLL_6M:							// ϵͳƵΪPLL 6M Hz
		Delay_base_ms = f06m_1ms_t;
	
	    break;	
			
     	default:
      	Delay_base_ms = f24m_1ms_t;
		Delay_base_100us = f24m_100us_t;
     	break;
	}

}


//*********************************************************************
//    : delay_ms()
//  : msʱ
// ֵ	: x Ϊx>0
// شֵ	: none
//
// ע     : ɹ̶Ȧʱһʱ䣬ӳʱ䵥λms
// ע		: ϵͳʱԴΪPLLϵͳƵΪ24MHz12MHz6MHz
// 
// ʹ÷£
//          : delay_ms(1);     		    // ӳ Լ1ms
//          : delay_ms(30);     		// ӳ Լ30ms
//          : delay_ms(500);     		// ӳ Լ500ms (Լ0.5s)
//*********************************************************************
void delay_ms(uint x){

volatile uint  i = 0;

if(!x) return;
	
	for(; x>0; x--){
    	for(i=0; i< Delay_base_ms; i++){
		__asm("NOP");
	    CLR_WDT;                        // Źʱ (ι)		
		}
	CLR_WDT;                            // Źʱ (ι)
	}


}



//*********************************************************************
//    : delay_100us()
//  : 100usʱ
// ֵ	: y Ϊy>0y趨 = 110
// شֵ	: none
//
// ע     : ɹ̶Ȧʱһʱ䣬ӳʱ䵥λus
// ע		: 1.ϵͳʱԴΪPLLϵͳƵΪ24MHz
//          : 2.ϴ󣬹ӳ >1msʹdelay_ms()
// 
// ʹ÷£
//          : delay_100us(1);     		// ӳ 100us = 0.1ms
//          : delay_100us(10);     		// ӳ 1000us = 1ms
//*********************************************************************
void delay_100us(uint y){

volatile uint  i = 0;	 

if(!y) return;

	for(; y>0; y--){

    	for(i=0; i< Delay_base_100us; i++){
		__asm("NOP");
	    CLR_WDT;                        // Źʱ (ι)		
		}
	CLR_WDT;                            // Źʱ (ι)
	}


}

