//*************************************************************************************
// file			: main.h
// version		: V1.0 2020/07/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

/* ---------------------- reference header files ------------------------------ */
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7653_SFR.h"
#include "SQ7653_TMRA.h"


/* ---------------------- user-defined macros ------------------------------ */
#define d_10Hz_Count 2343    	      	  // count 2343 times to get 10Hz frequency (0.0426ms * 2343= 99.81ms)

#define   BTN1_in    P1DI_P0	      	  // BTN1(P1.0) button 1 input voltage
#define   BTN2_in    P1DI_P1		      // BTN2(P1.1) button 2 input voltage
#define   BTN3_in    P1DI_P2		      // BTN3(P1.2) button 3 input voltage

#define   LED1_out   P0DO_P0		  	  // LED1(P0.0) output voltage
#define   LED2_out   P0DO_P1		  	  // LED2(P0.1) output voltage
#define   LED3_out   P0DO_P2              // LED3(P0.2) output voltage

#define   LED1_to_LED3_turn_off   P0DO = (P0DO & 0xF8)|0x07;
#define   LED1_to_LED3_turn_on    P0DO = (P0DO & 0xF8);

#define   BIT0  0x0001				  
#define   BIT1  0x0002
#define   BIT2  0x0004
#define   BIT3  0x0008
#define   BIT4  0x0010
#define   BIT5  0x0020
#define   BIT6  0x0040
#define   BIT7  0x0080
#define   BIT8  0x0100
#define   BIT9  0x0200
#define   BIT10 0x0400
#define   BIT11 0x0800
#define   BIT12 0x1000
#define   BIT13 0x2000
#define   BIT14 0x4000
#define   BIT15 0x8000

#define   SET(n,c)  ((n) |= (c))      	  
#define   CLR(n,c)  ((n) &= ~(c))

/* ---------------------- extern global variables ------------------------- */




/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);


#endif //#ifndef _INCLUDES_H__

