//*************************************************************************************
// file			: SQ7653_TMRA.h
// version		: V1.0 2020/07/17
// brief		: TMRA0 header file 
// note			:        
//**************************************************************************************
#ifndef _SQ7653_TMRA_H__
#define _SQ7653_TMRA_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char TMRA00_Int_Flag;	  	       // TMRA00 interrupt flag
extern unsigned char TMRA01_Int_Flag;	  	       // TMRA01 interrupt flag

/* ---------------------- user-defined macros ------------------------------ */
//For t_mod_sel------
#define set_8bit    			0x00		       // 8-bit mode
#define	output  				0x01		       // timer 0 and 1 outputs AND together to TA01O  
#define set_16bit  				0x02		       // 16-bit mode
#define pre_scale   			0x04		       // pre-scale mode
#define complementary   		0x05		       // complementary mode

//For op_mod_sel------
#define timer    				0x00		       // timer mode
#define	event_counter  			0x01		       // event counter mode 
#define capture  				0x03	  	       // capture mode
#define pulse_width_modulation  0x04		       // pulse width modulation (PWM) mode
#define pulse_width_measurement 0x05		       // pulse width measurement mode
#define PPG						0x06		       // programmable pulse generate (PPG) mode

//----------------------------------------------------------------
void TMRA0_Timer_Init(unsigned char t_mode_sel);   // TMRA0  initialization
void TMRA00_Init(unsigned char op_mode_sel);	   // TMRA00 initialization
void TMRA01_Init(unsigned char op_mode_sel);	   // TMRA01 initialization

void TMRA00_IntEnable();					       // enable TMRA00 interrupt
void TMRA01_IntEnable();					       // enable TMRA01 interrupt

void TMRA00_SetPeriod(unsigned int period);	   // set TMRA00 timer counter
void TMRA01_SetPeriod(unsigned int period);	   // set TMRA01 timer counter
void TMRA0_16bit_SetPeriod(unsigned int period); // set TMRA0 timer counter

void TMRA00_Start();							   // start to run TMRA00
void TMRA01_Start();							   // start to run TMRA01
void TMRA0_16bit_Start();						   // start to run TMRA0

void TMRA00_Stop();							 	   // stop and clear TMRA00
void TMRA01_Stop();							 	   // stop and clear TMRA01
void TMRA0_16bit_Stop();						   // stop TMRA0

void __interrupt TMRA00_IRQ(void);			  	   // TMRA00 interrupt service routine
void __interrupt TMRA01_IRQ(void);			  	   // TMRA01 interrupt service routine


#endif

