//*************************************************************************************
// file			: SQ7653_TMRA0.c
// version		: V1.0 2020/07/17
// brief		: Timer A0 (TMRA0)related functions
// note			: TMRA0 related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TMRA00_Int_Flag;		  	// TMRA00 interrupt flag
unsigned char TMRA01_Int_Flag;		  	// TMRA01 interrupt flag

//*********************************************************************
// name			: TMRA0_Timer_Init()
// brief		: TMRA0 initialization
// note			: t_mode_sel:
//						set_8bit    	: 8-bit mode
//						output  		: timer 0 and 1 outputs AND together to TA01O 
//						set_16bit		: 16-bit mode
//						pre_scale   	: pre-scale mode
//						complementary	: complementary mode
//*********************************************************************
void TMRA0_Timer_Init(unsigned char t_mode_sel){

	PCKEN0_TMRA0 = 1;                   // enable TMRA0  *this must be enabled first, the relevant staging settings later to be useful
	TMRA0CFG_TCFG = t_mode_sel;			// TMRA0 mode selection
	
}


//*********************************************************************
// name			: TMRA00_Init()
// brief		: TMRA00 initialization
// note			: op_mode_sel:
//						 timer  				 : timer mode
//						 event_counter 			 : event counter mode 
//						 capture 				 : capture mode
//						 pulse_width_modulation  : pulse width modulation (PWM) mode
//						 pulse_width_measurement : pulse width measurement mode
//						 PPG					 : programmable pulse generate (PPG) mode
//*********************************************************************
void TMRA00_Init(unsigned char op_mode_sel){

	TMRA0MD0_TCK = 0x01;				// select timer source clock to fcgck/1024 (24Mz / 1024 = 23437.5Hz, about 0.0426ms)	
	TMRA0MD0_TCM = op_mode_sel;			// operation mode selection

}



//*********************************************************************
// name			: TMRA01_Init()
// brief		: TMRA01 initialization
// note			: op_mode_sel:
//						 timer  				 : timer mode
//						 event_counter 			 : event counter mode 
//						 capture 				 : capture mode
//						 pulse_width_modulation  : pulse width modulation (PWM) mode
//						 pulse_width_measurement : pulse width measurement mode
//						 PPG					 : programmable pulse generate (PPG) mode
//*********************************************************************
void TMRA01_Init(unsigned char op_mode_sel){
	
	TMRA0MD1_TCK = 0x01;				// select timer source clock to fcgck/1024 (24Mz / 1024 = 23437.5Hz, about 0.0426ms)
	TMRA0MD1_TCM = op_mode_sel;			// operation mode selection
	
}


//*********************************************************************
// name			: TMRA00_IntEnable()
// brief		: enalbe TMRA00 interrupt
// note			: 
//*********************************************************************
void TMRA00_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA00_IRQ = 1;                 // enalbe TMRA00 interrupt
	
	//TMRA0CR0_TMROVIE = 0;             // generate no TMRA00 interrupt request when the counter overflow occurs
	//TMRA0CR0_TMROVIE = 1;             // generate a TMRA00 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}


//*********************************************************************
// name			: TMRA01_IntEnable()
// brief		: enalbe TMRA01 interrupt
// note			: 
//*********************************************************************
void TMRA01_IntEnable(){
	__ASM("DI");					    // enable all maskable interrupts
	IER_TMRA01_IRQ = 1;                 // enalbe TMRA01 interrupt
	
	//TMRA0CR1_TMROVIE = 0;             // generate no TMRA01 interrupt request when the counter overflow occurs
	//TMRA0CR1_TMROVIE = 1;             // generate a TMRA01 interrupt request when the counter overflow occurs
	
	__ASM("EI");						// enable all maskable interrupts
}



//*********************************************************************
// name			: TMRA00_SetPeriod()
// brief		: set TMRA00 timer counter
// note			: 
//*********************************************************************
void TMRA00_SetPeriod(unsigned int period){	
	TMRA0DR0 = period;              	

}


//*********************************************************************
// name			: TMRA01_SetPeriod()
// brief		: set TMRA01 timer counter
// note			: 
//*********************************************************************
void TMRA01_SetPeriod(unsigned int period){	
	TMRA0DR1 = period;              	
}


//*********************************************************************
// name			: TMRA0_16bit_SetPeriod()
// brief		: set TMRA0 timer counter
// note			: 
//*********************************************************************
void TMRA0_16bit_SetPeriod(unsigned int period){    
    TMRA0DR0 = period&0xff;             // low byte first
    TMRA0DR1 = period>>8;               // then high byte
}


//*********************************************************************
// name			: TMRA00_Start()
// brief		: start to run TMRA00
// note			: 
//*********************************************************************
void TMRA00_Start(){
	TMRA0CR0_RUN = 1;                   // start to run TMRA00
	
}


//*********************************************************************
// name			: TMRA01_Start()
// brief		: start to run TMRA01
// note			: 
//*********************************************************************
void TMRA01_Start(){
	TMRA0CR1_RUN = 1;                   // start to run TMRA01
	
}


//*********************************************************************
// name			: TMRA0_16bit_Start()
// brief		: start to run TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Start(){
	TMRA0CR1_RUN = 1;                   // start to run TMRA0
	
}


//*********************************************************************
// name			: TMRA00_Stop()
// brief		: stop and clear TMRA00
// note			: 
//*********************************************************************
void TMRA00_Stop(){
	TMRA0CR0_RUN = 0;                   // stop and clear TMRA00

}


//*********************************************************************
// name			: TMRA01_Stop()
// brief		: stop and clear TMRA01
// note			: 
//*********************************************************************
void TMRA01_Stop(){
	TMRA0CR1_RUN = 0;                   // stop and clear TMRA01

}


//*********************************************************************
// name			: TMRA0_16bit_Stop()
// brief		: stop TMRA0
// note			: 
//*********************************************************************
void TMRA0_16bit_Stop(){
	TMRA0CR1_RUN = 0;                   // stop and clear TMRA0
	
}


//*********************************************************************
// name			: __interrupt TMRA00_IRQ()
// brief		: TMRA00 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA00_IRQ(void){
	__asm("NOP");						// no operation
	TMRA00_Int_Flag = 1;				// set TMRA00_Int_Flag to 1
	
	
}


//*********************************************************************
// name			: __interrupt TMRA01_IRQ()
// brief		: TMRA01 interrupt service routine
// note			:
//*********************************************************************
void __interrupt TMRA01_IRQ(void){
	__asm("NOP");						// no operation
	TMRA01_Int_Flag = 1;				// set TMRA01_Int_Flag to 1
	
	
}

