//*************************************************************************************
// file			: SQ7653_FMC.c
// version		: V1.0 2020/07/17
// brief		: FMC and EEPROM controller related functions
// note			: FMC and EEPROM controller related functions are gathered in this subroutine
//**************************************************************************************

#include "main.h"

// ============================================================================
// Flash 
// ============================================================================
//*********************************************************************
// name			: FMC_FERR_CLEAR()
// brief		: Clear FSR 
// retval		: 
//*********************************************************************
void FMC_FERR_CLEAR()
{
	if(FSR_FERR !=0){
       FSR_FERR = 0x07;
       
	}
}



//*********************************************************************
// name			: FMC_Init()
// brief		: FMC initialization
// note			: 
//            sysclk : System clock frequency in MHz
//*********************************************************************
void FMC_Init(unsigned char sysclk)
{
	FCKDIV = sysclk - 1;
}



//*********************************************************************
// name			: FMC_PageErase()
// brief		: Flash page erase
// retval		: 0: erase successfully  
//            	  1: erase failed  
// note			: 
//*********************************************************************
unsigned char FMC_PageErase(unsigned int address)
{
    unsigned char status;								// status variable
    FMC_FERR_CLEAR();
    
	FADDR0 = (unsigned char)address & 0x00FF;			// set address register
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;
	
	FCR = 0x18;											// set page erase command 

	FDATA0 = 0xA5;										// write data 0xA5 to buffer 
	FDATA0 = 0x5A;										// write data 0x5A to buffer
	
	do{	                                              	// wait for page erase to finish
	    status = FSR;									
        status &= 0x80;
	//  status = FSR_BUSY;		
	}while(status);										

	return(FSR_FERR);									// return error message
}



//*********************************************************************
// name			: FMC_WriteByte()
// brief		: write one byte of flash data
// retval		: 0: write successfully  
//            	  1: write failed 
// note			: 
//*********************************************************************

unsigned char FMC_WriteByte(unsigned int address, unsigned char data)
{
	unsigned char status;								// status variable
	FMC_FERR_CLEAR();
    
	FDATA0 = data;                                      // write data to buffer  
	
	FADDR0 = (unsigned char)address & 0x00FF;        	// set address register
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;

	FCR = 0x04;                                  		// set data write command  
	FDATA0 = 0xA5;										// write data 0xA5 to buffer 
	FDATA0 = 0x5A;										// write data 0x5A to buffer
	
	do{                                                	// wait for write data to finish
	    status = FSR;
        status &= 0x80;
	// status = FSR_BUSY;		
	}while(status);										
	
	return(FSR_FERR);									// return error message
}



//*********************************************************************
// name			: FMC_ReadByte()
// brief		: read one byte of flash data
// note			: 
//*********************************************************************
void FMC_ReadByte(unsigned int address, unsigned char* data)
{
    FMC_FERR_CLEAR();
	FADDR0 = (unsigned char)address & 0x00FF;         	// set address register
	FADDR1 = (unsigned char)(address >> 8) & 0x00FF;
   
    FCR = 0x00;                                   		// set data read command        
	*data = FDATA0; 
}



// ============================================================================
// EEPROM 
// ============================================================================
//*********************************************************************
// name			: FMC_EEERR_CLEAR()
// brief		: Clear ESR 
// retval		: 
//*********************************************************************
void FMC_EEERR_CLEAR()
{
	if(EESR_EEERR !=0){
       EESR_EEERR = 0x07;
       
	}
}


//*********************************************************************
// name			: FMC_PageEraseEE()
// brief		: EEPROM page erase
// retval		: 0: erase successfully  
//            	  1: erase failed 
// note			: 
//*********************************************************************
unsigned char FMC_PageEraseEE(unsigned int address)
{
    unsigned char status;								// status variable
	FMC_EEERR_CLEAR();
    
	EEADDR0 = (unsigned char)address & 0x00FF;			// set address register
	EEADDR1 = (unsigned char)(address >> 8) & 0x00FF;
	
	EECR = 0x18;										// set page erase command
	EEDATA0 = 0xA5;                                    	// write data 0xA5 to buffer 
	EEDATA0 = 0x5A;                                    	// write data 0x5A to buffer  
	
	do{	                                               	// wait for page erase to finish
	    status = EESR;
        status &= 0x80; 		  
	}while(status);										

	return(EESR_EEERR);									// return error message
}



//*********************************************************************
// name			: FMC_WriteByteEE()
// brief		: write one byte of flash data
// retval		: 0: write successfully  
//            	  1: write failed   
// note			: 
//*********************************************************************
unsigned char FMC_WriteByteEE(unsigned int address, unsigned char data)
{
	unsigned char status;								// status variable
    FMC_EEERR_CLEAR();
    
	EEDATA0 = data;                                     // write data to buffer 
	
	EEADDR0 = (unsigned char)address & 0x00FF;        	// set address register
	EEADDR1 = (unsigned char)(address >> 8) & 0x00FF;

	EECR = 0x04;                                  		// set data write command  
	EEDATA0 = 0xA5;                                     // write data 0xA5 to buffer
	EEDATA0 = 0x5A;                                     // write data 0x5A to buffer
	
	do{                                                	// wait for data write to finish
	    status = EESR;
        status &= 0x80; 		  
	}while(status);										
	
	return(EESR_EEERR);									// return error message
}



//*********************************************************************
// name			: FMC_ReadByteEE()
// brief		: read one byte of flash data
// note			: 
//*********************************************************************
void FMC_ReadByteEE(unsigned int address, unsigned char* data)
{
    FMC_EEERR_CLEAR();
	EEADDR0 = (unsigned char)address & 0x00FF;       	// set address register
	EEADDR1 = (unsigned char)(address >> 8) & 0x00FF;
   
    EECR = 0x00;                                   		// set data read command       
	*data = EEDATA0; 
}


