//*************************************************************************************
// file 		: SQ7653_EINT.c
// version		: V1.0 2020/07/17
// brief		: EINT related functions
// note			: EINT related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char Push_BTN1_Flag; // external interrupt flag of button 1
unsigned char Push_BTN2_Flag; // external interrupt flag of button 2
//unsigned char Push_BTN3_Flag; // external interrupt flag of button 3

//*********************************************************************
// name			: EINT_Init()
// brief		: external interrupt initialization
// note			: SQ7653 has 10 external interrupts from EXT0 to EXT9 
//
//*********************************************************************
void EINT_Init(){
	
	//====== EINT0 (P1.0)====================================================================================================================
	PCKEN3_EINT0 = 1;                                     // enable EINT0  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR0_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR0_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR0_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	

	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR0_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR0_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR0_INTINC = 0x00;                          // fsysclk
		//EINTCR0_INTINC = 0x01;                          // fsysclk/4
		//EINTCR0_INTINC = 0x02;                          // fsysclk/8
		EINTCR0_INTINC = 0x03;                            // fsysclk/16

	
	
	//====== EINT1 (P1.1)====================================================================================================================
	PCKEN3_EINT1 = 1;                                     // enable EINT1  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR1_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR1_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR1_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR1_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR1_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR1_INTINC = 0x00;                          // fsysclk
		//EINTCR1_INTINC = 0x01;                          // fsysclk/4
		//EINTCR1_INTINC = 0x02;                          // fsysclk/8
		EINTCR1_INTINC = 0x03;                            // fsysclk/16


/*
	//====== EINT2 (P1.2)====================================================================================================================
	PCKEN3_EINT2 = 1;                                     // enable EINT2  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR2_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR2_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR2_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR2_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR2_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR2_INTINC = 0x00;                          // fsysclk
		//EINTCR2_INTINC = 0x01;                          // fsysclk/4
		//EINTCR2_INTINC = 0x02;                          // fsysclk/8
		EINTCR2_INTINC = 0x03;                            // fsysclk/16

*/
	


/*	
	//====== EINT3 (P1.3)====================================================================================================================
	PCKEN3_EINT3 = 1;                                     // enable EINT3  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR3_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR3_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR3_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR3_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR3_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR3_INTINC = 0x00;                          // fsysclk
		//EINTCR3_INTINC = 0x01;                          // fsysclk/4
		//EINTCR3_INTINC = 0x02;                          // fsysclk/8
		EINTCR3_INTINC = 0x03;                            // fsysclk/16
		
*/	


	
/*	
	//====== EINT4 (P1.4)====================================================================================================================
	PCKEN3_EINT4 = 1;                                     // enable EINT4  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======

	//--- interrupt request generation edge setting --- 
	//EINTCR4_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR4_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR4_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR4_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR4_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR4_INTINC = 0x00;                          // fsysclk
		//EINTCR4_INTINC = 0x01;                          // fsysclk/4
		//EINTCR4_INTINC = 0x02;                          // fsysclk/8
		EINTCR4_INTINC = 0x03;                            // fsysclk/16
		
*/		



/*	
	//====== EINT5 (P1.5)====================================================================================================================
	PCKEN3_EINT5 = 1;                                     // enable EINT5  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR5_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR5_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR5_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR5_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR5_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR5_INTINC = 0x00;                          // fsysclk
		//EINTCR5_INTINC = 0x01;                          // fsysclk/4
		//EINTCR5_INTINC = 0x02;                          // fsysclk/8
		EINTCR5_INTINC = 0x03;                            // fsysclk/16
		
*/		



/*	
	//====== EINT6 (P1.6)====================================================================================================================
	PCKEN3_EINT6 = 1;                                     // enable EINT6  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======

	//--- interrupt request generation edge setting --- 
	//EINTCR6_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR6_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR6_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR6_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR6_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR6_INTINC = 0x00;                          // fsysclk
		//EINTCR6_INTINC = 0x01;                          // fsysclk/4
		//EINTCR6_INTINC = 0x02;                          // fsysclk/8
		EINTCR6_INTINC = 0x03;                            // fsysclk/16
		
*/		

	

/*	
	//====== EINT7 (P1.7)====================================================================================================================
	PCKEN3_EINT7 = 1;                                     // enable EINT7  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR7_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR7_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR7_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR7_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR7_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR7_INTINC = 0x00;                          // fsysclk
		//EINTCR7_INTINC = 0x01;                          // fsysclk/4
		//EINTCR7_INTINC = 0x02;                          // fsysclk/8
		EINTCR7_INTINC = 0x03;                            // fsysclk/16
		
*/		



/*	
	//====== EINT8 (P0.7)====================================================================================================================
	PCKEN4_EINT8 = 1;                                     // enable EINT8  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR8_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR8_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR8_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR8_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR8_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR8_INTINC = 0x00;                          // fsysclk
		//EINTCR8_INTINC = 0x01;                          // fsysclk/4
		//EINTCR8_INTINC = 0x02;                          // fsysclk/8
		EINTCR8_INTINC = 0x03;                            // fsysclk/16
		
*/	



/*	
	//====== EINT9 (P0.6)====================================================================================================================
	PCKEN4_EINT9 = 1;                                     // enable EINT9  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- interrupt request generation edge setting --- 
	//EINTCR9_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge(rising edge)
	EINTCR9_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge(falling edge)
	//EINTCR9_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges(both edge)
	
	//--- noise canceller related setting ---

	  // the level of a signal that has passed through the noise canceller when interrupt request signals are generated
		EINTCR9_INTLVL  = 0;							  // 0 : initial state or signal level "L"
		//EINTCR9_INTLVL  = 1;							  // 1 : signal level "H"
	
	  // noise canceller sampling interval setting
		//EINTCR9_INTINC = 0x00;                          // fsysclk
		//EINTCR9_INTINC = 0x01;                          // fsysclk/4
		//EINTCR9_INTINC = 0x02;                          // fsysclk/8
		EINTCR9_INTINC = 0x03;                            // fsysclk/16
		
*/


}


//*********************************************************************
// name			: EINT_IntEnable()
// brief		: enable external interrupt
// note			: 
//*********************************************************************
void EINT_IntEnable(){
	__ASM("DI");	                                      // disable all maskable interrupts

	IFR_EXT0_IRQ = 0;                                     // clear EINT0 interrupt flag                                                                             
	IER_EXT0_IRQ = 1;                                     // enable EINT0 interrupt
	

	IFR_EXT1_IRQ = 0;                                     // clear EINT1 interrupt flag
	IER_EXT1_IRQ = 1;                                     // enable EINT1 interrupt

	
	/*
	IFR_EXT2_IRQ = 0;                                     // clear EINT2 interrupt flag
	IER_EXT2_IRQ = 1;                                     // enable EINT2 interrupt
	*/

	/*
	IFR_EXT3_IRQ = 0;                                     // clear EINT3 interrupt flag
	IER_EXT3_IRQ = 1;                                     // enable EINT3 interrupt
	*/


	/*
	IFR_EXT4_IRQ = 0;                                     // clear EINT4 interrupt flag
	IER_EXT4_IRQ = 1;                                     // enable EINT4 interrupt
	*/


	/*
	IFR_EXT5_IRQ = 0;                                     // clear EINT5 interrupt flag
	IER_EXT5_IRQ = 1;                                     // enable EINT5 interrupt
	*/


	/*
	IFR_EXT6_IRQ = 0;                                     // clear EINT6 interrupt flag
	IER_EXT6_IRQ = 1;                                     // enable EINT6 interrupt
	*/


	/*
	IFR_EXT7_IRQ = 0;                                     // clear EINT7 interrupt flag
	IER_EXT7_IRQ = 1;                                     // enable EINT7 interrupt
	*/
	
	
	
	/*
	IFR_EXT8_IRQ = 0;                                     // clear EINT8 interrupt flag
	IER_EXT8_IRQ = 1;                                     // enable EINT8 interrupt
	*/
	
	
	/*
	IFR_EXT9_IRQ = 0;                                     // clear EINT9 interrupt flag
	IER_EXT9_IRQ = 1;                                     // enable EINT9 interrupt
	*/	
	
	__ASM("EI");                                          // enable all maskable interrupts
}


//*********************************************************************
// name			: EINT_Stop()
// brief		: disable external interrupt
// note			: 
//*********************************************************************
void EINT_Stop(){
	IER_EXT0_IRQ = 0;                                     // disable EINT0 interrupt
	IER_EXT1_IRQ = 0;                                     // disable EINT1 interrupt
	
	//IER_EXT2_IRQ = 0; 								  // disable EINT2 interrupt
	//IER_EXT3_IRQ = 0; 								  // disable EINT3 interrupt
	//IER_EXT4_IRQ = 0; 								  // disable EINT4 interrupt
	//IER_EXT5_IRQ = 0; 								  // disable EINT5 interrupt
	//IER_EXT6_IRQ = 0; 								  // disable EINT6 interrupt
	//IER_EXT7_IRQ = 0; 								  // disable EINT7 interrupt
	//IER_EXT8_IRQ = 0; 								  // disable EINT8 interrupt
	//IER_EXT9_IRQ = 0; 								  // disable EINT9 interrupt
	
}



//*********************************************************************
// name			: __interrupt EXT0_IRQ()
// brief		: EXT0_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT0_IRQ(void){
	__asm("NOP");										  // no operation	
	Push_BTN1_Flag = 1;									  // set Push_BTN1_Flag to 1
	
}

//*********************************************************************
// name			: __interrupt EXT1_IRQ()
// brief		: EXT1_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT1_IRQ(void){
	__asm("NOP");										  // no operation	
	Push_BTN2_Flag = 1;									  // set Push_BTN2_Flag to 1
	
}

//*********************************************************************
// name			: __interrupt EXT2_IRQ()
// brief		: EXT2_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT2_IRQ(void){
	__asm("NOP");								          // no operation	
	//Push_BTN3_Flag = 1;								  // set Push_BTN3_Flag to 1
	// 
}

//*********************************************************************
// name			: __interrupt EXT3_IRQ()
// brief		: EXT3_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT3_IRQ(void){
	__asm("NOP");	                                      // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT4_IRQ()
// brief		: EXT4_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT4_IRQ(void){
	__asm("NOP");                                         // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT5_IRQ()
// brief		: EXT5_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT5_IRQ(void){
	__asm("NOP");										  // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT6_IRQ()
// brief		: EXT6_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT6_IRQ(void){
	__asm("NOP");										  // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT7_IRQ()
// brief		: EXT7_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT7_IRQ(void){
	__asm("NOP");										  // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT8_IRQ()
// brief		: EXT8_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT8_IRQ(void){
	__asm("NOP");										  // no operation
	
}

//*********************************************************************
// name			: __interrupt EXT9_IRQ()
// brief		: EXT9_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt EXT9_IRQ(void){
	__asm("NOP");										  // no operation
	
}


