//*************************************************************************************
// file			: SQ7653_Delay_Loop.h
// version		: V1.0 2020/07/17 2020/09/03
// brief		: SQ7653_Delay_Loop header file
// note			:        
//**************************************************************************************
#ifndef _SQ7653_DELAY_LOOP_H__
#define _SQ7653_DELAY_LOOP_H__

/* ---------------------- extern global variables ------------------------- */
extern volatile  unsigned int  Delay_base_ms;
extern volatile  unsigned int  Delay_base_100us;

/* ---------------------- user-defined macros ------------------------------ */
#define PLL         1
 
#define PLL_24M    	0x00	  // system frequency divided by 1    (24M/1 = 24MHz) 
#define	PLL_12M  	0x01	  // system frequency divided by 2    (24M/2 = 12MHz) 
#define PLL_6M  	0x02	  // system frequency divided by 4    (24M/4 = 6MHz) 

// the number of loops required for the 1ms Delay Loop function corresponding to each system frequency is defined here
#define f24m_1ms_t    (1496)  // this is the number of loops required by the Delay Loop function for 1ms at PLL 24MHz, please do not modify this definition!
#define f12m_1ms_t    (1496/2)
#define f06m_1ms_t    (1496/4)

// the number of loops required for the 100us Delay Loop function corresponding to each system frequency is defined here
#define f24m_100us_t  (149)   // this is the number of loops required by the Delay Loop function for 100us at PLL 24MHz, please do not modify this definition!



//------------------------------------------------------------------
void Delay_Loop_Init();
void delay_ms(uint x);
void delay_100us(uint y);


#endif


