//*************************************************************************************
// file			: main.h
// version		: V1.0 2020/07/17
// brief		: header file of this example
// note			: the custom variables used are collected in this document in this header file
//**************************************************************************************
#ifndef _INCLUDES_H__
#define _INCLUDES_H__

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "SQ7653_SFR.h"
#include "SQ7653_DIC.h"

#define BTN1_in    P1DI_P0
#define BTN2_in    P1DI_P1
#define BTN3_in    P1DI_P2

#define LED1_out   P0DO_P0
#define LED2_out   P0DO_P1
#define LED3_out   P0DO_P2

//****************************************************
//  transfer the value in binary in C language **********************
//****************************************************
#define Define2Bin(n)        \
(                            \
    ( ( n >> 21 ) & 0x80 ) | \
    ( ( n >> 18 ) & 0x40 ) | \
    ( ( n >> 15 ) & 0x20 ) | \
    ( ( n >> 12 ) & 0x10 ) | \
    ( ( n >>  9 ) & 0x08 ) | \
    ( ( n >>  6 ) & 0x04 ) | \
    ( ( n >>  3 ) & 0x02 ) | \
    ( ( n       ) & 0x01 )   \
)
#define set8bit(n)  Define2Bin(0x##n##L)
//  The value can be written in binary in the program as follows
//  tempVAR = set8bit(10101010);   <==>   temp = 0xAA;
//****************************************************

#define BIT0  0x0001
#define BIT1  0x0002
#define BIT2  0x0004
#define BIT3  0x0008
#define BIT4  0x0010
#define BIT5  0x0020
#define BIT6  0x0040
#define BIT7  0x0080
#define BIT8  0x0100
#define BIT9  0x0200
#define BIT10 0x0400
#define BIT11 0x0800
#define BIT12 0x1000
#define BIT13 0x2000
#define BIT14 0x4000
#define BIT15 0x8000

#define M_SET(n,c)  ((n) |= (c))     
#define M_CLR(n,c)  ((n) &= ~(c))

/* ---------------------- extern functions ------------------------ */
extern void STARTUP(void);



#endif //#ifndef _INCLUDES_H__

