//*************************************************************************************
// file			: SQ7653_DIC.h
// version		: V1.0 2020/07/17
// brief		: DIC header file
// note			: 
//**************************************************************************************
#ifndef _SQ7653_DIC_H__
#define _SQ7653_DIC_H__

extern unsigned char dic_crc[4];			// array to keep the crc checksum for sequence 1
extern unsigned char dic_crc_check[4];	// array to keep the crc checksum for sequence 2

// Source address
extern unsigned char in_addr_sram[4];
extern unsigned char in_addr_flash[4];
extern unsigned char in_addr_rom[4];
extern unsigned char dic_result;


void DIC_Setup();
void DIC_Get_result(unsigned char  *dic_data);
unsigned char DIC_Done(void);
void DIC_Init(unsigned char *src, size_t length);
void DIC_Disable(void);

unsigned char Cmp_CRC(unsigned char *crc1, unsigned char *crc2);
void __interrupt DIC_IRQ(void);

#endif