//******************************************
// file 		: SQ7653_TMRA_Complementary
// version		: V1.0 2020/07/17
// brief		: TMRA_Complementary header file
// note			:
//******************************************
#ifndef _SQ7653_TMRA_Complementary_H__
#define _SQ7653_TMRA_Complementary_H__

/******************
 * 1st Argument
 * ****************/
/* ---------------------- user-defined macros ------------------------------ */
//For t_mod_sel------
#define set_8bit    			0x00		    // 8-bit mode
#define output  				0x01		    // timer 0 and 1 outputs AND together to TA01O  
#define set_16bit  			    0x02		    // 16-bit mode
#define pre_scale   			0x04		    // pre-scale mode
#define complementary   		0x05		    // complementary mode

//For op_mod_sel------
#define timer    				0x00		    // timer mode
#define event_counter  		    0x01		    // event counter mode 
#define capture  				0x03	  	    // capture mode
#define PWM  					0x04		    // pulse width modulation (PWM) mode
#define pulse_measure 		    0x05		    // pulse width measurement mode
#define PPG						0x06		    // programmable pulse generate (PPG) mode

extern unsigned char TMRA00_Int_Flag;		  	// TMRA00 interrupt flag
extern unsigned char TMRA01_Int_Flag;		  	// TMRA01 interrupt flag

void TMRA00_Timer_Init(void);
void TMRA0_16BIT_Complementary_Init(void);
void TMRA1_16BIT_Complementary_Init(uchar CP_mode);
//====================
void TMRA0_16BIT_SetDuty(uint duty);
void TMRA0_16BIT_SetPeriod(uint period);
//======================
void TMRA0_Setdead time(uchar scale, uchar Dtime);
void TMRA0_Fault_Detect_Init(uchar FD_mode);
//======================

void TMRA00_Start(void);
void TMRA01_Start(void);
void TMRA11_Start(void);
void TMRA00_Stop(void); 
void TMRA01_Stop(void);
void TMRA11_Stop(void);

void TMRA00_IntEnable(void);
void TMRA01_IntEnable(void);
void TMRA00_IntDisable(void);
void TMRA01_IntDisable(void);

void __interrupt TMRA00_IRQ(void);
void __interrupt TMRA01_IRQ(void);
void __interrupt TMRA11_IRQ(void);


#endif








