//*************************************************************************************
// file			: SQ7653_TBT.c
// version		: V1.0 2020/07/17
// brief		: TBT related functions
// note			: TBT related functions are collected in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char TBT_Int_Flag;		   // TBT interrupt flag

//*********************************************************************
// name			: TBT_Init()
// brief		: TBT initialization
// note			: 
//*********************************************************************
void TBT_Init(){
	TBTCR_DV9CK = 0;                    // set DV9CK to 0
    TBTCR_TBTCK = 0x09;                 // selects the TBT interrupt frequency
										// set interrupt frequency to fcgck / 2^22
										// 								     (fcgck / 2^20 = 22.888Hz)
										// T=1/22.888 = 43.69ms
}


//*********************************************************************
// name			: TBT_IntEnable()
// brief		: TBT initialization
// note			: 
//*********************************************************************
void TBT_IntEnable(){	
    __ASM("DI");						// enable all maskable interrupts
	IER_TBT_IRQ = 1;                   // enable TBT interrupt
	__ASM("EI");                        // enable all maskable interrupts
}


//*********************************************************************
// name			: TBT_Start()
// brief		: start TBT
// note			: 
//*********************************************************************
void TBT_Start(){	
	TBTCR_TBTEN = 1;
}


//*********************************************************************
// name			: TBT_Stop()
// brief		: stop TBT
// note			: 
//*********************************************************************
void TBT_Stop(){	
	TBTCR_TBTEN = 0;
}


//*********************************************************************
// name			: __interrupt IntTBT()
// brief		: TBT interrupt subroutine
// note			:
//*********************************************************************
void __interrupt TBT_IRQ(void){
	__asm("NOP");						// no operation
	TBT_Int_Flag = 1;					// set TBT interrupt flag to 1
	
}
