//*************************************************************************************
// file			: SQ7653_CMP.c
// version		: V1.0 2020/07/17
// brief		: COMPARATOR related functions
// note			: CMP related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

unsigned char CMP_Int_Flag;		      // CMP interrupt flag
//*********************************************************************
// name			: CMP_Init()
// brief		: CMP initialization
// note			: 
//*********************************************************************
void CMP_Init(){
	PCKEN6_CMP = 1;                   
	P1CFGCR = 0x8F;                   // set COM0P pin
	P1CFGCR = 0x9F;                   // set COM0N pin
	P3CFGCR = 0x8F;                   // set CMPO pin
	CMPSR_CMPO = 1;                	  // enable CMP result output
	
}


//*********************************************************************
// name			: CMP_IntEnable()
// brief		: enable CMP interrupt
// note			: 
//*********************************************************************
void CMP_IntEnable(){
	__ASM("DI");
	IER_CMP_IRQ = 1;
	CMPCR_CMPES = 0x03;               // 1: interrupt is generated on CMPO rising edge. 2: interrupt is generated on CMPO falling edge. 3: interrupt is generated both on CMPO rising edge or falling edge
	CMPCR_CMPIE = 1;                  // enable CMP interrupt
	__ASM("EI");
}


//*********************************************************************
// name			: CMP_Start()
// brief		: start CMP
// note			: 
//*********************************************************************
void CMP_Start(){
	CMPCR_CMPEN = 1;              
}


//*********************************************************************
// name			: CMP_Stop()
// brief		: stop CMP
// note			: 
//*********************************************************************
void CMP_Stop(){
	CMPCR_CMPEN = 0; 
}


//*********************************************************************
// name			: __interrupt CMP_IRQ()
// brief		: CMP_IRQ interrupt service routine
// note			:
//*********************************************************************
void __interrupt CMP_IRQ(void){
	__asm("NOP");							  // no operation
	CMPSR_CMPIF = 1;                          // clear interrupt flag
	CMP_Int_Flag = 1;

}

