//*************************************************************************************
// file			: SQ7653_TBT.h
// version		: V1.0 2020/07/17
// brief		: TBT header file
// note			: 
//**************************************************************************************
#ifndef _SQ7653_TBT_H__
#define _SQ7653_TBT_H__

#define TBT_HF    0                     // high-speed frequency clock/2^9
#define TBT_LF    1                     // low-frequency clock/2^2

#define TBT_CKDIV_1073741824    0x00	//TBT interrupt frequency : fcgck/2^30 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_536870912	    0x01	//TBT interrupt frequency : fcgck/2^29 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_268435456	    0x02	//TBT interrupt frequency : fcgck/2^28 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_134217728	    0x03	//TBT interrupt frequency : fcgck/2^27 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_67108864	    0x04	//TBT interrupt frequency : fcgck/2^26 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_33554432	    0x05	//TBT interrupt frequency : fcgck/2^25 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_16777216	    0x06	//TBT interrupt frequency : fcgck/2^24 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_8388608	    0x07	//TBT interrupt frequency : fcgck/2^23 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_4194304	    0x08	//TBT interrupt frequency : fcgck/2^22 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_1048576 	    0x09	//TBT interrupt frequency : fcgck/2^20 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_32768	        0x0A	//TBT interrupt frequency : fcgck/2^15 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_8192	        0x0B	//TBT interrupt frequency : fcgck/2^13 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_4096	        0x0C	//TBT interrupt frequency : fcgck/2^12 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_2048	        0x0D	//TBT interrupt frequency : fcgck/2^11 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_1024	        0x0E	//TBT interrupt frequency : fcgck/2^10 (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0
#define TBT_CKDIV_256		    0x0F	//TBT interrupt frequency : fcgck/2^8  (Hz) valid in normal mode or sleep mode and TBTCR<DV9CK>=0

extern unsigned int TBT_Int_Flag;		// TBT interrupt flag

void TBT_Init();
void TBT_IntEnable();
void TBT_Start();
void TBT_Stop();
void __interrupt TBT_IRQ(void);
#endif