//*************************************************************************************
// file			: SQ7653_ADC.h
// version		: V1.0 2020/07/17
// brief		: ADC header file
// note			: 
//**************************************************************************************

#ifndef _SQ7653_ADC_H__
#define _SQ7653_ADC_H__

#define	ad_test_times       16
#define ADC_RefScale(x)    (x/4096)         // x fills in the value of uV

#define IRFEN_VDD   0x01
#define IRFEN_XREF  0x02

#define AMD_Stop    0x00
#define	AMD_Single  0x01
#define AMD_Repeat  0x03
#define AMD_Mask    0x03


#define EVSEL_ADRS     0x00
#define EVSEL_TMRA00   0x08
#define EVSEL_TMRA01   0x09
#define EVSEL_TMRA30   0x0A
#define EVSEL_TMRA31   0x0C
#define EVSEL_EINT7    0x0D

#define AIN0	       0x0
#define AIN1	       0x1
#define AIN2	       0x2
#define AIN3	       0x3
#define AIN4	       0x4
#define AIN5	       0x5
#define AIN6	       0x6
#define AIN7	       0x7


extern uint  ADC_Code_READ;

void ADC_Init();
void ADC_Start();
void ADC_Stop();
void ADC_IntEnable();
void ADC_Disable();
unsigned int ADC_Convert_Repeat();
void ADC_Convert_Single();
char ADC_ConvertDone();
long ADC_Read_Value(unsigned char chsel);
void __interrupt ADC_IRQ(void);

#endif