//SQ7653_ADC_Repeat_mode example
//*************************************************************************************
// file			: main.c
// version		: V1.0 2020/07/17
// brief		: main program
// description	: select 3.00V as reference voltage
//			  this example uses repeat mode : ADC repeat mode is performed automatically after initialization
// note			: connect P1.4 (AIN_4) to the measured voltage
//			  * If the reference voltage does not use this example (3.090V),you need to modify the program of voltage conversion unit in this main.c according to your requirements    
//               ain4_mv = (ADC_Code_READ*ADC_RefScale(actual VDD voltage))/1000;
// example		:
// ain4_mv = (ADC_Code_READ*ADC_RefScale(3090000))/1000;  // ADC value is converted into unit of milli-volt if VDD voltage is 3.09V
// ain4_mv = (ADC_Code_READ*ADC_RefScale(5000000))/1000;  // ADC value is converted into unit of milli-volt if VDD voltage is 5.00V
//**************************************************************************************

#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"


/* ---------------------- global variables -------------------------- */
unsigned int ADC_Code_READ;                   // store the ADC value
long ain4_mv;                          		  // ADC value converted to voltage value (in mv)

/* ----------------------- main program --------------------------- */
void main()
{
	unsigned char temp;
	
/* ---------------------- system initialization ------------------------ */

	
/* ---------------------- pin configuration initialization ------------------------ */


/* ---------------------- ADC initialization ------------------------ */
 	ADC_Init();								  // ADC initialization,ADC reference voltage : VDD
	ADC_Start();                        
	
    while(1){ 

        CLR_WDT;                        	  // clear the watchdog timer 
		NOP;                            	  // no operation
        NOP;                            	  // no operation    
        NOP;                            	  // no operation
		
		// perform repeat mode and return the average ADC converted value
		ADC_Code_READ = ADC_Convert_Repeat(AIN4);			 
		
		// ---if the reference voltage is AVDD and emulation is used, the VDD voltage of the IC should be checked first----
		// need to set according to actual VDD voltage
		ain4_mv = (ADC_Code_READ*ADC_RefScale(3090000))/1000;  // ADC value is converted into unit of milli-volt if VDD voltage is 3.09V
		
		//ain4_mv = (ADC_Code_READ*ADC_RefScale(4810000))/1000;   // ADC value is converted into unit of milli-volt if VDD voltage is 4.81V
		//ain4_mv = (ADC_Code_READ*ADC_RefScale(5000000))/1000;   // ADC value is converted into unit of milli-volt if VDD voltage is 5.00V
		
		__asm("NOP");                            	              // no operation, the break point can be set here
	
    }
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n WDT_IRQ(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n SWI_IRQ(void)              // software reset interrupt service routine
{
	SWRST = 0x5a;
	SWRST = 0xa5;
	SWRST = 0xc3;
	SWRST = 0x3c;	
}
/* ------------------- end of interrupt service routine ------------------ */


/* -------------------- SQ7653 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 
void * const IntTbl1[] = {
	OnlyReti,				/* 0xff3a : Reserved		*/									
	OnlyReti,				/* 0xff3c : Reserved		*/									
	OnlyReti,				/* 0xff3e : Reserved		*/									
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : Reserved		*/									
	OnlyReti,				/* 0xff5a : Reserved        */								
	OnlyReti,				/* 0xff5c : Reserved        */									
	OnlyReti,				/* 0xff5e : Reserved        */									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved    	*/
	OnlyReti,				/* 0xff6c : TX2_IRQ			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : RX2_IRQ			*/	//interrupt source:UART2 RX2	
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : Reserved		*/									
	OnlyReti,				/* 0xff78 : Reserved		*/									
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/		
	OnlyReti,		    	/* 0xff82 : EXT9_IRQ		*/	//external interrupt9							
	OnlyReti,	    		/* 0xff84 : EXT8_IRQ		*/	//external interrupt8								
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : Reserved		*/									
	OnlyReti,				/* 0xff8e : Reserved		*/									
	OnlyReti,				/* 0xff90 : TX1_IRQ		    */	//interrupt source:UART1 TX1						
	OnlyReti,				/* 0xff92 : RX1_IRQ		    */	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : TMRA41_IRQ		*/	//interrupt source:counter1 of TMRA4								
	OnlyReti,				/* 0xff9a : TMRA40_IRQ		*/	//interrupt source:counter0 of TMRA4								
	OnlyReti,				/* 0xff9c : TMRA31_IRQ		*/	//interrupt source:counter1 of TMRA3								
	OnlyReti,				/* 0xff9e : TMRA30_IRQ		*/	//interrupt source:counter0 of TMRA3								
	OnlyReti,				/* 0xffa0 : EE_IRQ			*/	//interrupt source:EEPROM						
	OnlyReti,				/* 0xffa2 : EXT7_IRQ		*/	//external interrupt7						
	OnlyReti,				/* 0xffa4 : EXT6_IRQ		*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : EXT5_IRQ		*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : EXT4_IRQ		*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/									
	OnlyReti,				/* 0xffb0 : DIC_IRQ			*/	//interrupt source:DIC							
	OnlyReti,				/* 0xffb2 : CRC_IRQ			*/	//interrupt source:CRC								
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : FMC_IRQ			*/	//interrupt source:FMC								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : CMP_IRQ  		*/	//interrupt source:Comparator								
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,			    /* 0xffce : ADC_IRQ			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : EXT3_IRQ		*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : EXT2_IRQ		*/	//external interrupt2							
	OnlyReti,				/* 0xffd4 : EXT1_IRQ		*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : EXT0_IRQ		*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : SIO0_IRQ		*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : I2C0_IRQ		*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : TX0_IRQ			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : RX0_IRQ			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : TMRA21_IRQ		*/	//interrupt source:counter1 of TMRA2					
	OnlyReti,				/* 0xffe4 : TMRA20_IRQ		*/	//interrupt source:counter0 of TMRA2								
	OnlyReti,				/* 0xffe6 : TMRA11_IRQ		*/	//interrupt source:counter1 of TMRA1								
	OnlyReti,				/* 0xffe8 : TMRA10_IRQ		*/	//interrupt source:counter0 of TMRA1
	OnlyReti,				/* 0xffea : TMRA01_IRQ		*/	//interrupt source:counter1 of TMRA0							
	OnlyReti,				/* 0xffec : TMRA00_IRQ		*/	//interrupt source:counter0 of TMRA0								
	OnlyReti,			    /* 0xffee : LVD1_IRQ		*/	//interrupt source:low voltage detection1
	OnlyReti, 			    /* 0xfff0 : TBT_IRQ			*/	//interrupt source:time base timer						
	OnlyReti,				/* 0xfff2 : Reserved		*/
	OnlyReti,				/* 0xfff4 : Reserved		*/
	OnlyReti,				/* 0xfff6 : LVD0_IRQ		*/	//interrupt source:low voltage detection0							
	WDT_IRQ,				/* 0xfff8 : WDT_IRQ			*/	//non-maskable interrupt source:watchdog timer	
	(void *)0xffff,			/* 0xfffa : Reserved		*/		
	SWI_IRQ,				/* 0xfffc : SWI_IRQ/INTUNDEF*/	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/*----------------- end of SQ7653 interrupt vector -----------------*/

