//SQ7617_WDT example
//*************************************************************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// description	: at the beginning of the program, LED1 (P2.0) lights up for a short time and then starts to blink, and then WDT starts
// 
//            1. when the LED is blinking, it means program keeps clearing watchdog timer
//            2. when pressing button 1,  program stop clearing watchdog timer
//               and then WDT reset occurs, the system is reset and LED1 (P2.0) can be seen to return to light for a short time and then start to blink
// 
// note			: [Button Configuration] button 1 :  BTN1(P3.0) external interrupt(IntEXT0)
// 
//			  [LED Configuration]  LED 1  (P2.0)
// 
//            * please do not run this program in debug mode
//**************************************************************************************
#ifndef	IO_MEM

#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned char bWDT_test;
unsigned int K,Z = 0;						  // variables for delayed loop

/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */
	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                        	  // set P2.0, P2.1 and P2.2 as output pins
    P3OE  = 0x7C;                        	  // set P3.0, P3.1 and P3.7 as input pins
	P3PU |= 0x83;                       	  // enable P3.0, P3.1 and P3.7 built-in pull-up resistors
	LED1_out = 1;							  // set LED1 to the light off
/* ---------------------- EINT initialization ------------------------ */
	EINT_Init();                        	  // initialize EINT
	EINT_IntEnable();                   	  // enable EINT interrupt
/* -------- delayed for a period of time, so that LED1 is lit for a period of time -------- */	
	for(K=2000;K>0;K--){
		for(Z=0;Z<2000;Z++){
			NOP;							  // no operation
			NOP;						      // no operation
			NOP;                              // no operation
		}
    LED1_out = 0;                             // light on LED1
	}	
/* ---------------------- TBT initialization -------------------------- */
	TBT_Init();                         	  // initialize TBT
	TBT_IntEnable();                    	  // enable TBT interrupt
	TBT_Start();                        	  // start TBT  
/* ---------------------- WDT initialization ------------------------ */
	WDCTR_WDTEN = 0;                    	  // disable WDT
	WDCDR = 0xB1;                       	  // write disable code	
	
	WDCTR_WDTW = 0x00;                  	  // tThe 8-bit up counter is cleared by writing the clear code at any point within the overflow time of the 8-bit up counter
	WDCTR_WDTT = 0x03;                  	  // set overflow time : 2^24 / fsysclk(24MHz) = 0.699s
	
	WDCTR_WDTOUT = 1;                   	  // WDT reset request signal when overflow
	//WDCTR_WDTOUT = 0;                   	  // WDT interrupt request signal when overflow

	WDCTR_WDTEN = 1;                    	  // enable WDT	
	bWDT_test = 0;
    //---------------------------------------------------------------------   
	while(1){
		if(bWDT_test==0){
			__asm("NOP");					  // no operation
			WDCDR = 0x4E;                	  // clear the watchdog timer 
			
 		    if(TBT_Int_Flag){       	  	  // wait for TBT interrupt flag to be 1
			TBT_Int_Flag = 0;  	  			  // clear TBT interrupt flag to 0 for the next interrupt		
				LED1_out =~LED1_out;		  // LED1(P2.0) inverted
			}

			if(Push_BTN1_Flag){      	  	  // wait for external interrupt flag of button = 1
				Push_BTN1_Flag = 0;			  // clear external interrupt flag in order to wait for the next press
				bWDT_test =1;                 // 
            }
		}
    }
	
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)               // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7617 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	IntEXT0,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//***I2C0 interrupt reserved for internal EEPROM use only***									
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	IntTBT,					/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7617 interrupt vector ---------------------- */

