//*************************************************************************************
// file			: SQ7617_HIRC_System_Init.h
// version		: V1.0
// brief		: HIRC_System_Init header file
// note			: 
//**************************************************************************************

#ifndef _SQ7617_HIRC_System_Init_H__
#define _SQ7617_HIRC_System_Init_H__

/* ---------------------- extern global variables ------------------------- */




/* ---------------------- user-defined macros ------------------------------ */
#define HIRC_16M    0x00	// system frequency divided by 1  (16M/1  = 16MHz)
#define HIRC_8M     0x01	// system frequency divided by 2  (16M/2  = 8MHz)
#define HIRC_4M		0x02	// system frequency divided by 4  (16M/4  = 4MHz)
#define HIRC_2M     0x03   	// system frequency divided by 8  (16M/8  = 2MHz)
#define HIRC_1M     0x04   	// system frequency divided by 16 (16M/16 = 1MHz)

#define HIRC_500K   0x05 	// system frequency divided by 32 (16M/32 = 0.5MHz = 500KHz)
#define HIRC_250K   0x06 	// system frequency divided by 64 (16M/64 = 0.25MHz = 250KHz)
#define HIRC_62_5K  0x07	// system frequency divided by 128(16M/128= 0.0625MHz = 62.5KHz)


//------------------------------------------------------------------
void HIRC_System_Init(unsigned char F_div_sel);		// HIRC initialization
void HIRC_Freq_Division(unsigned char F_div_sel);	// HIRC frequency division selection


#endif


