//*************************************************************************************
// file			: SQ7617_RTC.c
// version		: V1.0
// brief		: RTC related functions
// note			: RTC related functions are gathered in this subroutine  [for SQ7617_RTC_Timer example]
//**************************************************************************************
#include "main.h"

unsigned char RTC_timer_actFlag;			  // flag for timeout interrupt

//*********************************************************************
// name			: RTC_Init()
// brief		: RTC initialization
// note			:
//*********************************************************************
void RTC_Init()
{
	PCKEN6_RTC = 1;	                    	  // enable RTC clock

}


//*********************************************************************
// name			: RTC_IntEnable()
// brief		: enable RTC interrupt
// note			:
//*********************************************************************
void RTC_IntEnable(unsigned char intsel,unsigned char enable){
	__ASM("DI");							// disable all maskable interrupts
	
	IER_RTC = enable;		                
	RTCCR1 = intsel;
	
	__ASM("EI");							// enable all maskable interrupts
}

//*********************************************************************
// name			: RTC_IntDisable()
// brief		: disable RTC interrupt
// note			:
//*********************************************************************
void RTC_IntDisable(){
	__ASM("DI");							// disable all maskable interrupts
	IER_RTC = 0;		
	RTCCR1 =  0x00;              
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: RTC_Start()
// brief		: start RTC
// note			:
//*********************************************************************
void RTC_Start(void)
{
	RTCCR0_RTCEN = 1;		                  // start RTC
}


//*********************************************************************
// name			: RTC_Stop()
// brief		: stop RTC
// note			:
//*********************************************************************
void RTC_Stop(void)
{
	RTCCR0_RTCEN = 0;			              // stop RTC
}

//*********************************************************************
// name			: RTC_TimerSetAndEnable()
// brief		: set RTC timer function
// note			: timer timeout setting
//*********************************************************************
void RTC_TimerSetAndEnable(void)
{
	RTCCR0 = 0x00;							  // RTC setting
	RTCCR1 |= 0x08;							  // enable RTC timeout interrupt (RTCCR1_TOIE = 1)

	//RTCTMRCR_CONT = 0;					  // set RTC to single mode
	RTCTMRCR_CONT = 1;						  // set RTC to continuous mode

//--- timer source clock selection ---// when CLKSEL=00, RTCCLK = (LXTAL/8)
	//RTCTMRCR_TMRSEL = 0;					  // RTCCLK          when CLKSEL=00, T=1/(LXTAL/8)	       = 244.140625us
	RTCTMRCR_TMRSEL = 1;					  // RTCCLK/64		 when CLKSEL=00, T=1/[(LXTAL/8)/64]   = 15.625ms
	//RTCTMRCR_TMRSEL = 2;					  // RTCCLK/4096     when CLKSEL=00, T=1/[(LXTAL/8)/4096] = 1sec
	//RTCTMRCR_TMRSEL = 3;					  // MINCLK
	
//--- RTC timeout value (must larger than 0) ---//
	//RTCTMRTO = 8;				  	      	  // RTCTMRCR_TMRSEL = 1, about 125ms  (15.625ms*8=125ms)
	//RTCTMRTO = 16;				  	      // RTCTMRCR_TMRSEL = 1, about 250ms  (15.625ms*16=250ms)
	//RTCTMRTO = 24;				  	      // RTCTMRCR_TMRSEL = 1, about 375ms  (15.625ms*24=375ms)
	  RTCTMRTO = 32;				  	      // RTCTMRCR_TMRSEL = 1, about 500ms  (15.625ms*32=500ms)
	//RTCTMRTO = 40;				  	      // RTCTMRCR_TMRSEL = 1, about 625ms  (15.625ms*40=625ms)
	//RTCTMRTO = 48;				  	      // RTCTMRCR_TMRSEL = 1, about 750ms  (15.625ms*48=750ms)
	//RTCTMRTO = 56;				  	      // RTCTMRCR_TMRSEL = 1, about 875ms  (15.625ms*56=875ms)
	//RTCTMRTO = 64;				  	      // RTCTMRCR_TMRSEL = 1, about 1s     (15.625ms*64=1s)
}


//*********************************************************************
// name			: RTC_TimerStart()
// brief		: enable RTC timer function
// note			:
//*********************************************************************
void RTC_TimerStart(void)
{
	RTCTMRCR_TMREN = 1;						  // enable RTC timer function
}

//*********************************************************************
// name			: RTC_TimerStop()
// brief		: disable RTC timer function
// note			:
//*********************************************************************
void RTC_TimerStop(void)
{
	RTCTMRCR_TMREN = 0;						  // disable RTC timer function
	while(RTCTMRCR_TMRST != 0); 			  // make sure timer stop
}


//*********************************************************************
// name			: __interrupt IntRTC()
// brief		: RTC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRTC(void)
{
	__asm("NOP");					    	  // no operation

/*	
	//--- second interrupt ---
	if (RTCCR1_SECF == 1 )			    	  // second interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x40;    	  // clear second interrupt flag
		
		RTC_1sec_actFlag = 1;				  // set RTC_1sec_actFlag to 1
		LED1_out = ~LED1_out;
		
	}
*/
	
/* 	
	//--- alarm interrupt ---
	if(RTCCR1_ALF == 1)						  // alarm interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x20;		  // clear alarm interrupt flag
		
		RTC_alarm_actFlag = 1;				  // set RTC_alarm_actFlag to 1
	} 
*/
	


	//--- timer overtime interrupt ---
	if (RTCCR1_TOF == 1)			    	  // timer overtime interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x80;		  // clear timer overtime interrupt flag
		RTC_timer_actFlag = 1;				  // set RTC_timer_actFlag to 1
		LED1_out = ~LED1_out;
	}

	
}


