//*************************************************************************************
// file			: SQ7617_RTC.h
// version		: V1.0
// brief		: RTC header file
// note			: [for SQ7617_RTC_1Sec example]
//**************************************************************************************
#ifndef _SQ7617_RTC_H__
#define _SQ7617_RTC_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char RTC_1sec_actFlag;			  // flag for second interrupt



/* ---------------------- user-defined macros ------------------------------ */
#define RTC_TIE   	0x08
#define RTC_SIE   	0x04
#define RTC_AIE   	0x02
#define RTC_WREIE 	0x01


//------------------------------------------------------------------
void RTC_Init();											 	// RTC initialization
void RTC_IntEnable(unsigned char intsel,unsigned char enable);  // enable RTC interrupt
void RTC_IntDisable(); 					// disable RTC interrupt
void RTC_Start(void);                   // start RTC
void RTC_Stop(void);                    // stop RTC
void RTC_TimerSetAndEnable(void);       // set RTC function
void RTC_TimerStart(void);              // enable RTC timer function
void RTC_TimerStop(void);               // disable RTC timer function
void __interrupt IntRTC(void);			// RTC interrupt service routine
#endif


