//*************************************************************************************
// file			: SQ7617_RTC.c
// version		: V1.0
// brief		: RTC related functions
// note			: RTC related functions are gathered in this subroutine  [for SQ7617_RTC_1Sec example]
//**************************************************************************************
#include "main.h"

unsigned char RTC_1sec_actFlag;			  	  // flag for second interrupt

//*********************************************************************
// name			: RTC_Init()
// brief		: RTC initialization
// note			:
//*********************************************************************
void RTC_Init()
{
	PCKEN6_RTC = 1;	                    	  // enable RTC clock

}


//*********************************************************************
// name			: RTC_IntEnable()
// brief		: enable RTC interrupt
// note			:
//*********************************************************************
void RTC_IntEnable(unsigned char intsel,unsigned char enable){
	__ASM("DI");							// disable all maskable interrupts
	
	IER_RTC = enable;		                
	RTCCR1 = intsel;
	
	__ASM("EI");							// enable all maskable interrupts
}

//*********************************************************************
// name			: RTC_IntDisable()
// brief		: disable RTC interrupt
// note			:
//*********************************************************************
void RTC_IntDisable(){
	__ASM("DI");							// disable all maskable interrupts
	IER_RTC = 0;		
	RTCCR1 =  0x00;              
	__ASM("EI");							// enable all maskable interrupts
}


//*********************************************************************
// name			: RTC_Start()
// brief		: start RTC
// note			:
//*********************************************************************
void RTC_Start(void)
{
	RTCCR0_RTCEN = 1;		                  // start RTC
}


//*********************************************************************
// name			: RTC_Stop()
// brief		: stop RTC
// note			:
//*********************************************************************
void RTC_Stop(void)
{
	RTCCR0_RTCEN = 0;			              // stop RTC
}

//*********************************************************************
// name			: RTC_TimerSetAndEnable()
// brief		: set RTC function
// note			:
//*********************************************************************
void RTC_TimerSetAndEnable(void)
{
	RTCCR0 = 0x00;							  // RTC setting
	RTCCR1 |= 0x08;							  // enable RTC timeout interrupt (RTCCR1_TOIE = 1)

	//RTCTMRCR_CONT = 0;					  // set RTC to single mode
	RTCTMRCR_CONT = 1;						  // set RTC to continuous mode

	RTCTMRTO = 0x02;						  // RTC timeout value (must larger than 0)
}


//*********************************************************************
// name			: RTC_TimerStart()
// brief		: enable RTC timer function
// note			:
//*********************************************************************
void RTC_TimerStart(void)
{
	RTCTMRCR_TMREN = 1;						  // enable RTC timer function
}

//*********************************************************************
// name			: RTC_TimerStop()
// brief		: disable RTC timer function
// note			:
//*********************************************************************
void RTC_TimerStop(void)
{
	RTCTMRCR_TMREN = 0;						  // disable RTC timer function
	while(RTCTMRCR_TMRST != 0); 			  // make sure timer stop
}


//*********************************************************************
// name			: __interrupt IntRTC()
// brief		: RTC interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntRTC(void)
{
	__asm("NOP");					    	  // no operation
	
	//--- second interrupt ---
	if (RTCCR1_SECF == 1 )			    	  // second interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x40;    	  // clear second interrupt flag
		
		RTC_1sec_actFlag = 1;				  // set RTC_1sec_actFlag to 1
		LED1_out = ~LED1_out;
		
	}

	
/* 	
	//--- alarm interrupt ---
	if(RTCCR1_ALF == 1)						  // alarm interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x20;		  // clear alarm interrupt flag
		
		
		RTC_alarm_actFlag = 1;				  // set RTC_alarm_actFlag to 1
	} 
*/
	

/*	
	//--- timer overtime interrupt ---
	if (RTCCR1_TOF == 1)			    	  // timer overtime interrupt is generated
	{
		RTCCR1 = (RTCCR1&0x0F)|0x80;		  // clear timer overtime interrupt flag

	}
*/
	
}


