//*************************************************************************************
// file			: SQ7617_KWU.c
// version		: V1.0
// brief		: KWU related functions
// note			: KWU related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"



//******************************************************************************
// name			: KWU_Pin_Select()
// brief		: select KWU pin
// note			: the comment block '//' can be uncommented to set other KWUs
//			  one KWU can be only selected for one pin
//******************************************************************************
void KWU_Pin_Select(void)
{
//====== KWU 0 ======
//KWUSR0_KWU0 = 0x00;                 	  // set KWU pin to P0.0
//KWUSR0_KWU0 = 0x01;                 	  // set KWU pin to P1.0
//KWUSR0_KWU0 = 0x02;                 	  // set KWU pin to P2.0
KWUSR0_KWU0 = 0x03;                 	  // set KWU pin to P3.0

//====== KWU 1 ======
//KWUSR0_KWU1 = 0x00;                 	  // set KWU pin to P0.1
//KWUSR0_KWU1 = 0x01;                 	  // set KWU pin to P1.1
//KWUSR0_KWU1 = 0x02;                 	  // set KWU pin to P2.1
//KWUSR0_KWU1 = 0x03;                 	  // set KWU pin to P3.1

//====== KWU 2 ======
//KWUSR0_KWU2 = 0x00;                 	  // set KWU pin to P0.2
//KWUSR0_KWU2 = 0x01;                 	  // set KWU pin to P1.2
//KWUSR0_KWU2 = 0x02;                 	  // set KWU pin to P2.2

//====== KWU 3 ======
//KWUSR0_KWU3 = 0x00;                 	  // set KWU pin to P3.6
//KWUSR0_KWU3 = 0x01;                 	  // set KWU pin to P1.3
//KWUSR0_KWU3 = 0x02;                 	  // set KWU pin to P4.6

//====== KWU 4 ======
//KWUSR1_KWU4 = 0x00;                 	  // set KWU pin to P0.4
//KWUSR1_KWU4 = 0x01;                 	  // set KWU pin to P1.4
//KWUSR1_KWU4 = 0x02;                 	  // set KWU pin to P2.4
//KWUSR1_KWU4 = 0x03;                 	  // set KWU pin to P3.4

//====== KWU 5 ======
//KWUSR1_KWU5 = 0x00;                 	  // set KWU pin to P0.5
//KWUSR1_KWU5 = 0x01;                 	  // set KWU pin to P1.5
//KWUSR1_KWU5 = 0x02;                 	  // set KWU pin to P2.5
//KWUSR1_KWU5 = 0x03;                 	  // set KWU pin to P3.5

//====== KWU 6 ======
//KWUSR1_KWU6 = 0x00;                 	  // set KWU pin to P0.6
//KWUSR1_KWU6 = 0x01;                 	  // set KWU pin to P1.6
//KWUSR1_KWU6 = 0x02;                 	  // set KWU pin to P2.6

//====== KWU 7 ======
//KWUSR1_KWU7 = 0x00;                 	  // set KWU pin to P3.7
//KWUSR1_KWU7 = 0x01;                 	  // set KWU pin to P1.7
//KWUSR1_KWU7 = 0x02;                 	  // set KWU pin to P4.7
}


//******************************************************************************
// name			: KWU_Enable()
// brief		: initialize and enable KWU
// note			: the comment block '/**/' can be uncommented to set other KWUs
//			  low level release and high level release cannot coexist in the same KWU
//******************************************************************************
void KWU_Enable(void)
{
//====== KWU 0 ======
//--- low level release 

    KWUCR0_KW0LE    = 0; 	 		   	  // KWI0 low level release 
    KWUCR0_KW0EN    = 1;	 	          // enable KWU0
	
//--- high level release
/*     
    KWUCR0_KW0LE    = 1; 
    KWUCR0_KW0EN    = 1;
*/
 
//====== KWU 1 ======
//--- low level release 
/*    
    KWUCR0_KW1LE    = 0;
    KWUCR0_KW1EN    = 1;
*/
 
//--- high level release
/*   
    KWUCR0_KW1LE    = 1; 
    KWUCR0_KW1EN    = 1;
*/
   
//====== KWU 2 ======
//--- low level release 
/* 
    KWUCR0_KW2LE    = 0;
    KWUCR0_KW2EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR0_KW2LE    = 1; 
    KWUCR0_KW2EN    = 1;
*/
    
//====== KWU 3 ======
//--- low level release 
/*    
    KWUCR0_KW3LE    = 0;
    KWUCR0_KW3EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR0_KW3LE    = 1;
    KWUCR0_KW3EN    = 1; 
*/
    
//====== KWU 4 ======
//--- low level release 
/*  
    KWUCR1_KW4LE    = 0;
    KWUCR1_KW4EN    = 1;
*/
 
//--- high level release
/*     
    KWUCR1_KW4LE    = 1;
    KWUCR1_KW4EN    = 1;
*/
    
//====== KWU 5 ======
//--- low level release 
/*  
    KWUCR1_KW5LE    = 0;
    KWUCR1_KW5EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW5LE    = 1;
    KWUCR1_KW5EN    = 1;
*/
    
//====== KWU 6 ======
//--- low level release 
/*     
    KWUCR1_KW6LE    = 0;
    KWUCR1_KW6EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW6LE    = 1;
    KWUCR1_KW6EN    = 1;
*/
    
//====== KWU 7 ======
//--- low level release 
/*  
    KWUCR1_KW7LE    = 0;
    KWUCR1_KW7EN    = 1;
*/
 
//--- high level release
/*    
    KWUCR1_KW7LE    = 1;
    KWUCR1_KW7EN    = 1;
*/

}


//*********************************************************************
// name			: KWU_Disable()
// brief		: disable KWU
// note			: the comment block '/**/' can be uncommented to set other KWUs
//*********************************************************************
void KWU_Disable(void)
{

//====== KWU 0 ======   
/*         
    KWUCR0_KW0EN    = 0; 
*/
    
//====== KWU 1 ======   
/*         
    KWUCR1_KW1EN    = 0; 
*/

//====== KWU 2 ======
/*
    KWUCR0_KW2EN    = 0;
*/

//====== KWU 3 ======   
/*       
    KWUCR0_KW3EN    = 0; 
*/
    
//====== KWU 4 ======   
/*       
    KWUCR1_KW4EN    = 0; 
*/
    
//====== KWU 5 ======   
/*      
    KWUCR1_KW5EN    = 0; 
*/
    
//====== KWU 6 ======   
/*       
    KWUCR1_KW6EN    = 0; 
*/
    
//====== KWU 7 ======   
/*        
    KWUCR1_KW7EN    = 0; 
*/
 
}



