//*************************************************************************************
// file			: SQ7617_SFR_addr.h
// version		: V1.1 2020/07/30
// brief		: 1. define the architecture of the continuous bit combination of special registers
// 				  2. declare the image address of the special function register
// note			: 
//**************************************************************************************
#ifndef _SQ7617_SFR_ADDR_H_
#define _SQ7617_SFR_ADDR_H_

/* This definition is for I/O variable and extern definition */
/* So please do not use the name "IO_MEM".*/
#ifdef IO_MEM
#define EXTERN
#else
#define EXTERN extern
#endif

//****************************************************
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif
//****************************************************

//****************************************************
//  1. define the architecture of the continuous bit combination of special registers **************
//****************************************************

//****************************************************
//=== combination of single bit ======
typedef struct
{
    uchar   b7:1;
    uchar   b6:1;
    uchar   b5:1;
    uchar   b4:1;
    uchar   b3:1;
    uchar   b2:1;
    uchar   b1:1;
    uchar   b0:1;
} BIT8_LIST;
typedef struct
{
    uint    b15:1;
    uint    b14:1;
    uint    b13:1;
    uint    b12:1;
    uint    b11:1;
    uint    b10:1;
    uint    b9:1;
    uint    b8:1;
    uint    b7:1;
    uint    b6:1;
    uint    b5:1;
    uint    b4:1;
    uint    b3:1;
    uint    b2:1;
    uint    b1:1;
    uint    b0:1;
} BIT16_LIST;

//****************************************************
//=== combination of multiple bits ======
typedef struct {                uchar b7_6:2;   uchar bd:6; } BIT8_7_6;
typedef struct {                uchar b7_5:3;   uchar bd:5; } BIT8_7_5;
typedef struct {                uchar b7_4:4;   uchar bd:4; } BIT8_7_4;
typedef struct {                uchar b7_3:5;   uchar bd:3; } BIT8_7_3;
typedef struct {                uchar b7_2:6;   uchar bd:2; } BIT8_7_2;
typedef struct {                uchar b7_1:7;   uchar bd:1; } BIT8_7_1;

typedef struct { uchar bu:1;    uchar b6_5:2;   uchar bd:5; } BIT8_6_5;
typedef struct { uchar bu:1;    uchar b6_4:3;   uchar bd:4; } BIT8_6_4;
typedef struct { uchar bu:1;    uchar b6_3:4;   uchar bd:3; } BIT8_6_3;
typedef struct { uchar bu:1;    uchar b6_2:5;   uchar bd:2; } BIT8_6_2;
typedef struct { uchar bu:1;    uchar b6_1:6;   uchar bd:1; } BIT8_6_1;
typedef struct { uchar bu:1;    uchar b6_0:7;               } BIT8_6_0;

typedef struct { uchar bu:2;    uchar b5_4:2;   uchar bd:4; } BIT8_5_4;
typedef struct { uchar bu:2;    uchar b5_3:3;   uchar bd:3; } BIT8_5_3;
typedef struct { uchar bu:2;    uchar b5_2:4;   uchar bd:2; } BIT8_5_2;
typedef struct { uchar bu:2;    uchar b5_1:5;   uchar bd:1; } BIT8_5_1;
typedef struct { uchar bu:2;    uchar b5_0:6;               } BIT8_5_0;

typedef struct { uchar bu:3;    uchar b4_3:2;   uchar bd:3; } BIT8_4_3;
typedef struct { uchar bu:3;    uchar b4_2:3;   uchar bd:2; } BIT8_4_2;
typedef struct { uchar bu:3;    uchar b4_1:4;   uchar bd:1; } BIT8_4_1;
typedef struct { uchar bu:3;    uchar b4_0:5;               } BIT8_4_0;

typedef struct { uchar bu:4;    uchar b3_2:2;   uchar bd:2; } BIT8_3_2;
typedef struct { uchar bu:4;    uchar b3_1:3;   uchar bd:1; } BIT8_3_1;
typedef struct { uchar bu:4;    uchar b3_0:4;               } BIT8_3_0;

typedef struct { uchar bu:5;    uchar b2_1:2;   uchar bd:1; } BIT8_2_1;
typedef struct { uchar bu:5;    uchar b2_0:3;               } BIT8_2_0;

typedef struct { uchar bu:6;    uchar b1_0:2;               } BIT8_1_0;

//****************************************************
//=== multiple combination definition of BIT_LIST_8 ======
typedef union
{
    uchar       byte;
    BIT8_LIST   bit;
    BIT8_7_6    b7_6;
    BIT8_7_5    b7_5;
    BIT8_7_4    b7_4;
    BIT8_7_3    b7_3;
    BIT8_7_2    b7_2;
    BIT8_7_1    b7_1;
    BIT8_6_5    b6_5;
    BIT8_6_4    b6_4;
    BIT8_6_3    b6_3;
    BIT8_6_2    b6_2;
    BIT8_6_1    b6_1;
    BIT8_6_0    b6_0;
    BIT8_5_4    b5_4;
    BIT8_5_3    b5_3;
    BIT8_5_2    b5_2;
    BIT8_5_1    b5_1;
    BIT8_5_0    b5_0;
    BIT8_4_3    b4_3;
    BIT8_4_2    b4_2;
    BIT8_4_1    b4_1;
    BIT8_4_0    b4_0;
    BIT8_3_2    b3_2;
    BIT8_3_1    b3_1;
    BIT8_3_0    b3_0;
    BIT8_2_1    b2_1;
    BIT8_2_0    b2_0;
    BIT8_1_0    b1_0;
} BIT_LIST_8;

//****************************************************
//=== multiple combination definition of BIT_LIST_16 ======
typedef union
{
    uint        word;
    uchar       byte[2];
    BIT16_LIST  bit;
} BIT_LIST_16;

//****************************************************
//=== multiple combination definition of BIT_LIST_16_ADC ======
typedef union
{
    uint        word;
    uchar       byte[2];
	BIT_LIST_8  blst8_byte[2];
    BIT16_LIST  bit;
} BIT_LIST_16_ADC;
//****************************************************
//  end of --> define the architecture of the continuous bit combination of special registers ********
//****************************************************







//****************************************************
//  2. declare the image address of the special function register ******************
//****************************************************
//***[SFR] *******************************************
//volatile EXTERN BIT_LIST_8              __io(0x0000)    _0x0000;
//volatile EXTERN BIT_LIST_8              __io(0x0001)    _0x0001;
//volatile EXTERN BIT_LIST_8              __io(0x0002)    _0x0002;
//volatile EXTERN BIT_LIST_8              __io(0x0003)    _0x0003;
//volatile EXTERN BIT_LIST_8              __io(0x0004)    _0x0004;
//volatile EXTERN BIT_LIST_8              __io(0x0005)    _0x0005;
//volatile EXTERN BIT_LIST_8              __io(0x0006)    _0x0006;
//volatile EXTERN BIT_LIST_8              __io(0x0007)    _0x0007;
volatile EXTERN BIT_LIST_8              __io(0x0008)    _0x0008;
volatile EXTERN BIT_LIST_8              __io(0x0009)    _0x0009;
volatile EXTERN BIT_LIST_8              __io(0x000A)    _0x000A;
volatile EXTERN BIT_LIST_8              __io(0x000B)    _0x000B;
//volatile EXTERN BIT_LIST_8              __io(0x000C)    _0x000C;
//volatile EXTERN BIT_LIST_8              __io(0x000D)    _0x000D;
//volatile EXTERN BIT_LIST_8              __io(0x000E)    _0x000E;
//volatile EXTERN BIT_LIST_8              __io(0x000F)    _0x000F;
volatile EXTERN BIT_LIST_8              __io(0x0010)    _0x0010;
volatile EXTERN BIT_LIST_8              __io(0x0011)    _0x0011;
volatile EXTERN BIT_LIST_8              __io(0x0012)    _0x0012;
volatile EXTERN BIT_LIST_8              __io(0x0013)    _0x0013;
volatile EXTERN BIT_LIST_8              __io(0x0014)    _0x0014;
volatile EXTERN BIT_LIST_8              __io(0x0015)    _0x0015;
volatile EXTERN BIT_LIST_8              __io(0x0016)    _0x0016;
volatile EXTERN BIT_LIST_8              __io(0x0017)    _0x0017;
volatile EXTERN BIT_LIST_8              __io(0x0018)    _0x0018;
volatile EXTERN BIT_LIST_8              __io(0x0019)    _0x0019;
volatile EXTERN BIT_LIST_8              __io(0x001A)    _0x001A;
volatile EXTERN BIT_LIST_8              __io(0x001B)    _0x001B;
volatile EXTERN BIT_LIST_8              __io(0x001C)    _0x001C;
volatile EXTERN BIT_LIST_8              __io(0x001D)    _0x001D;
volatile EXTERN BIT_LIST_8              __io(0x001E)    _0x001E;
volatile EXTERN BIT_LIST_8              __io(0x001F)    _0x001F;
volatile EXTERN BIT_LIST_8              __io(0x0020)    _0x0020;
volatile EXTERN BIT_LIST_8              __io(0x0021)    _0x0021;
//volatile EXTERN BIT_LIST_8              __io(0x0022)    _0x0022;
volatile EXTERN BIT_LIST_8              __io(0x0023)    _0x0023;
volatile EXTERN BIT_LIST_8              __io(0x0024)    _0x0024;
//volatile EXTERN BIT_LIST_8              __io(0x0025)    _0x0025;
//volatile EXTERN BIT_LIST_8              __io(0x0026)    _0x0026;
volatile EXTERN BIT_LIST_8              __io(0x0027)    _0x0027;
volatile EXTERN BIT_LIST_8              __io(0x0028)    _0x0028;
volatile EXTERN BIT_LIST_8              __io(0x0029)    _0x0029;
volatile EXTERN BIT_LIST_8              __io(0x002A)    _0x002A;
volatile EXTERN BIT_LIST_8              __io(0x002B)    _0x002B;
//volatile EXTERN BIT_LIST_8              __io(0x002C)    _0x002C;
//volatile EXTERN BIT_LIST_8              __io(0x002D)    _0x002D;
volatile EXTERN BIT_LIST_8              __io(0x002E)    _0x002E;
volatile EXTERN BIT_LIST_8              __io(0x002F)    _0x002F;
volatile EXTERN BIT_LIST_8              __io(0x0030)    _0x0030;
volatile EXTERN BIT_LIST_8              __io(0x0031)    _0x0031;
//volatile EXTERN BIT_LIST_8              __io(0x0032)    _0x0032;
//volatile EXTERN BIT_LIST_8              __io(0x0033)    _0x0033;
volatile EXTERN BIT_LIST_8              __io(0x0034)    _0x0034;
volatile EXTERN BIT_LIST_8              __io(0x0035)    _0x0035;
//volatile EXTERN BIT_LIST_8              __io(0x0036)    _0x0036;
//volatile EXTERN BIT_LIST_8              __io(0x0037)    _0x0037;
volatile EXTERN BIT_LIST_8              __io(0x0038)    _0x0038;
volatile EXTERN BIT_LIST_8              __io(0x0039)    _0x0039;
volatile EXTERN BIT_LIST_8              __io(0x003A)    _0x003A;
//volatile EXTERN BIT_LIST_8              __io(0x003B)    _0x003B;
//volatile EXTERN BIT_LIST_8              __io(0x003C)    _0x003C;
//volatile EXTERN BIT_LIST_8              __io(0x003D)    _0x003D;
//volatile EXTERN BIT_LIST_8              __io(0x003E)    _0x003E;
volatile EXTERN BIT_LIST_8              __io(0x003F)    _0x003F;
volatile EXTERN BIT_LIST_8              __io(0x0040)    _0x0040;
volatile EXTERN BIT_LIST_8              __io(0x0041)    _0x0041;
volatile EXTERN BIT_LIST_8              __io(0x0042)    _0x0042;
volatile EXTERN BIT_LIST_8              __io(0x0043)    _0x0043;
volatile EXTERN BIT_LIST_8              __io(0x0044)    _0x0044;
volatile EXTERN BIT_LIST_8              __io(0x0045)    _0x0045;
volatile EXTERN BIT_LIST_8              __io(0x0046)    _0x0046;
volatile EXTERN BIT_LIST_8              __io(0x0047)    _0x0047;
//volatile EXTERN BIT_LIST_8              __io(0x0048)    _0x0048;
//volatile EXTERN BIT_LIST_8              __io(0x0049)    _0x0049;
//volatile EXTERN BIT_LIST_8              __io(0x004A)    _0x004A;
//volatile EXTERN BIT_LIST_8              __io(0x004B)    _0x004B;
//volatile EXTERN BIT_LIST_8              __io(0x004C)    _0x004C;
//volatile EXTERN BIT_LIST_8              __io(0x004D)    _0x004D;
//volatile EXTERN BIT_LIST_8              __io(0x004E)    _0x004E;
//volatile EXTERN BIT_LIST_8              __io(0x004F)    _0x004F;
//volatile EXTERN BIT_LIST_8              __io(0x0050)    _0x0050;
//volatile EXTERN BIT_LIST_8              __io(0x0051)    _0x0051;
//volatile EXTERN BIT_LIST_8              __io(0x0052)    _0x0052;
//volatile EXTERN BIT_LIST_8              __io(0x0053)    _0x0053;
//volatile EXTERN BIT_LIST_8              __io(0x0054)    _0x0054;
//volatile EXTERN BIT_LIST_8              __io(0x0055)    _0x0055;
//volatile EXTERN BIT_LIST_8              __io(0x0056)    _0x0056;
//volatile EXTERN BIT_LIST_8              __io(0x0057)    _0x0057;
//volatile EXTERN BIT_LIST_8              __io(0x0058)    _0x0058;
//volatile EXTERN BIT_LIST_8              __io(0x0059)    _0x0059;
//volatile EXTERN BIT_LIST_8              __io(0x005A)    _0x005A;
//volatile EXTERN BIT_LIST_8              __io(0x005B)    _0x005B;
//volatile EXTERN BIT_LIST_8              __io(0x005C)    _0x005C;
//volatile EXTERN BIT_LIST_8              __io(0x005D)    _0x005D;
//volatile EXTERN BIT_LIST_8              __io(0x005E)    _0x005E;
//volatile EXTERN BIT_LIST_8              __io(0x005F)    _0x005F;
//volatile EXTERN BIT_LIST_8              __io(0x0060)    _0x0060;
//volatile EXTERN BIT_LIST_8              __io(0x0061)    _0x0061;
//volatile EXTERN BIT_LIST_8              __io(0x0062)    _0x0062;
//volatile EXTERN BIT_LIST_8              __io(0x0063)    _0x0063;
//volatile EXTERN BIT_LIST_8              __io(0x0064)    _0x0064;
//volatile EXTERN BIT_LIST_8              __io(0x0065)    _0x0065;
//volatile EXTERN BIT_LIST_8              __io(0x0066)    _0x0066;
//volatile EXTERN BIT_LIST_8              __io(0x0067)    _0x0067;
volatile EXTERN BIT_LIST_8              __io(0x0068)    _0x0068;
volatile EXTERN BIT_LIST_8              __io(0x0069)    _0x0069;
volatile EXTERN BIT_LIST_8              __io(0x006A)    _0x006A;
volatile EXTERN BIT_LIST_8              __io(0x006B)    _0x006B;
volatile EXTERN BIT_LIST_8              __io(0x006C)    _0x006C;
volatile EXTERN BIT_LIST_8              __io(0x006D)    _0x006D;
volatile EXTERN BIT_LIST_8              __io(0x006E)    _0x006E;
volatile EXTERN BIT_LIST_8              __io(0x006F)    _0x006F;
volatile EXTERN BIT_LIST_8              __io(0x0070)    _0x0070;
volatile EXTERN BIT_LIST_8              __io(0x0071)    _0x0071;
volatile EXTERN BIT_LIST_8              __io(0x0072)    _0x0072;
volatile EXTERN BIT_LIST_8              __io(0x0073)    _0x0073;
volatile EXTERN BIT_LIST_8              __io(0x0074)    _0x0074;
volatile EXTERN BIT_LIST_8              __io(0x0075)    _0x0075;
volatile EXTERN BIT_LIST_8              __io(0x0076)    _0x0076;
volatile EXTERN BIT_LIST_8              __io(0x0077)    _0x0077;
volatile EXTERN BIT_LIST_8              __io(0x0078)    _0x0078;
volatile EXTERN BIT_LIST_8              __io(0x0079)    _0x0079;
volatile EXTERN BIT_LIST_8              __io(0x007A)    _0x007A;
volatile EXTERN BIT_LIST_8              __io(0x007B)    _0x007B;
volatile EXTERN BIT_LIST_8              __io(0x007C)    _0x007C;
volatile EXTERN BIT_LIST_8              __io(0x007D)    _0x007D;
volatile EXTERN BIT_LIST_8              __io(0x007E)    _0x007E;
volatile EXTERN BIT_LIST_8              __io(0x007F)    _0x007F;
volatile EXTERN BIT_LIST_16             __io(0x0080)    _0x0080;
//volatile EXTERN BIT_LIST_8              __io(0x0081)    _0x0081;
volatile EXTERN BIT_LIST_16             __io(0x0082)    _0x0082;
//volatile EXTERN BIT_LIST_8              __io(0x0083)    _0x0083;
volatile EXTERN BIT_LIST_16             __io(0x0084)    _0x0084;
//volatile EXTERN BIT_LIST_8              __io(0x0085)    _0x0085;
volatile EXTERN BIT_LIST_16             __io(0x0086)    _0x0086;
//volatile EXTERN BIT_LIST_8              __io(0x0087)    _0x0087;
volatile EXTERN BIT_LIST_16             __io(0x0088)    _0x0088;
//volatile EXTERN BIT_LIST_8              __io(0x0089)    _0x0089;
volatile EXTERN BIT_LIST_16             __io(0x008A)    _0x008A;
//volatile EXTERN BIT_LIST_8              __io(0x008B)    _0x008B;
volatile EXTERN BIT_LIST_16             __io(0x008C)    _0x008C;
//volatile EXTERN BIT_LIST_8              __io(0x008D)    _0x008D;
volatile EXTERN BIT_LIST_16             __io(0x008E)    _0x008E;
//volatile EXTERN BIT_LIST_8              __io(0x008F)    _0x008F;
volatile EXTERN BIT_LIST_16             __io(0x0090)    _0x0090;
//volatile EXTERN BIT_LIST_8              __io(0x0091)    _0x0091;
volatile EXTERN BIT_LIST_16             __io(0x0092)    _0x0092;
//volatile EXTERN BIT_LIST_8              __io(0x0093)    _0x0093;
volatile EXTERN BIT_LIST_16             __io(0x0094)    _0x0094;
//volatile EXTERN BIT_LIST_8              __io(0x0095)    _0x0095;
volatile EXTERN BIT_LIST_16             __io(0x0096)    _0x0096;
//volatile EXTERN BIT_LIST_8              __io(0x0097)    _0x0097;
volatile EXTERN BIT_LIST_16             __io(0x0098)    _0x0098;
//volatile EXTERN BIT_LIST_8              __io(0x0099)    _0x0099;
volatile EXTERN BIT_LIST_16             __io(0x009A)    _0x009A;
//volatile EXTERN BIT_LIST_8              __io(0x009B)    _0x009B;
volatile EXTERN BIT_LIST_16             __io(0x009C)    _0x009C;
//volatile EXTERN BIT_LIST_8              __io(0x009D)    _0x009D;
volatile EXTERN BIT_LIST_16             __io(0x009E)    _0x009E;
//volatile EXTERN BIT_LIST_8              __io(0x009F)    _0x009F;
volatile EXTERN BIT_LIST_8              __io(0x00A0)    _0x00A0;
volatile EXTERN BIT_LIST_8              __io(0x00A1)    _0x00A1;
volatile EXTERN BIT_LIST_8              __io(0x00A2)    _0x00A2;
volatile EXTERN BIT_LIST_8              __io(0x00A3)    _0x00A3;
volatile EXTERN BIT_LIST_8              __io(0x00A4)    _0x00A4;
volatile EXTERN BIT_LIST_8              __io(0x00A5)    _0x00A5;
volatile EXTERN BIT_LIST_8              __io(0x00A6)    _0x00A6;
volatile EXTERN BIT_LIST_8              __io(0x00A7)    _0x00A7;
volatile EXTERN BIT_LIST_8              __io(0x00A8)    _0x00A8;
volatile EXTERN BIT_LIST_8              __io(0x00A9)    _0x00A9;
volatile EXTERN BIT_LIST_8              __io(0x00AA)    _0x00AA;
volatile EXTERN BIT_LIST_8              __io(0x00AB)    _0x00AB;
volatile EXTERN BIT_LIST_8              __io(0x00AC)    _0x00AC;
volatile EXTERN BIT_LIST_8              __io(0x00AD)    _0x00AD;
volatile EXTERN BIT_LIST_8              __io(0x00AE)    _0x00AE;
volatile EXTERN BIT_LIST_8              __io(0x00AF)    _0x00AF;
volatile EXTERN BIT_LIST_8              __io(0x00B0)    _0x00B0;
volatile EXTERN BIT_LIST_8              __io(0x00B1)    _0x00B1;
//volatile EXTERN BIT_LIST_8              __io(0x00B2)    _0x00B2;
//volatile EXTERN BIT_LIST_8              __io(0x00B3)    _0x00B3;
//volatile EXTERN BIT_LIST_8              __io(0x00B4)    _0x00B4;
//volatile EXTERN BIT_LIST_8              __io(0x00B5)    _0x00B5;
//volatile EXTERN BIT_LIST_8              __io(0x00B6)    _0x00B6;
//volatile EXTERN BIT_LIST_8              __io(0x00B7)    _0x00B7;
volatile EXTERN BIT_LIST_8              __io(0x00B8)    _0x00B8;
volatile EXTERN BIT_LIST_8              __io(0x00B9)    _0x00B9;
volatile EXTERN BIT_LIST_8              __io(0x00BA)    _0x00BA;
volatile EXTERN BIT_LIST_8              __io(0x00BB)    _0x00BB;
volatile EXTERN BIT_LIST_8              __io(0x00BC)    _0x00BC;
volatile EXTERN BIT_LIST_8              __io(0x00BD)    _0x00BD;
volatile EXTERN BIT_LIST_8              __io(0x00BE)    _0x00BE;
volatile EXTERN BIT_LIST_8              __io(0x00BF)    _0x00BF;
volatile EXTERN BIT_LIST_8              __io(0x00C0)    _0x00C0;
volatile EXTERN BIT_LIST_8              __io(0x00C1)    _0x00C1;
//volatile EXTERN BIT_LIST_8              __io(0x00C2)    _0x00C2;
//volatile EXTERN BIT_LIST_8              __io(0x00C3)    _0x00C3;
//volatile EXTERN BIT_LIST_8              __io(0x00C4)    _0x00C4;
//volatile EXTERN BIT_LIST_8              __io(0x00C5)    _0x00C5;
//volatile EXTERN BIT_LIST_8              __io(0x00C6)    _0x00C6;
//volatile EXTERN BIT_LIST_8              __io(0x00C7)    _0x00C7;
//volatile EXTERN BIT_LIST_8              __io(0x00C8)    _0x00C8;
//volatile EXTERN BIT_LIST_8              __io(0x00C9)    _0x00C9;
//volatile EXTERN BIT_LIST_8              __io(0x00CA)    _0x00CA;
//volatile EXTERN BIT_LIST_8              __io(0x00CB)    _0x00CB;
//volatile EXTERN BIT_LIST_8              __io(0x00CC)    _0x00CC;
//volatile EXTERN BIT_LIST_8              __io(0x00CD)    _0x00CD;
//volatile EXTERN BIT_LIST_8              __io(0x00CE)    _0x00CE;
//volatile EXTERN BIT_LIST_8              __io(0x00CF)    _0x00CF;
volatile EXTERN BIT_LIST_8              __io(0x00D0)    _0x00D0;
volatile EXTERN BIT_LIST_8              __io(0x00D1)    _0x00D1;
volatile EXTERN BIT_LIST_8              __io(0x00D2)    _0x00D2;
volatile EXTERN BIT_LIST_8              __io(0x00D3)    _0x00D3;
volatile EXTERN BIT_LIST_8              __io(0x00D4)    _0x00D4;
volatile EXTERN BIT_LIST_8              __io(0x00D5)    _0x00D5;
volatile EXTERN BIT_LIST_8              __io(0x00D6)    _0x00D6;
volatile EXTERN BIT_LIST_8              __io(0x00D7)    _0x00D7;
//volatile EXTERN BIT_LIST_8              __io(0x00D8)    _0x00D8;
//volatile EXTERN BIT_LIST_8              __io(0x00D9)    _0x00D9;
//volatile EXTERN BIT_LIST_8              __io(0x00DA)    _0x00DA;
//volatile EXTERN BIT_LIST_8              __io(0x00DB)    _0x00DB;
//volatile EXTERN BIT_LIST_8              __io(0x00DC)    _0x00DC;
//volatile EXTERN BIT_LIST_8              __io(0x00DD)    _0x00DD;
//volatile EXTERN BIT_LIST_8              __io(0x00DE)    _0x00DE;
//volatile EXTERN BIT_LIST_8              __io(0x00DF)    _0x00DF;
volatile EXTERN BIT_LIST_8              __io(0x00E0)    _0x00E0;
volatile EXTERN BIT_LIST_8              __io(0x00E1)    _0x00E1;
volatile EXTERN BIT_LIST_8              __io(0x00E2)    _0x00E2;
volatile EXTERN BIT_LIST_8              __io(0x00E3)    _0x00E3;
volatile EXTERN BIT_LIST_8              __io(0x00E4)    _0x00E4;
volatile EXTERN BIT_LIST_8              __io(0x00E5)    _0x00E5;
//volatile EXTERN BIT_LIST_8              __io(0x00E6)    _0x00E6;
//volatile EXTERN BIT_LIST_8              __io(0x00E7)    _0x00E7;
//volatile EXTERN BIT_LIST_8              __io(0x00E8)    _0x00E8;
//volatile EXTERN BIT_LIST_8              __io(0x00E9)    _0x00E9;
//volatile EXTERN BIT_LIST_8              __io(0x00EA)    _0x00EA;
//volatile EXTERN BIT_LIST_8              __io(0x00EB)    _0x00EB;
//volatile EXTERN BIT_LIST_8              __io(0x00EC)    _0x00EC;
//volatile EXTERN BIT_LIST_8              __io(0x00ED)    _0x00ED;
//volatile EXTERN BIT_LIST_8              __io(0x00EE)    _0x00EE;
//volatile EXTERN BIT_LIST_8              __io(0x00EF)    _0x00EF;
volatile EXTERN BIT_LIST_8              __io(0x00F0)    _0x00F0;
volatile EXTERN BIT_LIST_8              __io(0x00F1)    _0x00F1;
volatile EXTERN BIT_LIST_8              __io(0x00F2)    _0x00F2;
volatile EXTERN BIT_LIST_8              __io(0x00F3)    _0x00F3;
volatile EXTERN BIT_LIST_8              __io(0x00F4)    _0x00F4;
volatile EXTERN BIT_LIST_8              __io(0x00F5)    _0x00F5;
//volatile EXTERN BIT_LIST_8              __io(0x00F6)    _0x00F6;
//volatile EXTERN BIT_LIST_8              __io(0x00F7)    _0x00F7;
//volatile EXTERN BIT_LIST_8              __io(0x00F8)    _0x00F8;
//volatile EXTERN BIT_LIST_8              __io(0x00F9)    _0x00F9;
//volatile EXTERN BIT_LIST_8              __io(0x00FA)    _0x00FA;
//volatile EXTERN BIT_LIST_8              __io(0x00FB)    _0x00FB;
//volatile EXTERN BIT_LIST_8              __io(0x00FC)    _0x00FC;
//volatile EXTERN BIT_LIST_8              __io(0x00FD)    _0x00FD;
//volatile EXTERN BIT_LIST_8              __io(0x00FE)    _0x00FE;
//volatile EXTERN BIT_LIST_8              __io(0x00FF)    _0x00FF;
volatile EXTERN BIT_LIST_8              __io(0x0100)    _0x0100;
volatile EXTERN BIT_LIST_8              __io(0x0101)    _0x0101;
volatile EXTERN BIT_LIST_8              __io(0x0102)    _0x0102;
volatile EXTERN BIT_LIST_8              __io(0x0103)    _0x0103;
volatile EXTERN BIT_LIST_8              __io(0x0104)    _0x0104;
volatile EXTERN BIT_LIST_8              __io(0x0105)    _0x0105;
//volatile EXTERN BIT_LIST_8              __io(0x0106)    _0x0106;
//volatile EXTERN BIT_LIST_8              __io(0x0107)    _0x0107;
//volatile EXTERN BIT_LIST_8              __io(0x0108)    _0x0108;
//volatile EXTERN BIT_LIST_8              __io(0x0109)    _0x0109;
//volatile EXTERN BIT_LIST_8              __io(0x010A)    _0x010A;
//volatile EXTERN BIT_LIST_8              __io(0x010B)    _0x010B;
//volatile EXTERN BIT_LIST_8              __io(0x010C)    _0x010C;
//volatile EXTERN BIT_LIST_8              __io(0x010D)    _0x010D;
//volatile EXTERN BIT_LIST_8              __io(0x010E)    _0x010E;
//volatile EXTERN BIT_LIST_8              __io(0x010F)    _0x010F;
volatile EXTERN BIT_LIST_8              __io(0x0110)    _0x0110;
volatile EXTERN BIT_LIST_8              __io(0x0111)    _0x0111;
volatile EXTERN BIT_LIST_8              __io(0x0112)    _0x0112;
volatile EXTERN BIT_LIST_8              __io(0x0113)    _0x0113;
volatile EXTERN BIT_LIST_8              __io(0x0114)    _0x0114;
volatile EXTERN BIT_LIST_8              __io(0x0115)    _0x0115;
//volatile EXTERN BIT_LIST_8              __io(0x0116)    _0x0116;
//volatile EXTERN BIT_LIST_8              __io(0x0117)    _0x0117;
//volatile EXTERN BIT_LIST_8              __io(0x0118)    _0x0118;
//volatile EXTERN BIT_LIST_8              __io(0x0119)    _0x0119;
//volatile EXTERN BIT_LIST_8              __io(0x011A)    _0x011A;
//volatile EXTERN BIT_LIST_8              __io(0x011B)    _0x011B;
//volatile EXTERN BIT_LIST_8              __io(0x011C)    _0x011C;
//volatile EXTERN BIT_LIST_8              __io(0x011D)    _0x011D;
//volatile EXTERN BIT_LIST_8              __io(0x011E)    _0x011E;
//volatile EXTERN BIT_LIST_8              __io(0x011F)    _0x011F;
volatile EXTERN BIT_LIST_8              __io(0x0120)    _0x0120;
volatile EXTERN BIT_LIST_8              __io(0x0121)    _0x0121;
volatile EXTERN BIT_LIST_8              __io(0x0122)    _0x0122;
volatile EXTERN BIT_LIST_8              __io(0x0123)    _0x0123;
volatile EXTERN BIT_LIST_8              __io(0x0124)    _0x0124;
volatile EXTERN BIT_LIST_8              __io(0x0125)    _0x0125;
//volatile EXTERN BIT_LIST_8              __io(0x0126)    _0x0126;
//volatile EXTERN BIT_LIST_8              __io(0x0127)    _0x0127;
//volatile EXTERN BIT_LIST_8              __io(0x0128)    _0x0128;
//volatile EXTERN BIT_LIST_8              __io(0x0129)    _0x0129;
//volatile EXTERN BIT_LIST_8              __io(0x012A)    _0x012A;
//volatile EXTERN BIT_LIST_8              __io(0x012B)    _0x012B;
//volatile EXTERN BIT_LIST_8              __io(0x012C)    _0x012C;
//volatile EXTERN BIT_LIST_8              __io(0x012D)    _0x012D;
//volatile EXTERN BIT_LIST_8              __io(0x012E)    _0x012E;
//volatile EXTERN BIT_LIST_8              __io(0x012F)    _0x012F;
//volatile EXTERN BIT_LIST_8              __io(0x0130)    _0x0130;
//volatile EXTERN BIT_LIST_8              __io(0x0131)    _0x0131;
//volatile EXTERN BIT_LIST_8              __io(0x0132)    _0x0132;
//volatile EXTERN BIT_LIST_8              __io(0x0133)    _0x0133;
//volatile EXTERN BIT_LIST_8              __io(0x0134)    _0x0134;
//volatile EXTERN BIT_LIST_8              __io(0x0135)    _0x0135;
//volatile EXTERN BIT_LIST_8              __io(0x0136)    _0x0136;
//volatile EXTERN BIT_LIST_8              __io(0x0137)    _0x0137;
//volatile EXTERN BIT_LIST_8              __io(0x0138)    _0x0138;
//volatile EXTERN BIT_LIST_8              __io(0x0139)    _0x0139;
//volatile EXTERN BIT_LIST_8              __io(0x013A)    _0x013A;
//volatile EXTERN BIT_LIST_8              __io(0x013B)    _0x013B;
//volatile EXTERN BIT_LIST_8              __io(0x013C)    _0x013C;
//volatile EXTERN BIT_LIST_8              __io(0x013D)    _0x013D;
//volatile EXTERN BIT_LIST_8              __io(0x013E)    _0x013E;
//volatile EXTERN BIT_LIST_8              __io(0x013F)    _0x013F;
volatile EXTERN BIT_LIST_8              __io(0x0140)    _0x0140;
volatile EXTERN BIT_LIST_8              __io(0x0141)    _0x0141;
volatile EXTERN BIT_LIST_8              __io(0x0142)    _0x0142;
volatile EXTERN BIT_LIST_8              __io(0x0143)    _0x0143;
volatile EXTERN BIT_LIST_8              __io(0x0144)    _0x0144;
volatile EXTERN BIT_LIST_8              __io(0x0145)    _0x0145;
//volatile EXTERN BIT_LIST_8              __io(0x0146)    _0x0146;
//volatile EXTERN BIT_LIST_8              __io(0x0147)    _0x0147;
//volatile EXTERN BIT_LIST_8              __io(0x0148)    _0x0148;
//volatile EXTERN BIT_LIST_8              __io(0x0149)    _0x0149;
//volatile EXTERN BIT_LIST_8              __io(0x014A)    _0x014A;
//volatile EXTERN BIT_LIST_8              __io(0x014B)    _0x014B;
//volatile EXTERN BIT_LIST_8              __io(0x014C)    _0x014C;
//volatile EXTERN BIT_LIST_8              __io(0x014D)    _0x014D;
//volatile EXTERN BIT_LIST_8              __io(0x014E)    _0x014E;
//volatile EXTERN BIT_LIST_8              __io(0x014F)    _0x014F;
volatile EXTERN BIT_LIST_8              __io(0x0150)    _0x0150;
volatile EXTERN BIT_LIST_8              __io(0x0151)    _0x0151;
volatile EXTERN BIT_LIST_8              __io(0x0152)    _0x0152;
volatile EXTERN BIT_LIST_8              __io(0x0153)    _0x0153;
volatile EXTERN BIT_LIST_8              __io(0x0154)    _0x0154;
volatile EXTERN BIT_LIST_8              __io(0x0155)    _0x0155;
//volatile EXTERN BIT_LIST_8              __io(0x0156)    _0x0156;
//volatile EXTERN BIT_LIST_8              __io(0x0157)    _0x0157;
//volatile EXTERN BIT_LIST_8              __io(0x0158)    _0x0158;
//volatile EXTERN BIT_LIST_8              __io(0x0159)    _0x0159;
//volatile EXTERN BIT_LIST_8              __io(0x015A)    _0x015A;
//volatile EXTERN BIT_LIST_8              __io(0x015B)    _0x015B;
//volatile EXTERN BIT_LIST_8              __io(0x015C)    _0x015C;
//volatile EXTERN BIT_LIST_8              __io(0x015D)    _0x015D;
//volatile EXTERN BIT_LIST_8              __io(0x015E)    _0x015E;
//volatile EXTERN BIT_LIST_8              __io(0x015F)    _0x015F;
volatile EXTERN BIT_LIST_8              __io(0x0160)    _0x0160;
volatile EXTERN BIT_LIST_8              __io(0x0161)    _0x0161;
volatile EXTERN BIT_LIST_8              __io(0x0162)    _0x0162;
volatile EXTERN BIT_LIST_8              __io(0x0163)    _0x0163;
volatile EXTERN BIT_LIST_8              __io(0x0164)    _0x0164;
volatile EXTERN BIT_LIST_8              __io(0x0165)    _0x0165;
//volatile EXTERN BIT_LIST_8              __io(0x0166)    _0x0166;
//volatile EXTERN BIT_LIST_8              __io(0x0167)    _0x0167;
//volatile EXTERN BIT_LIST_8              __io(0x0168)    _0x0168;
//volatile EXTERN BIT_LIST_8              __io(0x0169)    _0x0169;
//volatile EXTERN BIT_LIST_8              __io(0x016A)    _0x016A;
//volatile EXTERN BIT_LIST_8              __io(0x016B)    _0x016B;
volatile EXTERN BIT_LIST_8              __io(0x016C)    _0x016C;
volatile EXTERN BIT_LIST_8              __io(0x016D)    _0x016D;
volatile EXTERN BIT_LIST_8              __io(0x016E)    _0x016E;
//volatile EXTERN BIT_LIST_8              __io(0x016F)    _0x016F;
volatile EXTERN BIT_LIST_8              __io(0x0170)    _0x0170;
volatile EXTERN BIT_LIST_8              __io(0x0171)    _0x0171;
//volatile EXTERN BIT_LIST_8              __io(0x0172)    _0x0172;
//volatile EXTERN BIT_LIST_8              __io(0x0173)    _0x0173;
//volatile EXTERN BIT_LIST_8              __io(0x0174)    _0x0174;
//volatile EXTERN BIT_LIST_8              __io(0x0175)    _0x0175;
//volatile EXTERN BIT_LIST_8              __io(0x0176)    _0x0176;
//volatile EXTERN BIT_LIST_8              __io(0x0177)    _0x0177;
volatile EXTERN BIT_LIST_8              __io(0x0178)    _0x0178;
volatile EXTERN BIT_LIST_8              __io(0x0179)    _0x0179;
volatile EXTERN BIT_LIST_8              __io(0x017A)    _0x017A;
volatile EXTERN BIT_LIST_8              __io(0x017B)    _0x017B;
volatile EXTERN BIT_LIST_8              __io(0x017C)    _0x017C;
volatile EXTERN BIT_LIST_8              __io(0x017D)    _0x017D;
volatile EXTERN BIT_LIST_8              __io(0x017E)    _0x017E;
volatile EXTERN BIT_LIST_8              __io(0x017F)    _0x017F;
//volatile EXTERN BIT_LIST_8              __io(0x0180)    _0x0180;
//volatile EXTERN BIT_LIST_8              __io(0x0181)    _0x0181;
//volatile EXTERN BIT_LIST_8              __io(0x0182)    _0x0182;
//volatile EXTERN BIT_LIST_8              __io(0x0183)    _0x0183;
//volatile EXTERN BIT_LIST_8              __io(0x0184)    _0x0184;
//volatile EXTERN BIT_LIST_8              __io(0x0185)    _0x0185;
//volatile EXTERN BIT_LIST_8              __io(0x0186)    _0x0186;
volatile EXTERN BIT_LIST_8              __io(0x0187)    _0x0187;
volatile EXTERN BIT_LIST_8              __io(0x0188)    _0x0188;
volatile EXTERN BIT_LIST_8              __io(0x0189)    _0x0189;
//volatile EXTERN BIT_LIST_8              __io(0x018A)    _0x018A;
//volatile EXTERN BIT_LIST_8              __io(0x018B)    _0x018B;
volatile EXTERN BIT_LIST_8              __io(0x018C)    _0x018C;
volatile EXTERN BIT_LIST_8              __io(0x018D)    _0x018D;
//volatile EXTERN BIT_LIST_8              __io(0x018E)    _0x018E;
//volatile EXTERN BIT_LIST_8              __io(0x018F)    _0x018F;
volatile EXTERN BIT_LIST_8              __io(0x0190)    _0x0190;
volatile EXTERN BIT_LIST_8              __io(0x0191)    _0x0191;
volatile EXTERN BIT_LIST_8              __io(0x0192)    _0x0192;
volatile EXTERN BIT_LIST_8              __io(0x0193)    _0x0193;
volatile EXTERN BIT_LIST_8              __io(0x0194)    _0x0194;
volatile EXTERN BIT_LIST_8              __io(0x0195)    _0x0195;
volatile EXTERN BIT_LIST_8              __io(0x0196)    _0x0196;
volatile EXTERN BIT_LIST_8              __io(0x0197)    _0x0197;
//volatile EXTERN BIT_LIST_8              __io(0x0198)    _0x0198;
//volatile EXTERN BIT_LIST_8              __io(0x0199)    _0x0199;
//volatile EXTERN BIT_LIST_8              __io(0x019A)    _0x019A;
//volatile EXTERN BIT_LIST_8              __io(0x019B)    _0x019B;
//volatile EXTERN BIT_LIST_8              __io(0x019C)    _0x019C;
//volatile EXTERN BIT_LIST_8              __io(0x019D)    _0x019D;
//volatile EXTERN BIT_LIST_8              __io(0x019E)    _0x019E;
//volatile EXTERN BIT_LIST_8              __io(0x019F)    _0x019F;
volatile EXTERN BIT_LIST_8              __io(0x01A0)    _0x01A0;
volatile EXTERN BIT_LIST_8              __io(0x01A1)    _0x01A1;
volatile EXTERN BIT_LIST_8              __io(0x01A2)    _0x01A2;
volatile EXTERN BIT_LIST_8              __io(0x01A3)    _0x01A3;
volatile EXTERN BIT_LIST_8              __io(0x01A4)    _0x01A4;
volatile EXTERN BIT_LIST_8              __io(0x01A5)    _0x01A5;
volatile EXTERN BIT_LIST_8              __io(0x01A6)    _0x01A6;
volatile EXTERN BIT_LIST_8              __io(0x01A7)    _0x01A7;
volatile EXTERN BIT_LIST_8              __io(0x01A8)    _0x01A8;
volatile EXTERN BIT_LIST_8              __io(0x01A9)    _0x01A9;
volatile EXTERN BIT_LIST_8              __io(0x01AA)    _0x01AA;
volatile EXTERN BIT_LIST_8              __io(0x01AB)    _0x01AB;
//volatile EXTERN BIT_LIST_8              __io(0x01AC)    _0x01AC;
//volatile EXTERN BIT_LIST_8              __io(0x01AD)    _0x01AD;
//volatile EXTERN BIT_LIST_8              __io(0x01AE)    _0x01AE;
//volatile EXTERN BIT_LIST_8              __io(0x01AF)    _0x01AF;
volatile EXTERN BIT_LIST_8              __io(0x01B0)    _0x01B0;
volatile EXTERN BIT_LIST_8              __io(0x01B1)    _0x01B1;
volatile EXTERN BIT_LIST_8              __io(0x01B2)    _0x01B2;
volatile EXTERN BIT_LIST_8              __io(0x01B3)    _0x01B3;
volatile EXTERN BIT_LIST_8              __io(0x01B4)    _0x01B4;
volatile EXTERN BIT_LIST_8              __io(0x01B5)    _0x01B5;
volatile EXTERN BIT_LIST_8              __io(0x01B6)    _0x01B6;
volatile EXTERN BIT_LIST_8              __io(0x01B7)    _0x01B7;
volatile EXTERN BIT_LIST_8              __io(0x01B8)    _0x01B8;
volatile EXTERN BIT_LIST_8              __io(0x01B9)    _0x01B9;
volatile EXTERN BIT_LIST_8              __io(0x01BA)    _0x01BA;
volatile EXTERN BIT_LIST_8              __io(0x01BB)    _0x01BB;
//volatile EXTERN BIT_LIST_8              __io(0x01BC)    _0x01BC;
//volatile EXTERN BIT_LIST_8              __io(0x01BD)    _0x01BD;
//volatile EXTERN BIT_LIST_8              __io(0x01BE)    _0x01BE;
//volatile EXTERN BIT_LIST_8              __io(0x01BF)    _0x01BF;
volatile EXTERN BIT_LIST_8              __io(0x01C0)    _0x01C0;
volatile EXTERN BIT_LIST_8              __io(0x01C1)    _0x01C1;
volatile EXTERN BIT_LIST_8              __io(0x01C2)    _0x01C2;
volatile EXTERN BIT_LIST_8              __io(0x01C3)    _0x01C3;
volatile EXTERN BIT_LIST_8              __io(0x01C4)    _0x01C4;
volatile EXTERN BIT_LIST_8              __io(0x01C5)    _0x01C5;
volatile EXTERN BIT_LIST_8              __io(0x01C6)    _0x01C6;
volatile EXTERN BIT_LIST_8              __io(0x01C7)    _0x01C7;
volatile EXTERN BIT_LIST_8              __io(0x01C8)    _0x01C8;
volatile EXTERN BIT_LIST_8              __io(0x01C9)    _0x01C9;
volatile EXTERN BIT_LIST_8              __io(0x01CA)    _0x01CA;
volatile EXTERN BIT_LIST_8              __io(0x01CB)    _0x01CB;
volatile EXTERN BIT_LIST_8              __io(0x01CC)    _0x01CC;
volatile EXTERN BIT_LIST_8              __io(0x01CD)    _0x01CD;
volatile EXTERN BIT_LIST_8              __io(0x01CE)    _0x01CE;
volatile EXTERN BIT_LIST_8              __io(0x01CF)    _0x01CF;
volatile EXTERN BIT_LIST_8              __io(0x01D0)    _0x01D0;
volatile EXTERN BIT_LIST_8              __io(0x01D1)    _0x01D1;
volatile EXTERN BIT_LIST_8              __io(0x01D2)    _0x01D2;
volatile EXTERN BIT_LIST_8              __io(0x01D3)    _0x01D3;
volatile EXTERN BIT_LIST_8              __io(0x01D4)    _0x01D4;
volatile EXTERN BIT_LIST_8              __io(0x01D5)    _0x01D5;
volatile EXTERN BIT_LIST_8              __io(0x01D6)    _0x01D6;
volatile EXTERN BIT_LIST_8              __io(0x01D7)    _0x01D7;
//volatile EXTERN BIT_LIST_8              __io(0x01D8)    _0x01D8;
//volatile EXTERN BIT_LIST_8              __io(0x01D9)    _0x01D9;
//volatile EXTERN BIT_LIST_8              __io(0x01DA)    _0x01DA;
//volatile EXTERN BIT_LIST_8              __io(0x01DB)    _0x01DB;
//volatile EXTERN BIT_LIST_8              __io(0x01DC)    _0x01DC;
//volatile EXTERN BIT_LIST_8              __io(0x01DD)    _0x01DD;
//volatile EXTERN BIT_LIST_8              __io(0x01DE)    _0x01DE;
//volatile EXTERN BIT_LIST_8              __io(0x01DF)    _0x01DF;
//volatile EXTERN BIT_LIST_8              __io(0x01E0)    _0x01E0;
//volatile EXTERN BIT_LIST_8              __io(0x01E1)    _0x01E1;
//volatile EXTERN BIT_LIST_8              __io(0x01E2)    _0x01E2;
//volatile EXTERN BIT_LIST_8              __io(0x01E3)    _0x01E3;
//volatile EXTERN BIT_LIST_8              __io(0x01E4)    _0x01E4;
//volatile EXTERN BIT_LIST_8              __io(0x01E5)    _0x01E5;
//volatile EXTERN BIT_LIST_8              __io(0x01E6)    _0x01E6;
//volatile EXTERN BIT_LIST_8              __io(0x01E7)    _0x01E7;
//volatile EXTERN BIT_LIST_8              __io(0x01E8)    _0x01E8;
//volatile EXTERN BIT_LIST_8              __io(0x01E9)    _0x01E9;
//volatile EXTERN BIT_LIST_8              __io(0x01EA)    _0x01EA;
//volatile EXTERN BIT_LIST_8              __io(0x01EB)    _0x01EB;
//volatile EXTERN BIT_LIST_8              __io(0x01EC)    _0x01EC;
//volatile EXTERN BIT_LIST_8              __io(0x01ED)    _0x01ED;
//volatile EXTERN BIT_LIST_8              __io(0x01EE)    _0x01EE;
//volatile EXTERN BIT_LIST_8              __io(0x01EF)    _0x01EF;
//volatile EXTERN BIT_LIST_8              __io(0x01F0)    _0x01F0;
//volatile EXTERN BIT_LIST_8              __io(0x01F1)    _0x01F1;
//volatile EXTERN BIT_LIST_8              __io(0x01F2)    _0x01F2;
//volatile EXTERN BIT_LIST_8              __io(0x01F3)    _0x01F3;
//volatile EXTERN BIT_LIST_8              __io(0x01F4)    _0x01F4;
//volatile EXTERN BIT_LIST_8              __io(0x01F5)    _0x01F5;
//volatile EXTERN BIT_LIST_8              __io(0x01F6)    _0x01F6;
//volatile EXTERN BIT_LIST_8              __io(0x01F7)    _0x01F7;
//volatile EXTERN BIT_LIST_8              __io(0x01F8)    _0x01F8;
//volatile EXTERN BIT_LIST_8              __io(0x01F9)    _0x01F9;
//volatile EXTERN BIT_LIST_8              __io(0x01FA)    _0x01FA;
//volatile EXTERN BIT_LIST_8              __io(0x01FB)    _0x01FB;
//volatile EXTERN BIT_LIST_8              __io(0x01FC)    _0x01FC;
//volatile EXTERN BIT_LIST_8              __io(0x01FD)    _0x01FD;
//volatile EXTERN BIT_LIST_8              __io(0x01FE)    _0x01FE;
//volatile EXTERN BIT_LIST_8              __io(0x01FF)    _0x01FF;
//volatile EXTERN BIT_LIST_8              __io(0x0200)    _0x0200;
//volatile EXTERN BIT_LIST_8              __io(0x0201)    _0x0201;
//volatile EXTERN BIT_LIST_8              __io(0x0202)    _0x0202;
//volatile EXTERN BIT_LIST_8              __io(0x0203)    _0x0203;
//volatile EXTERN BIT_LIST_8              __io(0x0204)    _0x0204;
//volatile EXTERN BIT_LIST_8              __io(0x0205)    _0x0205;
//volatile EXTERN BIT_LIST_8              __io(0x0206)    _0x0206;
//volatile EXTERN BIT_LIST_8              __io(0x0207)    _0x0207;
//volatile EXTERN BIT_LIST_8              __io(0x0208)    _0x0208;
//volatile EXTERN BIT_LIST_8              __io(0x0209)    _0x0209;
//volatile EXTERN BIT_LIST_8              __io(0x020A)    _0x020A;
//volatile EXTERN BIT_LIST_8              __io(0x020B)    _0x020B;
//volatile EXTERN BIT_LIST_8              __io(0x020C)    _0x020C;
//volatile EXTERN BIT_LIST_8              __io(0x020D)    _0x020D;
//volatile EXTERN BIT_LIST_8              __io(0x020E)    _0x020E;
//volatile EXTERN BIT_LIST_8              __io(0x020F)    _0x020F;
//volatile EXTERN BIT_LIST_8              __io(0x0210)    _0x0210;
//volatile EXTERN BIT_LIST_8              __io(0x0211)    _0x0211;
//volatile EXTERN BIT_LIST_8              __io(0x0212)    _0x0212;
//volatile EXTERN BIT_LIST_8              __io(0x0213)    _0x0213;
//volatile EXTERN BIT_LIST_8              __io(0x0214)    _0x0214;
//volatile EXTERN BIT_LIST_8              __io(0x0215)    _0x0215;
//volatile EXTERN BIT_LIST_8              __io(0x0216)    _0x0216;
//volatile EXTERN BIT_LIST_8              __io(0x0217)    _0x0217;
//volatile EXTERN BIT_LIST_8              __io(0x0218)    _0x0218;
//volatile EXTERN BIT_LIST_8              __io(0x0219)    _0x0219;
//volatile EXTERN BIT_LIST_8              __io(0x021A)    _0x021A;
//volatile EXTERN BIT_LIST_8              __io(0x021B)    _0x021B;
//volatile EXTERN BIT_LIST_8              __io(0x021C)    _0x021C;
//volatile EXTERN BIT_LIST_8              __io(0x021D)    _0x021D;
//volatile EXTERN BIT_LIST_8              __io(0x021E)    _0x021E;
//volatile EXTERN BIT_LIST_8              __io(0x021F)    _0x021F;
//volatile EXTERN BIT_LIST_8              __io(0x0220)    _0x0220;
//volatile EXTERN BIT_LIST_8              __io(0x0221)    _0x0221;
//volatile EXTERN BIT_LIST_8              __io(0x0222)    _0x0222;
//volatile EXTERN BIT_LIST_8              __io(0x0223)    _0x0223;
//volatile EXTERN BIT_LIST_8              __io(0x0224)    _0x0224;
//volatile EXTERN BIT_LIST_8              __io(0x0225)    _0x0225;
//volatile EXTERN BIT_LIST_8              __io(0x0226)    _0x0226;
//volatile EXTERN BIT_LIST_8              __io(0x0227)    _0x0227;
//volatile EXTERN BIT_LIST_8              __io(0x0228)    _0x0228;
//volatile EXTERN BIT_LIST_8              __io(0x0229)    _0x0229;
//volatile EXTERN BIT_LIST_8              __io(0x022A)    _0x022A;
//volatile EXTERN BIT_LIST_8              __io(0x022B)    _0x022B;
//volatile EXTERN BIT_LIST_8              __io(0x022C)    _0x022C;
//volatile EXTERN BIT_LIST_8              __io(0x022D)    _0x022D;
//volatile EXTERN BIT_LIST_8              __io(0x022E)    _0x022E;
//volatile EXTERN BIT_LIST_8              __io(0x022F)    _0x022F;
//volatile EXTERN BIT_LIST_8              __io(0x0230)    _0x0230;
//volatile EXTERN BIT_LIST_8              __io(0x0231)    _0x0231;
//volatile EXTERN BIT_LIST_8              __io(0x0232)    _0x0232;
//volatile EXTERN BIT_LIST_8              __io(0x0233)    _0x0233;
//volatile EXTERN BIT_LIST_8              __io(0x0234)    _0x0234;
//volatile EXTERN BIT_LIST_8              __io(0x0235)    _0x0235;
//volatile EXTERN BIT_LIST_8              __io(0x0236)    _0x0236;
//volatile EXTERN BIT_LIST_8              __io(0x0237)    _0x0237;
//volatile EXTERN BIT_LIST_8              __io(0x0238)    _0x0238;
//volatile EXTERN BIT_LIST_8              __io(0x0239)    _0x0239;
//volatile EXTERN BIT_LIST_8              __io(0x023A)    _0x023A;
//volatile EXTERN BIT_LIST_8              __io(0x023B)    _0x023B;
//volatile EXTERN BIT_LIST_8              __io(0x023C)    _0x023C;
//volatile EXTERN BIT_LIST_8              __io(0x023D)    _0x023D;
//volatile EXTERN BIT_LIST_8              __io(0x023E)    _0x023E;
//volatile EXTERN BIT_LIST_8              __io(0x023F)    _0x023F;
//volatile EXTERN BIT_LIST_8              __io(0x0240)    _0x0240;
//volatile EXTERN BIT_LIST_8              __io(0x0241)    _0x0241;
//volatile EXTERN BIT_LIST_8              __io(0x0242)    _0x0242;
//volatile EXTERN BIT_LIST_8              __io(0x0243)    _0x0243;
//volatile EXTERN BIT_LIST_8              __io(0x0244)    _0x0244;
//volatile EXTERN BIT_LIST_8              __io(0x0245)    _0x0245;
//volatile EXTERN BIT_LIST_8              __io(0x0246)    _0x0246;
//volatile EXTERN BIT_LIST_8              __io(0x0247)    _0x0247;
//volatile EXTERN BIT_LIST_8              __io(0x0248)    _0x0248;
//volatile EXTERN BIT_LIST_8              __io(0x0249)    _0x0249;
//volatile EXTERN BIT_LIST_8              __io(0x024A)    _0x024A;
//volatile EXTERN BIT_LIST_8              __io(0x024B)    _0x024B;
//volatile EXTERN BIT_LIST_8              __io(0x024C)    _0x024C;
//volatile EXTERN BIT_LIST_8              __io(0x024D)    _0x024D;
//volatile EXTERN BIT_LIST_8              __io(0x024E)    _0x024E;
//volatile EXTERN BIT_LIST_8              __io(0x024F)    _0x024F;
//volatile EXTERN BIT_LIST_8              __io(0x0250)    _0x0250;
//volatile EXTERN BIT_LIST_8              __io(0x0251)    _0x0251;
//volatile EXTERN BIT_LIST_8              __io(0x0252)    _0x0252;
//volatile EXTERN BIT_LIST_8              __io(0x0253)    _0x0253;
//volatile EXTERN BIT_LIST_8              __io(0x0254)    _0x0254;
//volatile EXTERN BIT_LIST_8              __io(0x0255)    _0x0255;
//volatile EXTERN BIT_LIST_8              __io(0x0256)    _0x0256;
//volatile EXTERN BIT_LIST_8              __io(0x0257)    _0x0257;
//volatile EXTERN BIT_LIST_8              __io(0x0258)    _0x0258;
//volatile EXTERN BIT_LIST_8              __io(0x0259)    _0x0259;
//volatile EXTERN BIT_LIST_8              __io(0x025A)    _0x025A;
//volatile EXTERN BIT_LIST_8              __io(0x025B)    _0x025B;
//volatile EXTERN BIT_LIST_8              __io(0x025C)    _0x025C;
//volatile EXTERN BIT_LIST_8              __io(0x025D)    _0x025D;
//volatile EXTERN BIT_LIST_8              __io(0x025E)    _0x025E;
//volatile EXTERN BIT_LIST_8              __io(0x025F)    _0x025F;
//volatile EXTERN BIT_LIST_8              __io(0x0260)    _0x0260;
//volatile EXTERN BIT_LIST_8              __io(0x0261)    _0x0261;
//volatile EXTERN BIT_LIST_8              __io(0x0262)    _0x0262;
//volatile EXTERN BIT_LIST_8              __io(0x0263)    _0x0263;
//volatile EXTERN BIT_LIST_8              __io(0x0264)    _0x0264;
//volatile EXTERN BIT_LIST_8              __io(0x0265)    _0x0265;
//volatile EXTERN BIT_LIST_8              __io(0x0266)    _0x0266;
//volatile EXTERN BIT_LIST_8              __io(0x0267)    _0x0267;
//volatile EXTERN BIT_LIST_8              __io(0x0268)    _0x0268;
//volatile EXTERN BIT_LIST_8              __io(0x0269)    _0x0269;
//volatile EXTERN BIT_LIST_8              __io(0x026A)    _0x026A;
//volatile EXTERN BIT_LIST_8              __io(0x026B)    _0x026B;
//volatile EXTERN BIT_LIST_8              __io(0x026C)    _0x026C;
//volatile EXTERN BIT_LIST_8              __io(0x026D)    _0x026D;
//volatile EXTERN BIT_LIST_8              __io(0x026E)    _0x026E;
//volatile EXTERN BIT_LIST_8              __io(0x026F)    _0x026F;
//volatile EXTERN BIT_LIST_8              __io(0x0270)    _0x0270;
//volatile EXTERN BIT_LIST_8              __io(0x0271)    _0x0271;
//volatile EXTERN BIT_LIST_8              __io(0x0272)    _0x0272;
//volatile EXTERN BIT_LIST_8              __io(0x0273)    _0x0273;
//volatile EXTERN BIT_LIST_8              __io(0x0274)    _0x0274;
//volatile EXTERN BIT_LIST_8              __io(0x0275)    _0x0275;
//volatile EXTERN BIT_LIST_8              __io(0x0276)    _0x0276;
//volatile EXTERN BIT_LIST_8              __io(0x0277)    _0x0277;
//volatile EXTERN BIT_LIST_8              __io(0x0278)    _0x0278;
//volatile EXTERN BIT_LIST_8              __io(0x0279)    _0x0279;
//volatile EXTERN BIT_LIST_8              __io(0x027A)    _0x027A;
//volatile EXTERN BIT_LIST_8              __io(0x027B)    _0x027B;
//volatile EXTERN BIT_LIST_8              __io(0x027C)    _0x027C;
//volatile EXTERN BIT_LIST_8              __io(0x027D)    _0x027D;
//volatile EXTERN BIT_LIST_8              __io(0x027E)    _0x027E;
//volatile EXTERN BIT_LIST_8              __io(0x027F)    _0x027F;
//volatile EXTERN BIT_LIST_8              __io(0x0280)    _0x0280;
//volatile EXTERN BIT_LIST_8              __io(0x0281)    _0x0281;
//volatile EXTERN BIT_LIST_8              __io(0x0282)    _0x0282;
//volatile EXTERN BIT_LIST_8              __io(0x0283)    _0x0283;
//volatile EXTERN BIT_LIST_8              __io(0x0284)    _0x0284;
//volatile EXTERN BIT_LIST_8              __io(0x0285)    _0x0285;
//volatile EXTERN BIT_LIST_8              __io(0x0286)    _0x0286;
//volatile EXTERN BIT_LIST_8              __io(0x0287)    _0x0287;
//volatile EXTERN BIT_LIST_8              __io(0x0288)    _0x0288;
//volatile EXTERN BIT_LIST_8              __io(0x0289)    _0x0289;
//volatile EXTERN BIT_LIST_8              __io(0x028A)    _0x028A;
//volatile EXTERN BIT_LIST_8              __io(0x028B)    _0x028B;
//volatile EXTERN BIT_LIST_8              __io(0x028C)    _0x028C;
//volatile EXTERN BIT_LIST_8              __io(0x028D)    _0x028D;
//volatile EXTERN BIT_LIST_8              __io(0x028E)    _0x028E;
//volatile EXTERN BIT_LIST_8              __io(0x028F)    _0x028F;
//volatile EXTERN BIT_LIST_8              __io(0x0290)    _0x0290;
//volatile EXTERN BIT_LIST_8              __io(0x0291)    _0x0291;
//volatile EXTERN BIT_LIST_8              __io(0x0292)    _0x0292;
//volatile EXTERN BIT_LIST_8              __io(0x0293)    _0x0293;
//volatile EXTERN BIT_LIST_8              __io(0x0294)    _0x0294;
//volatile EXTERN BIT_LIST_8              __io(0x0295)    _0x0295;
//volatile EXTERN BIT_LIST_8              __io(0x0296)    _0x0296;
//volatile EXTERN BIT_LIST_8              __io(0x0297)    _0x0297;
//volatile EXTERN BIT_LIST_8              __io(0x0298)    _0x0298;
//volatile EXTERN BIT_LIST_8              __io(0x0299)    _0x0299;
//volatile EXTERN BIT_LIST_8              __io(0x029A)    _0x029A;
//volatile EXTERN BIT_LIST_8              __io(0x029B)    _0x029B;
//volatile EXTERN BIT_LIST_8              __io(0x029C)    _0x029C;
//volatile EXTERN BIT_LIST_8              __io(0x029D)    _0x029D;
//volatile EXTERN BIT_LIST_8              __io(0x029E)    _0x029E;
//volatile EXTERN BIT_LIST_8              __io(0x029F)    _0x029F;
//volatile EXTERN BIT_LIST_8              __io(0x02A0)    _0x02A0;
//volatile EXTERN BIT_LIST_8              __io(0x02A1)    _0x02A1;
//volatile EXTERN BIT_LIST_8              __io(0x02A2)    _0x02A2;
//volatile EXTERN BIT_LIST_8              __io(0x02A3)    _0x02A3;
//volatile EXTERN BIT_LIST_8              __io(0x02A4)    _0x02A4;
//volatile EXTERN BIT_LIST_8              __io(0x02A5)    _0x02A5;
//volatile EXTERN BIT_LIST_8              __io(0x02A6)    _0x02A6;
//volatile EXTERN BIT_LIST_8              __io(0x02A7)    _0x02A7;
//volatile EXTERN BIT_LIST_8              __io(0x02A8)    _0x02A8;
//volatile EXTERN BIT_LIST_8              __io(0x02A9)    _0x02A9;
//volatile EXTERN BIT_LIST_8              __io(0x02AA)    _0x02AA;
//volatile EXTERN BIT_LIST_8              __io(0x02AB)    _0x02AB;
//volatile EXTERN BIT_LIST_8              __io(0x02AC)    _0x02AC;
//volatile EXTERN BIT_LIST_8              __io(0x02AD)    _0x02AD;
//volatile EXTERN BIT_LIST_8              __io(0x02AE)    _0x02AE;
//volatile EXTERN BIT_LIST_8              __io(0x02AF)    _0x02AF;
//volatile EXTERN BIT_LIST_8              __io(0x02B0)    _0x02B0;
//volatile EXTERN BIT_LIST_8              __io(0x02B1)    _0x02B1;
//volatile EXTERN BIT_LIST_8              __io(0x02B2)    _0x02B2;
//volatile EXTERN BIT_LIST_8              __io(0x02B3)    _0x02B3;
//volatile EXTERN BIT_LIST_8              __io(0x02B4)    _0x02B4;
//volatile EXTERN BIT_LIST_8              __io(0x02B5)    _0x02B5;
//volatile EXTERN BIT_LIST_8              __io(0x02B6)    _0x02B6;
//volatile EXTERN BIT_LIST_8              __io(0x02B7)    _0x02B7;
//volatile EXTERN BIT_LIST_8              __io(0x02B8)    _0x02B8;
//volatile EXTERN BIT_LIST_8              __io(0x02B9)    _0x02B9;
//volatile EXTERN BIT_LIST_8              __io(0x02BA)    _0x02BA;
//volatile EXTERN BIT_LIST_8              __io(0x02BB)    _0x02BB;
//volatile EXTERN BIT_LIST_8              __io(0x02BC)    _0x02BC;
//volatile EXTERN BIT_LIST_8              __io(0x02BD)    _0x02BD;
//volatile EXTERN BIT_LIST_8              __io(0x02BE)    _0x02BE;
//volatile EXTERN BIT_LIST_8              __io(0x02BF)    _0x02BF;
//volatile EXTERN BIT_LIST_8              __io(0x02C0)    _0x02C0;
//volatile EXTERN BIT_LIST_8              __io(0x02C1)    _0x02C1;
//volatile EXTERN BIT_LIST_8              __io(0x02C2)    _0x02C2;
//volatile EXTERN BIT_LIST_8              __io(0x02C3)    _0x02C3;
//volatile EXTERN BIT_LIST_8              __io(0x02C4)    _0x02C4;
//volatile EXTERN BIT_LIST_8              __io(0x02C5)    _0x02C5;
//volatile EXTERN BIT_LIST_8              __io(0x02C6)    _0x02C6;
//volatile EXTERN BIT_LIST_8              __io(0x02C7)    _0x02C7;
//volatile EXTERN BIT_LIST_8              __io(0x02C8)    _0x02C8;
//volatile EXTERN BIT_LIST_8              __io(0x02C9)    _0x02C9;
//volatile EXTERN BIT_LIST_8              __io(0x02CA)    _0x02CA;
//volatile EXTERN BIT_LIST_8              __io(0x02CB)    _0x02CB;
//volatile EXTERN BIT_LIST_8              __io(0x02CC)    _0x02CC;
//volatile EXTERN BIT_LIST_8              __io(0x02CD)    _0x02CD;
//volatile EXTERN BIT_LIST_8              __io(0x02CE)    _0x02CE;
//volatile EXTERN BIT_LIST_8              __io(0x02CF)    _0x02CF;
//volatile EXTERN BIT_LIST_8              __io(0x02D0)    _0x02D0;
//volatile EXTERN BIT_LIST_8              __io(0x02D1)    _0x02D1;
//volatile EXTERN BIT_LIST_8              __io(0x02D2)    _0x02D2;
//volatile EXTERN BIT_LIST_8              __io(0x02D3)    _0x02D3;
//volatile EXTERN BIT_LIST_8              __io(0x02D4)    _0x02D4;
//volatile EXTERN BIT_LIST_8              __io(0x02D5)    _0x02D5;
//volatile EXTERN BIT_LIST_8              __io(0x02D6)    _0x02D6;
//volatile EXTERN BIT_LIST_8              __io(0x02D7)    _0x02D7;
//volatile EXTERN BIT_LIST_8              __io(0x02D8)    _0x02D8;
//volatile EXTERN BIT_LIST_8              __io(0x02D9)    _0x02D9;
//volatile EXTERN BIT_LIST_8              __io(0x02DA)    _0x02DA;
//volatile EXTERN BIT_LIST_8              __io(0x02DB)    _0x02DB;
//volatile EXTERN BIT_LIST_8              __io(0x02DC)    _0x02DC;
//volatile EXTERN BIT_LIST_8              __io(0x02DD)    _0x02DD;
//volatile EXTERN BIT_LIST_8              __io(0x02DE)    _0x02DE;
//volatile EXTERN BIT_LIST_8              __io(0x02DF)    _0x02DF;
//volatile EXTERN BIT_LIST_8              __io(0x02E0)    _0x02E0;
//volatile EXTERN BIT_LIST_8              __io(0x02E1)    _0x02E1;
//volatile EXTERN BIT_LIST_8              __io(0x02E2)    _0x02E2;
//volatile EXTERN BIT_LIST_8              __io(0x02E3)    _0x02E3;
//volatile EXTERN BIT_LIST_8              __io(0x02E4)    _0x02E4;
//volatile EXTERN BIT_LIST_8              __io(0x02E5)    _0x02E5;
//volatile EXTERN BIT_LIST_8              __io(0x02E6)    _0x02E6;
//volatile EXTERN BIT_LIST_8              __io(0x02E7)    _0x02E7;
//volatile EXTERN BIT_LIST_8              __io(0x02E8)    _0x02E8;
//volatile EXTERN BIT_LIST_8              __io(0x02E9)    _0x02E9;
//volatile EXTERN BIT_LIST_8              __io(0x02EA)    _0x02EA;
//volatile EXTERN BIT_LIST_8              __io(0x02EB)    _0x02EB;
//volatile EXTERN BIT_LIST_8              __io(0x02EC)    _0x02EC;
//volatile EXTERN BIT_LIST_8              __io(0x02ED)    _0x02ED;
//volatile EXTERN BIT_LIST_8              __io(0x02EE)    _0x02EE;
//volatile EXTERN BIT_LIST_8              __io(0x02EF)    _0x02EF;
//volatile EXTERN BIT_LIST_8              __io(0x02F0)    _0x02F0;
//volatile EXTERN BIT_LIST_8              __io(0x02F1)    _0x02F1;
//volatile EXTERN BIT_LIST_8              __io(0x02F2)    _0x02F2;
//volatile EXTERN BIT_LIST_8              __io(0x02F3)    _0x02F3;
//volatile EXTERN BIT_LIST_8              __io(0x02F4)    _0x02F4;
//volatile EXTERN BIT_LIST_8              __io(0x02F5)    _0x02F5;
//volatile EXTERN BIT_LIST_8              __io(0x02F6)    _0x02F6;
//volatile EXTERN BIT_LIST_8              __io(0x02F7)    _0x02F7;
//volatile EXTERN BIT_LIST_8              __io(0x02F8)    _0x02F8;
//volatile EXTERN BIT_LIST_8              __io(0x02F9)    _0x02F9;
//volatile EXTERN BIT_LIST_8              __io(0x02FA)    _0x02FA;
//volatile EXTERN BIT_LIST_8              __io(0x02FB)    _0x02FB;
//volatile EXTERN BIT_LIST_8              __io(0x02FC)    _0x02FC;
//volatile EXTERN BIT_LIST_8              __io(0x02FD)    _0x02FD;
//volatile EXTERN BIT_LIST_8              __io(0x02FE)    _0x02FE;
//volatile EXTERN BIT_LIST_8              __io(0x02FF)    _0x02FF;
volatile EXTERN BIT_LIST_8              __io(0x0300)    _0x0300;
volatile EXTERN BIT_LIST_8              __io(0x0301)    _0x0301;
volatile EXTERN BIT_LIST_8              __io(0x0302)    _0x0302;
//volatile EXTERN BIT_LIST_8              __io(0x0303)    _0x0303;
volatile EXTERN BIT_LIST_8              __io(0x0304)    _0x0304;
//volatile EXTERN BIT_LIST_8              __io(0x0305)    _0x0305;
volatile EXTERN BIT_LIST_8              __io(0x0306)    _0x0306;
volatile EXTERN BIT_LIST_8              __io(0x0307)    _0x0307;
volatile EXTERN BIT_LIST_8              __io(0x0308)    _0x0308;
//volatile EXTERN BIT_LIST_8              __io(0x0309)    _0x0309;
volatile EXTERN BIT_LIST_8              __io(0x030A)    _0x030A;
volatile EXTERN BIT_LIST_8              __io(0x030B)    _0x030B;
volatile EXTERN BIT_LIST_8              __io(0x030C)    _0x030C;
//volatile EXTERN BIT_LIST_8              __io(0x030D)    _0x030D;
//volatile EXTERN BIT_LIST_8              __io(0x030E)    _0x030E;
//volatile EXTERN BIT_LIST_8              __io(0x030F)    _0x030F;
volatile EXTERN BIT_LIST_16_ADC         __io(0x0310)    _0x0310;
//volatile EXTERN BIT_LIST_8              __io(0x0311)    _0x0311;
volatile EXTERN BIT_LIST_16_ADC         __io(0x0312)    _0x0312;
//volatile EXTERN BIT_LIST_8              __io(0x0313)    _0x0313;
volatile EXTERN BIT_LIST_16_ADC         __io(0x0314)    _0x0314;
//volatile EXTERN BIT_LIST_8              __io(0x0315)    _0x0315;
//volatile EXTERN BIT_LIST_8              __io(0x0316)    _0x0316;
//volatile EXTERN BIT_LIST_8              __io(0x0317)    _0x0317;
//volatile EXTERN BIT_LIST_8              __io(0x0318)    _0x0318;
//volatile EXTERN BIT_LIST_8              __io(0x0319)    _0x0319;
//volatile EXTERN BIT_LIST_8              __io(0x031A)    _0x031A;
//volatile EXTERN BIT_LIST_8              __io(0x031B)    _0x031B;
//volatile EXTERN BIT_LIST_8              __io(0x031C)    _0x031C;
//volatile EXTERN BIT_LIST_8              __io(0x031D)    _0x031D;
//volatile EXTERN BIT_LIST_8              __io(0x031E)    _0x031E;
//volatile EXTERN BIT_LIST_8              __io(0x031F)    _0x031F;
//volatile EXTERN BIT_LIST_8              __io(0x0320)    _0x0320;
//volatile EXTERN BIT_LIST_8              __io(0x0321)    _0x0321;
//volatile EXTERN BIT_LIST_8              __io(0x0322)    _0x0322;
//volatile EXTERN BIT_LIST_8              __io(0x0323)    _0x0323;
//volatile EXTERN BIT_LIST_8              __io(0x0324)    _0x0324;
//volatile EXTERN BIT_LIST_8              __io(0x0325)    _0x0325;
//volatile EXTERN BIT_LIST_8              __io(0x0326)    _0x0326;
//volatile EXTERN BIT_LIST_8              __io(0x0327)    _0x0327;
//volatile EXTERN BIT_LIST_8              __io(0x0328)    _0x0328;
//volatile EXTERN BIT_LIST_8              __io(0x0329)    _0x0329;
//volatile EXTERN BIT_LIST_8              __io(0x032A)    _0x032A;
//volatile EXTERN BIT_LIST_8              __io(0x032B)    _0x032B;
//volatile EXTERN BIT_LIST_8              __io(0x032C)    _0x032C;
//volatile EXTERN BIT_LIST_8              __io(0x032D)    _0x032D;
//volatile EXTERN BIT_LIST_8              __io(0x032E)    _0x032E;
//volatile EXTERN BIT_LIST_8              __io(0x032F)    _0x032F;
//volatile EXTERN BIT_LIST_8              __io(0x0330)    _0x0330;
//volatile EXTERN BIT_LIST_8              __io(0x0331)    _0x0331;
//volatile EXTERN BIT_LIST_8              __io(0x0332)    _0x0332;
//volatile EXTERN BIT_LIST_8              __io(0x0333)    _0x0333;
//volatile EXTERN BIT_LIST_8              __io(0x0334)    _0x0334;
//volatile EXTERN BIT_LIST_8              __io(0x0335)    _0x0335;
//volatile EXTERN BIT_LIST_8              __io(0x0336)    _0x0336;
//volatile EXTERN BIT_LIST_8              __io(0x0337)    _0x0337;
//volatile EXTERN BIT_LIST_8              __io(0x0338)    _0x0338;
//volatile EXTERN BIT_LIST_8              __io(0x0339)    _0x0339;
//volatile EXTERN BIT_LIST_8              __io(0x033A)    _0x033A;
//volatile EXTERN BIT_LIST_8              __io(0x033B)    _0x033B;
//volatile EXTERN BIT_LIST_8              __io(0x033C)    _0x033C;
//volatile EXTERN BIT_LIST_8              __io(0x033D)    _0x033D;
//volatile EXTERN BIT_LIST_8              __io(0x033E)    _0x033E;
//volatile EXTERN BIT_LIST_8              __io(0x033F)    _0x033F;
//volatile EXTERN BIT_LIST_8              __io(0x0340)    _0x0340;
//volatile EXTERN BIT_LIST_8              __io(0x0341)    _0x0341;
//volatile EXTERN BIT_LIST_8              __io(0x0342)    _0x0342;
//volatile EXTERN BIT_LIST_8              __io(0x0343)    _0x0343;
//volatile EXTERN BIT_LIST_8              __io(0x0344)    _0x0344;
//volatile EXTERN BIT_LIST_8              __io(0x0345)    _0x0345;
//volatile EXTERN BIT_LIST_8              __io(0x0346)    _0x0346;
//volatile EXTERN BIT_LIST_8              __io(0x0347)    _0x0347;
//volatile EXTERN BIT_LIST_8              __io(0x0348)    _0x0348;
//volatile EXTERN BIT_LIST_8              __io(0x0349)    _0x0349;
//volatile EXTERN BIT_LIST_8              __io(0x034A)    _0x034A;
//volatile EXTERN BIT_LIST_8              __io(0x034B)    _0x034B;
//volatile EXTERN BIT_LIST_8              __io(0x034C)    _0x034C;
//volatile EXTERN BIT_LIST_8              __io(0x034D)    _0x034D;
//volatile EXTERN BIT_LIST_8              __io(0x034E)    _0x034E;
//volatile EXTERN BIT_LIST_8              __io(0x034F)    _0x034F;
//volatile EXTERN BIT_LIST_8              __io(0x0350)    _0x0350;
//volatile EXTERN BIT_LIST_8              __io(0x0351)    _0x0351;
//volatile EXTERN BIT_LIST_8              __io(0x0352)    _0x0352;
//volatile EXTERN BIT_LIST_8              __io(0x0353)    _0x0353;
//volatile EXTERN BIT_LIST_8              __io(0x0354)    _0x0354;
//volatile EXTERN BIT_LIST_8              __io(0x0355)    _0x0355;
//volatile EXTERN BIT_LIST_8              __io(0x0356)    _0x0356;
//volatile EXTERN BIT_LIST_8              __io(0x0357)    _0x0357;
//volatile EXTERN BIT_LIST_8              __io(0x0358)    _0x0358;
//volatile EXTERN BIT_LIST_8              __io(0x0359)    _0x0359;
//volatile EXTERN BIT_LIST_8              __io(0x035A)    _0x035A;
//volatile EXTERN BIT_LIST_8              __io(0x035B)    _0x035B;
//volatile EXTERN BIT_LIST_8              __io(0x035C)    _0x035C;
//volatile EXTERN BIT_LIST_8              __io(0x035D)    _0x035D;
//volatile EXTERN BIT_LIST_8              __io(0x035E)    _0x035E;
//volatile EXTERN BIT_LIST_8              __io(0x035F)    _0x035F;
//volatile EXTERN BIT_LIST_8              __io(0x0360)    _0x0360;
//volatile EXTERN BIT_LIST_8              __io(0x0361)    _0x0361;
//volatile EXTERN BIT_LIST_8              __io(0x0362)    _0x0362;
//volatile EXTERN BIT_LIST_8              __io(0x0363)    _0x0363;
//volatile EXTERN BIT_LIST_8              __io(0x0364)    _0x0364;
//volatile EXTERN BIT_LIST_8              __io(0x0365)    _0x0365;
//volatile EXTERN BIT_LIST_8              __io(0x0366)    _0x0366;
//volatile EXTERN BIT_LIST_8              __io(0x0367)    _0x0367;
//volatile EXTERN BIT_LIST_8              __io(0x0368)    _0x0368;
//volatile EXTERN BIT_LIST_8              __io(0x0369)    _0x0369;
//volatile EXTERN BIT_LIST_8              __io(0x036A)    _0x036A;
//volatile EXTERN BIT_LIST_8              __io(0x036B)    _0x036B;
//volatile EXTERN BIT_LIST_8              __io(0x036C)    _0x036C;
//volatile EXTERN BIT_LIST_8              __io(0x036D)    _0x036D;
//volatile EXTERN BIT_LIST_8              __io(0x036E)    _0x036E;
//volatile EXTERN BIT_LIST_8              __io(0x036F)    _0x036F;
//volatile EXTERN BIT_LIST_8              __io(0x0370)    _0x0370;
//volatile EXTERN BIT_LIST_8              __io(0x0371)    _0x0371;
//volatile EXTERN BIT_LIST_8              __io(0x0372)    _0x0372;
//volatile EXTERN BIT_LIST_8              __io(0x0373)    _0x0373;
//volatile EXTERN BIT_LIST_8              __io(0x0374)    _0x0374;
//volatile EXTERN BIT_LIST_8              __io(0x0375)    _0x0375;
//volatile EXTERN BIT_LIST_8              __io(0x0376)    _0x0376;
//volatile EXTERN BIT_LIST_8              __io(0x0377)    _0x0377;
//volatile EXTERN BIT_LIST_8              __io(0x0378)    _0x0378;
//volatile EXTERN BIT_LIST_8              __io(0x0379)    _0x0379;
//volatile EXTERN BIT_LIST_8              __io(0x037A)    _0x037A;
//volatile EXTERN BIT_LIST_8              __io(0x037B)    _0x037B;
//volatile EXTERN BIT_LIST_8              __io(0x037C)    _0x037C;
//volatile EXTERN BIT_LIST_8              __io(0x037D)    _0x037D;
//volatile EXTERN BIT_LIST_8              __io(0x037E)    _0x037E;
//volatile EXTERN BIT_LIST_8              __io(0x037F)    _0x037F;
//volatile EXTERN BIT_LIST_8              __io(0x0380)    _0x0380;
//volatile EXTERN BIT_LIST_8              __io(0x0381)    _0x0381;
//volatile EXTERN BIT_LIST_8              __io(0x0382)    _0x0382;
//volatile EXTERN BIT_LIST_8              __io(0x0383)    _0x0383;
//volatile EXTERN BIT_LIST_8              __io(0x0384)    _0x0384;
//volatile EXTERN BIT_LIST_8              __io(0x0385)    _0x0385;
//volatile EXTERN BIT_LIST_8              __io(0x0386)    _0x0386;
//volatile EXTERN BIT_LIST_8              __io(0x0387)    _0x0387;
//volatile EXTERN BIT_LIST_8              __io(0x0388)    _0x0388;
//volatile EXTERN BIT_LIST_8              __io(0x0389)    _0x0389;
//volatile EXTERN BIT_LIST_8              __io(0x038A)    _0x038A;
//volatile EXTERN BIT_LIST_8              __io(0x038B)    _0x038B;
//volatile EXTERN BIT_LIST_8              __io(0x038C)    _0x038C;
//volatile EXTERN BIT_LIST_8              __io(0x038D)    _0x038D;
//volatile EXTERN BIT_LIST_8              __io(0x038E)    _0x038E;
//volatile EXTERN BIT_LIST_8              __io(0x038F)    _0x038F;
//volatile EXTERN BIT_LIST_8              __io(0x0390)    _0x0390;
//volatile EXTERN BIT_LIST_8              __io(0x0391)    _0x0391;
//volatile EXTERN BIT_LIST_8              __io(0x0392)    _0x0392;
//volatile EXTERN BIT_LIST_8              __io(0x0393)    _0x0393;
//volatile EXTERN BIT_LIST_8              __io(0x0394)    _0x0394;
//volatile EXTERN BIT_LIST_8              __io(0x0395)    _0x0395;
//volatile EXTERN BIT_LIST_8              __io(0x0396)    _0x0396;
//volatile EXTERN BIT_LIST_8              __io(0x0397)    _0x0397;
//volatile EXTERN BIT_LIST_8              __io(0x0398)    _0x0398;
//volatile EXTERN BIT_LIST_8              __io(0x0399)    _0x0399;
//volatile EXTERN BIT_LIST_8              __io(0x039A)    _0x039A;
//volatile EXTERN BIT_LIST_8              __io(0x039B)    _0x039B;
//volatile EXTERN BIT_LIST_8              __io(0x039C)    _0x039C;
//volatile EXTERN BIT_LIST_8              __io(0x039D)    _0x039D;
//volatile EXTERN BIT_LIST_8              __io(0x039E)    _0x039E;
//volatile EXTERN BIT_LIST_8              __io(0x039F)    _0x039F;
//volatile EXTERN BIT_LIST_8              __io(0x03A0)    _0x03A0;
//volatile EXTERN BIT_LIST_8              __io(0x03A1)    _0x03A1;
//volatile EXTERN BIT_LIST_8              __io(0x03A2)    _0x03A2;
//volatile EXTERN BIT_LIST_8              __io(0x03A3)    _0x03A3;
//volatile EXTERN BIT_LIST_8              __io(0x03A4)    _0x03A4;
//volatile EXTERN BIT_LIST_8              __io(0x03A5)    _0x03A5;
//volatile EXTERN BIT_LIST_8              __io(0x03A6)    _0x03A6;
//volatile EXTERN BIT_LIST_8              __io(0x03A7)    _0x03A7;
//volatile EXTERN BIT_LIST_8              __io(0x03A8)    _0x03A8;
//volatile EXTERN BIT_LIST_8              __io(0x03A9)    _0x03A9;
//volatile EXTERN BIT_LIST_8              __io(0x03AA)    _0x03AA;
//volatile EXTERN BIT_LIST_8              __io(0x03AB)    _0x03AB;
//volatile EXTERN BIT_LIST_8              __io(0x03AC)    _0x03AC;
//volatile EXTERN BIT_LIST_8              __io(0x03AD)    _0x03AD;
//volatile EXTERN BIT_LIST_8              __io(0x03AE)    _0x03AE;
//volatile EXTERN BIT_LIST_8              __io(0x03AF)    _0x03AF;
//volatile EXTERN BIT_LIST_8              __io(0x03B0)    _0x03B0;
//volatile EXTERN BIT_LIST_8              __io(0x03B1)    _0x03B1;
//volatile EXTERN BIT_LIST_8              __io(0x03B2)    _0x03B2;
//volatile EXTERN BIT_LIST_8              __io(0x03B3)    _0x03B3;
//volatile EXTERN BIT_LIST_8              __io(0x03B4)    _0x03B4;
//volatile EXTERN BIT_LIST_8              __io(0x03B5)    _0x03B5;
//volatile EXTERN BIT_LIST_8              __io(0x03B6)    _0x03B6;
//volatile EXTERN BIT_LIST_8              __io(0x03B7)    _0x03B7;
//volatile EXTERN BIT_LIST_8              __io(0x03B8)    _0x03B8;
//volatile EXTERN BIT_LIST_8              __io(0x03B9)    _0x03B9;
//volatile EXTERN BIT_LIST_8              __io(0x03BA)    _0x03BA;
//volatile EXTERN BIT_LIST_8              __io(0x03BB)    _0x03BB;
//volatile EXTERN BIT_LIST_8              __io(0x03BC)    _0x03BC;
//volatile EXTERN BIT_LIST_8              __io(0x03BD)    _0x03BD;
//volatile EXTERN BIT_LIST_8              __io(0x03BE)    _0x03BE;
//volatile EXTERN BIT_LIST_8              __io(0x03BF)    _0x03BF;
//volatile EXTERN BIT_LIST_8              __io(0x03C0)    _0x03C0;
//volatile EXTERN BIT_LIST_8              __io(0x03C1)    _0x03C1;
//volatile EXTERN BIT_LIST_8              __io(0x03C2)    _0x03C2;
//volatile EXTERN BIT_LIST_8              __io(0x03C3)    _0x03C3;
//volatile EXTERN BIT_LIST_8              __io(0x03C4)    _0x03C4;
//volatile EXTERN BIT_LIST_8              __io(0x03C5)    _0x03C5;
//volatile EXTERN BIT_LIST_8              __io(0x03C6)    _0x03C6;
//volatile EXTERN BIT_LIST_8              __io(0x03C7)    _0x03C7;
//volatile EXTERN BIT_LIST_8              __io(0x03C8)    _0x03C8;
//volatile EXTERN BIT_LIST_8              __io(0x03C9)    _0x03C9;
//volatile EXTERN BIT_LIST_8              __io(0x03CA)    _0x03CA;
//volatile EXTERN BIT_LIST_8              __io(0x03CB)    _0x03CB;
//volatile EXTERN BIT_LIST_8              __io(0x03CC)    _0x03CC;
//volatile EXTERN BIT_LIST_8              __io(0x03CD)    _0x03CD;
//volatile EXTERN BIT_LIST_8              __io(0x03CE)    _0x03CE;
//volatile EXTERN BIT_LIST_8              __io(0x03CF)    _0x03CF;
//volatile EXTERN BIT_LIST_8              __io(0x03D0)    _0x03D0;
//volatile EXTERN BIT_LIST_8              __io(0x03D1)    _0x03D1;
//volatile EXTERN BIT_LIST_8              __io(0x03D2)    _0x03D2;
//volatile EXTERN BIT_LIST_8              __io(0x03D3)    _0x03D3;
//volatile EXTERN BIT_LIST_8              __io(0x03D4)    _0x03D4;
//volatile EXTERN BIT_LIST_8              __io(0x03D5)    _0x03D5;
//volatile EXTERN BIT_LIST_8              __io(0x03D6)    _0x03D6;
//volatile EXTERN BIT_LIST_8              __io(0x03D7)    _0x03D7;
//volatile EXTERN BIT_LIST_8              __io(0x03D8)    _0x03D8;
//volatile EXTERN BIT_LIST_8              __io(0x03D9)    _0x03D9;
//volatile EXTERN BIT_LIST_8              __io(0x03DA)    _0x03DA;
//volatile EXTERN BIT_LIST_8              __io(0x03DB)    _0x03DB;
//volatile EXTERN BIT_LIST_8              __io(0x03DC)    _0x03DC;
//volatile EXTERN BIT_LIST_8              __io(0x03DD)    _0x03DD;
//volatile EXTERN BIT_LIST_8              __io(0x03DE)    _0x03DE;
//volatile EXTERN BIT_LIST_8              __io(0x03DF)    _0x03DF;
//volatile EXTERN BIT_LIST_8              __io(0x03E0)    _0x03E0;
//volatile EXTERN BIT_LIST_8              __io(0x03E1)    _0x03E1;
//volatile EXTERN BIT_LIST_8              __io(0x03E2)    _0x03E2;
//volatile EXTERN BIT_LIST_8              __io(0x03E3)    _0x03E3;
//volatile EXTERN BIT_LIST_8              __io(0x03E4)    _0x03E4;
//volatile EXTERN BIT_LIST_8              __io(0x03E5)    _0x03E5;
//volatile EXTERN BIT_LIST_8              __io(0x03E6)    _0x03E6;
//volatile EXTERN BIT_LIST_8              __io(0x03E7)    _0x03E7;
//volatile EXTERN BIT_LIST_8              __io(0x03E8)    _0x03E8;
//volatile EXTERN BIT_LIST_8              __io(0x03E9)    _0x03E9;
//volatile EXTERN BIT_LIST_8              __io(0x03EA)    _0x03EA;
//volatile EXTERN BIT_LIST_8              __io(0x03EB)    _0x03EB;
//volatile EXTERN BIT_LIST_8              __io(0x03EC)    _0x03EC;
//volatile EXTERN BIT_LIST_8              __io(0x03ED)    _0x03ED;
//volatile EXTERN BIT_LIST_8              __io(0x03EE)    _0x03EE;
//volatile EXTERN BIT_LIST_8              __io(0x03EF)    _0x03EF;
//volatile EXTERN BIT_LIST_8              __io(0x03F0)    _0x03F0;
//volatile EXTERN BIT_LIST_8              __io(0x03F1)    _0x03F1;
//volatile EXTERN BIT_LIST_8              __io(0x03F2)    _0x03F2;
//volatile EXTERN BIT_LIST_8              __io(0x03F3)    _0x03F3;
//volatile EXTERN BIT_LIST_8              __io(0x03F4)    _0x03F4;
//volatile EXTERN BIT_LIST_8              __io(0x03F5)    _0x03F5;
//volatile EXTERN BIT_LIST_8              __io(0x03F6)    _0x03F6;
//volatile EXTERN BIT_LIST_8              __io(0x03F7)    _0x03F7;
//volatile EXTERN BIT_LIST_8              __io(0x03F8)    _0x03F8;
//volatile EXTERN BIT_LIST_8              __io(0x03F9)    _0x03F9;
//volatile EXTERN BIT_LIST_8              __io(0x03FA)    _0x03FA;
//volatile EXTERN BIT_LIST_8              __io(0x03FB)    _0x03FB;
//volatile EXTERN BIT_LIST_8              __io(0x03FC)    _0x03FC;
//volatile EXTERN BIT_LIST_8              __io(0x03FD)    _0x03FD;
//volatile EXTERN BIT_LIST_8              __io(0x03FE)    _0x03FE;
//volatile EXTERN BIT_LIST_8              __io(0x03FF)    _0x03FF;
//volatile EXTERN BIT_LIST_8              __io(0x0400)    _0x0400;
//volatile EXTERN BIT_LIST_8              __io(0x0401)    _0x0401;
//volatile EXTERN BIT_LIST_8              __io(0x0402)    _0x0402;
//volatile EXTERN BIT_LIST_8              __io(0x0403)    _0x0403;
//volatile EXTERN BIT_LIST_8              __io(0x0404)    _0x0404;
//volatile EXTERN BIT_LIST_8              __io(0x0405)    _0x0405;
//volatile EXTERN BIT_LIST_8              __io(0x0406)    _0x0406;
//volatile EXTERN BIT_LIST_8              __io(0x0407)    _0x0407;
//volatile EXTERN BIT_LIST_8              __io(0x0408)    _0x0408;
//volatile EXTERN BIT_LIST_8              __io(0x0409)    _0x0409;
//volatile EXTERN BIT_LIST_8              __io(0x040A)    _0x040A;
//volatile EXTERN BIT_LIST_8              __io(0x040B)    _0x040B;
//volatile EXTERN BIT_LIST_8              __io(0x040C)    _0x040C;
//volatile EXTERN BIT_LIST_8              __io(0x040D)    _0x040D;
//volatile EXTERN BIT_LIST_8              __io(0x040E)    _0x040E;
//volatile EXTERN BIT_LIST_8              __io(0x040F)    _0x040F;
//volatile EXTERN BIT_LIST_8              __io(0x0410)    _0x0410;
//volatile EXTERN BIT_LIST_8              __io(0x0411)    _0x0411;
//volatile EXTERN BIT_LIST_8              __io(0x0412)    _0x0412;
//volatile EXTERN BIT_LIST_8              __io(0x0413)    _0x0413;
//volatile EXTERN BIT_LIST_8              __io(0x0414)    _0x0414;
//volatile EXTERN BIT_LIST_8              __io(0x0415)    _0x0415;
//volatile EXTERN BIT_LIST_8              __io(0x0416)    _0x0416;
//volatile EXTERN BIT_LIST_8              __io(0x0417)    _0x0417;
//volatile EXTERN BIT_LIST_8              __io(0x0418)    _0x0418;
//volatile EXTERN BIT_LIST_8              __io(0x0419)    _0x0419;
//volatile EXTERN BIT_LIST_8              __io(0x041A)    _0x041A;
//volatile EXTERN BIT_LIST_8              __io(0x041B)    _0x041B;
//volatile EXTERN BIT_LIST_8              __io(0x041C)    _0x041C;
//volatile EXTERN BIT_LIST_8              __io(0x041D)    _0x041D;
//volatile EXTERN BIT_LIST_8              __io(0x041E)    _0x041E;
//volatile EXTERN BIT_LIST_8              __io(0x041F)    _0x041F;
//volatile EXTERN BIT_LIST_8              __io(0x0420)    _0x0420;
//volatile EXTERN BIT_LIST_8              __io(0x0421)    _0x0421;
//volatile EXTERN BIT_LIST_8              __io(0x0422)    _0x0422;
//volatile EXTERN BIT_LIST_8              __io(0x0423)    _0x0423;
//volatile EXTERN BIT_LIST_8              __io(0x0424)    _0x0424;
//volatile EXTERN BIT_LIST_8              __io(0x0425)    _0x0425;
//volatile EXTERN BIT_LIST_8              __io(0x0426)    _0x0426;
//volatile EXTERN BIT_LIST_8              __io(0x0427)    _0x0427;
//volatile EXTERN BIT_LIST_8              __io(0x0428)    _0x0428;
//volatile EXTERN BIT_LIST_8              __io(0x0429)    _0x0429;
//volatile EXTERN BIT_LIST_8              __io(0x042A)    _0x042A;
//volatile EXTERN BIT_LIST_8              __io(0x042B)    _0x042B;
//volatile EXTERN BIT_LIST_8              __io(0x042C)    _0x042C;
//volatile EXTERN BIT_LIST_8              __io(0x042D)    _0x042D;
//volatile EXTERN BIT_LIST_8              __io(0x042E)    _0x042E;
//volatile EXTERN BIT_LIST_8              __io(0x042F)    _0x042F;
//volatile EXTERN BIT_LIST_8              __io(0x0430)    _0x0430;
//volatile EXTERN BIT_LIST_8              __io(0x0431)    _0x0431;
//volatile EXTERN BIT_LIST_8              __io(0x0432)    _0x0432;
//volatile EXTERN BIT_LIST_8              __io(0x0433)    _0x0433;
//volatile EXTERN BIT_LIST_8              __io(0x0434)    _0x0434;
//volatile EXTERN BIT_LIST_8              __io(0x0435)    _0x0435;
//volatile EXTERN BIT_LIST_8              __io(0x0436)    _0x0436;
//volatile EXTERN BIT_LIST_8              __io(0x0437)    _0x0437;
//volatile EXTERN BIT_LIST_8              __io(0x0438)    _0x0438;
//volatile EXTERN BIT_LIST_8              __io(0x0439)    _0x0439;
//volatile EXTERN BIT_LIST_8              __io(0x043A)    _0x043A;
//volatile EXTERN BIT_LIST_8              __io(0x043B)    _0x043B;
//volatile EXTERN BIT_LIST_8              __io(0x043C)    _0x043C;
//volatile EXTERN BIT_LIST_8              __io(0x043D)    _0x043D;
//volatile EXTERN BIT_LIST_8              __io(0x043E)    _0x043E;
//volatile EXTERN BIT_LIST_8              __io(0x043F)    _0x043F;
//volatile EXTERN BIT_LIST_8              __io(0x0440)    _0x0440;
//volatile EXTERN BIT_LIST_8              __io(0x0441)    _0x0441;
//volatile EXTERN BIT_LIST_8              __io(0x0442)    _0x0442;
//volatile EXTERN BIT_LIST_8              __io(0x0443)    _0x0443;
//volatile EXTERN BIT_LIST_8              __io(0x0444)    _0x0444;
//volatile EXTERN BIT_LIST_8              __io(0x0445)    _0x0445;
//volatile EXTERN BIT_LIST_8              __io(0x0446)    _0x0446;
//volatile EXTERN BIT_LIST_8              __io(0x0447)    _0x0447;
//volatile EXTERN BIT_LIST_8              __io(0x0448)    _0x0448;
//volatile EXTERN BIT_LIST_8              __io(0x0449)    _0x0449;
//volatile EXTERN BIT_LIST_8              __io(0x044A)    _0x044A;
//volatile EXTERN BIT_LIST_8              __io(0x044B)    _0x044B;
//volatile EXTERN BIT_LIST_8              __io(0x044C)    _0x044C;
//volatile EXTERN BIT_LIST_8              __io(0x044D)    _0x044D;
//volatile EXTERN BIT_LIST_8              __io(0x044E)    _0x044E;
//volatile EXTERN BIT_LIST_8              __io(0x044F)    _0x044F;
//volatile EXTERN BIT_LIST_8              __io(0x0450)    _0x0450;
//volatile EXTERN BIT_LIST_8              __io(0x0451)    _0x0451;
//volatile EXTERN BIT_LIST_8              __io(0x0452)    _0x0452;
//volatile EXTERN BIT_LIST_8              __io(0x0453)    _0x0453;
//volatile EXTERN BIT_LIST_8              __io(0x0454)    _0x0454;
//volatile EXTERN BIT_LIST_8              __io(0x0455)    _0x0455;
//volatile EXTERN BIT_LIST_8              __io(0x0456)    _0x0456;
//volatile EXTERN BIT_LIST_8              __io(0x0457)    _0x0457;
//volatile EXTERN BIT_LIST_8              __io(0x0458)    _0x0458;
//volatile EXTERN BIT_LIST_8              __io(0x0459)    _0x0459;
//volatile EXTERN BIT_LIST_8              __io(0x045A)    _0x045A;
//volatile EXTERN BIT_LIST_8              __io(0x045B)    _0x045B;
//volatile EXTERN BIT_LIST_8              __io(0x045C)    _0x045C;
//volatile EXTERN BIT_LIST_8              __io(0x045D)    _0x045D;
//volatile EXTERN BIT_LIST_8              __io(0x045E)    _0x045E;
//volatile EXTERN BIT_LIST_8              __io(0x045F)    _0x045F;
//volatile EXTERN BIT_LIST_8              __io(0x0460)    _0x0460;
//volatile EXTERN BIT_LIST_8              __io(0x0461)    _0x0461;
//volatile EXTERN BIT_LIST_8              __io(0x0462)    _0x0462;
//volatile EXTERN BIT_LIST_8              __io(0x0463)    _0x0463;
//volatile EXTERN BIT_LIST_8              __io(0x0464)    _0x0464;
//volatile EXTERN BIT_LIST_8              __io(0x0465)    _0x0465;
//volatile EXTERN BIT_LIST_8              __io(0x0466)    _0x0466;
//volatile EXTERN BIT_LIST_8              __io(0x0467)    _0x0467;
//volatile EXTERN BIT_LIST_8              __io(0x0468)    _0x0468;
//volatile EXTERN BIT_LIST_8              __io(0x0469)    _0x0469;
//volatile EXTERN BIT_LIST_8              __io(0x046A)    _0x046A;
//volatile EXTERN BIT_LIST_8              __io(0x046B)    _0x046B;
//volatile EXTERN BIT_LIST_8              __io(0x046C)    _0x046C;
//volatile EXTERN BIT_LIST_8              __io(0x046D)    _0x046D;
//volatile EXTERN BIT_LIST_8              __io(0x046E)    _0x046E;
//volatile EXTERN BIT_LIST_8              __io(0x046F)    _0x046F;
//volatile EXTERN BIT_LIST_8              __io(0x0470)    _0x0470;
//volatile EXTERN BIT_LIST_8              __io(0x0471)    _0x0471;
//volatile EXTERN BIT_LIST_8              __io(0x0472)    _0x0472;
//volatile EXTERN BIT_LIST_8              __io(0x0473)    _0x0473;
//volatile EXTERN BIT_LIST_8              __io(0x0474)    _0x0474;
//volatile EXTERN BIT_LIST_8              __io(0x0475)    _0x0475;
//volatile EXTERN BIT_LIST_8              __io(0x0476)    _0x0476;
//volatile EXTERN BIT_LIST_8              __io(0x0477)    _0x0477;
//volatile EXTERN BIT_LIST_8              __io(0x0478)    _0x0478;
//volatile EXTERN BIT_LIST_8              __io(0x0479)    _0x0479;
//volatile EXTERN BIT_LIST_8              __io(0x047A)    _0x047A;
//volatile EXTERN BIT_LIST_8              __io(0x047B)    _0x047B;
//volatile EXTERN BIT_LIST_8              __io(0x047C)    _0x047C;
//volatile EXTERN BIT_LIST_8              __io(0x047D)    _0x047D;
//volatile EXTERN BIT_LIST_8              __io(0x047E)    _0x047E;
//volatile EXTERN BIT_LIST_8              __io(0x047F)    _0x047F;
//volatile EXTERN BIT_LIST_8              __io(0x0480)    _0x0480;
//volatile EXTERN BIT_LIST_8              __io(0x0481)    _0x0481;
//volatile EXTERN BIT_LIST_8              __io(0x0482)    _0x0482;
//volatile EXTERN BIT_LIST_8              __io(0x0483)    _0x0483;
//volatile EXTERN BIT_LIST_8              __io(0x0484)    _0x0484;
//volatile EXTERN BIT_LIST_8              __io(0x0485)    _0x0485;
//volatile EXTERN BIT_LIST_8              __io(0x0486)    _0x0486;
//volatile EXTERN BIT_LIST_8              __io(0x0487)    _0x0487;
//volatile EXTERN BIT_LIST_8              __io(0x0488)    _0x0488;
//volatile EXTERN BIT_LIST_8              __io(0x0489)    _0x0489;
//volatile EXTERN BIT_LIST_8              __io(0x048A)    _0x048A;
//volatile EXTERN BIT_LIST_8              __io(0x048B)    _0x048B;
//volatile EXTERN BIT_LIST_8              __io(0x048C)    _0x048C;
//volatile EXTERN BIT_LIST_8              __io(0x048D)    _0x048D;
//volatile EXTERN BIT_LIST_8              __io(0x048E)    _0x048E;
//volatile EXTERN BIT_LIST_8              __io(0x048F)    _0x048F;
//volatile EXTERN BIT_LIST_8              __io(0x0490)    _0x0490;
//volatile EXTERN BIT_LIST_8              __io(0x0491)    _0x0491;
//volatile EXTERN BIT_LIST_8              __io(0x0492)    _0x0492;
//volatile EXTERN BIT_LIST_8              __io(0x0493)    _0x0493;
//volatile EXTERN BIT_LIST_8              __io(0x0494)    _0x0494;
//volatile EXTERN BIT_LIST_8              __io(0x0495)    _0x0495;
//volatile EXTERN BIT_LIST_8              __io(0x0496)    _0x0496;
//volatile EXTERN BIT_LIST_8              __io(0x0497)    _0x0497;
//volatile EXTERN BIT_LIST_8              __io(0x0498)    _0x0498;
//volatile EXTERN BIT_LIST_8              __io(0x0499)    _0x0499;
//volatile EXTERN BIT_LIST_8              __io(0x049A)    _0x049A;
//volatile EXTERN BIT_LIST_8              __io(0x049B)    _0x049B;
//volatile EXTERN BIT_LIST_8              __io(0x049C)    _0x049C;
//volatile EXTERN BIT_LIST_8              __io(0x049D)    _0x049D;
//volatile EXTERN BIT_LIST_8              __io(0x049E)    _0x049E;
//volatile EXTERN BIT_LIST_8              __io(0x049F)    _0x049F;
//volatile EXTERN BIT_LIST_8              __io(0x04A0)    _0x04A0;
//volatile EXTERN BIT_LIST_8              __io(0x04A1)    _0x04A1;
//volatile EXTERN BIT_LIST_8              __io(0x04A2)    _0x04A2;
//volatile EXTERN BIT_LIST_8              __io(0x04A3)    _0x04A3;
//volatile EXTERN BIT_LIST_8              __io(0x04A4)    _0x04A4;
//volatile EXTERN BIT_LIST_8              __io(0x04A5)    _0x04A5;
//volatile EXTERN BIT_LIST_8              __io(0x04A6)    _0x04A6;
//volatile EXTERN BIT_LIST_8              __io(0x04A7)    _0x04A7;
//volatile EXTERN BIT_LIST_8              __io(0x04A8)    _0x04A8;
//volatile EXTERN BIT_LIST_8              __io(0x04A9)    _0x04A9;
//volatile EXTERN BIT_LIST_8              __io(0x04AA)    _0x04AA;
//volatile EXTERN BIT_LIST_8              __io(0x04AB)    _0x04AB;
//volatile EXTERN BIT_LIST_8              __io(0x04AC)    _0x04AC;
//volatile EXTERN BIT_LIST_8              __io(0x04AD)    _0x04AD;
//volatile EXTERN BIT_LIST_8              __io(0x04AE)    _0x04AE;
//volatile EXTERN BIT_LIST_8              __io(0x04AF)    _0x04AF;
//volatile EXTERN BIT_LIST_8              __io(0x04B0)    _0x04B0;
//volatile EXTERN BIT_LIST_8              __io(0x04B1)    _0x04B1;
//volatile EXTERN BIT_LIST_8              __io(0x04B2)    _0x04B2;
//volatile EXTERN BIT_LIST_8              __io(0x04B3)    _0x04B3;
//volatile EXTERN BIT_LIST_8              __io(0x04B4)    _0x04B4;
//volatile EXTERN BIT_LIST_8              __io(0x04B5)    _0x04B5;
//volatile EXTERN BIT_LIST_8              __io(0x04B6)    _0x04B6;
//volatile EXTERN BIT_LIST_8              __io(0x04B7)    _0x04B7;
//volatile EXTERN BIT_LIST_8              __io(0x04B8)    _0x04B8;
//volatile EXTERN BIT_LIST_8              __io(0x04B9)    _0x04B9;
//volatile EXTERN BIT_LIST_8              __io(0x04BA)    _0x04BA;
//volatile EXTERN BIT_LIST_8              __io(0x04BB)    _0x04BB;
//volatile EXTERN BIT_LIST_8              __io(0x04BC)    _0x04BC;
//volatile EXTERN BIT_LIST_8              __io(0x04BD)    _0x04BD;
//volatile EXTERN BIT_LIST_8              __io(0x04BE)    _0x04BE;
//volatile EXTERN BIT_LIST_8              __io(0x04BF)    _0x04BF;
//volatile EXTERN BIT_LIST_8              __io(0x04C0)    _0x04C0;
//volatile EXTERN BIT_LIST_8              __io(0x04C1)    _0x04C1;
//volatile EXTERN BIT_LIST_8              __io(0x04C2)    _0x04C2;
//volatile EXTERN BIT_LIST_8              __io(0x04C3)    _0x04C3;
//volatile EXTERN BIT_LIST_8              __io(0x04C4)    _0x04C4;
//volatile EXTERN BIT_LIST_8              __io(0x04C5)    _0x04C5;
//volatile EXTERN BIT_LIST_8              __io(0x04C6)    _0x04C6;
//volatile EXTERN BIT_LIST_8              __io(0x04C7)    _0x04C7;
//volatile EXTERN BIT_LIST_8              __io(0x04C8)    _0x04C8;
//volatile EXTERN BIT_LIST_8              __io(0x04C9)    _0x04C9;
//volatile EXTERN BIT_LIST_8              __io(0x04CA)    _0x04CA;
//volatile EXTERN BIT_LIST_8              __io(0x04CB)    _0x04CB;
//volatile EXTERN BIT_LIST_8              __io(0x04CC)    _0x04CC;
//volatile EXTERN BIT_LIST_8              __io(0x04CD)    _0x04CD;
//volatile EXTERN BIT_LIST_8              __io(0x04CE)    _0x04CE;
//volatile EXTERN BIT_LIST_8              __io(0x04CF)    _0x04CF;
//volatile EXTERN BIT_LIST_8              __io(0x04D0)    _0x04D0;
//volatile EXTERN BIT_LIST_8              __io(0x04D1)    _0x04D1;
//volatile EXTERN BIT_LIST_8              __io(0x04D2)    _0x04D2;
//volatile EXTERN BIT_LIST_8              __io(0x04D3)    _0x04D3;
//volatile EXTERN BIT_LIST_8              __io(0x04D4)    _0x04D4;
//volatile EXTERN BIT_LIST_8              __io(0x04D5)    _0x04D5;
//volatile EXTERN BIT_LIST_8              __io(0x04D6)    _0x04D6;
//volatile EXTERN BIT_LIST_8              __io(0x04D7)    _0x04D7;
//volatile EXTERN BIT_LIST_8              __io(0x04D8)    _0x04D8;
//volatile EXTERN BIT_LIST_8              __io(0x04D9)    _0x04D9;
//volatile EXTERN BIT_LIST_8              __io(0x04DA)    _0x04DA;
//volatile EXTERN BIT_LIST_8              __io(0x04DB)    _0x04DB;
//volatile EXTERN BIT_LIST_8              __io(0x04DC)    _0x04DC;
//volatile EXTERN BIT_LIST_8              __io(0x04DD)    _0x04DD;
//volatile EXTERN BIT_LIST_8              __io(0x04DE)    _0x04DE;
//volatile EXTERN BIT_LIST_8              __io(0x04DF)    _0x04DF;
//volatile EXTERN BIT_LIST_8              __io(0x04E0)    _0x04E0;
//volatile EXTERN BIT_LIST_8              __io(0x04E1)    _0x04E1;
//volatile EXTERN BIT_LIST_8              __io(0x04E2)    _0x04E2;
//volatile EXTERN BIT_LIST_8              __io(0x04E3)    _0x04E3;
//volatile EXTERN BIT_LIST_8              __io(0x04E4)    _0x04E4;
//volatile EXTERN BIT_LIST_8              __io(0x04E5)    _0x04E5;
//volatile EXTERN BIT_LIST_8              __io(0x04E6)    _0x04E6;
//volatile EXTERN BIT_LIST_8              __io(0x04E7)    _0x04E7;
//volatile EXTERN BIT_LIST_8              __io(0x04E8)    _0x04E8;
//volatile EXTERN BIT_LIST_8              __io(0x04E9)    _0x04E9;
//volatile EXTERN BIT_LIST_8              __io(0x04EA)    _0x04EA;
//volatile EXTERN BIT_LIST_8              __io(0x04EB)    _0x04EB;
//volatile EXTERN BIT_LIST_8              __io(0x04EC)    _0x04EC;
//volatile EXTERN BIT_LIST_8              __io(0x04ED)    _0x04ED;
//volatile EXTERN BIT_LIST_8              __io(0x04EE)    _0x04EE;
//volatile EXTERN BIT_LIST_8              __io(0x04EF)    _0x04EF;
//volatile EXTERN BIT_LIST_8              __io(0x04F0)    _0x04F0;
//volatile EXTERN BIT_LIST_8              __io(0x04F1)    _0x04F1;
//volatile EXTERN BIT_LIST_8              __io(0x04F2)    _0x04F2;
//volatile EXTERN BIT_LIST_8              __io(0x04F3)    _0x04F3;
//volatile EXTERN BIT_LIST_8              __io(0x04F4)    _0x04F4;
//volatile EXTERN BIT_LIST_8              __io(0x04F5)    _0x04F5;
//volatile EXTERN BIT_LIST_8              __io(0x04F6)    _0x04F6;
//volatile EXTERN BIT_LIST_8              __io(0x04F7)    _0x04F7;
//volatile EXTERN BIT_LIST_8              __io(0x04F8)    _0x04F8;
//volatile EXTERN BIT_LIST_8              __io(0x04F9)    _0x04F9;
//volatile EXTERN BIT_LIST_8              __io(0x04FA)    _0x04FA;
//volatile EXTERN BIT_LIST_8              __io(0x04FB)    _0x04FB;
//volatile EXTERN BIT_LIST_8              __io(0x04FC)    _0x04FC;
//volatile EXTERN BIT_LIST_8              __io(0x04FD)    _0x04FD;
//volatile EXTERN BIT_LIST_8              __io(0x04FE)    _0x04FE;
//volatile EXTERN BIT_LIST_8              __io(0x04FF)    _0x04FF;



//volatile EXTERN BIT_LIST_8              __io(0x0800)    _0x0800;
//volatile EXTERN BIT_LIST_8              __io(0x0801)    _0x0801;
//volatile EXTERN BIT_LIST_8              __io(0x0802)    _0x0802;
//volatile EXTERN BIT_LIST_8              __io(0x0803)    _0x0803;
//volatile EXTERN BIT_LIST_8              __io(0x0804)    _0x0804;
//volatile EXTERN BIT_LIST_8              __io(0x0805)    _0x0805;
//volatile EXTERN BIT_LIST_8              __io(0x0806)    _0x0806;
//volatile EXTERN BIT_LIST_8              __io(0x0807)    _0x0807;
//volatile EXTERN BIT_LIST_8              __io(0x0808)    _0x0808;
//volatile EXTERN BIT_LIST_8              __io(0x0809)    _0x0809;
//volatile EXTERN BIT_LIST_8              __io(0x080A)    _0x080A;
//volatile EXTERN BIT_LIST_8              __io(0x080B)    _0x080B;
//volatile EXTERN BIT_LIST_8              __io(0x080C)    _0x080C;
//volatile EXTERN BIT_LIST_8              __io(0x080D)    _0x080D;
//volatile EXTERN BIT_LIST_8              __io(0x080E)    _0x080E;
//volatile EXTERN BIT_LIST_8              __io(0x080F)    _0x080F;
//volatile EXTERN BIT_LIST_8              __io(0x0810)    _0x0810;
//volatile EXTERN BIT_LIST_8              __io(0x0811)    _0x0811;
//volatile EXTERN BIT_LIST_8              __io(0x0812)    _0x0812;
//volatile EXTERN BIT_LIST_8              __io(0x0813)    _0x0813;
//volatile EXTERN BIT_LIST_8              __io(0x0814)    _0x0814;
//volatile EXTERN BIT_LIST_8              __io(0x0815)    _0x0815;
//volatile EXTERN BIT_LIST_8              __io(0x0816)    _0x0816;
//volatile EXTERN BIT_LIST_8              __io(0x0817)    _0x0817;
//volatile EXTERN BIT_LIST_8              __io(0x0818)    _0x0818;
//volatile EXTERN BIT_LIST_8              __io(0x0819)    _0x0819;
//volatile EXTERN BIT_LIST_8              __io(0x081A)    _0x081A;
//volatile EXTERN BIT_LIST_8              __io(0x081B)    _0x081B;
//volatile EXTERN BIT_LIST_8              __io(0x081C)    _0x081C;
//volatile EXTERN BIT_LIST_8              __io(0x081D)    _0x081D;
//volatile EXTERN BIT_LIST_8              __io(0x081E)    _0x081E;
//volatile EXTERN BIT_LIST_8              __io(0x081F)    _0x081F;
//volatile EXTERN BIT_LIST_8              __io(0x0820)    _0x0820;
//volatile EXTERN BIT_LIST_8              __io(0x0821)    _0x0821;
//volatile EXTERN BIT_LIST_8              __io(0x0822)    _0x0822;
//volatile EXTERN BIT_LIST_8              __io(0x0823)    _0x0823;
//volatile EXTERN BIT_LIST_8              __io(0x0824)    _0x0824;
//volatile EXTERN BIT_LIST_8              __io(0x0825)    _0x0825;
//volatile EXTERN BIT_LIST_8              __io(0x0826)    _0x0826;
//volatile EXTERN BIT_LIST_8              __io(0x0827)    _0x0827;
//volatile EXTERN BIT_LIST_8              __io(0x0828)    _0x0828;
//volatile EXTERN BIT_LIST_8              __io(0x0829)    _0x0829;
//volatile EXTERN BIT_LIST_8              __io(0x082A)    _0x082A;
//volatile EXTERN BIT_LIST_8              __io(0x082B)    _0x082B;
//volatile EXTERN BIT_LIST_8              __io(0x082C)    _0x082C;
//volatile EXTERN BIT_LIST_8              __io(0x082D)    _0x082D;
//volatile EXTERN BIT_LIST_8              __io(0x082E)    _0x082E;
//volatile EXTERN BIT_LIST_8              __io(0x082F)    _0x082F;
//volatile EXTERN BIT_LIST_8              __io(0x0830)    _0x0830;
//volatile EXTERN BIT_LIST_8              __io(0x0831)    _0x0831;
//volatile EXTERN BIT_LIST_8              __io(0x0832)    _0x0832;
//volatile EXTERN BIT_LIST_8              __io(0x0833)    _0x0833;
//volatile EXTERN BIT_LIST_8              __io(0x0834)    _0x0834;
//volatile EXTERN BIT_LIST_8              __io(0x0835)    _0x0835;
//volatile EXTERN BIT_LIST_8              __io(0x0836)    _0x0836;
//volatile EXTERN BIT_LIST_8              __io(0x0837)    _0x0837;
//volatile EXTERN BIT_LIST_8              __io(0x0838)    _0x0838;
//volatile EXTERN BIT_LIST_8              __io(0x0839)    _0x0839;
//volatile EXTERN BIT_LIST_8              __io(0x083A)    _0x083A;
//volatile EXTERN BIT_LIST_8              __io(0x083B)    _0x083B;
//volatile EXTERN BIT_LIST_8              __io(0x083C)    _0x083C;
//volatile EXTERN BIT_LIST_8              __io(0x083D)    _0x083D;
//volatile EXTERN BIT_LIST_8              __io(0x083E)    _0x083E;
//volatile EXTERN BIT_LIST_8              __io(0x083F)    _0x083F;
//volatile EXTERN BIT_LIST_8              __io(0x0840)    _0x0840;
//volatile EXTERN BIT_LIST_8              __io(0x0841)    _0x0841;
//volatile EXTERN BIT_LIST_8              __io(0x0842)    _0x0842;
//volatile EXTERN BIT_LIST_8              __io(0x0843)    _0x0843;
//volatile EXTERN BIT_LIST_8              __io(0x0844)    _0x0844;
//volatile EXTERN BIT_LIST_8              __io(0x0845)    _0x0845;
//volatile EXTERN BIT_LIST_8              __io(0x0846)    _0x0846;
//volatile EXTERN BIT_LIST_8              __io(0x0847)    _0x0847;
//volatile EXTERN BIT_LIST_8              __io(0x0848)    _0x0848;
//volatile EXTERN BIT_LIST_8              __io(0x0849)    _0x0849;
//volatile EXTERN BIT_LIST_8              __io(0x084A)    _0x084A;
//volatile EXTERN BIT_LIST_8              __io(0x084B)    _0x084B;
//volatile EXTERN BIT_LIST_8              __io(0x084C)    _0x084C;
//volatile EXTERN BIT_LIST_8              __io(0x084D)    _0x084D;
//volatile EXTERN BIT_LIST_8              __io(0x084E)    _0x084E;
//volatile EXTERN BIT_LIST_8              __io(0x084F)    _0x084F;
volatile EXTERN BIT_LIST_8              __io(0x0850)    _0x0850;
volatile EXTERN BIT_LIST_8              __io(0x0851)    _0x0851;
//volatile EXTERN BIT_LIST_8              __io(0x0852)    _0x0852;
//volatile EXTERN BIT_LIST_8              __io(0x0853)    _0x0853;
//volatile EXTERN BIT_LIST_8              __io(0x0854)    _0x0854;
//volatile EXTERN BIT_LIST_8              __io(0x0855)    _0x0855;
//volatile EXTERN BIT_LIST_8              __io(0x0856)    _0x0856;
//volatile EXTERN BIT_LIST_8              __io(0x0857)    _0x0857;
volatile EXTERN BIT_LIST_8              __io(0x0858)    _0x0858;
//volatile EXTERN BIT_LIST_8              __io(0x0859)    _0x0859;
//volatile EXTERN BIT_LIST_8              __io(0x085A)    _0x085A;
//volatile EXTERN BIT_LIST_8              __io(0x085B)    _0x085B;
volatile EXTERN BIT_LIST_8              __io(0x085C)    _0x085C;
volatile EXTERN BIT_LIST_8              __io(0x085D)    _0x085D;
//volatile EXTERN BIT_LIST_8              __io(0x085E)    _0x085E;
//volatile EXTERN BIT_LIST_8              __io(0x085F)    _0x085F;
volatile EXTERN BIT_LIST_8              __io(0x0860)    _0x0860;
//volatile EXTERN BIT_LIST_8              __io(0x0861)    _0x0861;
volatile EXTERN BIT_LIST_8              __io(0x0862)    _0x0862;
volatile EXTERN BIT_LIST_8              __io(0x0863)    _0x0863;
volatile EXTERN BIT_LIST_8              __io(0x0864)    _0x0864;
volatile EXTERN BIT_LIST_8              __io(0x0865)    _0x0865;
volatile EXTERN BIT_LIST_8              __io(0x0866)    _0x0866;
volatile EXTERN BIT_LIST_8              __io(0x0867)    _0x0867;
//volatile EXTERN BIT_LIST_8              __io(0x0868)    _0x0868;
//volatile EXTERN BIT_LIST_8              __io(0x0869)    _0x0869;
//volatile EXTERN BIT_LIST_8              __io(0x086A)    _0x086A;
//volatile EXTERN BIT_LIST_8              __io(0x086B)    _0x086B;
//volatile EXTERN BIT_LIST_8              __io(0x086C)    _0x086C;
//volatile EXTERN BIT_LIST_8              __io(0x086D)    _0x086D;
//volatile EXTERN BIT_LIST_8              __io(0x086E)    _0x086E;
//volatile EXTERN BIT_LIST_8              __io(0x086F)    _0x086F;
volatile EXTERN BIT_LIST_8              __io(0x0870)    _0x0870;
volatile EXTERN BIT_LIST_8              __io(0x0871)    _0x0871;
//volatile EXTERN BIT_LIST_8              __io(0x0872)    _0x0872;
//volatile EXTERN BIT_LIST_8              __io(0x0873)    _0x0873;
volatile EXTERN BIT_LIST_8              __io(0x0874)    _0x0874;
volatile EXTERN BIT_LIST_8              __io(0x0875)    _0x0875;
volatile EXTERN BIT_LIST_8              __io(0x0876)    _0x0876;
volatile EXTERN BIT_LIST_8              __io(0x0877)    _0x0877;
volatile EXTERN BIT_LIST_8              __io(0x0878)    _0x0878;
volatile EXTERN BIT_LIST_8              __io(0x0879)    _0x0879;
volatile EXTERN BIT_LIST_8              __io(0x087A)    _0x087A;
volatile EXTERN BIT_LIST_8              __io(0x087B)    _0x087B;
volatile EXTERN BIT_LIST_8              __io(0x087C)    _0x087C;
volatile EXTERN BIT_LIST_8              __io(0x087D)    _0x087D;
volatile EXTERN BIT_LIST_8              __io(0x087E)    _0x087E;
volatile EXTERN BIT_LIST_8              __io(0x087F)    _0x087F;
volatile EXTERN BIT_LIST_8              __io(0x0880)    _0x0880;
//volatile EXTERN BIT_LIST_8              __io(0x0881)    _0x0881;
//volatile EXTERN BIT_LIST_8              __io(0x0882)    _0x0882;
//volatile EXTERN BIT_LIST_8              __io(0x0883)    _0x0883;
//volatile EXTERN BIT_LIST_8              __io(0x0884)    _0x0884;
//volatile EXTERN BIT_LIST_8              __io(0x0885)    _0x0885;
//volatile EXTERN BIT_LIST_8              __io(0x0886)    _0x0886;
//volatile EXTERN BIT_LIST_8              __io(0x0887)    _0x0887;
//volatile EXTERN BIT_LIST_8              __io(0x0888)    _0x0888;
//volatile EXTERN BIT_LIST_8              __io(0x0889)    _0x0889;
//volatile EXTERN BIT_LIST_8              __io(0x088A)    _0x088A;
//volatile EXTERN BIT_LIST_8              __io(0x088B)    _0x088B;
//volatile EXTERN BIT_LIST_8              __io(0x088C)    _0x088C;
//volatile EXTERN BIT_LIST_8              __io(0x088D)    _0x088D;
//volatile EXTERN BIT_LIST_8              __io(0x088E)    _0x088E;
//volatile EXTERN BIT_LIST_8              __io(0x088F)    _0x088F;
//volatile EXTERN BIT_LIST_8              __io(0x0890)    _0x0890;
//volatile EXTERN BIT_LIST_8              __io(0x0891)    _0x0891;
//volatile EXTERN BIT_LIST_8              __io(0x0892)    _0x0892;
//volatile EXTERN BIT_LIST_8              __io(0x0893)    _0x0893;
//volatile EXTERN BIT_LIST_8              __io(0x0894)    _0x0894;
//volatile EXTERN BIT_LIST_8              __io(0x0895)    _0x0895;
//volatile EXTERN BIT_LIST_8              __io(0x0896)    _0x0896;
//volatile EXTERN BIT_LIST_8              __io(0x0897)    _0x0897;
//volatile EXTERN BIT_LIST_8              __io(0x0898)    _0x0898;
//volatile EXTERN BIT_LIST_8              __io(0x0899)    _0x0899;
//volatile EXTERN BIT_LIST_8              __io(0x089A)    _0x089A;
//volatile EXTERN BIT_LIST_8              __io(0x089B)    _0x089B;
//volatile EXTERN BIT_LIST_8              __io(0x089C)    _0x089C;
//volatile EXTERN BIT_LIST_8              __io(0x089D)    _0x089D;
//volatile EXTERN BIT_LIST_8              __io(0x089E)    _0x089E;
//volatile EXTERN BIT_LIST_8              __io(0x089F)    _0x089F;
//volatile EXTERN BIT_LIST_8              __io(0x08A0)    _0x08A0;
//volatile EXTERN BIT_LIST_8              __io(0x08A1)    _0x08A1;
//volatile EXTERN BIT_LIST_8              __io(0x08A2)    _0x08A2;
//volatile EXTERN BIT_LIST_8              __io(0x08A3)    _0x08A3;
//volatile EXTERN BIT_LIST_8              __io(0x08A4)    _0x08A4;
//volatile EXTERN BIT_LIST_8              __io(0x08A5)    _0x08A5;
//volatile EXTERN BIT_LIST_8              __io(0x08A6)    _0x08A6;
//volatile EXTERN BIT_LIST_8              __io(0x08A7)    _0x08A7;
//volatile EXTERN BIT_LIST_8              __io(0x08A8)    _0x08A8;
//volatile EXTERN BIT_LIST_8              __io(0x08A9)    _0x08A9;
//volatile EXTERN BIT_LIST_8              __io(0x08AA)    _0x08AA;
//volatile EXTERN BIT_LIST_8              __io(0x08AB)    _0x08AB;
//volatile EXTERN BIT_LIST_8              __io(0x08AC)    _0x08AC;
//volatile EXTERN BIT_LIST_8              __io(0x08AD)    _0x08AD;
//volatile EXTERN BIT_LIST_8              __io(0x08AE)    _0x08AE;
//volatile EXTERN BIT_LIST_8              __io(0x08AF)    _0x08AF;
//volatile EXTERN BIT_LIST_8              __io(0x08B0)    _0x08B0;
//volatile EXTERN BIT_LIST_8              __io(0x08B1)    _0x08B1;
//volatile EXTERN BIT_LIST_8              __io(0x08B2)    _0x08B2;
//volatile EXTERN BIT_LIST_8              __io(0x08B3)    _0x08B3;
//volatile EXTERN BIT_LIST_8              __io(0x08B4)    _0x08B4;
//volatile EXTERN BIT_LIST_8              __io(0x08B5)    _0x08B5;
//volatile EXTERN BIT_LIST_8              __io(0x08B6)    _0x08B6;
//volatile EXTERN BIT_LIST_8              __io(0x08B7)    _0x08B7;
//volatile EXTERN BIT_LIST_8              __io(0x08B8)    _0x08B8;
//volatile EXTERN BIT_LIST_8              __io(0x08B9)    _0x08B9;
//volatile EXTERN BIT_LIST_8              __io(0x08BA)    _0x08BA;
//volatile EXTERN BIT_LIST_8              __io(0x08BB)    _0x08BB;
//volatile EXTERN BIT_LIST_8              __io(0x08BC)    _0x08BC;
//volatile EXTERN BIT_LIST_8              __io(0x08BD)    _0x08BD;
//volatile EXTERN BIT_LIST_8              __io(0x08BE)    _0x08BE;
//volatile EXTERN BIT_LIST_8              __io(0x08BF)    _0x08BF;
//volatile EXTERN BIT_LIST_8              __io(0x08C0)    _0x08C0;
//volatile EXTERN BIT_LIST_8              __io(0x08C1)    _0x08C1;
//volatile EXTERN BIT_LIST_8              __io(0x08C2)    _0x08C2;
//volatile EXTERN BIT_LIST_8              __io(0x08C3)    _0x08C3;
//volatile EXTERN BIT_LIST_8              __io(0x08C4)    _0x08C4;
//volatile EXTERN BIT_LIST_8              __io(0x08C5)    _0x08C5;
//volatile EXTERN BIT_LIST_8              __io(0x08C6)    _0x08C6;
//volatile EXTERN BIT_LIST_8              __io(0x08C7)    _0x08C7;
//volatile EXTERN BIT_LIST_8              __io(0x08C8)    _0x08C8;
//volatile EXTERN BIT_LIST_8              __io(0x08C9)    _0x08C9;
//volatile EXTERN BIT_LIST_8              __io(0x08CA)    _0x08CA;
//volatile EXTERN BIT_LIST_8              __io(0x08CB)    _0x08CB;
//volatile EXTERN BIT_LIST_8              __io(0x08CC)    _0x08CC;
//volatile EXTERN BIT_LIST_8              __io(0x08CD)    _0x08CD;
//volatile EXTERN BIT_LIST_8              __io(0x08CE)    _0x08CE;
//volatile EXTERN BIT_LIST_8              __io(0x08CF)    _0x08CF;
//volatile EXTERN BIT_LIST_8              __io(0x08D0)    _0x08D0;
//volatile EXTERN BIT_LIST_8              __io(0x08D1)    _0x08D1;
//volatile EXTERN BIT_LIST_8              __io(0x08D2)    _0x08D2;
//volatile EXTERN BIT_LIST_8              __io(0x08D3)    _0x08D3;
//volatile EXTERN BIT_LIST_8              __io(0x08D4)    _0x08D4;
//volatile EXTERN BIT_LIST_8              __io(0x08D5)    _0x08D5;
//volatile EXTERN BIT_LIST_8              __io(0x08D6)    _0x08D6;
//volatile EXTERN BIT_LIST_8              __io(0x08D7)    _0x08D7;
//volatile EXTERN BIT_LIST_8              __io(0x08D8)    _0x08D8;
//volatile EXTERN BIT_LIST_8              __io(0x08D9)    _0x08D9;
//volatile EXTERN BIT_LIST_8              __io(0x08DA)    _0x08DA;
//volatile EXTERN BIT_LIST_8              __io(0x08DB)    _0x08DB;
//volatile EXTERN BIT_LIST_8              __io(0x08DC)    _0x08DC;
//volatile EXTERN BIT_LIST_8              __io(0x08DD)    _0x08DD;
//volatile EXTERN BIT_LIST_8              __io(0x08DE)    _0x08DE;
//volatile EXTERN BIT_LIST_8              __io(0x08DF)    _0x08DF;
//volatile EXTERN BIT_LIST_8              __io(0x08E0)    _0x08E0;
//volatile EXTERN BIT_LIST_8              __io(0x08E1)    _0x08E1;
//volatile EXTERN BIT_LIST_8              __io(0x08E2)    _0x08E2;
//volatile EXTERN BIT_LIST_8              __io(0x08E3)    _0x08E3;
//volatile EXTERN BIT_LIST_8              __io(0x08E4)    _0x08E4;
//volatile EXTERN BIT_LIST_8              __io(0x08E5)    _0x08E5;
//volatile EXTERN BIT_LIST_8              __io(0x08E6)    _0x08E6;
//volatile EXTERN BIT_LIST_8              __io(0x08E7)    _0x08E7;
//volatile EXTERN BIT_LIST_8              __io(0x08E8)    _0x08E8;
//volatile EXTERN BIT_LIST_8              __io(0x08E9)    _0x08E9;
//volatile EXTERN BIT_LIST_8              __io(0x08EA)    _0x08EA;
//volatile EXTERN BIT_LIST_8              __io(0x08EB)    _0x08EB;
//volatile EXTERN BIT_LIST_8              __io(0x08EC)    _0x08EC;
//volatile EXTERN BIT_LIST_8              __io(0x08ED)    _0x08ED;
//volatile EXTERN BIT_LIST_8              __io(0x08EE)    _0x08EE;
//volatile EXTERN BIT_LIST_8              __io(0x08EF)    _0x08EF;
//volatile EXTERN BIT_LIST_8              __io(0x08F0)    _0x08F0;
//volatile EXTERN BIT_LIST_8              __io(0x08F1)    _0x08F1;
//volatile EXTERN BIT_LIST_8              __io(0x08F2)    _0x08F2;
//volatile EXTERN BIT_LIST_8              __io(0x08F3)    _0x08F3;
//volatile EXTERN BIT_LIST_8              __io(0x08F4)    _0x08F4;
//volatile EXTERN BIT_LIST_8              __io(0x08F5)    _0x08F5;
//volatile EXTERN BIT_LIST_8              __io(0x08F6)    _0x08F6;
//volatile EXTERN BIT_LIST_8              __io(0x08F7)    _0x08F7;
//volatile EXTERN BIT_LIST_8              __io(0x08F8)    _0x08F8;
//volatile EXTERN BIT_LIST_8              __io(0x08F9)    _0x08F9;
//volatile EXTERN BIT_LIST_8              __io(0x08FA)    _0x08FA;
//volatile EXTERN BIT_LIST_8              __io(0x08FB)    _0x08FB;
//volatile EXTERN BIT_LIST_8              __io(0x08FC)    _0x08FC;
//volatile EXTERN BIT_LIST_8              __io(0x08FD)    _0x08FD;
//volatile EXTERN BIT_LIST_8              __io(0x08FE)    _0x08FE;
//volatile EXTERN BIT_LIST_8              __io(0x08FF)    _0x08FF;    

//****************************************************
//  end of --> declare the image address of the special function register ************
//****************************************************
#endif

