//*************************************************************************************
// file 		: SQ7617_I2C1.h
// version		: V1.1 2020/09/03
// brief		: I2C1 header file
// note			:  
//**************************************************************************************
#ifndef _SQ7617_I2C1_H__
#define _SQ7617_I2C1_H__
/* ---------------------- extern global variables ------------------------- */



/* ---------------------- user-defined macros ------------------------------ */
#define I2C_1 0x01

#define enable         (1)
#define disable        (0)

// PxFC1,PxFC2 configuration
// SDA1 (P0.0) ; SCL1 (P0.2)
#define P0FC_P0_SDA1   P0FC1_P0 = 1; P0FC2_P0 = 0;
#define P0FC_P2_SCL1   P0FC1_P2 = 1; P0FC2_P2 = 0;

// SDA1 (P2.1) ; SCL1 (P2.2)
#define P2FC_P1_SDA1   P2FC1_P1 = 1; P2FC2_P1 = 0;
#define P2FC_P2_SCL1   P2FC1_P2 = 1; P2FC2_P2 = 0;

// SDA1 (P4.6) ; SCL1 (P4.7)
#define P4FC_P6_SDA1   P4FC1_P6 = 1; P4FC2_P6 = 0;
#define P4FC_P7_SCL1   P4FC1_P7 = 1; P4FC2_P7 = 0;


#define i2c1BusFree    (0)
#define i2c1BusBusy    (1)
#define directionW     (0x00)
#define directionR     (0x01)

//bufcount : number of data bits
#define BC_8bit        0x00
#define BC_1bit        0x01
#define BC_2bit        0x02
#define BC_3bit        0x03
#define BC_4bit        0x04
#define BC_5bit        0x05
#define BC_6bit        0x06
#define BC_7bit        0x07

// SYSCLK@24MHZ							fscl          
#define SCK_HI_9_LO_12			0x00	//1143 kHz	;
#define SCK_HI_11_LO_14			0x01	// 960 kHz	;
#define SCK_HI_15_LO_18			0x02	// 727 kHz	;
#define SCK_HI_23_LO_26			0x03	// 490 kHz	;
#define SCK_HI_39_LO_42			0x04	// 296 kHz	;
#define SCK_HI_71_LO_74			0x05	// 166 kHz	;
#define SCK_HI_135_LO_138		0x06	//  88 kHz	;
#define SCK_HI_263_LO_266		0x07	//  45 kHz	;

#define waitCountMax            250     // maximum waiting counting value

#define initBusLowErr           0xE0    // if one of SDA or SCL is not H level, 
                                        // its error code is 0xE0
										
#define nackTimeoutErr          0xE1    // if there is no response, 
                                        // its error code is 0xE1


//----------------------------------------------------------------
void  I2C1_SetSlaveAddr(uchar addr);						// set slave address
void  I2C1_Init();											// I2C1 initialization
void  I2C1_Int(uchar config);                               // enable / disable I2C1 interrupt

uchar I2C1_Start(uchar deviceId, uchar addr);	            // I2C1 generate the start condition
void  I2C1_Confirm_Tx_Completed();                          // wait for tranfer completion
uchar I2C1_Wait_Slave_ACK();                                // wait for Slave return ACK
void  I2C1_SetSlaveAddr_Direction(uchar deviceId, uchar i2cDirection); // set slave device address and direction

uchar I2C1_ReStart(uchar deviceId);						    // I2C1 generate the restart condition
void  I2C1_Stop();											// I2C1 generate the stop condition
uchar I2C1_Bytes_Write(uchar *data, uchar len);	            // I2C1 transmits data
uchar I2C1_Bytes_Read(uchar *data, uchar len);	            // I2C1 receives data
void  I2C1_Reset();                                         // software reset I2C1

void  __interrupt IntI2C1(void);							// I2C1 interrupt service routine
void  I2C1_Error_Handling();                                // error handling

#endif


