//*************************************************************************************
// file			: SQ7617_Delay_Loop.c
// version		: V1.0 2020/09/03
// brief		: SQ7617_Delay_Loop related functions
// 
// note			: 1. SQ7617_Delay_Loop related functions are collected in this subroutine
//				  2. delay_ms() is only applicable when the system clock source is PLL and the system main frequency is 24MHz, 12MHz and 6MHz
//            	  3. delay_100us() is only applicable when the system clock source is PLL and the system main frequency is 24MHz
//				  4. there is an error because the while loop used to delay the loop, for precise delay application, please use timer for delay function
//**************************************************************************************
#include "main.h"

volatile  unsigned int  Delay_base_ms;
volatile  unsigned int  Delay_base_100us;

//*********************************************************************
// name			: Delay_Loop_Init()
// brief		: initialize the delay loop
// param		: none
// شֵ	: none
//
// note			: the number of times required to switch the minimum unit of the Delay Loop function based on the system frequency
//*********************************************************************
void Delay_Loop_Init(){

   /* Tips:
       // this function example is only applicable to the system clock source for PLL and the system main frequency is 24MHz, 12MHz and 6MHz
       // otherwise you must add or adjust in Delay_Loop_Init() by yourself
    */
   
	if(CLKCR0_SCKSRC != PLL){
	return;
	
	}

	switch(CLKCR0_SCKPSC){
	    case PLL_24M:							// when system frequecy is PLL 24 MHz
        Delay_base_ms = f24m_1ms_t;
		Delay_base_100us = f24m_100us_t;
        break;
			
        case PLL_12M:							// when system frequecy is PLL 12 MHz
        Delay_base_ms = f12m_1ms_t;
	
        break;
			
        case PLL_6M:							// when system frequecy is PLL 6 MHz
		Delay_base_ms = f06m_1ms_t;
		
	    break;	
			
     	default:
      	Delay_base_ms = f24m_1ms_t;
		Delay_base_100us = f24m_100us_t;
     	break;
      }

}


//*********************************************************************
// name			: delay_ms()
// function		: delay function in unit of ms
// input 		: x is a multiplier, x > 0
// retval		: none
//
// note			: it is only applicable when the system clock source is PLL and the system main frequency is 24MHz, 12MHz and 6MHz
//				  for example,
//				  delay_ms(1);     		    // delay 1 ms
//				  delay_ms(30);     		// delay 30 ms
//				  delay_ms(500);     		// delay 500 ms
//*********************************************************************
void delay_ms(uint x){

volatile uint  i = 0;	

if(!x) return;
	
	for(; x>0; x--){
    	for(i=0; i< Delay_base_ms; i++){
		__asm("NOP");
	    CLR_WDT;                        // clear the watchdog timer 		
		}
	CLR_WDT;                            // clear the watchdog timer 
	}


}



//*********************************************************************
// name			: delay_100us()
// function		: delay function in unit of 100 us
// param		: y is a multiplier, y > 0, y is suggested to be 1 to 10
// retval		: none
//
// note			: it is only applicable when the system clock source is PLL and the system main frequency is 24MHz
//				  there is an error because the while loop used to delay the loop, for precise delay application, please use timer for delay function
//				  for example,
//				  delay_100us(1);     		// delay 100 us = 0.1 ms
//				  delay_100us(10);     		// delay 1000 us = 1 ms
//*********************************************************************
void delay_100us(uint y){

volatile uint  i = 0;	 

if(!y) return;

	for(; y>0; y--){

    	for(i=0; i< Delay_base_100us; i++){
		__asm("NOP");
	    CLR_WDT;                        // clear the watchdog timer 		
		}
	CLR_WDT;                            // clear the watchdog timer 
	}


}

