//SQ7617_DIC example
//*************************************************************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// description	: using DIC to calculate the CRC of SRAM, flash memory and  ROM
//
//			  press button 1 : using DIC to calculate the CRC of SRAM and then compare the result. light on LED1 when the 2 results are the same
//			  press button 2 : using DIC to calculate the CRC of flash memory and then compare the result. light on LED2 when the 2 results are the same
//			  press button 3 : using DIC to calculate the CRC of ROM and then compare the result. light on LED2 when the 2 results are the same
//
//			  *when the button is released, the LED will turn off and wait for next press
//			  *if the compared result is not the same, LED will not light on
//
// note			: 
//				 [Button Configuration] 
//                button 1 : BTN1_in(P3.0)
//				  button 2 : BTN2_in(P3.1)
//				  button 3 : BTN3_in(P3.7)
// 
//				  [LED Configuration] LED 1  (P2.0)
//				  [LED Configuration] LED 2  (P2.1)
//				  [LED Configuration] LED 3  (P2.2)
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */


/* ----------------------- main program --------------------------- */
void main()
{		
    unsigned char temp,i;
/* ---------------------- system initialization ------------------------ */
	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                        	  // set P2.0, P2.1 and P2.2 as output pins
    P3OE  = 0x7C;                        	  // set P3.0, P3.1 and P3.7 as input pins
	P3PU |= 0x83;                       	  // enable P3.0, P3.1 and P3.7 built-in pull-up resistors
	LED1_out = 1;							  // set LED1 to the light off
	LED2_out = 1;							  // set LED2 to the light off
	LED3_out = 1;							  // set LED3 to the light off		
/* ---------------------- CRC initialization ------------------------ */
	PCKEN7_CRC = 1;							  // CRC initialization
//---------------------------------------------------------------------------
	while(1)
	{
      if((P3DI & 0x83) != 0x83){   			  // determine if any of the buttons 1~3 are pressed 
		if(BTN1_in == 0){					  // press button 1 : BTN2_in(P3.0)
            DIC_Setup();                	  // setup DIC
			
			// initialize DIC
            DIC_Init((unsigned char *) in_addr_sram, 0x0800);
 
            while(DIC_Done() == 0)      	  // wait for DIC to complete
            {
                __ASM("NOP");				  // no operation
            }
		    DIC_Get_result(dic_crc);		  // get DIC result
			//---------------------------------------------------------
			
			// initialize DIC
            DIC_Init((unsigned char *) in_addr_sram, 0x0800);
  
            while(DIC_Done() == 0)      	  // wait for DIC to complete
            {
                __ASM("NOP");				  // no operation
            }
		    DIC_Get_result(dic_crc_check);	  // get DIC result
			//---------------------------------------------------------
 
            dic_result = Cmp_CRC(dic_crc, dic_crc_check);  // compare 2 CRC results                                     
            //DIC_Disable();              	  // disable DIC
			
            if(dic_result != 0)         	  // if 2 CRC results are not the same
            {                         			                            
                __ASM("NOP");				  // no operation
            }
			else{
				LED1_out = 0;		    	  // if 2 CRC results are the same, light on LED 1		
			}
	
		}
		//------------------------------------------------------------------------------------------------------------------
		else if(BTN2_in == 0){				  // press button 2 : BTN2_in(P3.1)
			
            DIC_Setup();                	  // setup DIC
			
			// initialize DIC
    		DIC_Init((unsigned char *) in_addr_flash, 0x1000); 
  
            while(DIC_Done() == 0)       	  // wait for DIC to complete
            {
                __ASM("NOP");				  // no operation
            }
		    DIC_Get_result(dic_crc);	      // get DIC result
			//---------------------------------------------------------
			
			// initialize DIC
     		DIC_Init((unsigned char *) in_addr_flash, 0x1000); 

            while(DIC_Done() == 0)       	  // wait for DIC to complete
            {
                __ASM("NOP");				  // no operation
            }
		    DIC_Get_result(dic_crc_check);	  // get DIC result
			//---------------------------------------------------------
            dic_result = Cmp_CRC(dic_crc, dic_crc_check);  // compare 2 CRC results 
            //DIC_Disable();               	  // disable DIC
			
            if(dic_result != 0)
            {                            	  // if 2 CRC results are not the same			                            
				__ASM("NOP"); 				  // no operation
            }		
			else{
                LED2_out = 0;            	  // if 2 CRC results are the same, light on LED 2	
			}
		
		}
		//------------------------------------------------------------------------------------------------------------------
		else if(BTN3_in == 0){				  // press button 3 : BTN3_in(P3.7)                                       
  
            DIC_Setup();                	  // setup DIC
			
			// initialize DIC
    		DIC_Init((unsigned char *) in_addr_rom, 0x1000);  
 
            while(DIC_Done() == 0)      	  // wait for DIC to complete
            { 
                __ASM("NOP");				  // no operation
            }
		    DIC_Get_result(dic_crc);	      // get DIC result
			//---------------------------------------------------------
			
			// initialize DIC
    		DIC_Init((unsigned char *) in_addr_rom, 0x1000);  
  
            while(DIC_Done() == 0)      	  // wait for DIC to complete 
            {
                __ASM("NOP");				  // no operation
            }
            DIC_Get_result(dic_crc_check);	  // get DIC result	
			//---------------------------------------------------------
            dic_result = Cmp_CRC(dic_crc, dic_crc_check);  // compare 2 CRC results 		
            //DIC_Disable();              	  // disable DIC
			
            if(dic_result != 0){        	  // if 2 CRC results are not the same		                            
				__ASM("NOP"); 				  // no operation
             }
            else{			
                LED3_out = 0;           	  // if 2 CRC results are the same, light on LED 3
            }				
		
		}
		//--------------------------------------------------------------------------------------------
		while((P3DI & 0x83) != 0x83);   	  // wait for button released
		
        LED1_out = 1;                   	  // let LEDs 1~3 all lights off
        LED2_out = 1;
        LED3_out = 1; 		
	  } 
	}	
	
}



/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)               // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7617 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//***I2C0 interrupt reserved for internal EEPROM use only***									
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7617 interrupt vector ---------------------- */

