//*************************************************************************************
// file			: SQ7615_PLL_System_Init.h
// version		: V3.1
// brief		: PLL_System_Init header file
// note			: 
//**************************************************************************************

#ifndef _SQ7615_PLL_System_Init_H__
#define _SQ7615_PLL_System_Init_H__

/* ---------------------- extern global variables ------------------------- */





/* ---------------------- user-defined macros ------------------------------ */
#define PLL_24M    	0x01	// system frequency divided by 2    (48M/2	= 24MHz) 
#define	PLL_12M  	0x02	// system frequency divided by 4    (48M/4	= 12MHz) 
#define PLL_6M  	0x03	// system frequency divided by 8    (48M/8	= 6MHz) 
#define PLL_3M    	0x04	// system frequency divided by 16   (48M/16	= 3MHz) 
#define PLL_1_5M    0x05	// system frequency divided by 32   (48M/32	= 1.5MHz = 1500kHz)

#define PLL_750K    0x06	// system frequency divided by 64   (48M/64	= 750kHz) 
#define PLL_375K    0x07	// system frequency divided by 128  (48M/128 = 375kHz) 

//------------------------------------------------------------------
void PLL_System_Init(unsigned char F_div_sel);		// PLL initialization
void PLL_Freq_Division(unsigned char F_div_sel);	// PLL frequency division selection


#endif


