//*************************************************************************************
// file			: SQ7615_PLL_System_Init.c
// version		: V3.1
// brief		: PLL_System_Init related functions
// note			: PLL_System_Init related functions are collected in this subroutine
//**************************************************************************************

#include "main.h"

//*********************************************************************
// name			: PLL_System_Init()
// brief		: PLL initialization
// note			: 
// F_div_sel: PLL_24M	system frequency divided by 2  (48M/2  = 24MHz)
//            PLL_12M	system frequency divided by 4  (48M/4  = 12MHz)
//			  PLL_6M	system frequency divided by 8  (48M/8  = 6MHz)
//			  PLL_3M    system frequency divided by 16 (48M/16 = 3MHz)
//			  PLL_1_5M  system frequency divided by 32 (48M/32 = 1.5MHz = 1500KHz)
//			  PLL_750K  system frequency divided by 64 (48M/64 = 750kHz)
//			  PLL_375K  system frequency divided by 128(48M/128= 375kMHz)
//
// example		: to use PLL 24MHz as the system clock source, the function is used as shown below
//			  	  PLL_System_Init(PLL_24M);		  // (48M/2=24MHz) 
//*********************************************************************
void PLL_System_Init(unsigned char F_div_sel){

	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	PLL_Freq_Division(F_div_sel);			  // PLL frequency division selection
    
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
}


//*********************************************************************
// name			: PLL_Freq_Division()
// brief		: PLL frequency division selection
// note			: 
//*********************************************************************
void PLL_Freq_Division(unsigned char F_div_sel){


	CLKCR0_SCKPSC = F_div_sel;                // set system clock frequency division
  

}

