//*************************************************************************************
// file			: SQ7615_HIRC_System_Init.c
// version		: V3.1
// brief		: HIRC_System_Init related functions
// note			: HIRC_System_Init related functions are collected in this subroutine
//**************************************************************************************

#include "main.h"

//*********************************************************************
// name			: HIRC_System_Init()
// brief		: HIRC initialization
// note			: 
// F_div_sel: HIRC_16M	 system frequency divided by 1  (16M/1  = 16MHz)
//            HIRC_8M	 system frequency divided by 2  (16M/2  = 8MHz)
//			  HIRC_4M	 system frequency divided by 4  (16M/4  = 4MHz)
//			  HIRC_2M    system frequency divided by 8  (16M/8  = 2MHz)
//			  HIRC_1M    system frequency divided by 16 (16M/16 = 1MHz)
//			  HIRC_500K  system frequency divided by 32 (16M/32 = 0.5MHz = 500KHz)
//			  HIRC_250K  system frequency divided by 64 (16M/64 = 0.25MHz = 250KHz)
//			  HIRC_62_5K system frequency divided by 128(16M/128= 0.0625MHz = 62.5KHz)
//
// example		: to use HIRC 8MHz as the system clock source, the function is used as shown below
//			  HIRC_System_Init(HIRC_8M);	  // (16M/2=8MHz) 
//*********************************************************************
void HIRC_System_Init(unsigned char F_div_sel){

	CLKCR1_HIRCEN  = 1;                       // enable HIRC
	while(CLKCR1_HIRCRDY ==0);				  // wait for HIRC to be ready
	CLKCR0_SCKSRC = 0;                        // switch system clock source to HIRC
	HIRC_Freq_Division(F_div_sel);			  // HIRC frequency division selection
    
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
}


//*********************************************************************
// name			: HIRC_Freq_Division()
// brief		: HIRC frequency division selection
// note			: 
//*********************************************************************
void HIRC_Freq_Division(unsigned char F_div_sel){


	CLKCR0_SCKPSC = F_div_sel;                // set system clock frequency division
  

}

