//*************************************************************************************
// file			: SQ7615_SIO.h
// version		: V3.2
// brief		: SIO header file
// note			: 
//**************************************************************************************
#ifndef _SQ7615_SIO_H__
#define _SQ7615_SIO_H__

/* ---------------------- extern global variables ------------------------- */




/* ---------------------- user-defined macros ------------------------------ */
#define SIO_0  0
#define SIO_1  1

#define SIO_CKS_DIV512   0x00
#define SIO_CKS_DIV64    0x01
#define SIO_CKS_DIV32    0x02
#define SIO_CKS_DIV16    0x03
#define SIO_CKS_DIV8     0x04
#define SIO_CKS_DIV4     0x05
#define SIO_CKS_DIV2     0x06
#define SIO_CKS_EXT      0x07

//------------------------------------------------------------------
void SIO0_Init();											// SIO0 initialization
void SIO1_Init();											// SIO1 initialization
void SIO_Start(unsigned char sio);							// start SIO
void SIO_Stop(unsigned char sio);							// stop SIO0
void SIO_IntEnable(unsigned char sio);						// enable SIO interrupt
void SIO_ByteSend(unsigned char sio, unsigned char txdata);	// SO transmits data
unsigned char SIO_ByteRead(unsigned char sio);				// SI receives data
void SIO_ReservedStopWait(unsigned char sio);				// wait for SIO stop

void __interrupt IntSIO0(void);								// SIO0 interrupt service routine
void __interrupt IntSIO1(void);								// SIO1 interrupt service routine

#endif



