//SQ7615_SIO_Master_For_SPI_Flash_IS25LP080D example
//*************************************************************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// description	: this program is SIO demostration for SQ7615 chip as Master and SPI Flash IS25LP080D as Slave
//			  you can use the IDE to set breakpoints to observe Sector Erase, Data Write and Data Read commands
// reminder		: make sure the VDD of MQ-Link is 3.3V
//            * make sure the VDD of MQ-Link is 3.3V
//
// set transfer format to MSB first,set transfer mode to 8-bit transmit and receive mode,CPOL = 1, CPHA=1
// note			: 1. set SIO1 as Master
//			         set P0.2 to SCLK1
//		             set P0.0 to SI1
//					 set P0.1 to SO1
// 
//			  2. SCLK1(P0.2) connects to IS25LP080D SCK0 ;    SCK
//				 SI1(P0.0) connects to IS25LP080D SO   ;    MISO
//				 SO1(P0.1) connects to IS25LP080D SI   ;    MOSI
//				 P4.3 connects to IS25LP080D CE#  ;    /CS, Chip EN
//
//			  3. 
//				  [LED Configuration] LED 1  (P2.0) read ManufacturerID & DeviceID to correctly identify the lamp number
//				  [LED Configuration] LED 2  (P2.1) LED2 flashes when Sector Erase ends
//				  [LED Configuration] LED 3  (P2.2) LED3 flashes when Page Program ends
//
//            4.  the last procedure will compare the correct value of the readout with the LED light on or light off, 
//                if all data is read correctly, light on LED1, LED2 and LED3
//                if any data is not read correctly, light off LED1, LED2 and LED3
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */

unsigned char m_rx;
unsigned char Read_Data[16];
unsigned char Send_Data[4];

unsigned char i,j;
unsigned char ManufacturerID_DATA = 0,DeviceID_DATA = 0;
/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */
	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                        	  // set P2.0, P2.1 and P2.2 as output pins
	P4OE_P3 = 1;							  // set P4.3 as output pin
	P4DO_P3 = 1;							  // set P4.3 to output high
    
	LED1_out = 1;							  // set LED1 to the light off
	LED2_out = 1;							  // set LED2 to the light off
	LED3_out = 1;							  // set LED3 to the light off
/* ---------------------- SIO1 initialization ------------------------ */	
    SIO1_Init();                        	  // initialize SIO1 to SIO Master
	for(i=0;i<250;i++);                       // Delay loop
	
	
 //	read Manufacturer ID and Device ID through command 0x90 and check them --------------------------------------------
    P4DO_P3 = 0;                              // CS PIN Enable (low level)
	for(i=0;i<50;i++);
	SIO_ByteSend(SIO_1,0x90);                 // master transmits command 0x90
	SIO_ByteSend(SIO_1,0x00);                 // 3 Dummy Bytes
	SIO_ByteSend(SIO_1,0x00);                  
	SIO_ByteSend(SIO_1,0x00);
	for(i=0;i<10;i++);						  // Delay loop
	
	ManufacturerID_DATA = SIO_ByteRead(SIO_1);// get Manufacturer ID
	DeviceID_DATA = SIO_ByteRead(SIO_1);      // get Device ID
	
    P4DO_P3 = 1;	                          // CS PIN Disable (high level)
	
	// ManufacturerID_DATA is expected to be 0x9D and DeviceID_DATA is 0x13
	// if the result is correct, then light on LED1; if not, the LED1 remains off
	if(ManufacturerID_DATA == 0x9D && DeviceID_DATA == 0x13 ){                      
		LED1_out = 0;                         // correct, light on LED1
	}
	else{
		LED1_out = 1;                         // wrong, light off LED1
	}
    
    __asm("NOP");	                          // **no operation, the breakpoint is located here**

 // *** before executing Sector Erase, the Write Enable command must be executed first *** //
 //	Write Enable command is 0x06 ------------------------------------------------
 	P4DO_P3 = 0;                              // CS PIN Enable (low level)
 	SIO_ByteSend(SIO_1,0x06);                 // master transmits command 0x06
    P4DO_P3 = 1;	                          // CS PIN Disable (high level)  
	
	for(i=0;i<250;i++);
    
 //	Sector Erase command is 0x20 ----------------------------------------
    
	P4DO_P3 = 0;                              // CS PIN Enable (low level)
	SIO_ByteSend(SIO_1,0x20);                 // master transmits command 0x20
	
    // Sector Erase [Sector 48] start address is 030000h
	SIO_ByteSend(SIO_1,0x03);                 // ADDR msb   A23 ~A16
	SIO_ByteSend(SIO_1,0x00);                 // ADDR       A15 ~A8 
	SIO_ByteSend(SIO_1,0x00);	              // ADDR lsb   A7  ~A0
	P4DO_P3 = 1;                              // CS PIN Disable (high level)
    for(i=0;i<250;i++);
	for(i=0;i<250;i++);
    IS25LP_WaitBusy();
    // Sector Erase Time (4K-bytes) wait>300 ms
    // Delay loop
	for(i=0;i<250;i++);                       // Delay loop
    for(i=0;i<250;i++);                       // Delay loop
    for(i=0;i<250;i++);                       // Delay loop
	
	LED2_out = 0;                             // light on LED2
	for(i=0;i<255;i++){                       // Delay loop
	   for(j=0;j<255;j++){
	   }
	}
	LED2_out = 1;                             // light off LED2
	
	__asm("NOP");	                          // **no operation, the breakpoint is located here**
 // -------------------------------------------------------------------------------
 //	Read Data command is 0x03 ------------------------------------------------
 // make sure all values of data are 0xFF
 
    P4DO_P3 = 0;                              // CS PIN Enable (low level)
	SIO_ByteSend(SIO_1,0x03);                 // master transmits command 0x03
	// [Sector 48] start address is 030000h
	SIO_ByteSend(SIO_1,0x03);                 // ADDR msb   A23 ~A16
	SIO_ByteSend(SIO_1,0x00);                 // ADDR       A15 ~A8
	SIO_ByteSend(SIO_1,0x00);                 // ADDR lsb   A7  ~A0
	

	for(i=0;i<16;i++){
	Read_Data[i] = SIO_ByteRead(SIO_1);	      // SIO1 receives data
	
	}

    P4DO_P3 = 1;                              // CS PIN Disable (high level)
	
    __asm("NOP");	                          // **no operation, the breakpoint is located here**
	

 // *** before executing Page Program, the Write Enable command must be executed first *** //
 //	Write Enable command is 0x06 ------------------------------------------------  
 	P4DO_P3 = 0;                              // CS PIN Enable (low level)
 	SIO_ByteSend(SIO_1,0x06);                 // master transmits command 0x06
    P4DO_P3 = 1;	                          // CS PIN Disable (high level) 
 
	for(i=0;i<250;i++);                       // Delay loop
    
 //	Write Data command is 0x02 ---------------------------------------------
    P4DO_P3 = 0;	                          // CS PIN Enable (low level)
	SIO_ByteSend(SIO_1,0x02);				  // Page Program (PP, 02h)
	// [Sector 48] start address is 030000h
	SIO_ByteSend(SIO_1,0x03);                 // ADDR msb   A23 ~A16
	SIO_ByteSend(SIO_1,0x00);                 // ADDR       A15 ~A8
	SIO_ByteSend(SIO_1,0x00);                 // ADDR lsb   A7  ~A0

    // Program Data0~Data7:0x76,0x15,0x1A,0x2B,0x3C,0x4D,0x5E,0x6F
	SIO_ByteSend(SIO_1,0x76);                 // PGM data 0
	SIO_ByteSend(SIO_1,0x15);                 // PGM data 1
	
	SIO_ByteSend(SIO_1,0x1A);                 // PGM data 2
	SIO_ByteSend(SIO_1,0x2B);                 // PGM data 3
	
	SIO_ByteSend(SIO_1,0x3C);                 // PGM data 4
	SIO_ByteSend(SIO_1,0x4D);                 // PGM data 5
	
	SIO_ByteSend(SIO_1,0x5E);                 // PGM data 6
	SIO_ByteSend(SIO_1,0x6F);                 // PGM data 7
	
	for(i=0;i<16;i++){
	Read_Data[i] = SIO_ByteRead(SIO_1);	      // SIO1 receives data
	
	}
    P4DO_P3 = 1;                              // CS PIN Disable (high level) 
    for(i=0;i<250;i++);                       // Delay loop
    IS25LP_WaitBusy();        

	for(i=0;i<255;i++){                       // Delay loop
	   for(j=0;j<255;j++){
	   }
	}

    LED3_out = 0;                             // light on LED3
	for(i=0;i<255;i++){                       // Delay loop
	   for(j=0;j<255;j++){
	   }
	}   
    LED3_out = 1;                             // light off LED3
	
    __asm("NOP");	                          // **no operation, the breakpoint is located here**
   

 //	Read Data command is 0x03 ---------------------------------------------
 // check all programmed data in IS25LP080D
 
    P4DO_P3 = 0;                              // CS PIN Enable (low level) 
	SIO_ByteSend(SIO_1,0x03);                 // master transmits command 0x03
	// [Sector 48] start address is 030000h
	SIO_ByteSend(SIO_1,0x03);                 // ADDR msb   A23 ~A16
	SIO_ByteSend(SIO_1,0x00);                 // ADDR       A15 ~A8
	SIO_ByteSend(SIO_1,0x00);                 // ADDR lsb   A7  ~A0
	
	for(i=0;i<16;i++){
	Read_Data[i] = SIO_ByteRead(SIO_1);	      // SIO1 receives data
	
	}
	
    P4DO_P3 = 1;                              // CS PIN Disable (high level) 
	
    // compare the correct value of the readout with the LED light on or light off
    if(Read_Data[0] == 0x76 &&
       Read_Data[1] == 0x15 &&
       Read_Data[2] == 0x1A &&
       Read_Data[3] == 0x2B &&
       Read_Data[4] == 0x3C &&
       Read_Data[5] == 0x4D &&
       Read_Data[6] == 0x5E &&
       Read_Data[7] == 0x6F
    ){  
		LED_all_turn_on;                      // correct, light on all LEDs
	}
	else{
		LED_all_turn_off;                     // wrong, light off all LEDs
	}
    
    
    __asm("NOP");	                          // **no operation, the breakpoint is located here**




  while(1){
    CLR_WDT;                                  // clear the watchdog timer  
 
  }
}


/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)			  // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */

/* -------------------- SQ7615 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	IntSIO1,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7615 interrupt vector ---------------------- */

