//SQ7615_RTC example
//*************************************************************************************
// file			: main.c
// version		: V3.1
// brief		: main program
// description	: when program starts, LED2(P2.1) blinks every 2 seconds
//			  after 10 seconds, alarm happens and LED1 starts blinking
//			  when press button 1 BTN1(P3.0), stop LED1 blinking
// note			: 
//			  [external low frequency crystal Configuration] connect external 32.768KHz crystal with P4.0 and P4.1
// 
//			  [Button Configuration] button 1 :  BTN1(P3.0)  stop LED1 blinking
// 
//			  [LED Configuration]  LED 1  (P2.0) alarm happens and LED1(P2.0) blinks   
//			  [LED Configuration]  LED 2  (P2.1) blinking every 2 second
// 
//			  [RTC clock output] set to P2.2, output frequency is 32.768/8 = 4.01 KHz 
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned int LoopCnt=0;

RTC_Perpetual_Calendar_Time rtc;                              
RTC_ALARM rtc_alarm;

/* ----------------------- main program --------------------------- */
void main()
{
	
/* ---------------------- system initialization ------------------------ */
	P4FC1   = 0x03;                        	  // set P4.0 to LXOUT and set P4.1 to LXIN 
	P4FC2   = 0x03;
    CLKCR1_LXEN = 1;                     	  // enable external low frequency crystal  
    while(CLKCR1_LXRDY == 0);            	  // wait for external low frequency crystal ready
    CLKCR0_SCKLF = 1;                    	  // set external low frequency crystal as system clock                

	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                        	  // set P2.0, P2.1 and P2.2 as output pins
    P3OE  = 0x00;                        	  // set P3.0 as input pin
	P3PU |= 0x07;                       	  // enable P3.0 built-in pull-up resistor
	LED1_out = 1;							  // set LED1 to the light off
	LED2_out = 1;							  // set LED2 to the light off
/* ---------------------- RTC initialization ------------------------ */
    RTC_Init();	                        	  // RTC initialization
	
	// set current time : 2019/11/18 Monday 15:06:50
	rtc.year = 19;							  // year : 2019
	rtc.mon	 = 11;							  // month : 11
	rtc.week = 1;							  // day of the week : Monday
	rtc.day	 = 18;							  // day : 18
	rtc.hour = 15;						      // hour : 15
	rtc.min	 = 6;							  // minute : 06
	rtc.sec	 = 50;							  // second : 50
	RTC_SetDate(&rtc);                  	  // set current time
	
	//-------------------------------------------------------
	// set alarm time : 18 Monday 15:07:00
	rtc_alarm.week = 1;						  // day of the week : Monday                 	  
	rtc_alarm.day  = 18;					  // day : 18
	rtc_alarm.hour = 15;					  // hour : 15
	rtc_alarm.min  = 7;					 	  // minute : 07					 	  
	RTC_SetAlarm(&rtc_alarm);           	  // set alarm time
	
	//-------------------------------------------------------
	RTC_IntEnable(RTC_SIE|RTC_AIE,1);         // setup RTC interrupt  
	RTC_Output();                       	  // enable interrupt clock output                                    
	RTC_Start();							  // start RTC     
	
     while(1){
		if(RTC_1sec_actFlag){
			RTC_1sec_actFlag = 0;			  // clear flag for second interrupt
			RTCCR1_SECF = 0;
			LED2_out = ~LED2_out;			  // LED2(P2.1) inverted every second
			RTC_Refresh(&rtc);          	  // update RTC time
		}
		
		
		if(RTC_alarm_actFlag){
			if(LoopCnt++ >= 40000){
				LoopCnt = 0; 
				LED1_out = ~LED1_out;  	  	  // alarm interrupt generates, LED1(P2.0) inverted
			}			
		}
		
		if(BTN1_in == 0){
			if(RTC_alarm_actFlag){
				RTCCR1_ALIE =0;				  // disable alarm interrupt
				RTC_alarm_actFlag = 0;		  // clear flag for alarm interrupt					
				LED1_out = 1;          		  // light off LED1(P2.0)
			}
		}
    }
}

/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)               // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */



/* -------------------- SQ7615 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	IntRTC,			    	/* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7615 interrupt vector ---------------------- */

