//SQ7615_MAC example
//*************************************************************************************
// file			: main.c
// version		: V3.1
// brief		: main program
// description	: 
//			  when press button 1: MAC perform (C+(A*B)), if the result is correct, light on LED1
//			  when press button 2: MAC perform (C-(A+B)) with unsigned and saturation mode, if the result is correct, light on LED2
//			  when press button 3: MAC perform (C-(A+B)) with unsigned and unsaturation mode, if the result is correct, light on LED3
//
//            *when the button is released, the LED will turn off and wait for next press
// 
// note			: 
//				 [Button Configuration] 
//                button 1 : BTN1_in(P3.0)
//				  button 2 : BTN2_in(P3.1)
//				  button 3 : BTN3_in(P3.2)
// 
//				  [LED Configuration] LED 1  (P2.0)
//				  [LED Configuration] LED 2  (P2.1)
//				  [LED Configuration] LED 3  (P2.2)
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */


/* ----------------------- main program --------------------------- */
void main()
{

    unsigned long a;
    unsigned long b;
    unsigned long c;
    unsigned int j;

/* ---------------------- system initialization ------------------------ */	
	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                        	  // set P2.0, P2.1 and P2.2 as output pins
    P3OE  = 0x00;                        	  // set P3.1, P3.2 and P3.3 as input pins
	P3PU |= 0x07;                       	  // enable P3.1, P3.2 and P3.3 built-in pull-up resistors
	LED1_out = 1;							  // set LED1 to the light off
	LED2_out = 1;							  // set LED2 to the light off
	LED3_out = 1;							  // set LED3 to the light off
/* ---------------------- MAC initialization ------------------------ */		
    MAC_Init();                         	  // initialize MAC
	
	while(1)
	{
      if((P3DI & 0x07) != 0x07){	  
	    if(BTN1_in == 0)					  // if press button 1 :  BTN1_in(P3.0)
		{
			a = 60;							  
            b = 100;						  
            c = 2;
            *(unsigned long*)&MACC0 = c;	  // set variable c to MACC
            MACCR0_MODE = MAC_Mode_CAddMul;   // setup MAC to perform (C+(A*B))

            for(j=0;j<100;j++){
               *(unsigned long*)&MACA0 = a; // set variable a to MACA
               *(unsigned long*)&MACB0 = b; // set variable b to MACB

               MACCR1_START = 1;			  // start MAC
			   while(MACCR1_START);		  // wait for MAC to finish
            }

            c = *(unsigned long*)&MACC0;	  // get calculation result from MACC
			//c = (((*(unsigned long*)&MACC2 & 0xFF)<<16)|((*(unsigned long*)&MACC1 & 0xFF)<<8)|(*(unsigned long*)&MACC0 & 0xFF));
			//c = (((*(unsigned long*)&MACC4 & 0xFF)<<32)|((*(unsigned long*)&MACC3 & 0xFF)<<24)|((*(unsigned long*)&MACC2 & 0xFF)<<16)|((*(unsigned long*)&MACC1 & 0xFF)<<8)|(*(unsigned long*)&MACC0 & 0xFF));
			MACC4 = 0x00;                     
			
            if(c != 0x0927C2){				  // check calculation result 
               __ASM("NOP");				  // no operation
            }
			else							  // calculation result is correct, light on LED1
			{
			   LED1_out = 0; 	 
			}
		}
		//--------------------------------------------------------------------------------
	    else if(BTN2_in == 0){				  // if press button 2 :  BTN2_in(P3.1)
			
            a = 0xFFFFFFFF;
            b = 0xFFFFFFFC;
			c = 0x12345678;
            *(unsigned long*)&MACA0 = a;	  // set variable a to MACA
            *(unsigned long*)&MACB0 = b;	  // set variable b to MACB
			*(unsigned long*)&MACC0 = c;	  // set variable c to MACC
			MACC4 = 0x00;
			
            MACCR0_SAT = 1;                   // enable saturation mode
			MACCR0_MODE = MAC_Mode_CSubSum;   // setup MAC to perform (C-(A+B))			
			
            MACCR1_START = 1;                 // start MAC
            while(MACCR1_START);			  // wait for MAC to finish
            c = *(unsigned long*)&MACC0;	  // get calculation result from MACC
			//c = (((*(unsigned long*)&MACC4 & 0xFF)<<32)|((*(unsigned long*)&MACC3 & 0xFF)<<24)|((*(unsigned long*)&MACC2 & 0xFF)<<16)|((*(unsigned long*)&MACC1 & 0xFF)<<8)|(*(unsigned long*)&MACC0 & 0xFF));

			
			//-------------------------------------------------------------
            if(c != 0x00000000){			  // check calculation result
			   __ASM("NOP");				  // no operation
	        }
			else{							  // calculation result is correct, light on LED2
			   LED2_out = 0; 	 
			}

	    }
		//-------------------------------------------------------------------------------------
		else if(BTN3_in == 0){				  // if press button 3 :  BTN2_in(P3.2)
			
            a = 0xFFFFFFFF;
            b = 0xFFFFFFFC;
			c = 0x12345678;
            *(unsigned long*)&MACA0 = a;	  // set variable a to MACA
            *(unsigned long*)&MACB0 = b;	  // set variable b to MACB
			*(unsigned long*)&MACC0 = c;	  // set variable c to MACC
			MACC4 = 0x00;

            MACCR0_SAT = 0;                   // disable saturation mode
            MACCR0_MODE = MAC_Mode_CSubSum;   // setup MAC to perform (C-(A+B))
			
            MACCR1_START = 1;                 // start MAC
            while(MACCR1_START);			  // wait for MAC to finish
			c = *(unsigned long*)&MACC0;	  // get calculation result from MACC
			//c = (((*(unsigned long*)&MACC4 & 0xFF)<<32)|((*(unsigned long*)&MACC3 & 0xFF)<<24)|((*(unsigned long*)&MACC2 & 0xFF)<<16)|((*(unsigned long*)&MACC1 & 0xFF)<<8)|(*(unsigned long*)&MACC0 & 0xFF));
			
			
			//-------------------------------------------------------------
            if((c & 0xFFFFFFFF) != 0x1234567D){  // check calculation result 
			   __ASM("NOP");				  // no operation
            }
			else{							  // calculation result is correct, light on LED3
			   LED3_out = 0; 	 
			}
		}
		
		while((P3DI & 0x07) != 0x07);		  // wait for button released
		
		LED1_out = 1;						  // light off all LEDs
		LED2_out = 1; 
		LED3_out = 1; 	
	  }	
	}			
}



/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)              // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7615 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7615 interrupt vector ---------------------- */

