//*************************************************************************************
// file 		: SQ7615_EINT.c
// version		: V3.1
// brief		: EINT related functions
// note			: EINT related functions are gathered in this subroutine
//
//**************************************************************************************
#include "main.h"
unsigned char Push_BTN1_Flag;  // external interrupt flag of button 1
// unsigned char Push_BTN2_Flag; // external interrupt flag of button 2
// unsigned char Push_BTN3_Flag; // external interrupt flag of button 3


//*********************************************************************
// name			: EINT_Init()
// brief		: external interrupt initialization
// note			: 
//*********************************************************************
void EINT_Init(){
	
	//====== EINT0 ====================================================================================================================
	PCKEN3_EINT0 = 1;                                     // enable EINT0  *this must be enabled first, the relevant staging settings later to be useful
    //====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR0_INTSEL = 0x00;                              // set EINT0 to P0.0
	//EINTCR0_INTSEL = 0x01;                              // set EINT0 to P1.0
	//EINTCR0_INTSEL = 0x02;                              // set EINT0 to P2.0
	EINTCR0_INTSEL = 0x03;                                // set EINT0 to P3.0
	//EINTCR0_INTSEL = 0x04;                              // set EINT0 to P4.0
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR0_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge
	EINTCR0_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR0_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR0_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
	
	
/*	
	//====== EINT1 ====================================================================================================================
	PCKEN3_EINT1 = 1;                                     // enable EINT1  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR1_INTSEL = 0x00;                              // set EINT1 to P0.1
	//EINTCR1_INTSEL = 0x01;                              // set EINT1 to P1.1
	//EINTCR1_INTSEL = 0x02;                              // set EINT1 to P2.1
	EINTCR1_INTSEL = 0x03;                                // set EINT1 to P3.1
	//EINTCR1_INTSEL = 0x04;                              // set EINT1 to P4.1
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR1_INTES  = 0x00;							  // interrupt request generation edge : detected at rising edge
	EINTCR1_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR1_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR1_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/



/*
	//====== EINT2 ====================================================================================================================
	PCKEN3_EINT2 = 1;                                     // enable EINT2  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR2_INTSEL = 0x00;                              // set EINT2 to P0.2
	//EINTCR2_INTSEL = 0x01;                              // set EINT2 to P1.2
	//EINTCR2_INTSEL = 0x02;                              // set EINT2 to P2.2
	EINTCR2_INTSEL = 0x03;                                // set EINT2 to P3.2
	
	//*****[reminder]*****
	//P4.2 is external reset pin by default,
	//if you want to set it to other function, please disable external reset function
	//EINTCR2_INTSEL = 0x04;                              // set EINT2 to P4.2
	//SYSCR0_XRSTDIS = 1;								  // disable external reset
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR2_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR2_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR2_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR2_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/


	
/*	
	//====== EINT3 ====================================================================================================================
	PCKEN3_EINT3 = 1;                                     // enable EINT3  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR3_INTSEL = 0x00;                              // set EINT3 to P3.6
	//EINTCR3_INTSEL = 0x01;                              // set EINT3 to P1.3
	//EINTCR3_INTSEL = 0x02;                              // set EINT3 to P4.6
	EINTCR3_INTSEL = 0x03;                                // set EINT3 to P3.3
	//EINTCR3_INTSEL = 0x04;                              // set EINT3 to P4.3
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR3_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR3_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR3_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR3_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/	
	


/*	
	//====== EINT4 ====================================================================================================================
	PCKEN3_EINT4 = 1;                                     // enable EINT4  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR4_INTSEL = 0x00;                              // set EINT4 to P0.4
	//EINTCR4_INTSEL = 0x01;                              // set EINT4 to P1.4
	//EINTCR4_INTSEL = 0x02;                              // set EINT4 to P2.4
	
	//*****[reminder]*****
	//P3.4 is debug pin by default, 
	//if you want to set it to other function, please disable debug function
	//EINTCR4_INTSEL = 0x03;                              // set EINT4 to P3.4
	//SYSCR0_OCDDIS = 1;								  // disable debug function
	
	//EINTCR4_INTSEL = 0x04;                              // set EINT4 to P4.4
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR4_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR4_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR4_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR4_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		



/*	
	//====== EINT5 ====================================================================================================================
	PCKEN3_EINT5 = 1;                                     // enable EINT5  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR5_INTSEL = 0x00;                              // set EINT5 to P0.5
	//EINTCR5_INTSEL = 0x01;                              // set EINT5 to P1.5
	//EINTCR5_INTSEL = 0x02;                              // set EINT5 to P2.5
	EINTCR5_INTSEL = 0x03;                                // set EINT5 to P3.5
	//EINTCR5_INTSEL = 0x04;                              // set EINT5 to P4.5
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR5_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR5_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR5_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR5_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		



/*	
	//====== EINT6 ====================================================================================================================
	PCKEN3_EINT6 = 1;                                     // enable EINT6  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR6_INTSEL = 0x00;                              // set EINT6 to P0.6
	//EINTCR6_INTSEL = 0x01;                              // set EINT6 to P1.6
	EINTCR6_INTSEL = 0x02;                                // set EINT6 to P2.6
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR6_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR6_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR6_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR6_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		


	
/*	
	//====== EINT7 ====================================================================================================================
	PCKEN3_EINT7 = 1;                                     // enable EINT7  *this must be enabled first, the relevant staging settings later to be useful
	//====== parameter setting ======
	
	//--- select external interrupt pin -------------------------------------------------------------
	//EINTCR7_INTSEL = 0x00;                              // set EINT7 to P3.7
	EINTCR7_INTSEL = 0x01;                                // set EINT7 to P1.7
	//EINTCR7_INTSEL = 0x02;                              // set EINT7 to P4.7
	
	//--- interrupt request generation edge setting -------------------------------------------------------------------
	//EINTCR7_INTES  = 0x00;                              // interrupt request generation edge : detected at rising edge
	EINTCR7_INTES  = 0x01;                                // interrupt request generation edge : detected at falling edge
	//EINTCR7_INTES  = 0x02;                              // interrupt request generation edge : detected at both edges
	
	EINTCR7_INTINC = 0x03;                                // noise canceller sampling interval : fcgck/16
*/		
	



}


//*********************************************************************
// name			: EINT_IntEnable()
// brief		: enable external interrupt
// note			: 
//*********************************************************************
void EINT_IntEnable(){
	__ASM("DI");	                                      // disable all maskable interrupts

	IFR_EXT0 = 0;                                         // clear EINT0 interrupt flag                                                                             
	IER_EXT0 = 1;                                         // enable EINT0 interrupt
	
/*
	IFR_EXT1 = 0;                                         // clear EINT1 interrupt flag
	IER_EXT1 = 1;                                         // enable EINT1 interrupt
*/
	
/*
	IFR_EXT2 = 0;                                         // clear EINT2 interrupt flag
	IER_EXT2 = 1;                                         // enable EINT2 interrupt
*/

/*
	IFR_EXT3 = 0;                                         // clear EINT3 interrupt flag
	IER_EXT3 = 1;                                         // enable EINT3 interrupt
*/


/*
	IFR_EXT4 = 0;                                         // clear EINT4 interrupt flag
	IER_EXT4 = 1;                                         // enable EINT4 interrupt
*/


/*
	IFR_EXT5 = 0;                                         // clear EINT5 interrupt flag
	IER_EXT5 = 1;                                         // enable EINT5 interrupt
*/


/*
	IFR_EXT6 = 0;                                         // clear EINT6 interrupt flag
	IER_EXT6 = 1;                                         // enable EINT6 interrupt
*/


/*
	IFR_EXT7 = 0;                                         // clear EINT7 interrupt flag
	IER_EXT7 = 1;                                         // enable EINT7 interrupt
*/
	
	__ASM("EI");                                          // enable all maskable interrupts
}


//*********************************************************************
// name			: EINT_IntDisable()
// brief		: disable external interrupt
// note			: 
//*********************************************************************
void EINT_IntDisable(){
	IER_EXT0 = 0;                                         // disable EINT0 interrupt
	//IER_EXT1 = 0;                                       // disable EINT1 interrupt
	//IER_EXT2 = 0; 									  // disable EINT2 interrupt
	
	//IER_EXT3 = 0; 									  // disable EINT3 interrupt
	//IER_EXT4 = 0; 									  // disable EINT4 interrupt
	//IER_EXT5 = 0; 									  // disable EINT5 interrupt
	//IER_EXT6 = 0; 									  // disable EINT6 interrupt
	//IER_EXT7 = 0; 									  // disable EINT7 interrupt	
}


//*********************************************************************
// name			: __interrupt IntEXT0()
// brief		: IntEXT0 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT0(void){
	__asm("NOP");										  // no operation	
	Push_BTN1_Flag = 1;									  // set Push_BTN1_Flag to 1

 						  
}


//*********************************************************************
// name			: __interrupt IntEXT1()
// brief		: IntEXT1 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT1(void){
	__asm("NOP");										  // no operation
	//Push_BTN2_Flag = 1;								  // set Push_BTN2_Flag to 1

	

}


//*********************************************************************
// name			: __interrupt IntEXT2()
// brief		: IntEXT2 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT2(void){
	__asm("NOP");								          // no operation
	//Push_BTN3_Flag = 1;								  // set Push_BTN3_Flag to 1

						  
}


//*********************************************************************
// name			: __interrupt IntEXT3()
// brief		: IntEXT3 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT3(void){
	__asm("NOP");	                                      // no operation
}


//*********************************************************************
// name			: __interrupt IntEXT4()
// brief		: IntEXT4 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT4(void){
	__asm("NOP");                                         // no operation
}


//*********************************************************************
// name			: __interrupt IntEXT5()
// brief		: IntEXT5 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT5(void){
	__asm("NOP");										  // no operation
}


//*********************************************************************
// name			: __interrupt IntEXT6()
// brief		: IntEXT6 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT6(void){
	__asm("NOP");										  // no operation
}


//*********************************************************************
// name			: __interrupt IntEXT7()
// brief		: IntEXT7 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntEXT7(void){
	__asm("NOP");										  // no operation
}

