//*************************************************************************************
// file			: SQ7615_SFR.h
// version		: V1.2 2023/12/04
// brief		: declare the detailed name of each the special function register
// note			: 
//**************************************************************************************
#ifndef _SQ7615_SFR_H_
#define _SQ7615_SFR_H_

#include "SQ7615_SFR_addr.h"

//**********************************************************
//******
#define NOP                 __asm("NOP")                        // no operation
//******
#define DI                  __asm("DI")                         // disable all maskable interrupts // MIFR_IMF = 0
#define EI                  __asm("EI")                         // enable all maskable interrupts // MIFR_IMF = 1
//******
#define CLR_WDT             WDCDR_WDTCR=0x4E					// clear the watchdog timer
//******
#define DIS_WDT             WDCTR_WDTEN=0; WDCDR_WDTCR=0xB1		// disable the watchdog timer operation and clear the 8-bit up counter
//******
//**********************************************************

//==========================
//			SYSCR0			
//==========================
#define SYSCR0 				_0x0008.byte
#define SYSCR0_XRSTDIS		_0x0008.bit.b3
#define SYSCR0_OCDDIS		_0x0008.bit.b2
#define SYSCR0_ROMST		_0x0008.bit.b1

//==========================
//			PMR
//==========================
#define PMR        			_0x000A.byte
#define PMR_LDOON  			_0x000A.bit.b4
#define PMR_DSM  			_0x000A.bit.b3
#define PMR_PMODE  			_0x000A.b2_0.b2_0

//==========================
//			RSTFLG
//==========================
#define RSTFLG     			_0x000B.byte
#define RSTFLG_CLR  		_0x000B.bit.b7
#define RSTFLG_BLMF  		_0x000B.bit.b3
#define RSTFLG_WDTF  		_0x000B.bit.b2
#define RSTFLG_EXBRORF  	_0x000B.bit.b0

//==========================
//			RTCCR0
//==========================
#define RTCCR0     			_0x0010.byte
#define RTCCR0_WREN			_0x0010.bit.b7
#define RTCCR0_RTCEN		_0x0010.bit.b6
#define RTCCR0_H12			_0x0010.bit.b5
#define RTCCR0_CLKOEN		_0x0010.bit.b4
#define RTCCR0_CLKOSEL  	_0x0010.b3_2.b3_2
#define RTCCR0_CLKSEL		_0x0010.b1_0.b1_0

//==========================
//			RTCCR1
//==========================
#define RTCCR1     			_0x0011.byte
#define RTCCR1_TOF			_0x0011.bit.b7
#define RTCCR1_SECF			_0x0011.bit.b6
#define RTCCR1_ALF			_0x0011.bit.b5
#define RTCCR1_WRFENF		_0x0011.bit.b4
#define RTCCR1_TOIE			_0x0011.bit.b3
#define RTCCR1_SECIE		_0x0011.bit.b2
#define RTCCR1_ALIE			_0x0011.bit.b1
#define RTCCR1_WRENIE		_0x0011.bit.b0

//==========================
//			RTCSEC
//==========================
#define RTCSEC    			_0x0012.byte
#define RTCSEC_SECONDS		_0x0012.b6_0.b6_0

//==========================
//			RTCMIN
//==========================
#define RTCMIN     			_0x0013.byte
#define RTCMIN_MINUTES		_0x0013.b6_0.b6_0

//==========================
//			RTCHR
//==========================
#define RTCHR      			_0x0014.byte
#define RTCHR_AMPM			_0x0014.bit.b5
#define RTCHR_HOURS  		_0x0014.b4_0.b4_0

//==========================
//			RTCDAY
//==========================
#define RTCDAY     			_0x0015.byte
#define RTCDAY_DAYS			_0x0015.b5_0.b5_0

//==========================
//			RTCWDAY
//==========================
#define RTCWDAY    			_0x0016.byte
#define RTCWDAY_WEEKDAYS	_0x0016.b2_0.b2_0

//==========================
//			RTCMONTH
//==========================
#define RTCMONTH   			_0x0017.byte
#define RTCMONTH_MONTHS		_0x0017.b3_0.b3_0

//==========================
//			RTCYEAR
//==========================
#define RTCYEAR    			_0x0018.byte
#define RTCYEAR_YEARS		_0x0018.byte

//==========================
//			RTCALMIN
//==========================
#define RTCALMIN  	 		_0x0019.byte
#define RTCALMIN_MINBYP		_0x0019.bit.b7
#define RTCALMIN_ALMIN      _0x0019.b6_0.b6_0

//==========================
//			RTCALHR
//==========================
#define RTCALHR				_0x001A.byte
#define RTCALHR_HRBYP		_0x001A.bit.b7
#define RTCALHR_AMPM		_0x001A.bit.b5
#define RTCALHR_ALHR	    _0x001A.b4_0.b4_0

//==========================
//			RTCALDAY
//==========================
#define RTCALDAY   			_0x001B.byte
#define RTCALDAY_DAYBYP		_0x001B.bit.b7
#define RTCALDAY_ALDAY   	_0x001B.b5_0.b5_0

//==========================
//			RTCALWDAY
//==========================
#define RTCALWDAY  			_0x001C.byte
#define RTCALWDAY_WAYBYP	_0x001C.bit.b7
#define RTCALWDAY_ALWDAY	_0x001C.b2_0.b2_0

//==========================
//			RTCTMRCR
//==========================
#define RTCTMRCR			_0x001D.byte
#define RTCTMRCR_TMRST		_0x001D.bit.b7
#define RTCTMRCR_CONT		_0x001D.bit.b6
#define RTCTMRCR_TMREN		_0x001D.bit.b5
#define RTCTMRCR_CALEN		_0x001D.bit.b2
#define RTCTMRCR_TMRSEL		_0x001D.b1_0.b1_0

//==========================
//			RTCTMRTO
//==========================
#define RTCTMRTO			_0x001E.byte
#define RTCTMRTO_TMRTO		_0x001E.byte

//==========================
//			RTCOFST
//==========================
#define RTCOFST  			_0x001F.byte
#define RTCOFST_MODE		_0x001F.bit.b7		
#define RTCOFST_SIGN		_0x001F.bit.b6
#define RTCOFST_OFFSET		_0x001F.b5_0.b5_0

//==========================
//			CLKCR0
//==========================
#define CLKCR0     			_0x0020.byte
#define CLKCR0_SCKRDY		_0x0020.bit.b7
#define CLKCR0_SCKPSC		_0x0020.b6_4.b6_4
#define CLKCR0_SCKLF		_0x0020.bit.b3
#define CLKCR0_SCKSRC		_0x0020.b2_0.b2_0

//==========================
//			CLKCR1
//==========================
#define CLKCR1     			_0x0021.byte
#define CLKCR1_LXRDY		_0x0021.bit.b7
#define CLKCR1_HXRDY		_0x0021.bit.b6
#define CLKCR1_LPIRCRDY		_0x0021.bit.b5
#define CLKCR1_HIRCRDY		_0x0021.bit.b4
#define CLKCR1_LXEN			_0x0021.bit.b3
#define CLKCR1_HXEN			_0x0021.bit.b2
#define CLKCR1_LPIRCEN		_0x0021.bit.b1
#define CLKCR1_HIRCEN		_0x0021.bit.b0

//==========================
//			CLKCR3
//==========================
#define CLKCR3     			_0x0023.byte
#define CLKCR3_CMIE  		_0x0023.bit.b7
#define CLKCR3_LXCMEN		_0x0023.bit.b6
#define CLKCR3_HXCMEN		_0x0023.bit.b5

//==========================
//			PLLCR0
//==========================
#define PLLCR0     			_0x0024.byte
#define PLLCR0_PLLREF		_0x0024.bit.b2
#define PLLCR0_PLLRDY		_0x0024.bit.b1
#define PLLCR0_PLLEN		_0x0024.bit.b0

//==========================
//			FCKDIV
//==========================
#define FCKDIV     			_0x0027.byte

//==========================
//			WDCTR
//==========================
#define WDCTR      			_0x0028.byte
#define WDCTR_WDTEN			_0x0028.bit.b5
#define WDCTR_WDTW			_0x0028.b4_3.b4_3
#define WDCTR_WDTT			_0x0028.b2_1.b2_1
#define WDCTR_WDTOUT		_0x0028.bit.b0

//==========================
//			WDCDR
//==========================
#define WDCDR     	 		_0x0029.byte
#define WDCDR_WDTCR			_0x0029.byte

//==========================
//			WDCNT
//==========================
#define WDCNT      			_0x002A.byte
#define WDCNT_WDCNT			_0x002A.byte

//==========================
//			WDST
//==========================
#define WDST       			_0x002B.byte
#define WDST_WINTST2		_0x002B.bit.b2
#define WDST_WINTST1		_0x002B.bit.b1
#define WDST_WDTST			_0x002B.bit.b0

//==========================
//			TBTCR
//==========================
#define TBTCR      			_0x002E.byte
#define TBTCR_DV9CK			_0x002E.bit.b5
#define TBTCR_TBTEN			_0x002E.bit.b4
#define TBTCR_TBTCK			_0x002E.b3_0.b3_0

//==========================
//			DVOCR
//==========================
#define DVOCR      			_0x002F.byte
#define DVOCR_DVOEN			_0x002F.bit.b2
#define DVOCR_DVOCK			_0x002F.b1_0.b1_0

//==========================
//			CMSR
//==========================
#define CMSR       			_0x0030.byte
#define CMSR_LXGLTCH		_0x0030.bit.b7
#define CMSR_LXSLW			_0x0030.bit.b6
#define CMSR_LXFST			_0x0030.bit.b5
#define CMSR_LXFAIL			_0x0030.bit.b4
#define CMSR_HXSLW			_0x0030.bit.b2
#define CMSR_HXFST			_0x0030.bit.b1
#define CMSR_HXFAIL			_0x0030.bit.b0

//==========================
//			LVDCR
//==========================
#define LVDCR      			_0x0031.byte

#define LVDCR_LVDCFG		_0x0031.b6_4.b6_4
#define LVDCR_LVDST			_0x0031.bit.b3
#define LVDCR_LVDF			_0x0031.bit.b2
#define LVDCR_LVDIEN		_0x0031.bit.b1
#define LVDCR_LVDEN			_0x0031.bit.b0

//==========================
//			PONCR
//==========================
#define PONCR      			_0x0034.byte
#define PONCR_BRORCFG		_0x0034.b2_1.b2_1
#define PONCR_BROREN		_0x0034.bit.b0

//==========================
//			CMCR
//==========================
#define CMCR       			_0x0035.byte
#define CMCR_LXGLTEN		_0x0035.bit.b7
#define CMCR_LXSLWEN		_0x0035.bit.b6
#define CMCR_LXFSTEN		_0x0035.bit.b5
#define CMCR_LXFAILEN		_0x0035.bit.b4

#define CMCR_HXSLWEN		_0x0035.bit.b2
#define CMCR_HXFSTEN		_0x0035.bit.b1
#define CMCR_HXFAILEN		_0x0035.bit.b0

//==========================
//			PMCFG
//==========================
#define PMCFG     			_0x0038.byte

//==========================
//			DMCFG
//==========================
#define DMCFG      			_0x0039.byte

//==========================
//			MIFR
//==========================
#define MIFR       			_0x003A.byte
#define MIFR_IMF			_0x003A.bit.b0

//==========================
//			PSW
//==========================
#define PSW        			_0x003F.byte
#define PSW_JF				_0x003F.bit.b7
#define PSW_ZF				_0x003F.bit.b6
#define PSW_CF				_0x003F.bit.b5
#define PSW_HF				_0x003F.bit.b4
#define PSW_SF				_0x003F.bit.b3
#define PSW_VF				_0x003F.bit.b2
#define PSW_RBS				_0x003F.bit.b1

//==========================
//			FCR0
//==========================
#define FCR0       			_0x0040.byte
#define FCR0_DATASZ0		_0x0040.b5_4.b5_4
#define FCR0_FCMD			_0x0040.b3_0.b3_0
//==========================
//			FCR1
//==========================
#define FCR1       			_0x0041.byte
#define FCR1_BUSY			_0x0041.bit.b7
#define FCR1_PROGA_ERR		_0x0041.bit.b6
#define FCR1_PROGD_ERR		_0x0041.bit.b5

//==========================
//			FADDR0
//==========================
#define FADDR0     			_0x0042.byte
#define FADDR0_FADDR		_0x0042.byte
//==========================
//			FADDR1
//==========================
#define FADDR1     			_0x0043.byte
#define FADDR1_FADDR		_0x0043.byte
//==========================
//			FDATA0
//==========================
#define FDATA0     			_0x0044.byte
#define FDATA0_FDATA		_0x0044.byte
//==========================
//			FDATA1
//==========================
#define FDATA1     			_0x0045.byte
#define FDATA1_FDATA		_0x0045.byte
//==========================
//			FDATA2
//==========================
#define FDATA2				_0x0046.byte
#define FDATA2_FDATA		_0x0046.byte
//==========================
//			FDATA3
//==========================
#define FDATA3     			_0x0047.byte
#define FDATA3_FDATA		_0x0047.byte

//==========================
//			TA0CR
//==========================
#define TA0CR      			_0x0068.byte
#define TA0CR_TAOVE			_0x0068.bit.b7
#define TA0CR_TATFF			_0x0068.bit.b6
#define TA0CR_TANC			_0x0068.b5_4.b5_4
#define TA0CR_TAACAP		_0x0068.bit.b1
#define TA0CR_TAMPPG		_0x0068.bit.b1
#define TA0CR_TAS			_0x0068.bit.b0

//==========================
//			TA1CR
//==========================
#define TA1CR      			_0x0069.byte
#define TA1CR_TAOVE			_0x0069.bit.b7
#define TA1CR_TATFF			_0x0069.bit.b6
#define TA1CR_TANC			_0x0069.b5_4.b5_4
#define TA1CR_TAACAP		_0x0069.bit.b1
#define TA1CR_TAMPPG		_0x0069.bit.b1
#define TA1CR_TAS			_0x0069.bit.b0

//==========================
//			TA2CR
//==========================
#define TA2CR      			_0x006A.byte
#define TA2CR_TAOVE			_0x006A.bit.b7
#define TA2CR_TATFF			_0x006A.bit.b6
#define TA2CR_TANC			_0x006A.b5_4.b5_4
#define TA2CR_TAACAP		_0x006A.bit.b1
#define TA2CR_TAMPPG		_0x006A.bit.b1
#define TA2CR_TAS			_0x006A.bit.b0

//==========================
//			TA3CR
//==========================
#define TA3CR      			_0x006B.byte
#define TA3CR_TAOVE			_0x006B.bit.b7
#define TA3CR_TATFF			_0x006B.bit.b6
#define TA3CR_TANC			_0x006B.b5_4.b5_4
#define TA3CR_TAACAP		_0x006B.bit.b1
#define TA3CR_TAMPPG		_0x006B.bit.b1
#define TA3CR_TAS			_0x006B.bit.b0

//==========================
//			TA4CR
//==========================
#define TA4CR      			_0x006C.byte
#define TA4CR_TAOVE			_0x006C.bit.b7
#define TA4CR_TATFF			_0x006C.bit.b6
#define TA4CR_TANC			_0x006C.b5_4.b5_4
#define TA4CR_TAACAP		_0x006C.bit.b1
#define TA4CR_TAMPPG		_0x006C.bit.b1
#define TA4CR_TAS			_0x006C.bit.b0

//==========================
//			TA5CR
//==========================
#define TA5CR      			_0x006D.byte
#define TA5CR_TAOVE			_0x006D.bit.b7
#define TA5CR_TATFF			_0x006D.bit.b6
#define TA5CR_TANC			_0x006D.b5_4.b5_4
#define TA5CR_TAACAP		_0x006D.bit.b1
#define TA5CR_TAMPPG		_0x006D.bit.b1
#define TA5CR_TAS			_0x006D.bit.b0

//==========================
//			TA6CR
//==========================
#define TA6CR      			_0x006E.byte
#define TA6CR_TAOVE			_0x006E.bit.b7
#define TA6CR_TATFF			_0x006E.bit.b6
#define TA6CR_TANC			_0x006E.b5_4.b5_4
#define TA6CR_TAACAP		_0x006E.bit.b1
#define TA6CR_TAMPPG		_0x006E.bit.b1
#define TA6CR_TAS			_0x006E.bit.b0

//==========================
//			TA7CR
//==========================
#define TA7CR      			_0x006F.byte
#define TA7CR_TAOVE			_0x006F.bit.b7
#define TA7CR_TATFF			_0x006F.bit.b6
#define TA7CR_TANC			_0x006F.b5_4.b5_4
#define TA7CR_TAACAP		_0x006F.bit.b1
#define TA7CR_TAMPPG		_0x006F.bit.b1
#define TA7CR_TAS			_0x006F.bit.b0

//==========================
//			TA0MOD
//==========================
#define TA0MOD     			_0x0070.byte
#define TA0MOD_TADBE		_0x0070.bit.b7
#define TA0MOD_TATED		_0x0070.bit.b6
#define TA0MOD_TAMCAP		_0x0070.bit.b5
#define TA0MOD_TAMETT		_0x0070.bit.b5
#define TA0MOD_TACK			_0x0070.b4_3.b4_3
#define TA0MOD_TAM			_0x0070.b2_0.b2_0

//==========================
//			TA1MOD
//==========================
#define TA1MOD     			_0x0071.byte
#define TA1MOD_TADBE		_0x0071.bit.b7
#define TA1MOD_TATED		_0x0071.bit.b6
#define TA1MOD_TAMCAP		_0x0071.bit.b5
#define TA1MOD_TAMETT		_0x0071.bit.b5
#define TA1MOD_TACK			_0x0071.b4_3.b4_3
#define TA1MOD_TAM			_0x0071.b2_0.b2_0

//==========================
//			TA2MOD
//==========================
#define TA2MOD      		_0x0072.byte
#define TA2MOD_TADBE		_0x0072.bit.b7
#define TA2MOD_TATED		_0x0072.bit.b6
#define TA2MOD_TAMCAP		_0x0072.bit.b5
#define TA2MOD_TAMETT		_0x0072.bit.b5
#define TA2MOD_TACK			_0x0072.b4_3.b4_3
#define TA2MOD_TAM			_0x0072.b2_0.b2_0

//==========================
//			TA3MOD
//==========================
#define TA3MOD     	 		_0x0073.byte
#define TA3MOD_TADBE		_0x0073.bit.b7
#define TA3MOD_TATED		_0x0073.bit.b6
#define TA3MOD_TAMCAP		_0x0073.bit.b5
#define TA3MOD_TAMETT		_0x0073.bit.b5
#define TA3MOD_TACK			_0x0073.b4_3.b4_3
#define TA3MOD_TAM			_0x0073.b2_0.b2_0

//==========================
//			TA4MOD
//==========================
#define TA4MOD     	 		_0x0074.byte
#define TA4MOD_TADBE		_0x0074.bit.b7
#define TA4MOD_TATED		_0x0074.bit.b6
#define TA4MOD_TAMCAP		_0x0074.bit.b5
#define TA4MOD_TAMETT		_0x0074.bit.b5
#define TA4MOD_TACK			_0x0074.b4_3.b4_3
#define TA4MOD_TAM			_0x0074.b2_0.b2_0

//==========================
//			TA5MOD
//==========================
#define TA5MOD     	 		_0x0075.byte
#define TA5MOD_TADBE		_0x0075.bit.b7
#define TA5MOD_TATED		_0x0075.bit.b6
#define TA5MOD_TAMCAP		_0x0075.bit.b5
#define TA5MOD_TAMETT		_0x0075.bit.b5
#define TA5MOD_TACK			_0x0075.b4_3.b4_3
#define TA5MOD_TAM			_0x0075.b2_0.b2_0

//==========================
//			TA6MOD
//==========================
#define TA6MOD     	 		_0x0076.byte
#define TA6MOD_TADBE		_0x0076.bit.b7
#define TA6MOD_TATED		_0x0076.bit.b6
#define TA6MOD_TAMCAP		_0x0076.bit.b5
#define TA6MOD_TAMETT		_0x0076.bit.b5
#define TA6MOD_TACK			_0x0076.b4_3.b4_3
#define TA6MOD_TAM			_0x0076.b2_0.b2_0

//==========================
//			TA7MOD
//==========================
#define TA7MOD     	 		_0x0077.byte
#define TA7MOD_TADBE		_0x0077.bit.b7
#define TA7MOD_TATED		_0x0077.bit.b6
#define TA7MOD_TAMCAP		_0x0077.bit.b5
#define TA7MOD_TAMETT		_0x0077.bit.b5
#define TA7MOD_TACK			_0x0077.b4_3.b4_3
#define TA7MOD_TAM			_0x0077.b2_0.b2_0

//==========================
//			TA0SR
//==========================
#define TA0SR      			_0x0078.byte
#define TA0SR_TAOVF			_0x0078.bit.b7
#define TA0SR_TACPFA		_0x0078.bit.b1
#define TA0SR_TACPFB		_0x0078.bit.b0

//==========================
//			TA1SR
//==========================
#define TA1SR      			_0x0079.byte
#define TA1SR_TAOVF			_0x0079.bit.b7
#define TA1SR_TACPFA		_0x0079.bit.b1
#define TA1SR_TACPFB		_0x0079.bit.b0

//==========================
//			TA2SR
//==========================
#define TA2SR      			_0x007A.byte
#define TA2SR_TAOVF			_0x007A.bit.b7
#define TA2SR_TACPFA		_0x007A.bit.b1
#define TA2SR_TACPFB		_0x007A.bit.b0

//==========================
//			TA3SR
//==========================
#define TA3SR      			_0x007B.byte
#define TA3SR_TAOVF			_0x007B.bit.b7
#define TA3SR_TACPFA		_0x007B.bit.b1
#define TA3SR_TACPFB		_0x007B.bit.b0

//==========================
//			TA4SR
//==========================
#define TA4SR      			_0x007C.byte
#define TA4SR_TAOVF			_0x007C.bit.b7
#define TA4SR_TACPFA		_0x007C.bit.b1
#define TA4SR_TACPFB		_0x007C.bit.b0

//==========================
//			TA5SR
//==========================
#define TA5SR      			_0x007D.byte
#define TA5SR_TAOVF			_0x007D.bit.b7
#define TA5SR_TACPFA		_0x007D.bit.b1
#define TA5SR_TACPFB		_0x007D.bit.b0

//==========================
//			TA6SR
//==========================
#define TA6SR      			_0x007E.byte
#define TA6SR_TAOVF			_0x007E.bit.b7
#define TA6SR_TACPFA		_0x007E.bit.b1
#define TA6SR_TACPFB		_0x007E.bit.b0

//==========================
//			TA7SR
//==========================
#define TA7SR      			_0x007F.byte
#define TA7SR_TAOVF			_0x007F.bit.b7
#define TA7SR_TACPFA		_0x007F.bit.b1
#define TA7SR_TACPFB		_0x007F.bit.b0

//==========================
//			TA0DRA
//==========================
#define TA0DRA    			_0x0080.word
#define TA0DRAL    			_0x0080.byte[0]
#define TA0DRAL_TADRAL		_0x0080.byte[0]
#define TA0DRAH    			_0x0080.byte[1]
#define TA0DRAH_TADRAH		_0x0080.byte[1]

//==========================
//			TA0DRB
//==========================
#define TA0DRB    			_0x0082.word
#define TA0DRBL    			_0x0082.byte[0]
#define TA0DRBL_TADRBL		_0x0082.byte[0]
#define TA0DRBH				_0x0082.byte[1]
#define TA0DRBH_TADRBH		_0x0082.byte[1]


//==========================
//			TA1DRA
//==========================
#define TA1DRA    			_0x0084.word
#define TA1DRAL    			_0x0084.byte[0]
#define TA1DRAL_TADRAL		_0x0084.byte[0]
#define TA1DRAH    			_0x0084.byte[1]
#define TA1DRAH_TADRAH		_0x0084.byte[1]

//==========================
//			TA1DRB
//==========================
#define TA1DRB    			_0x0086.word
#define TA1DRBL    			_0x0086.byte[0]
#define TA1DRBL_TADRBL		_0x0086.byte[0]
#define TA1DRBH				_0x0086.byte[1]
#define TA1DRBH_TADRBH		_0x0086.byte[1]

//==========================
//			TA2DRA
//==========================
#define TA2DRA    			_0x0088.word
#define TA2DRAL    			_0x0088.byte[0]
#define TA2DRAL_TADRAL		_0x0088.byte[0]
#define TA2DRAH    			_0x0088.byte[1]
#define TA2DRAH_TADRAH		_0x0088.byte[1]

//==========================
//			TA2DRB
//==========================
#define TA2DRB    			_0x008A.word
#define TA2DRBL    			_0x008A.byte[0]
#define TA2DRBL_TADRBL		_0x008A.byte[0]
#define TA2DRBH				_0x008A.byte[1]
#define TA2DRBH_TADRBH		_0x008A.byte[1]

//==========================
//			TA3DRA
//==========================
#define TA3DRA    			_0x008C.word
#define TA3DRAL    			_0x008C.byte[0]
#define TA3DRAL_TADRAL		_0x008C.byte[0]
#define TA3DRAH    			_0x008C.byte[1]
#define TA3DRAH_TADRAH		_0x008C.byte[1]

//==========================
//			TA3DRB
//==========================
#define TA3DRB    			_0x008E.word
#define TA3DRBL    			_0x008E.byte[0]
#define TA3DRBL_TADRBL		_0x008E.byte[0]
#define TA3DRBH				_0x008E.byte[1]
#define TA3DRBH_TADRBH		_0x008E.byte[1]

//==========================
//			TA4DRA
//==========================
#define TA4DRA    			_0x0090.word
#define TA4DRAL    			_0x0090.byte[0]
#define TA4DRAL_TADRAL		_0x0090.byte[0]
#define TA4DRAH    			_0x0090.byte[1]
#define TA4DRAH_TADRAH		_0x0090.byte[1]

//==========================
//			TA4DRB
//==========================
#define TA4DRB    			_0x0092.word
#define TA4DRBL    			_0x0092.byte[0]
#define TA4DRBL_TADRBL		_0x0092.byte[0]
#define TA4DRBH				_0x0092.byte[1]
#define TA4DRBH_TADRBH		_0x0092.byte[1]

//==========================
//			TA5DRA
//==========================
#define TA5DRA    			_0x0094.word
#define TA5DRAL    			_0x0094.byte[0]
#define TA5DRAL_TADRAL		_0x0094.byte[0]
#define TA5DRAH    			_0x0094.byte[1]
#define TA5DRAH_TADRAH		_0x0094.byte[1]

//==========================
//			TA5DRB
//==========================
#define TA5DRB    			_0x0096.word
#define TA5DRBL    			_0x0096.byte[0]
#define TA5DRBL_TADRBL		_0x0096.byte[0]
#define TA5DRBH				_0x0096.byte[1]
#define TA5DRBH_TADRBH		_0x0096.byte[1]

//==========================
//			TA6DRA
//==========================
#define TA6DRA    			_0x0098.word
#define TA6DRAL    			_0x0098.byte[0]
#define TA6DRAL_TADRAL		_0x0098.byte[0]
#define TA6DRAH    			_0x0098.byte[1]
#define TA6DRAH_TADRAH		_0x0098.byte[1]

//==========================
//			TA6DRB
//==========================
#define TA6DRB    			_0x009A.word
#define TA6DRBL    			_0x009A.byte[0]
#define TA6DRBL_TADRBL		_0x009A.byte[0]
#define TA6DRBH				_0x009A.byte[1]
#define TA6DRBH_TADRBH		_0x009A.byte[1]

//==========================
//			TA7DRA
//==========================
#define TA7DRA    			_0x009C.word
#define TA7DRAL    			_0x009C.byte[0]
#define TA7DRAL_TADRAL		_0x009C.byte[0]
#define TA7DRAH    			_0x009C.byte[1]
#define TA7DRAH_TADRAH		_0x009C.byte[1]

//==========================
//			TA7DRB
//==========================
#define TA7DRB    			_0x009E.word
#define TA7DRBL    			_0x009E.byte[0]
#define TA7DRBL_TADRBL		_0x009E.byte[0]
#define TA7DRBH				_0x009E.byte[1]
#define TA7DRBH_TADRBH		_0x009E.byte[1]

//==========================
//			UART0CR1
//==========================
#define UART0CR1   			_0x00A0.byte
#define UART0CR1_TXE		_0x00A0.bit.b7
#define UART0CR1_RXE		_0x00A0.bit.b6
#define UART0CR1_STOPBT		_0x00A0.bit.b5
#define UART0CR1_EVEN		_0x00A0.bit.b4
#define UART0CR1_PE			_0x00A0.bit.b3
#define UART0CR1_IRDASEL	_0x00A0.bit.b2
#define UART0CR1_BRG		_0x00A0.bit.b1

//==========================
//			UART0CR2
//==========================
#define UART0CR2   			_0x00A1.byte
#define UART0CR2_DV			_0x00A1.b7_6.b7_6
#define UART0CR2_RTSEL		_0x00A1.b5_3.b5_3
#define UART0CR2_RXDNC		_0x00A1.b2_1.b2_1
#define UART0CR2_STOPBR		_0x00A1.bit.b0

//==========================
//			UART0DR
//==========================
#define UART0DR    			_0x00A2.byte
#define UART0DR_UART0DR7	_0x00A2.bit.b7
#define UART0DR_UART0DR6	_0x00A2.bit.b6
#define UART0DR_UART0DR5	_0x00A2.bit.b5
#define UART0DR_UART0DR4	_0x00A2.bit.b4
#define UART0DR_UART0DR3	_0x00A2.bit.b3
#define UART0DR_UART0DR2	_0x00A2.bit.b2
#define UART0DR_UART0DR1	_0x00A2.bit.b1
#define UART0DR_UART0DR0	_0x00A2.bit.b0

//==========================
//			UART0SR
//==========================
#define UART0SR    			_0x00A3.byte
#define UART0SR_PERR		_0x00A3.bit.b7
#define UART0SR_FERR		_0x00A3.bit.b6
#define UART0SR_OERR		_0x00A3.bit.b5
#define UART0SR_RBSY		_0x00A3.bit.b3
#define UART0SR_RBFL		_0x00A3.bit.b2
#define UART0SR_TBSY		_0x00A3.bit.b1
#define UART0SR_TBFL		_0x00A3.bit.b0

//==========================
//			RD0BUF
//==========================
#define RD0BUF     			_0x00A4.byte

//==========================
//			TD0BUF
//==========================
#define TD0BUF     			_0x00A5.byte

//==========================
//			UART1CR1
//==========================
#define UART1CR1   			_0x00A6.byte
#define UART1CR1_TXE		_0x00A6.bit.b7
#define UART1CR1_RXE		_0x00A6.bit.b6
#define UART1CR1_STOPBT		_0x00A6.bit.b5
#define UART1CR1_EVEN		_0x00A6.bit.b4
#define UART1CR1_PE			_0x00A6.bit.b3
#define UART1CR1_IRDASEL	_0x00A6.bit.b2
#define UART1CR1_BRG		_0x00A6.bit.b1

//==========================
//			UART1CR2
//==========================
#define UART1CR2   			_0x00A7.byte
#define UART1CR2_DV			_0x00A7.b7_6.b7_6
#define UART1CR2_RTSEL		_0x00A7.b5_3.b5_3
#define UART1CR2_RXDNC		_0x00A7.b2_1.b2_1
#define UART1CR2_STOPBR		_0x00A7.bit.b0

//==========================
//			UART1DR
//==========================
#define UART1DR    			_0x00A8.byte
#define UART1DR_UART1DR7	_0x00A8.bit.b7
#define UART1DR_UART1DR6	_0x00A8.bit.b6
#define UART1DR_UART1DR5	_0x00A8.bit.b5
#define UART1DR_UART1DR4	_0x00A8.bit.b4
#define UART1DR_UART1DR3	_0x00A8.bit.b3
#define UART1DR_UART1DR2	_0x00A8.bit.b2
#define UART1DR_UART1DR1	_0x00A8.bit.b1
#define UART1DR_UART1DR0	_0x00A8.bit.b0

//==========================
//			UART1SR
//==========================
#define UART1SR    			_0x00A9.byte
#define UART1SR_PERR		_0x00A9.bit.b7
#define UART1SR_FERR		_0x00A9.bit.b6
#define UART1SR_OERR		_0x00A9.bit.b5
#define UART1SR_RBSY		_0x00A9.bit.b3
#define UART1SR_RBFL		_0x00A9.bit.b2
#define UART1SR_TBSY		_0x00A9.bit.b1
#define UART1SR_TBFL		_0x00A9.bit.b0

//==========================
//			RD1BUF
//==========================
#define RD1BUF     			_0x00AA.byte

//==========================
//			TD1BUF
//==========================
#define TD1BUF     			_0x00AB.byte

//==========================
//			UART2CR1
//==========================
#define UART2CR1   			_0x00AC.byte
#define UART2CR1_TXE		_0x00AC.bit.b7
#define UART2CR1_RXE		_0x00AC.bit.b6
#define UART2CR1_STOPBT		_0x00AC.bit.b5
#define UART2CR1_EVEN		_0x00AC.bit.b4
#define UART2CR1_PE			_0x00AC.bit.b3
#define UART2CR1_IRDASEL	_0x00AC.bit.b2
#define UART2CR1_BRG		_0x00AC.bit.b1

//==========================
//			UART2CR2
//==========================
#define UART2CR2   			_0x00AD.byte
#define UART2CR2_DV 		_0x00AD.b7_6.b7_6
#define UART2CR2_RTSEL		_0x00AD.b5_3.b5_3
#define UART2CR2_RXDNC		_0x00AD.b2_1.b2_1
#define UART2CR2_STOPBR		_0x00AD.bit.b0

//==========================
//			UART2DR
//==========================
#define UART2DR    			_0x00AE.byte
#define UART2DR_UART2DR7	_0x00AE.bit.b7
#define UART2DR_UART2DR6	_0x00AE.bit.b6
#define UART2DR_UART2DR5	_0x00AE.bit.b5
#define UART2DR_UART2DR4	_0x00AE.bit.b4
#define UART2DR_UART2DR3	_0x00AE.bit.b3
#define UART2DR_UART2DR2	_0x00AE.bit.b2
#define UART2DR_UART2DR1	_0x00AE.bit.b1
#define UART2DR_UART2DR0	_0x00AE.bit.b0

//==========================
//			UART2SR
//==========================
#define UART2SR    			_0x00AF.byte
#define UART2SR_PERR		_0x00AF.bit.b7
#define UART2SR_FERR		_0x00AF.bit.b6
#define UART2SR_OERR		_0x00AF.bit.b5
#define UART2SR_RBSY		_0x00AF.bit.b3
#define UART2SR_RBFL		_0x00AF.bit.b2
#define UART2SR_TBSY		_0x00AF.bit.b1
#define UART2SR_TBFL		_0x00AF.bit.b0

//==========================
//			RD2BUF
//==========================
#define RD2BUF     			_0x00B0.byte

//==========================
//			TD2BUF
//==========================
#define TD2BUF     			_0x00B1.byte

//==========================
//			SBI0CR1
//==========================
#define SBI0CR1    			_0x00B8.byte
#define SBI0CR1_BC			_0x00B8.b7_5.b7_5
#define SBI0CR1_ACK			_0x00B8.bit.b4
#define SBI0CR1_NOACK		_0x00B8.bit.b3
#define SBI0CR1_SCK			_0x00B8.b2_0.b2_0

//==========================
//			SBI0CR2
//==========================
#define SBI0CR2    			_0x00B9.byte
#define SBI0CR2_MST			_0x00B9.bit.b7
#define SBI0CR2_TRX			_0x00B9.bit.b6
#define SBI0CR2_BB			_0x00B9.bit.b5
#define SBI0CR2_PIN			_0x00B9.bit.b4
#define SBI0CR2_SBIM		_0x00B9.bit.b3
#define SBI0CR2_SWRST		_0x00B9.b1_0.b1_0

//==========================
//			SBI0SR
//==========================
#define SBI0SR    			_0x00BA.byte
#define SBI0SR_MST			_0x00BA.bit.b7
#define SBI0SR_TRX			_0x00BA.bit.b6
#define SBI0SR_BB			_0x00BA.bit.b5
#define SBI0SR_PIN			_0x00BA.bit.b4
#define SBI0SR_AL			_0x00BA.bit.b3
#define SBI0SR_AAS			_0x00BA.bit.b2
#define SBI0SR_AD0			_0x00BA.bit.b1
#define SBI0SR_LRB			_0x00BA.bit.b0

//==========================
//			I2C0AR
//==========================
#define I2C0AR    			_0x00BB.byte
#define I2C0AR_SA			_0x00BB.b7_1.b7_1
#define I2C0AR_ALS			_0x00BB.bit.b0

//==========================
//			SBI0DBR
//==========================
#define SBI0DBR    			_0x00BC.byte
#define SBI0DBR_SBI0DBR		_0x00BC.byte

//==========================
//			SBI1CR1
//==========================
#define SBI1CR1    			_0x00BD.byte
#define SBI1CR1_BC			_0x00BD.b7_5.b7_5
#define SBI1CR1_ACK			_0x00BD.bit.b4
#define SBI1CR1_NOACK		_0x00BD.bit.b3
#define SBI1CR1_SCK			_0x00BD.b2_0.b2_0

//==========================
//			SBI1CR2
//==========================
#define SBI1CR2    			_0x00BE.byte
#define SBI1CR2_MST			_0x00BE.bit.b7
#define SBI1CR2_TRX			_0x00BE.bit.b6
#define SBI1CR2_BB			_0x00BE.bit.b5
#define SBI1CR2_PIN			_0x00BE.bit.b4
#define SBI1CR2_SBIM		_0x00BE.bit.b3
#define SBI1CR2_SWRST		_0x00BE.b1_0.b1_0

//==========================
//			SBI1SR
//==========================
#define SBI1SR    			_0x00BF.byte
#define SBI1SR_MST			_0x00BF.bit.b7
#define SBI1SR_TRX			_0x00BF.bit.b6
#define SBI1SR_BB			_0x00BF.bit.b5
#define SBI1SR_PIN			_0x00BF.bit.b4
#define SBI1SR_AL			_0x00BF.bit.b3
#define SBI1SR_AAS			_0x00BF.bit.b2
#define SBI1SR_AD0			_0x00BF.bit.b1
#define SBI1SR_LRB			_0x00BF.bit.b0

//==========================
//			I2C1AR
//==========================
#define I2C1AR 	   			_0x00C0.byte
#define I2C1AR_SA			_0x00C0.b7_1.b7_1
#define I2C1AR_ALS			_0x00C0.bit.b0

//==========================
//			SBI1DBR
//==========================
#define SBI1DBR    			_0x00C1.byte
#define SBI1DBR_SBI1DBR		_0x00C1.byte


//==========================
//			SIO0CR1
//==========================
#define SIO0CR1    			_0x00D0.byte
#define SIO0CR1_SIOEDG		_0x00D0.bit.b7
#define SIO0CR1_SIOCKS		_0x00D0.b6_4.b6_4
#define SIO0CR1_SIODIR		_0x00D0.bit.b3
#define SIO0CR1_SIOS		_0x00D0.bit.b2
#define SIO0CR1_SIOM		_0x00D0.b1_0.b1_0 

//==========================
//			SIO0CR2
//==========================
#define SIO0CR2    			_0x00D1.byte
#define SIO0CR2_SPIEN		_0x00D1.bit.b0

//==========================
//			SIO0SR
//==========================
#define SIO0SR     			_0x00D2.byte
#define SIO0SR_SIOF			_0x00D2.bit.b7
#define SIO0SR_SEF			_0x00D2.bit.b6
#define SIO0SR_OERR			_0x00D2.bit.b5
#define SIO0SR_RENDB		_0x00D2.bit.b4
#define SIO0SR_UERR			_0x00D2.bit.b3
#define SIO0SR_TBFL			_0x00D2.bit.b2

//==========================
//			SIO0BUF
//==========================
#define SIO0BUF    			_0x00D3.byte

//==========================
//			SIO1CR1
//==========================
#define SIO1CR1    			_0x00D4.byte
#define SIO1CR1_SIOEDG		_0x00D4.bit.b7
#define SIO1CR1_SIOCKS		_0x00D4.b6_4.b6_4
#define SIO1CR1_SIODIR		_0x00D4.bit.b3
#define SIO1CR1_SIOS		_0x00D4.bit.b2
#define SIO1CR1_SIOM		_0x00D4.b1_0.b1_0

//==========================
//			SIO1CR2
//==========================
#define SIO1CR2   			_0x00D5.byte
#define SIO1CR2_SPIEN		_0x00D5.bit.b0

//==========================
//			SIO1SR
//==========================
#define SIO1SR     			_0x00D6.byte
#define SIO1SR_SIOF			_0x00D6.bit.b7
#define SIO1SR_SEF			_0x00D6.bit.b6
#define SIO1SR_OERR			_0x00D6.bit.b5
#define SIO1SR_RENDB		_0x00D6.bit.b4
#define SIO1SR_UERR			_0x00D6.bit.b3
#define SIO1SR_TBFL			_0x00D6.bit.b2

//==========================
//			SIO1BUF
//==========================
#define SIO1BUF    			_0x00D7.byte

//==========================
//			P0DO
//==========================
#define P0DO       			_0x00E0.byte
#define P0DO_P6 			_0x00E0.bit.b6
#define P0DO_P5 			_0x00E0.bit.b5
#define P0DO_P4 			_0x00E0.bit.b4
#define P0DO_P2 			_0x00E0.bit.b2
#define P0DO_P1 			_0x00E0.bit.b1
#define P0DO_P0 			_0x00E0.bit.b0

//==========================
//			P1DO
//==========================
#define P1DO            	_0x00E1.byte
#define P1DO_P7 			_0x00E1.bit.b7
#define P1DO_P6 			_0x00E1.bit.b6
#define P1DO_P5 			_0x00E1.bit.b5
#define P1DO_P4 			_0x00E1.bit.b4
#define P1DO_P3 			_0x00E1.bit.b3
#define P1DO_P2 			_0x00E1.bit.b2
#define P1DO_P1 			_0x00E1.bit.b1
#define P1DO_P0 			_0x00E1.bit.b0

//==========================
//			P2DO
//==========================
#define P2DO       			_0x00E2.byte
#define P2DO_P6 			_0x00E2.bit.b6
#define P2DO_P5 			_0x00E2.bit.b5
#define P2DO_P4 			_0x00E2.bit.b4
#define P2DO_P2 			_0x00E2.bit.b2
#define P2DO_P1 			_0x00E2.bit.b1
#define P2DO_P0 			_0x00E2.bit.b0

//==========================
//			P3DO
//==========================
#define P3DO       			_0x00E3.byte
#define P3DO_P7 			_0x00E3.bit.b7
#define P3DO_P6 			_0x00E3.bit.b6
#define P3DO_P5 			_0x00E3.bit.b5
#define P3DO_P4 			_0x00E3.bit.b4
#define P3DO_P3 			_0x00E3.bit.b3
#define P3DO_P2 			_0x00E3.bit.b2
#define P3DO_P1 			_0x00E3.bit.b1
#define P3DO_P0 			_0x00E3.bit.b0

//==========================
//			P4DO
//==========================
#define P4DO      			_0x00E4.byte
#define P4DO_P7 			_0x00E4.bit.b7
#define P4DO_P6 			_0x00E4.bit.b6
#define P4DO_P5 			_0x00E4.bit.b5
#define P4DO_P4 			_0x00E4.bit.b4
#define P4DO_P3 			_0x00E4.bit.b3
#define P4DO_P2 			_0x00E4.bit.b2
#define P4DO_P1 			_0x00E4.bit.b1
#define P4DO_P0 			_0x00E4.bit.b0

//==========================
//			P5DO
//==========================
#define P5DO       			_0x00E5.byte
#define P5DO_P4 			_0x00E5.bit.b4
#define P5DO_P3 			_0x00E5.bit.b3
#define P5DO_P2 			_0x00E5.bit.b2
#define P5DO_P1 			_0x00E5.bit.b1
#define P5DO_P0 			_0x00E5.bit.b0

//==========================
//			P0DI
//==========================
#define P0DI       			_0x00F0.byte
#define P0DI_P6 			_0x00F0.bit.b6
#define P0DI_P5 			_0x00F0.bit.b5
#define P0DI_P4 			_0x00F0.bit.b4
#define P0DI_P2 			_0x00F0.bit.b2
#define P0DI_P1 			_0x00F0.bit.b1
#define P0DI_P0 			_0x00F0.bit.b0

//==========================
//			P1DI
//==========================
#define P1DI       			_0x00F1.byte
#define P1DI_P7 			_0x00F1.bit.b7
#define P1DI_P6 			_0x00F1.bit.b6
#define P1DI_P5 			_0x00F1.bit.b5
#define P1DI_P4 			_0x00F1.bit.b4
#define P1DI_P3 			_0x00F1.bit.b3
#define P1DI_P2 			_0x00F1.bit.b2
#define P1DI_P1 			_0x00F1.bit.b1
#define P1DI_P0 			_0x00F1.bit.b0

//==========================
//			P2DI
//==========================
#define P2DI       			_0x00F2.byte
#define P2DI_P6 			_0x00F2.bit.b6
#define P2DI_P5 			_0x00F2.bit.b5
#define P2DI_P4 			_0x00F2.bit.b4
#define P2DI_P2 			_0x00F2.bit.b2
#define P2DI_P1 			_0x00F2.bit.b1
#define P2DI_P0 			_0x00F2.bit.b0

//==========================
//			P3DI
//==========================
#define P3DI       			_0x00F3.byte
#define P3DI_P7 			_0x00F3.bit.b7
#define P3DI_P6 			_0x00F3.bit.b6
#define P3DI_P5 			_0x00F3.bit.b5
#define P3DI_P4 			_0x00F3.bit.b4
#define P3DI_P3 			_0x00F3.bit.b3
#define P3DI_P2 			_0x00F3.bit.b2
#define P3DI_P1 			_0x00F3.bit.b1
#define P3DI_P0 			_0x00F3.bit.b0

//==========================
//			P4DI
//==========================
#define P4DI       			_0x00F4.byte
#define P4DI_P7 			_0x00F4.bit.b7
#define P4DI_P6 			_0x00F4.bit.b6
#define P4DI_P5 			_0x00F4.bit.b5
#define P4DI_P4 			_0x00F4.bit.b4
#define P4DI_P3 			_0x00F4.bit.b3
#define P4DI_P2 			_0x00F4.bit.b2
#define P4DI_P1 			_0x00F4.bit.b1
#define P4DI_P0 			_0x00F4.bit.b0

//==========================
//			P5DI
//==========================
#define P5DI       			_0x00F5.byte
#define P5DI_P4 			_0x00F5.bit.b4
#define P5DI_P3 			_0x00F5.bit.b3
#define P5DI_P2 			_0x00F5.bit.b2
#define P5DI_P1 			_0x00F5.bit.b1
#define P5DI_P0 			_0x00F5.bit.b0

//==========================
//			P0OE
//==========================
#define P0OE       			_0x0100.byte
#define P0OE_P6 			_0x0100.bit.b6
#define P0OE_P5 			_0x0100.bit.b5
#define P0OE_P4 			_0x0100.bit.b4
#define P0OE_P2 			_0x0100.bit.b2
#define P0OE_P1 			_0x0100.bit.b1
#define P0OE_P0 			_0x0100.bit.b0

//==========================
//			P1OE
//==========================
#define P1OE       			_0x0101.byte
#define P1OE_P7 			_0x0101.bit.b7
#define P1OE_P6 			_0x0101.bit.b6
#define P1OE_P5 			_0x0101.bit.b5
#define P1OE_P4 			_0x0101.bit.b4
#define P1OE_P3 			_0x0101.bit.b3
#define P1OE_P2 			_0x0101.bit.b2
#define P1OE_P1 			_0x0101.bit.b1
#define P1OE_P0 			_0x0101.bit.b0

//==========================
//			P2OE
//==========================
#define P2OE       			_0x0102.byte
#define P2OE_P6 			_0x0102.bit.b6
#define P2OE_P5 			_0x0102.bit.b5
#define P2OE_P4  			_0x0102.bit.b4
#define P2OE_P2 			_0x0102.bit.b2
#define P2OE_P1 			_0x0102.bit.b1
#define P2OE_P0 			_0x0102.bit.b0

//==========================
//			P3OE
//==========================
#define P3OE       			_0x0103.byte
#define P3OE_P7 			_0x0103.bit.b7
#define P3OE_P6 			_0x0103.bit.b6
#define P3OE_P5 			_0x0103.bit.b5
#define P3OE_P4 			_0x0103.bit.b4
#define P3OE_P3 			_0x0103.bit.b3
#define P3OE_P2 			_0x0103.bit.b2
#define P3OE_P1 			_0x0103.bit.b1
#define P3OE_P0 			_0x0103.bit.b0

//==========================
//			P4OE
//==========================
#define P4OE       			_0x0104.byte
#define P4OE_P7 			_0x0104.bit.b7
#define P4OE_P6 			_0x0104.bit.b6
#define P4OE_P5 			_0x0104.bit.b5
#define P4OE_P4 			_0x0104.bit.b4
#define P4OE_P3 			_0x0104.bit.b3
#define P4OE_P2 			_0x0104.bit.b2
#define P4OE_P1 			_0x0104.bit.b1
#define P4OE_P0 			_0x0104.bit.b0

//==========================
//			P5OE
//==========================
#define P5OE       			_0x0105.byte
#define P5OE_P4 			_0x0105.bit.b4
#define P5OE_P3 			_0x0105.bit.b3
#define P5OE_P2 			_0x0105.bit.b2
#define P5OE_P1 			_0x0105.bit.b1
#define P5OE_P0 			_0x0105.bit.b0

//==========================
//			P0PU
//==========================
#define P0PU       			_0x0110.byte
#define P0PU_P6 			_0x0110.bit.b6
#define P0PU_P5 			_0x0110.bit.b5
#define P0PU_P4 			_0x0110.bit.b4
#define P0PU_P2 			_0x0110.bit.b2
#define P0PU_P1 			_0x0110.bit.b1
#define P0PU_P0 			_0x0110.bit.b0

//==========================
//			P1PU
//==========================
#define P1PU      			_0x0111.byte
#define P1PU_P7 			_0x0111.bit.b7
#define P1PU_P6 			_0x0111.bit.b6
#define P1PU_P5 			_0x0111.bit.b5
#define P1PU_P4 			_0x0111.bit.b4
#define P1PU_P3 			_0x0111.bit.b3
#define P1PU_P2 			_0x0111.bit.b2
#define P1PU_P1 			_0x0111.bit.b1
#define P1PU_P0 			_0x0111.bit.b0

//==========================
//			P2PU
//==========================
#define P2PU       			_0x0112.byte
#define P2PU_P6 			_0x0112.bit.b6
#define P2PU_P5 			_0x0112.bit.b5
#define P2PU_P4 			_0x0112.bit.b4
#define P2PU_P2 			_0x0112.bit.b2
#define P2PU_P1 			_0x0112.bit.b1
#define P2PU_P0 			_0x0112.bit.b0

//==========================
//			P3PU
//==========================
#define P3PU       			_0x0113.byte
#define P3PU_P7 			_0x0113.bit.b7
#define P3PU_P6 			_0x0113.bit.b6
#define P3PU_P5 			_0x0113.bit.b5
#define P3PU_P4 			_0x0113.bit.b4
#define P3PU_P3 			_0x0113.bit.b3
#define P3PU_P2 			_0x0113.bit.b2
#define P3PU_P1 			_0x0113.bit.b1
#define P3PU_P0 			_0x0113.bit.b0

//==========================
//			P4PU
//==========================
#define P4PU       			_0x0114.byte
#define P4PU_P7 			_0x0114.bit.b7
#define P4PU_P6 			_0x0114.bit.b6
#define P4PU_P5 			_0x0114.bit.b5
#define P4PU_P4 			_0x0114.bit.b4
#define P4PU_P3 			_0x0114.bit.b3
#define P4PU_P2 			_0x0114.bit.b2
#define P4PU_P1 			_0x0114.bit.b1
#define P4PU_P0 			_0x0114.bit.b0

//==========================
//			P5PU
//==========================
#define P5PU       			_0x0115.byte
#define P5PU_P4 			_0x0115.bit.b4
#define P5PU_P3 			_0x0115.bit.b3
#define P5PU_P2 			_0x0115.bit.b2
#define P5PU_P1 			_0x0115.bit.b1
#define P5PU_P0 			_0x0115.bit.b0


//==========================
//			P0PD
//==========================
#define P0PD       			_0x0120.byte
#define P0PD_P6 			_0x0120.bit.b6
#define P0PD_P5 			_0x0120.bit.b5
#define P0PD_P4 			_0x0120.bit.b4
#define P0PD_P2 			_0x0120.bit.b2
#define P0PD_P1 			_0x0120.bit.b1
#define P0PD_P0 			_0x0120.bit.b0

//==========================
//			P1PD
//==========================
#define P1PD       			_0x0121.byte
#define P1PD_P7 			_0x0121.bit.b7
#define P1PD_P6 			_0x0121.bit.b6
#define P1PD_P5 			_0x0121.bit.b5
#define P1PD_P4 			_0x0121.bit.b4
#define P1PD_P3 			_0x0121.bit.b3
#define P1PD_P2 			_0x0121.bit.b2
#define P1PD_P1 			_0x0121.bit.b1
#define P1PD_P0 			_0x0121.bit.b0

//==========================
//			P2PD
//==========================
#define P2PD       			_0x0122.byte
#define P2PD_P6 			_0x0122.bit.b6
#define P2PD_P5 			_0x0122.bit.b5
#define P2PD_P4 			_0x0122.bit.b4
#define P2PD_P2 			_0x0122.bit.b2
#define P2PD_P1 			_0x0122.bit.b1
#define P2PD_P0 			_0x0122.bit.b0

//==========================
//			P3PD
//==========================
#define P3PD       			_0x0123.byte
#define P3PD_P7 			_0x0123.bit.b7
#define P3PD_P6 			_0x0123.bit.b6
#define P3PD_P5 			_0x0123.bit.b5
#define P3PD_P4 			_0x0123.bit.b4
#define P3PD_P3 			_0x0123.bit.b3
#define P3PD_P2 			_0x0123.bit.b2
#define P3PD_P1 			_0x0123.bit.b1
#define P3PD_P0 			_0x0123.bit.b0

//==========================
//			P4PD
//==========================
#define P4PD       			_0x0124.byte
#define P4PD_P7 			_0x0124.bit.b7
#define P4PD_P6 			_0x0124.bit.b6
#define P4PD_P5 			_0x0124.bit.b5
#define P4PD_P4 			_0x0124.bit.b4
#define P4PD_P3 			_0x0124.bit.b3
#define P4PD_P2 			_0x0124.bit.b2
#define P4PD_P1 			_0x0124.bit.b1
#define P4PD_P0 			_0x0124.bit.b0

//==========================
//			P5PD
//==========================
#define P5PD       			_0x0125.byte
#define P5PD_P4 			_0x0125.bit.b4
#define P5PD_P3 			_0x0125.bit.b3
#define P5PD_P2 			_0x0125.bit.b2
#define P5PD_P1 			_0x0125.bit.b1
#define P5PD_P0 			_0x0125.bit.b0

//==========================
//			P0DSEL
//==========================
// #define P0DSEL     	    _0x0130.byte
// #define P0DSEL_P6		_0x0130.bit.b6
// #define P0DSEL_P5		_0x0130.bit.b5
// #define P0DSEL_P4		_0x0130.bit.b4
// #define P0DSEL_P2		_0x0130.bit.b2
// #define P0DSEL_P1		_0x0130.bit.b1
// #define P0DSEL_P0		_0x0130.bit.b0

//==========================
//			P1DSEL
//==========================
// #define P1DSEL     		_0x0131.byte
// #define P1DSEL_P7		_0x0131.bit.b7
// #define P1DSEL_P6		_0x0131.bit.b6
// #define P1DSEL_P5		_0x0131.bit.b5
// #define P1DSEL_P4		_0x0131.bit.b4
// #define P1DSEL_P3		_0x0131.bit.b3
// #define P1DSEL_P2		_0x0131.bit.b2
// #define P1DSEL_P1		_0x0131.bit.b1
// #define P1DSEL_P0		_0x0131.bit.b0

//==========================
//			P2DSEL
//==========================
// #define P2DSEL     		_0x0132.byte
// #define P2DSEL_P6		_0x0132.bit.b6
// #define P2DSEL_P5		_0x0132.bit.b5
// #define P2DSEL_P4		_0x0132.bit.b4
// #define P2DSEL_P2		_0x0132.bit.b2
// #define P2DSEL_P1		_0x0132.bit.b1
// #define P2DSEL_P0		_0x0132.bit.b0

//==========================
//			P3DSEL
//==========================
// #define P3DSEL     		_0x0133.byte
// #define P3DSEL_P7		_0x0133.bit.b7
// #define P3DSEL_P6		_0x0133.bit.b6
// #define P3DSEL_P5		_0x0133.bit.b5
// #define P3DSEL_P4		_0x0133.bit.b4
// #define P3DSEL_P3		_0x0133.bit.b3
// #define P3DSEL_P2		_0x0133.bit.b2
// #define P3DSEL_P1		_0x0133.bit.b1
// #define P3DSEL_P0		_0x0133.bit.b0

//==========================
//			P4DSEL
//==========================
// #define P4DSEL     		_0x0134.byte
// #define P4DSEL_P7		_0x0134.bit.b7
// #define P4DSEL_P6		_0x0134.bit.b6
// #define P4DSEL_P5		_0x0134.bit.b5
// #define P4DSEL_P4		_0x0134.bit.b4
// #define P4DSEL_P3		_0x0134.bit.b3
// #define P4DSEL_P2		_0x0134.bit.b2
// #define P4DSEL_P1		_0x0134.bit.b1
// #define P4DSEL_P0		_0x0134.bit.b0

//==========================
//			P5DSEL
//==========================
// #define P5DSEL     		_0x0135.byte
// #define P5DSEL_P4		_0x0135.bit.b4
// #define P5DSEL_P3		_0x0135.bit.b3
// #define P5DSEL_P2		_0x0135.bit.b2
// #define P5DSEL_P1		_0x0135.bit.b1
// #define P5DSEL_P0		_0x0135.bit.b0


//==========================
//			P0FC1
//==========================
#define P0FC1      			_0x0140.byte
#define P0FC1_P6			_0x0140.bit.b6
#define P0FC1_P5			_0x0140.bit.b5
#define P0FC1_P4			_0x0140.bit.b4
#define P0FC1_P2			_0x0140.bit.b2
#define P0FC1_P1			_0x0140.bit.b1
#define P0FC1_P0			_0x0140.bit.b0

//==========================
//			P1FC1
//==========================
#define P1FC1      			_0x0141.byte
#define P1FC1_P7			_0x0141.bit.b7
#define P1FC1_P6			_0x0141.bit.b6
#define P1FC1_P5			_0x0141.bit.b5
#define P1FC1_P4			_0x0141.bit.b4
#define P1FC1_P3			_0x0141.bit.b3
#define P1FC1_P2			_0x0141.bit.b2
#define P1FC1_P1			_0x0141.bit.b1
#define P1FC1_P0			_0x0141.bit.b0

//==========================
//			P2FC1
//==========================
#define P2FC1      			_0x0142.byte
#define P2FC1_P6			_0x0142.bit.b6
#define P2FC1_P5			_0x0142.bit.b5
#define P2FC1_P4			_0x0142.bit.b4
#define P2FC1_P2			_0x0142.bit.b2
#define P2FC1_P1			_0x0142.bit.b1
#define P2FC1_P0			_0x0142.bit.b0

//==========================
//			P3FC1
//==========================
#define P3FC1				_0x0143.byte
#define P3FC1_P7			_0x0143.bit.b7
#define P3FC1_P6			_0x0143.bit.b6
#define P3FC1_P5			_0x0143.bit.b5
#define P3FC1_P4			_0x0143.bit.b4
#define P3FC1_P3			_0x0143.bit.b3
#define P3FC1_P2			_0x0143.bit.b2
#define P3FC1_P1			_0x0143.bit.b1
#define P3FC1_P0			_0x0143.bit.b0

//==========================
//			P4FC1
//==========================
#define P4FC1      			_0x0144.byte
#define P4FC1_P7			_0x0144.bit.b7
#define P4FC1_P6			_0x0144.bit.b6
#define P4FC1_P5			_0x0144.bit.b5
#define P4FC1_P4			_0x0144.bit.b4
#define P4FC1_P3			_0x0144.bit.b3
#define P4FC1_P2			_0x0144.bit.b2
#define P4FC1_P1			_0x0144.bit.b1
#define P4FC1_P0			_0x0144.bit.b0

//==========================
//			P5FC1
//==========================
#define P5FC1      			_0x0145.byte
#define P5FC1_P4			_0x0145.bit.b4
#define P5FC1_P3			_0x0145.bit.b3
#define P5FC1_P2			_0x0145.bit.b2
#define P5FC1_P1			_0x0145.bit.b1
#define P5FC1_P0			_0x0145.bit.b0


//==========================
//			P0FC2
//==========================
#define P0FC2      			_0x0150.byte
#define P0FC2_P6			_0x0150.bit.b6
#define P0FC2_P5			_0x0150.bit.b5
#define P0FC2_P4			_0x0150.bit.b4
#define P0FC2_P2			_0x0150.bit.b2
#define P0FC2_P1			_0x0150.bit.b1
#define P0FC2_P0			_0x0150.bit.b0

//==========================
//			P1FC2
//==========================
#define P1FC2      			_0x0151.byte
#define P1FC2_P7			_0x0151.bit.b7
#define P1FC2_P6			_0x0151.bit.b6
#define P1FC2_P5			_0x0151.bit.b5
#define P1FC2_P4			_0x0151.bit.b4
#define P1FC2_P3			_0x0151.bit.b3
#define P1FC2_P2			_0x0151.bit.b2
#define P1FC2_P1			_0x0151.bit.b1
#define P1FC2_P0			_0x0151.bit.b0

//==========================
//			P2FC2
//==========================
#define P2FC2      			_0x0152.byte
#define P2FC2_P6			_0x0152.bit.b6
#define P2FC2_P5			_0x0152.bit.b5
#define P2FC2_P4			_0x0152.bit.b4
#define P2FC2_P2			_0x0152.bit.b2
#define P2FC2_P1			_0x0152.bit.b1
#define P2FC2_P0			_0x0152.bit.b0

//==========================
//			P3FC2
//==========================
#define P3FC2      			_0x0153.byte
#define P3FC2_P7			_0x0153.bit.b7
#define P3FC2_P6			_0x0153.bit.b6
#define P3FC2_P5			_0x0153.bit.b5
#define P3FC2_P4			_0x0153.bit.b4
#define P3FC2_P3			_0x0153.bit.b3
#define P3FC2_P2			_0x0153.bit.b2
#define P3FC2_P1			_0x0153.bit.b1
#define P3FC2_P0			_0x0153.bit.b0

//==========================
//			P4FC2
//==========================
#define P4FC2      			_0x0154.byte
#define P4FC2_P7			_0x0154.bit.b7
#define P4FC2_P6			_0x0154.bit.b6
#define P4FC2_P5			_0x0154.bit.b5
#define P4FC2_P4			_0x0154.bit.b4
#define P4FC2_P3			_0x0154.bit.b3
#define P4FC2_P2			_0x0154.bit.b2
#define P4FC2_P1			_0x0154.bit.b1
#define P4FC2_P0			_0x0154.bit.b0

//==========================
//			P5FC2
//==========================
#define P5FC2      			_0x0155.byte
#define P5FC2_P4			_0x0155.bit.b4
#define P5FC2_P3			_0x0155.bit.b3
#define P5FC2_P2			_0x0155.bit.b2
#define P5FC2_P1			_0x0155.bit.b1
#define P5FC2_P0			_0x0155.bit.b0


//==========================
//			FSELR0
//==========================
#define FSELR0     			_0x0160.byte

//==========================
//			FSELR1
//==========================
#define FSELR1     			_0x0161.byte

//==========================
//			FSELR2
//==========================
#define FSELR2     			_0x0162.byte

//==========================
//			FSELR3
//==========================
#define FSELR3     			_0x0163.byte

//==========================
//			FSELR4
//==========================
#define FSELR4     			_0x0164.byte

//==========================
//			FSELR5
//==========================
#define FSELR5     			_0x0165.byte

//==========================
//			PCSELR0
//==========================
#define PCSELR0    			_0x016C.byte
#define PCSELR0_UART2		_0x016C.b5_4.b5_4
#define PCSELR0_UART1		_0x016C.b3_2.b3_2
#define PCSELR0_UART0		_0x016C.b1_0.b1_0

//==========================
//			PCSELR1
//==========================
#define PCSELR1    			_0x016D.byte
#define PCSELR1_I2C1		_0x016D.b3_2.b3_2
#define PCSELR1_I2C0		_0x016D.b1_0.b1_0

//==========================
//			PCSELR2
//==========================
#define PCSELR2    			_0x016E.byte
#define PCSELR2_SIO1		_0x016E.b3_2.b3_2
#define PCSELR2_SIO0		_0x016E.b1_0.b1_0

//==========================
//			PCSELR3
//==========================
//#define PCSELR3    		_0x016F.byte

//==========================
//			PCSELR4
//==========================
#define PCSELR4    			_0x0170.byte
#define PCSELR4_TCA3		_0x0170.b7_6.b7_6
#define PCSELR4_TCA2		_0x0170.b5_4.b5_4
#define PCSELR4_TCA1		_0x0170.b3_2.b3_2
#define PCSELR4_TCA0		_0x0170.b1_0.b1_0

//==========================
//			PCSELR5
//==========================
#define PCSELR5    			_0x0171.byte
#define PCSELR5_TCA7		_0x0171.b7_6.b7_6
#define PCSELR5_TCA6		_0x0171.b5_4.b5_4
#define PCSELR5_TCA5		_0x0171.b3_2.b3_2
#define PCSELR5_TCA4		_0x0171.b1_0.b1_0

//==========================
//			PCKEN0
//==========================
#define PCKEN0     			_0x0178.byte
#define PCKEN0_TCA3			_0x0178.bit.b7
#define PCKEN0_TCA2			_0x0178.bit.b6
#define PCKEN0_TCA1			_0x0178.bit.b5
#define PCKEN0_TCA0			_0x0178.bit.b4

//==========================
//			PCKEN1
//==========================
#define PCKEN1     			_0x0179.byte
#define PCKEN1_UART2		_0x0179.bit.b6
#define PCKEN1_UART1		_0x0179.bit.b5
#define PCKEN1_UART0		_0x0179.bit.b4
#define PCKEN1_TCA7			_0x0179.bit.b3
#define PCKEN1_TCA6			_0x0179.bit.b2
#define PCKEN1_TCA5			_0x0179.bit.b1
#define PCKEN1_TCA4			_0x0179.bit.b0

//==========================
//			PCKEN2
//==========================
#define PCKEN2     			_0x017A.byte
#define PCKEN2_SIO1			_0x017A.bit.b5
#define PCKEN2_SIO0			_0x017A.bit.b4
#define PCKEN2_I2C1			_0x017A.bit.b1
#define PCKEN2_I2C0			_0x017A.bit.b0

//==========================
//			PCKEN3
//==========================
#define PCKEN3     			_0x017B.byte
#define PCKEN3_EINT7		_0x017B.bit.b7
#define PCKEN3_EINT6		_0x017B.bit.b6
#define PCKEN3_EINT5		_0x017B.bit.b5
#define PCKEN3_EINT4		_0x017B.bit.b4
#define PCKEN3_EINT3		_0x017B.bit.b3
#define PCKEN3_EINT2		_0x017B.bit.b2
#define PCKEN3_EINT1		_0x017B.bit.b1
#define PCKEN3_EINT0		_0x017B.bit.b0

//==========================
//			PCKEN4
//==========================
#define PCKEN4     			_0x017C.byte

//==========================
//			PCKEN5
//==========================
#define PCKEN5     			_0x017D.byte
#define PCKEN5_MAC			_0x017D.bit.b1

//==========================
//			PCKEN6
//==========================
#define PCKEN6     			_0x017E.byte
#define PCKEN6_ADC			_0x017E.bit.b2
#define PCKEN6_RTC			_0x017E.bit.b1

//==========================
//			PCKEN7
//==========================
#define PCKEN7     			_0x017F.byte
#define PCKEN7_CRC			_0x017F.bit.b1

//==========================
//			PRSTR7
//==========================
#define PRSTR7     			_0x0187.byte

//==========================
//			KWUCR0
//==========================
#define KWUCR0     			_0x0188.byte
#define KWUCR0_KW3LE    	_0x0188.bit.b7
#define KWUCR0_KW3EN    	_0x0188.bit.b6
#define KWUCR0_KW2LE    	_0x0188.bit.b5
#define KWUCR0_KW2EN    	_0x0188.bit.b4
#define KWUCR0_KW1LE    	_0x0188.bit.b3
#define KWUCR0_KW1EN    	_0x0188.bit.b2
#define KWUCR0_KW0LE    	_0x0188.bit.b1
#define KWUCR0_KW0EN    	_0x0188.bit.b0


//==========================
//			KWUCR1
//==========================
#define KWUCR1     			_0x0189.byte
#define KWUCR1_KW7LE    	_0x0189.bit.b7                        
#define KWUCR1_KW7EN    	_0x0189.bit.b6
#define KWUCR1_KW6LE    	_0x0189.bit.b5                        
#define KWUCR1_KW6EN    	_0x0189.bit.b4
#define KWUCR1_KW5LE    	_0x0189.bit.b3                       
#define KWUCR1_KW5EN    	_0x0189.bit.b2
#define KWUCR1_KW4LE    	_0x0189.bit.b1                        
#define KWUCR1_KW4EN    	_0x0189.bit.b0

//==========================
//			KWUSR0
//==========================
#define KWUSR0   			_0x018C.byte
#define KWUSR0_KWU3     	_0x018C.b7_6.b7_6
#define KWUSR0_KWU2     	_0x018C.b5_4.b5_4
#define KWUSR0_KWU1     	_0x018C.b3_2.b3_2
#define KWUSR0_KWU0     	_0x018C.b1_0.b1_0

//==========================
//			KWUSR1
//==========================
#define KWUSR1   			_0x018D.byte
#define KWUSR1_KWU7     	_0x018D.b7_6.b7_6
#define KWUSR1_KWU6     	_0x018D.b5_4.b5_4
#define KWUSR1_KWU5     	_0x018D.b3_2.b3_2
#define KWUSR1_KWU4     	_0x018D.b1_0.b1_0


//==========================
//			EINTCR0
//==========================
#define EINTCR0    			_0x0190.byte
#define EINTCR0_INTSEL		_0x0190.b7_5.b7_5
#define EINTCR0_INTLVL		_0x0190.bit.b4
#define EINTCR0_INTES		_0x0190.b3_2.b3_2
#define EINTCR0_INTINC		_0x0190.b1_0.b1_0

//==========================
//			EINTCR1
//==========================
#define EINTCR1    			_0x0191.byte
#define EINTCR1_INTSEL		_0x0191.b7_5.b7_5
#define EINTCR1_INTLVL		_0x0191.bit.b4
#define EINTCR1_INTES		_0x0191.b3_2.b3_2
#define EINTCR1_INTINC		_0x0191.b1_0.b1_0

//==========================
//			EINTCR2
//==========================
#define EINTCR2    			_0x0192.byte
#define EINTCR2_INTSEL		_0x0192.b7_5.b7_5
#define EINTCR2_INTLVL		_0x0192.bit.b4
#define EINTCR2_INTES		_0x0192.b3_2.b3_2
#define EINTCR2_INTINC		_0x0192.b1_0.b1_0

//==========================
//			EINTCR3
//==========================
#define EINTCR3    			_0x0193.byte
#define EINTCR3_INTSEL		_0x0193.b7_5.b7_5
#define EINTCR3_INTLVL		_0x0193.bit.b4
#define EINTCR3_INTES		_0x0193.b3_2.b3_2
#define EINTCR3_INTINC		_0x0193.b1_0.b1_0

//==========================
//			EINTCR4
//==========================
#define EINTCR4    			_0x0194.byte
#define EINTCR4_INTSEL		_0x0194.b7_5.b7_5
#define EINTCR4_INTLVL		_0x0194.bit.b4
#define EINTCR4_INTES		_0x0194.b3_2.b3_2
#define EINTCR4_INTINC		_0x0194.b1_0.b1_0

//==========================
//			EINTCR5
//==========================
#define EINTCR5    			_0x0195.byte
#define EINTCR5_INTSEL		_0x0195.b7_5.b7_5
#define EINTCR5_INTLVL		_0x0195.bit.b4
#define EINTCR5_INTES		_0x0195.b3_2.b3_2
#define EINTCR5_INTINC		_0x0195.b1_0.b1_0

//==========================
//			EINTCR6
//==========================
#define EINTCR6    			_0x0196.byte
#define EINTCR6_INTSEL		_0x0196.b7_5.b7_5
#define EINTCR6_INTLVL		_0x0196.bit.b4
#define EINTCR6_INTES		_0x0196.b3_2.b3_2
#define EINTCR6_INTINC		_0x0196.b1_0.b1_0

//==========================
//			EINTCR7
//==========================
#define EINTCR7    			_0x0197.byte
#define EINTCR7_INTSEL		_0x0197.b7_5.b7_5
#define EINTCR7_INTLVL		_0x0197.bit.b4
#define EINTCR7_INTES		_0x0197.b3_2.b3_2
#define EINTCR7_INTINC		_0x0197.b1_0.b1_0



//==========================
//			IFR0
//==========================
#define IFR0      			_0x01A0.byte
#define IFR_TBT				_0x01A0.bit.b7
#define IFR_CFD				_0x01A0.bit.b5
#define IFR_LVD				_0x01A0.bit.b4
#define IFR_WDT				_0x01A0.bit.b3
#define IFR_UNDEF			_0x01A0.bit.b2
#define IFR_SWI				_0x01A0.bit.b1
#define IFR_RESET			_0x01A0.bit.b0

//==========================
//			IFR1
//==========================
#define IFR1       			_0x01A1.byte
#define IFR_TCA1			_0x01A1.bit.b4
#define IFR_TCA0			_0x01A1.bit.b3
#define IFR_RTC				_0x01A1.bit.b0

//==========================
//			IFR2
//==========================
#define IFR2       			_0x01A2.byte
#define IFR_EXT3			_0x01A2.bit.b7
#define IFR_EXT2			_0x01A2.bit.b6
#define IFR_EXT1			_0x01A2.bit.b5
#define IFR_EXT0			_0x01A2.bit.b4
#define IFR_SIO0			_0x01A2.bit.b3
#define IFR_I2C0			_0x01A2.bit.b2
#define IFR_UART0_TX		_0x01A2.bit.b1
#define IFR_UART0_RX		_0x01A2.bit.b0

//==========================
//			IFR3
//==========================
#define IFR3       			_0x01A3.byte
#define IFR_FMC				_0x01A3.bit.b5
#define IFR_ADC				_0x01A3.bit.b0

//==========================
//			IFR4
//==========================
#define IFR4       			_0x01A4.byte
#define IFR_DIC				_0x01A4.bit.b7

//==========================
//			IFR5
//==========================
#define IFR5       			_0x01A5.byte
#define IFR_MAC				_0x01A5.bit.b7
#define IFR_EXT7			_0x01A5.bit.b6
#define IFR_EXT6			_0x01A5.bit.b5
#define IFR_EXT5			_0x01A5.bit.b4
#define IFR_EXT4			_0x01A5.bit.b3


//==========================
//			IFR6
//==========================
#define IFR6       			_0x01A6.byte
#define IFR_UART1_TX1		_0x01A6.bit.b7
#define IFR_UART1_RX1		_0x01A6.bit.b6
#define IFR_TCA3			_0x01A6.bit.b2
#define IFR_TCA2			_0x01A6.bit.b1

//==========================
//			IFR7
//==========================
#define IFR7       			_0x01A7.byte
#define IFR_SIO1			_0x01A7.bit.b1
#define IFR_I2C1			_0x01A7.bit.b0

//==========================
//			IFR8
//==========================
#define IFR8       			_0x01A8.byte
#define IFR_TCA5			_0x01A8.bit.b4
#define IFR_TCA4			_0x01A8.bit.b3

//==========================
//			IFR9
//==========================
#define IFR9       			_0x01A9.byte
#define IFR_UART2_TX2		_0x01A9.bit.b1
#define IFR_UART2_RX2		_0x01A9.bit.b0

//==========================
//			IFR10
//==========================
#define IFR10      			_0x01AA.byte
#define IFR_TCA7			_0x01AA.bit.b3
#define IFR_TCA6			_0x01AA.bit.b2

//==========================
//			IFR11
//==========================
#define IFR11      			_0x01AB.byte

//==========================
//			IER0
//==========================
#define IER0       			_0x01B0.byte
#define IER_TBT				_0x01B0.bit.b7
#define IER_CFD				_0x01B0.bit.b5
#define IER_LVD				_0x01B0.bit.b4

//==========================
//			IER1
//==========================
#define IER1       			_0x01B1.byte
#define IER_TCA1			_0x01B1.bit.b4
#define IER_TCA0			_0x01B1.bit.b3
#define IER_RTC				_0x01B1.bit.b0

//==========================
//			IER2
//==========================
#define IER2       			_0x01B2.byte
#define IER_EXT3			_0x01B2.bit.b7
#define IER_EXT2			_0x01B2.bit.b6
#define IER_EXT1			_0x01B2.bit.b5
#define IER_EXT0			_0x01B2.bit.b4
#define IER_SIO0			_0x01B2.bit.b3
#define IER_I2C0			_0x01B2.bit.b2
#define IER_UART0_TX		_0x01B2.bit.b1
#define IER_UART0_RX		_0x01B2.bit.b0

//==========================
//			IER3
//==========================
#define IER3       			_0x01B3.byte
#define IER_FMC				_0x01B3.bit.b5
#define IER_ADC				_0x01B3.bit.b0

//==========================
//			IER4
//==========================
#define IER4       			_0x01B4.byte

#define IER_DIC				_0x01B4.bit.b7

//==========================
//			IER5
//==========================
#define IER5       			_0x01B5.byte
#define IER_MAC				_0x01B5.bit.b7
#define IER_EXT7			_0x01B5.bit.b6
#define IER_EXT6			_0x01B5.bit.b5
#define IER_EXT5			_0x01B5.bit.b4
#define IER_EXT4			_0x01B5.bit.b3

//==========================
//			IER6
//==========================
#define IER6       			_0x01B6.byte
#define IER_UART1_TX1		_0x01B6.bit.b7
#define IER_UART1_RX1		_0x01B6.bit.b6
#define IER_TCA3			_0x01B6.bit.b2
#define IER_TCA2			_0x01B6.bit.b1

//==========================
//			IER7
//==========================
#define IER7       			_0x01B7.byte
#define IER_SIO1			_0x01B7.bit.b1
#define IER_I2C1			_0x01B7.bit.b0

//==========================
//			IER8
//==========================
#define IER8       			_0x01B8.byte
#define IER_TCA5			_0x01B8.bit.b4
#define IER_TCA4			_0x01B8.bit.b3

//==========================
//			IER9
//==========================
#define IER9       			_0x01B9.byte
#define IER_UART2_TX2		_0x01B9.bit.b1
#define IER_UART2_RX2		_0x01B9.bit.b0

//==========================
//			IER10
//==========================
#define IER10     			_0x01BA.byte
#define IER_TCA7			_0x01BA.bit.b3
#define IER_TCA6			_0x01BA.bit.b2

//==========================
//			IER11
//==========================
#define IER11      			_0x01BB.byte

//==========================
//			IPR0
//==========================
#define IPR0       			_0x01C0.byte

//==========================
//			IPR1
//==========================
#define IPR1       			_0x01C1.byte
#define IPR_TBT				_0x01C1.b7_6.b7_6
#define IPR_CFD				_0x01C1.b3_2.b3_2
#define IPR_LVD				_0x01C1.b1_0.b1_0

//==========================
//			IPR2
//==========================
#define IPR2       			_0x01C2.byte
#define IPR_TCA0			_0x01C2.b7_6.b7_6
#define IPR_RTC				_0x01C2.b1_0.b1_0

//==========================
//			IPR3
//==========================
#define IPR3       			_0x01C3.byte

#define IPR_TCA1			_0x01C3.b1_0.b1_0

//==========================
//			IPR4
//==========================
#define IPR4       			_0x01C4.byte
#define IPR_SIO0			_0x01C4.b7_6.b7_6
#define IPR_I2C0			_0x01C4.b5_4.b5_4
#define IPR_UART0_TX		_0x01C4.b3_2.b3_2
#define IPR_UART0_RX		_0x01C4.b1_0.b1_0

//==========================
//			IPR5
//==========================
#define IPR5       			_0x01C5.byte
#define IPR_EXT3			_0x01C5.b7_6.b7_6
#define IPR_EXT2			_0x01C5.b5_4.b5_4
#define IPR_EXT1			_0x01C5.b3_2.b3_2
#define IPR_EXT0			_0x01C5.b1_0.b1_0

//==========================
//			IPR6
//==========================
#define IPR6       			_0x01C6.byte
#define IPR_ADC				_0x01C6.b1_0.b1_0

//==========================
//			IPR7
//==========================
#define IPR7       			_0x01C7.byte
#define IPR_FMC				_0x01C7.b3_2.b3_2

//==========================
//			IPR8
//==========================
#define IPR8       			_0x01C8.byte

//==========================
//			IPR9
//==========================
#define IPR9       			_0x01C9.byte
#define IPR_DIC				_0x01C9.b7_6.b7_6

//==========================
//			IPR10
//==========================
#define IPR10      			_0x01CA.byte
#define IPR_EXT4			_0x01CA.b7_6.b7_6

//==========================
//			IPR11
//==========================
#define IPR11      			_0x01CB.byte
#define IPR_MAC				_0x01CB.b7_6.b7_6
#define IPR_EXT7			_0x01CB.b5_4.b5_4
#define IPR_EXT6			_0x01CB.b3_2.b3_2
#define IPR_EXT5			_0x01CB.b1_0.b1_0

//==========================
//			IPR12
//==========================
#define IPR12      			_0x01CC.byte
#define IPR_TCA3			_0x01CC.b5_4.b5_4
#define IPR_TCA2			_0x01CC.b3_2.b3_2

//==========================
//			IPR13
//==========================
#define IPR13      			_0x01CD.byte
#define IPR_UART1_TX		_0x01CD.b7_6.b7_6
#define IPR_UART1_RX		_0x01CD.b5_4.b5_4

//==========================
//			IPR14
//==========================
#define IPR14      			_0x01CE.byte
#define IPR_SIO1			_0x01CE.b3_2.b3_2
#define IPR_I2C1			_0x01CE.b1_0.b1_0

//==========================
//			IPR15
//==========================
#define IPR15      			_0x01CF.byte

//==========================
//			IPR16
//==========================
#define IPR16      			_0x01D0.byte
#define IPR_TCA4			_0x01D0.b7_6.b7_6

//==========================
//			IPR17
//==========================
#define IPR17      			_0x01D1.byte

#define IPR_TCA5			_0x01D1.b1_0.b1_0

//==========================
//			IPR18
//==========================
#define IPR18      			_0x01D2.byte
#define IPR_UART2_TX2		_0x01D2.b3_2.b3_2
#define IPR_UART2_RX2		_0x01D2.b1_0.b1_0

//==========================
//			IPR19
//==========================
#define IPR19      			_0x01D3.byte

//==========================
//			IPR20
//==========================
#define IPR20      			_0x01D4.byte

#define IPR_TCA7			_0x01D4.b7_6.b7_6
#define IPR_TCA6			_0x01D4.b5_4.b5_4

//==========================
//			IPR21
//==========================
#define IPR21      			_0x01D5.byte

//==========================
//			IPR22
//==========================
#define IPR22      			_0x01D6.byte

//==========================
//			IPR23
//==========================
#define IPR23      			_0x01D7.byte


//==========================
//			ADCCR0
//==========================
#define ADCCR0				_0x0300.byte
#define ADCCR0_AMD			_0x0300.b7_6.b7_6
#define ADCCR0_AUTOPD		_0x0300.bit.b5
#define ADCCR0_INTLV		_0x0300.bit.b4
#define ADCCR0_INTEN		_0x0300.bit.b3
#define ADCCR0_IRFEN		_0x0300.b2_1.b2_1
#define ADCCR0_ADEN			_0x0300.bit.b0

//==========================
//			ADCCR1
//==========================
#define ADCCR1				_0x0301.byte
#define ADCCR1_EVSEL		_0x0301.b7_4.b7_4

//==========================
//			ADCCR2
//==========================
#define ADCCR2				_0x0302.byte
#define ADCCR2_LVINTEN		_0x0302.bit.b0
 
//==========================
//			ADCCKDIV
//==========================
#define ADCCKDIV			_0x0304.byte
#define ADCCKDIV_CKDIV		_0x0304.byte
#define ADCCKDIV_ADCKDIV	_0x0304.b3_0.b3_0
  
//==========================
//			ADCLV
//==========================
#define ADCLV    			_0x0306.byte
#define ADCLV_LVCMP			_0x0306.b7_6.b7_6
#define ADCLV_LVINTVL		_0x0306.bit.b5
#define ADCLV_LVSEL			_0x0306.b4_0.b4_0

//==========================
//			ADCSCAN0
//==========================
#define ADCSCAN0			_0x0307.byte
#define ADCSCAN0_ADCSCAN	_0x0307.byte

//==========================
//			ADCSCAN1
//==========================
#define ADCSCAN1			_0x0308.byte
#define ADCSCAN1_ADCSCAN	_0x0308.byte


//==========================
//			ADCSR
//==========================
#define ADCSR				_0x030A.byte
#define ADCSR_EOCF			_0x030A.bit.b7
#define ADCSR_ADBF			_0x030A.bit.b6
#define ADCSR_ADRDY         _0x030A.bit.b5
#define ADCSR_BUFOVR		_0x030A.bit.b3
#define ADCSR_UNLCK			_0x030A.bit.b2
#define ADCSR_LVDET			_0x030A.bit.b1
#define ADCSR_ADRS			_0x030A.bit.b0

//==========================
//			ADCCHRDY
//==========================
#define ADCCHRDY			_0x030B.byte
#define ADCCHRDY_CHRDY		_0x030B.b4_0.b4_0

//==========================
//			ADCCHSEL
//==========================
#define ADCCHSEL			_0x030C.byte
#define ADCCHSEL_CHSEL		_0x030C.b4_0.b4_0

//==========================
//			ADCDR  
//==========================
#define ADCDR				_0x0310.word
#define ADCDRL				_0x0310.byte[0]
#define ADCDRL_ADCDRL		_0x0310.byte[0]
#define ADCDRH				_0x0310.byte[1]
#define ADCDRH_ADCDRH		_0x0310.blst8_byte[1].b3_0.b3_0

//==========================
//			ADCLLV
//==========================
#define ADCLLV				_0x0312.word
#define ADCLLVL				_0x0312.byte[0]
#define ADCLLVL_ADCLLVL		_0x0312.byte[0]
#define ADCLLVH				_0x0312.byte[1]
#define ADCLLVH_ADCLLVH		_0x0312.blst8_byte[1].b3_0.b3_0

//==========================
//			ADCHLV
//==========================
#define ADCHLV 				_0x0314.word
#define ADCHLVL				_0x0314.byte[0]
#define ADCHLVL_ADCHLVL		_0x0314.byte[0]
#define ADCHLVH				_0x0314.byte[1]
#define ADCHLVH_ADCHLVH		_0x0314.blst8_byte[1].b3_0.b3_0


//==========================
//			CRCCR0
//==========================
#define CRCCR0              _0x0850.byte
#define CRCCR0_DATARDY      _0x0850.bit.b7
#define CRCCR0_SETONE       _0x0850.bit.b1
#define CRCCR0_CRCEN        _0x0850.bit.b0

//==========================
//			CRCCR1
//==========================
#define CRCCR1              _0x0851.byte

//==========================
//			CRCDI
//==========================
#define CRCDI              _0x0858.byte

//==========================
//			CRCDO0
//==========================
#define CRCDO0              _0x085C.byte

//==========================
//			CRCDO1
//==========================
#define CRCDO1              _0x085D.byte


//==========================
//			DICCR
//==========================
#define DICCR               _0x0860.byte
#define DICCR_DONE          _0x0860.bit.b7
#define DICCR_DICIE         _0x0860.bit.b4
#define DICCR_DICEN         _0x0860.bit.b0

//==========================
//			DICCNT0
//==========================
#define DICCNT0              _0x0862.byte

//==========================
//			DICCNT1
//==========================
#define DICCNT1              _0x0863.byte

//==========================
//			DICADR0
//==========================
#define DICADR0              _0x0864.byte

//==========================
//			DICCR
//==========================
#define DICADR1              _0x0865.byte

//==========================
//			DICCR
//==========================
#define DICADR2              _0x0866.byte

//==========================
//			DICCR
//==========================
#define DICADR3              _0x0867.byte






//==========================
//			MACCR0
//==========================
#define MACCR0          	_0x0870.byte
#define MACCR0_MODE     	_0x0870.b7_4.b7_4
#define MACCR0_SIGN     	_0x0870.bit.b2
#define MACCR0_SAT      	_0x0870.bit.b1
#define MACCR0_INTEN    	_0x0870.bit.b0
//==========================
//			MACCR1
//==========================
#define MACCR1          	_0x0871.byte
#define MACCR1_DIVERR   	_0x0871.bit.b7
#define MACCR1_INTF     	_0x0871.bit.b6
#define MACCR1_OF       	_0x0871.bit.b5
#define MACCR1_CF       	_0x0871.bit.b4
#define MACCR1_CLEARC   	_0x0871.bit.b3
#define MACCR1_CLEARB   	_0x0871.bit.b2
#define MACCR1_CLEARA   	_0x0871.bit.b1
#define MACCR1_START    	_0x0871.bit.b0
//==========================
//			MACA0
//==========================
#define MACA0            	_0x0874.byte
//==========================
//			MACA1
//==========================
#define MACA1            	_0x0875.byte
//==========================
//			MACA2
//==========================
#define MACA2            	_0x0876.byte

//==========================
//			MACA3
//==========================
#define MACA3            	_0x0877.byte

//==========================
//			MACB0
//==========================
#define MACB0            	_0x0878.byte

//==========================
//			MACB1
//==========================
#define MACB1            	_0x0879.byte

//==========================
//			MACB2
//==========================
#define MACB2            	_0x087A.byte

//==========================
//			MACB3
//==========================
#define MACB3            	_0x087B.byte

//==========================
//			MACC0
//==========================
#define MACC0            	_0x087C.byte

//==========================
//			MACC1
//==========================
#define MACC1            	_0x087D.byte

//==========================
//			MACC2
//==========================
#define MACC2            	_0x087E.byte

//==========================
//			MACC3
//==========================
#define MACC3            	_0x087F.byte

//==========================
//			MACC4
//==========================
#define MACC4            	_0x0880.byte

#endif

