//SQ7615_I2C0_Master_EEPROM_24C08 example

//*************************************************************************************
// file			: main.c
// version		: V3.3 2020/09/03
// brief		: main program
// description	: 24C08 R/W  example
//			  you can use the IDE to set breakpoints to observe Data Write and Data Read sequence results
// note			: 
//			  1. SDA0(P0.5) connects to 24C08 SDA Pin, 
//				 SCL0(P0.6) connects to 24C08 SCL Pin, 
//	             *the above SDA and SCL must be connected with external pull-up resistors
//            2.
//				 [LED Configuration] LED 1  (P2.0)
//				 [LED Configuration] LED 2  (P2.1)
//				 [LED Configuration] LED 3  (P2.2)
//
//            3. all LEDs will light on during writing data to AT24C08
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
unsigned char      iloop;
unsigned char      wBuf[16];  // transmitted data buffer
unsigned char      rBuf[16];  // received data buffer

// initial data in EEPROM
unsigned char      wBufFF[] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
							     0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
							 
/* ----------------------- main program --------------------------- */
void main()
{
  /* ---------------------- system initialization ------------------------ */
	PLLCR0_PLLEN  = 1;                     	  // enable PLL
	while(PLLCR0_PLLRDY ==0);				  // wait for PLL to be ready
	CLKCR0_SCKPSC = 1;                        // system frequency divided by 2   (48M/2=24MHz) 
    CLKCR0_SCKSRC = 1;                        // switch clock source to PLL
	while(CLKCR0_SCKRDY ==0);				  // wait for system clock to be ready
	
	Delay_Loop_Init();                        // initialize the delay loop
                                              // need to initialize before to use any delay loop functions

  /* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x07;                             // set P2.0, P2.1 and P2.2 as output pins
    P3OE  = 0x00;                             // set P3.1, P3.2 and P3.3 as input pins
	P3PU |= 0x07;                       	  // enable P3.1, P3.2 and P3.3 built-in pull-up resistors

	LED1_to_LED3_turn_off;                    // light off all LEDs

  /* ---------------------------------------------------------- */
	// initial write buffer data value
    for( iloop=0; iloop<16; iloop++ ){
        wBuf[iloop] = 0x10+iloop;
	}
  /* ---------------------- I2C0 initialization ------------------------ */ 
    I2C0_Init();		                      // set I2C0 to master mode
    
  //----------------------------------------------------------------

  // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
  //  Master Operation                                                         //
  // * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
    
    // Write Sequence FF
    // initial data in EEPROM
    
        LED1_to_LED3_turn_on;                           // light on all LEDs
        delay_ms(100);
		
		I2C0_Start(0xa0,0x00);				            // set I2C0 to master mode and I2C0 generate the start condition 
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        
        // write 16-byte data of wBufFF to AT24C08 from address 0x00
        I2C0_Bytes_Write(wBufFF, 16);
        I2C0_Stop();						            // I2C0 generate the stop condition
        
        delay_ms(6);                                    // wait AT24C08A pgm time >5ms...
      
        LED1_to_LED3_turn_off;                          // light off all LEDs
        __asm("NOP");					                // no operation, the breakpoint is located here

    //-------------------------------------------------------------------------------------
	// Read Sequence
    //  read 16-byte data from AT24C08 and start address is 0x00
    
        I2C0_Start(0xa0,0x00);				            // set I2C0 to master mode and I2C0 generate the start condition  	
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        I2C0_ReStart(0xa0);          		            // I2C0 generate the restart condition

        // read 16-byte data to rBuf
        I2C0_Bytes_Read(rBuf, 16);
        I2C0_Stop();						            // I2C0 generate the stop condition
        
        __asm("NOP");					                // no operation
        __asm("NOP");
        __asm("NOP");
        __asm("NOP");
        __asm("NOP");					                // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
    // Write Sequence
    //  write 3-byte data of wBuf to AT24C08 from address 0x00
    
        LED1_to_LED3_turn_on;                           // light on all LEDs
        delay_ms(100);
        
        I2C0_Start(0xa0,0x00);				            // set I2C0 to master mode and I2C0 generate the start condition     
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address

        // write 3-byte data of wBuf to AT24C08 from address 0x00
        I2C0_Bytes_Write(wBuf, 3);
        I2C0_Stop();						            // I2C0 generate the stop condition

        delay_ms(6);                                    // wait AT24C08A pgm time >5ms...
        
        LED1_to_LED3_turn_off;                          // light off all LEDs 
        __asm("NOP");					                // no operation, the breakpoint is located here
	
	//-------------------------------------------------------------------------------------
    // Read Sequence
    // read 16-byte data from AT24C08 and start address is 0x00
    
        I2C0_Start(0xa0,0x00);			                // set I2C0 to master mode and I2C0 generate the start condition   
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        I2C0_ReStart(0xa0);          		            // I2C0 generate the restart condition
		
        // read 16-byte data to rBuf
        I2C0_Bytes_Read(rBuf, 16);
        I2C0_Stop();						            // I2C0 generate the stop condition
        
        __asm("NOP");					                // no operation
        __asm("NOP");					         
        __asm("NOP");					         
        __asm("NOP");					         
        __asm("NOP");					                // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
    // Write Sequence
    // write data of wBuf to AT24C08 from address 0x06
    
        LED1_to_LED3_turn_on;                           // light on all LEDs
        delay_ms(100);
		
        I2C0_Start(0xa0,0x06);			                // set I2C0 to master mode and I2C0 generate the start condition   
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x06: slave start address

        // write 2-byte data of wBuf to AT24C08 from address 0x06
        I2C0_Bytes_Write(wBuf, 2);
        I2C0_Stop();						            // I2C0 generate the stop condition

        delay_ms(6);                                    // wait AT24C08A pgm time >5ms...
        
        LED1_to_LED3_turn_off;                          // light off all LEDs
        __asm("NOP");					                // no operation, the breakpoint is located here
    
	//-------------------------------------------------------------------------------------
    // Read Sequence
    // read 16-byte data from AT24C08 and start address is 0x00
    
        I2C0_Start(0xa0,0x00);			                // set I2C0 to master mode and I2C0 generate the start condition   
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x00: slave start address
        I2C0_ReStart(0xa0);          	                // I2C0 generate the restart condition
        
        // read 16-byte data to rBuf
        I2C0_Bytes_Read(rBuf, 16);
        I2C0_Stop();	                                // I2C0 generate the stop condition
        __asm("NOP");					                // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------
    // Read Sequence
    // read data from AT24C08 and start address is 0x05
    
        I2C0_Start(0xa0,0x05);			                // set I2C0 to master mode and I2C0 generate the start conditionʹ1ֽ(1byte)(0x05)   
        //..........| 0xa0: slave Device ID (AT24C08 EEPROM)
        //................| 0x05: slave start address
        I2C0_ReStart(0xa0);          	                // I2C0 generate the restart condition

        // read 10-byte data from AT24C08 and start address is 0x05
        I2C0_Bytes_Read(rBuf, 10);
        I2C0_Stop();                                    // I2C0 generate the stop condition
        __asm("NOP");					                // no operation, the breakpoint is located here

	//-------------------------------------------------------------------------------------

    while(1){
        CLR_WDT;						                // clear the watchdog timer 
    }
	
	

}



/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)              // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7615 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	OnlyReti,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	OnlyReti,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	OnlyReti,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7615 interrupt vector ---------------------- */

