//SQ7615_DVO example
//*************************************************************************************
// file			: main.c
// version		: V3.2
// brief		: main program
// description	: in this example, DVOB output pin is P4.7 and default DVOB output frequency is 3.906 KHz and LED1 (P2.0) light on
//			  1. press button 1 : BTN1_in(P3.0), stop DVOB output and light off all LEDs
//            2. press button 2 : BTN2_in(P3.1), set next output frequency and start DVOB output
//			  3. press button 3 : BTN3_in(P3.2), set last output frequency and start DVOB output
//
//			  there are 4 kinds of DVOB output frequency, this example:
//			  Freq_Out_Case = 1, DVOB output frequency is  3.906 KHz  LED1  (P2.0) light on
//			  Freq_Out_Case = 2, DVOB output frequency is  7.812 KHz  LED2  (P2.1) light on
//			  Freq_Out_Case = 3, DVOB output frequency is 15.625 KHz  LED3  (P2.2) light on
//			  Freq_Out_Case = 4, DVOB output frequency is 31.25  KHz  LED4  (P2.4) light on
//  
// note			: [Button Configuration]
//	 					 button 1 :	 BTN1_in(P3.0)
//						 button 2 :  BTN2_in(P3.1)
//						 button 3 :  BTN3_in(P3.2)
//
//			  [LED Configuration]	 
//						 LED1  (P2.0)
//			  			 LED2  (P2.1)
//			  			 LED3  (P2.2)
// 						 LED4  (P2.4)
//**************************************************************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "main.h"

/* ---------------------- global variables -------------------------- */
static unsigned char Main_State;
unsigned char Index;

unsigned char Freq_Out_Case;

const DVOB_FREQ_MODE DVOB_Freq_Mode[4]={
	  DVOB_fcgck_DIV_4096,                                            
	  DVOB_fcgck_DIV_2048,
      DVOB_fcgck_DIV_1024,	
	  DVOB_fcgck_DIV_512
};
//---------------------------------------------------------------

void Freq_Out_Case_Satus_LED(){  // according to the DVOB output frequency case, light on the corresponding case LED light number
	if(DVOCR_DVOEN == 0){
	   P2DO = 0xFF; // light off all LEDs
	}
	else if(DVOCR_DVOEN){
	        if(Freq_Out_Case==1){
			__ASM("NOP");    // no operation
				P2DO = 0xFE; // 1111 1110   LED1  (P2.0) light on
			}
			else if(Freq_Out_Case==2){
			__ASM("NOP");    // no operation	

				P2DO = 0xFD; //  1111 1101  LED2  (P2.1) light on 
			}
			else if(Freq_Out_Case==3){
			__ASM("NOP");    // no operation	
				P2DO = 0xFB; //  1111 1011  LED3  (P2.2) light on
			}							
			else if(Freq_Out_Case==4){
			__ASM("NOP");    // no operation	
				P2DO = 0xE7; //  1110 1111  LED4  (P2.4) light on
			}
	}

}



/* ----------------------- main program --------------------------- */
void main()
{
/* ---------------------- system initialization ------------------------ */
	CLKCR1_HIRCEN  = 1;                     // enable HIRC
	while(CLKCR1_HIRCRDY ==0);				// wait for HIRC to be ready
	CLKCR0_SCKPSC = 0x00;                   // system frequency divided by 1   (16M/1=16MHz) 
 	CLKCR0_SCKSRC = 0;                      // switch system clock source to HIRC
	while(CLKCR0_SCKRDY ==0);				// wait for system clock to be ready
/* ---------------------- pin configuration initialization ------------------------ */
    P2OE  = 0x17;                        	// set P2.0, P2.1, P2.2 and P2.4 as output pins
    P3OE  = 0x00;                        	// set P3.1, P3.2 and P3.3 as input pins
	P3PU |= 0x07;                       	// enable P3.1, P3.2 and P3.3 built-in pull-up resistors
	LED1_out = 1;							// set LED1 to the light off
	LED2_out = 1;							// set LED2 to the light off
	LED3_out = 1;							// set LED3 to the light off
	LED4_out = 1;							// set LED4 to the light off
/* ---------------------- EINT initialization ------------------------ */
	EINT_Init();                        	// initialize EINT
	EINT_IntEnable();                   	// enable external interrupt	
/* ---------------------- DVOB initialization and startup ----------------- */
	DVOB_Init();							// initialize DVOB
	DVOB_Start();							// start DVOB output
	
	if(DVOCR_DVOEN){
	LED1_out = 0;							// light on LED1
	Index = 1;
	Freq_Out_Case = 1;
	}
	//----------------------------------------------------------
	Main_State = STATE_WAIT_KEY;			// default state to wait for key press
	//----------------------------------------------------------
    while(1){
        switch(Main_State){
			case STATE_WAIT_KEY:			    	  	  // wait for key press 

					if(Push_BTN1_Flag){					  // if external interrupt flag of button is 1
						Push_BTN1_Flag = 0; 	  		  // set external interrupt flag of button 1 to 0				
							DVOB_Stop();  				  // stop DVOB
							
							if(DVOCR_DVOEN == 0){
								LED1_out = 1;
								LED2_out = 1;
								LED3_out = 1;
								LED4_out = 1;
							}
							Main_State = STATE_WAIT_KEY;		
					}
					
					else if(Push_BTN2_Flag){	
						Push_BTN2_Flag = 0; 	  		  // clear external interrupt flag of button 2
						DVOB_Stop();  				  	  // stop DVOB
						Index++;
						__ASM("NOP");					  // no operation
						
						if(Index > DVOB_fcgck_DIV_512)	  
						Index = DVOB_fcgck_DIV_4096;   
						Freq_Out_Case = DVOB_Freq_Mode[Index-1];
						
						
						Main_State = STATE_SET_FREQ;
						DVOB_Start();
						__ASM("NOP");				      // no operation
					}			
					
					else if(Push_BTN3_Flag){	
						Push_BTN3_Flag = 0; 	  		  // clear external interrupt flag of button 3
						DVOB_Stop();  				      // stop DVOB
				
						if (Index!=0){
							Index--;
						}
						else{
							Index =1;
						
						}
						__ASM("NOP");					  // no operation
						
                		if(Index < DVOB_fcgck_DIV_4096)						
                		Index = DVOB_fcgck_DIV_512;
  						Freq_Out_Case = DVOB_Freq_Mode[Index-1];
						
						
						Main_State = STATE_SET_FREQ;
						DVOB_Start(); 		   						   
					}
					__ASM("NOP");				          // no operation
			break;
			
			//-------------------------------------------------------------------
			case STATE_SET_FREQ:				      	  // select output frequency
			switch(Freq_Out_Case){
					case DVOB_fcgck_DIV_4096:  			  // set DVOB output frequency to fsysclk/4096, it's about 3.906 KHz
						TBTCR_DV9CK = 0;
						DVOCR_DVOCK = 0;
					    Freq_Out_Case_Satus_LED();		  // according to the DVOB output frequency case, light on the corresponding case LED light number
					break;

				    case DVOB_fcgck_DIV_2048:  			  // set DVOB output frequency to fsysclk/2048, it's about 7.812 KHz
						TBTCR_DV9CK = 0;
						DVOCR_DVOCK = 1;
						Freq_Out_Case_Satus_LED();		  // according to the DVOB output frequency case, light on the corresponding case LED light number
					break;
	
					case DVOB_fcgck_DIV_1024:  			  // set DVOB output frequency to fsysclk/1024, it's about 15.625 KHz
						TBTCR_DV9CK = 0;
						DVOCR_DVOCK = 2;
						Freq_Out_Case_Satus_LED();		  // according to the DVOB output frequency case, light on the corresponding case LED light number
					break;

					case DVOB_fcgck_DIV_512:  			  // set DVOB output frequency to fsysclk/512, it's about 31.25  KHz
						TBTCR_DV9CK = 0;
						DVOCR_DVOCK = 3;
						Freq_Out_Case_Satus_LED();		  // according to the DVOB output frequency case, light on the corresponding case LED light number
					break;
   					
					default:
					TBTCR_DV9CK = 0;
					DVOCR_DVOCK = 0;
					Freq_Out_Case_Satus_LED();		      // according to the DVOB output frequency case, light on the corresponding case LED light number					
					
					break;	
			}	
            Main_State = STATE_WAIT_KEY_RELEASE;				
			break;
			
			//-------------------------------------------------------------------
			case STATE_WAIT_KEY_RELEASE:				  // button released
				if((P3DI & 0x07) == 0x07){  			  // wait for button released
				__ASM("NOP");							  // no operation
				Main_State = STATE_WAIT_KEY;			  // return to wait for key press	
				}		
		    break;  
// 			
			default:
			break;		
		}	
    }
	
	
	
	
}




/* ---------------------- interrupt service routine ------------------------ */
void __interrupt OnlyReti(void)
{
	__asm("NOP"); 							  // no operation
}

void __interrupt_n OnlyRetn(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntWDT(void)
{
	__asm("NOP");							  // no operation
}

void __interrupt_n IntSWI(void)               // software reset interrupt service routine
{
	PRSTR7 = 0x5a;
	PRSTR7 = 0xa5;
	PRSTR7 = 0xc3;
	PRSTR7 = 0x3c;	
}
/* ------------------- end of interrupt service routine ---------------------- */


/* -------------------- SQ7615 interrupt vector ------------------ */
#pragma section const INT_VECTOR1 0xff40
void * const IntTbl1[] = {											
	OnlyReti,				/* 0xff40 : Reserved		*/									
	OnlyReti,				/* 0xff42 : Reserved		*/									
	OnlyReti,				/* 0xff44 : Reserved		*/									
	OnlyReti,				/* 0xff46 : Reserved		*/								
	OnlyReti,				/* 0xff48 : Reserved		*/									
	OnlyReti,				/* 0xff4a : Reserved		*/									
	OnlyReti,				/* 0xff4c : Reserved		*/									
	OnlyReti,				/* 0xff4e : Reserved		*/									
	OnlyReti,				/* 0xff50 : Reserved		*/									
	OnlyReti,				/* 0xff52 : Reserved		*/									
	OnlyReti,				/* 0xff54 : Reserved		*/									
	OnlyReti,				/* 0xff56 : Reserved		*/									
	OnlyReti,				/* 0xff58 : IntTCA7			*/	//interrupt source:TCA7 16-bit timer								
	OnlyReti,				/* 0xff5a : IntTCA6			*/	//interrupt source:TCA6 16-bit timer							
	OnlyReti,				/* 0xff5c : Reserved		*/									
	OnlyReti,				/* 0xff5e : Reserved		*/									
	OnlyReti,				/* 0xff60 : Reserved		*/									
	OnlyReti,				/* 0xff62 : Reserved		*/									
	OnlyReti,				/* 0xff64 : Reserved		*/									
	OnlyReti,				/* 0xff66 : Reserved		*/									
	OnlyReti,				/* 0xff68 : Reserved		*/									
	OnlyReti,				/* 0xff6a : Reserved		*/									
	OnlyReti,				/* 0xff6c : IntTX2			*/	//interrupt source:UART2 TX2								
	OnlyReti,				/* 0xff6e : IntRX2			*/	//interrupt source:UART2 RX2							
	OnlyReti,				/* 0xff70 : Reserved		*/									
	OnlyReti,				/* 0xff72 : Reserved		*/									
	OnlyReti,				/* 0xff74 : Reserved		*/									
	OnlyReti,				/* 0xff76 : IntTCA5			*/	//interrupt source:TCA5 16-bit timer								
	OnlyReti,				/* 0xff78 : IntTCA4			*/	//interrupt source:TCA4 16-bit timer								
	OnlyReti,				/* 0xff7a : Reserved		*/									
	OnlyReti,				/* 0xff7c : Reserved		*/									
	OnlyReti,				/* 0xff7e : Reserved		*/									
	OnlyReti,				/* 0xff80 : Reserved		*/									
	OnlyReti,		    	/* 0xff82 : Reserved		*/									
	OnlyReti,	    		/* 0xff84 : Reserved		*/									
	OnlyReti,				/* 0xff86 : Reserved		*/									
	OnlyReti,				/* 0xff88 : Reserved		*/									
	OnlyReti,				/* 0xff8a : Reserved		*/									
	OnlyReti,				/* 0xff8c : IntSIO1			*/	//interrupt source:SIO 1								
	OnlyReti,				/* 0xff8e : IntI2C1			*/	//interrupt source:I2C1						
	OnlyReti,				/* 0xff90 : IntTX1			*/	//interrupt source:UART1 TX1							
	OnlyReti,				/* 0xff92 : IntRX1			*/	//interrupt source:UART1 RX1								
	OnlyReti,				/* 0xff94 : Reserved		*/									
	OnlyReti,				/* 0xff96 : Reserved		*/									
	OnlyReti,				/* 0xff98 : Reserved		*/									
	OnlyReti,				/* 0xff9a : IntTCA3			*/	//interrupt source:TCA3 16-bit timer							
	OnlyReti,				/* 0xff9c : IntTCA2			*/	//interrupt source:TCA2 16-bit timer								
	OnlyReti,				/* 0xff9e : Reserved		*/									
	OnlyReti,				/* 0xffa0 : IntMAC			*/	//interrupt source:multiplier								
	OnlyReti,				/* 0xffa2 : IntEXT7			*/	//external interrupt7								
	OnlyReti,				/* 0xffa4 : IntEXT6			*/	//external interrupt6								
	OnlyReti,				/* 0xffa6 : IntEXT5			*/	//external interrupt5								
	OnlyReti,				/* 0xffa8 : IntEXT4			*/	//external interrupt4								
	OnlyReti,				/* 0xffaa : Reserved		*/									
	OnlyReti,				/* 0xffac : Reserved		*/									
	OnlyReti,				/* 0xffae : Reserved		*/							
	OnlyReti,				/* 0xffb0 : IntDIC			*/	//interrupt source:DIC								
	OnlyReti,				/* 0xffb2 : Reserved		*/							
	OnlyReti,				/* 0xffb4 : Reserved		*/									
	OnlyReti,				/* 0xffb6 : Reserved		*/									
	OnlyReti,				/* 0xffb8 : Reserved		*/									
	OnlyReti,				/* 0xffba : Reserved		*/									
	OnlyReti,				/* 0xffbc : Reserved		*/									
	OnlyReti,				/* 0xffbe : Reserved		*/									
	OnlyReti,				/* 0xffc0 : Reserved		*/									
	OnlyReti,				/* 0xffc2 : Reserved		*/									
	OnlyReti,				/* 0xffc4 : IntFMC			*/	//interrupt source:flash memory controller								
	OnlyReti,				/* 0xffc6 : Reserved		*/					
	OnlyReti,				/* 0xffc8 : Reserved		*/									
	OnlyReti,				/* 0xffca : Reserved		*/									
	OnlyReti,				/* 0xffcc : Reserved		*/									
	OnlyReti,               /* 0xffce : IntADC			*/	//interrupt source:ADC								
	OnlyReti,				/* 0xffd0 : IntEXT3			*/	//external interrupt3								
	IntEXT2,				/* 0xffd2 : IntEXT2			*/	//external interrupt2								
	IntEXT1,				/* 0xffd4 : IntEXT1			*/	//external interrupt1								
	IntEXT0,				/* 0xffd6 : IntEXT0			*/	//external interrupt0								
	OnlyReti,				/* 0xffd8 : IntSIO0			*/	//interrupt source:SIO 0								
	OnlyReti,				/* 0xffda : IntI2C0			*/	//interrupt source:I2C0								
	OnlyReti,				/* 0xffdc : IntTX0			*/	//interrupt source:UART0 TX0								
	OnlyReti,				/* 0xffde : IntRX0			*/	//interrupt source:UART0 RX0								
	OnlyReti,				/* 0xffe0 : Reserved		*/									
	OnlyReti,				/* 0xffe2 : Reserved		*/									
	OnlyReti,				/* 0xffe4 : Reserved		*/									
	OnlyReti,				/* 0xffe6 : IntTCA1			*/	//interrupt source:TCA1 16-bit timer								
	OnlyReti,				/* 0xffe8 : IntTCA0			*/	//interrupt source:TCA0 16-bit timer								
	OnlyReti,				/* 0xffea : Reserved		*/									
	OnlyReti,				/* 0xffec : Reserved		*/									
	OnlyReti,			    /* 0xffee : IntRTC			*/	//interrupt source:real-time clock timer								
	OnlyReti,				/* 0xfff0 : IntTBT			*/  //interrupt source:time base timer				
	OnlyReti,				/* 0xfff2 : Reserved		*/									
	OnlyReti,				/* 0xfff4 : IntCFD			*/	//interrupt source:clock fail detection								
	OnlyReti,				/* 0xfff6 : IntLVD			*/	//interrupt source:low voltage detection							
	IntWDT,					/* 0xfff8 : IntWDT			*/	//non-maskable interrupt source:watchdog timer		
	(void *)0xffff,			/* 0xfffa : Reserved		*/									
	IntSWI,					/* 0xfffc : IntSWI/INTUNDEF */	//non-maskable		
	STARTUP					/* 0xfffe : RESET			*/	//non-maskable			
};
#pragma section const
/* ------------------- end of SQ7615 interrupt vector ---------------------- */

