//*************************************************************************************
// file			: SQ7615_DIC.h
// version		: V3.1
// brief		: DIC header file
// note			: 
//**************************************************************************************
#ifndef _SQ7615_DIC_H__
#define _SQ7615_DIC_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char dic_crc[4];					// array to keep the crc checksum for sequence 1
extern unsigned char dic_crc_check[4];			// array to keep the crc checksum for sequence 2

// Source address
extern unsigned char in_addr_sram[4];
extern unsigned char in_addr_flash[4];
extern unsigned char in_addr_rom[4];
extern unsigned char dic_result;

/* ---------------------- user-defined macros ------------------------------ */





//------------------------------------------------------------------
void DIC_Setup();										// setup DIC
void DIC_Get_result(unsigned char  *dic_data);		// get DIC result
unsigned char DIC_Done(void);							// check DIC to finish
void DIC_Init(unsigned char *src, size_t length);	// DIC initialization
void DIC_Disable(void);								// disable DIC

unsigned char Cmp_CRC(unsigned char *crc1, unsigned char *crc2);// compare 2 CRC results 
void __interrupt IntDIC(void);							// DICinterrupt service routine

#endif

