//*************************************************************************************
// file			: SQ7615_DIC.c
// version		: V3.1
// brief		: DIC related functions
// note			: DIC related functions are gathered in this subroutine
//**************************************************************************************
#include "main.h"

// array to keep the crc checksum for sequence 1
unsigned char dic_crc[4];				   	// first DIC result
// array to keep the crc checksum for sequence 2
unsigned char dic_crc_check[4];			// second DIC result

// Source address
unsigned char in_addr_sram[4]  = {0x00, 0x01, 0x80, 0x00};    // Skip the first 256 bytes of sram, due to the definition for near_area 
unsigned char in_addr_flash[4] = {0x00, 0x00, 0x40, 0x00};
unsigned char in_addr_rom[4]   = {0x00, 0x00, 0x00, 0x00};

unsigned char dic_result;					// The DIC Result from cmp_crc


//*********************************************************************
// name			: DIC_Setup()
// brief		: setup DIC
// note			: Set up this DIC object for CRC with the specified parameters
//*********************************************************************
void DIC_Setup(unsigned char int_disable_enable)
{
    CRCCR0 = 0x00;         					// initialize CRC
    CRCCR1 = 0x02;         					// initialize CRC
    DICCR  = 0x00;          				// initialize DIC

}


//*********************************************************************
// name			: DIC_Get_result()
// brief		: get DIC result
// note			: dic_data Pointer to the 4 Bytes data for DIC.
//*********************************************************************
void DIC_Get_result(unsigned char  *dic_data)
{
	//read CRC calculation result
	dic_data[0] = CRCDO0;					//	need to read CRCDO0 first, then CRCDO1  
	dic_data[1] = CRCDO1;
	dic_data[2] = 0;						
	dic_data[3] = 0;							
}


//*********************************************************************
// name			: DIC_Done()
// brief		: check DIC to finish
// note			: 
//*********************************************************************
unsigned char DIC_Done()
{
	return(DICCR_DONE);					// 1: finished / 0: busy
	
}


//*********************************************************************
// name			: DIC_Init()
// brief		: DIC initialization
// note			: src Pointer to the data to check. 
//			  The length of the data to check in bytes.
//*********************************************************************
void DIC_Init(unsigned char *src, size_t length)
{
    CRCCR0 = 0x00;         					// initialize CRC
    CRCCR1 = 0x02;         					// initialize CRC
    DICCR  = 0x00;          				// initialize DIC
    CRCCR0 = 0x01;         					// start CRC	
	
    DICCNT0 = length & 0xff;				// set DIC data length (low byte)
    DICCNT1 = (length & 0xff00) >>8;;		// set DIC data length (high byte)

    // set DIC start address
    DICADR0 = src[0];
    DICADR1 = src[1];
    DICADR2 = src[2];
    DICADR3 = src[3];
	
    DICCR = 0x01;          					// start DIC
}


//*********************************************************************
// name			: DIC_Disable()
// brief		: disable DIC
// note			: Erase any sensitive information in this DIC object.
//*********************************************************************
void DIC_Disable()
{
	DICCR  = 0x00;							// stop DIC
	CRCCR1 = 0x00;
	CRCCR0 = 0x00;
}


//*********************************************************************
// name			: Cmp_CRC()
// brief		: compare 2 CRC results 
// note			:        
//*********************************************************************
unsigned char Cmp_CRC(unsigned char *crc1, unsigned char *crc2)
{
	unsigned char i;
	for(i=0;i<4;i++)
	{
		if(crc1[i] != crc2[i]) return(i+1);
	}
	
	return(0);
}


//*********************************************************************
// name			: __interrupt DIC()
// brief		: DICinterrupt service routine
// note			:
//*********************************************************************
void __interrupt IntDIC(void){
	__asm("NOP");							// no operation



}


