//*************************************************************************************
// file			: SQ7615_BROR.c
// version		: V3.1
// brief		: BROR related functions
// note			: BROR related functions are collected in this subroutine
//**************************************************************************************
#include "main.h"



//*********************************************************************
// name			: BROR_Init()
// brief		: BROR initialization program
// note			: set the BROR trigger level (VBROR)
//			  
//			  1_9V   	0x00    		// VBROR = 1.9V  +/-57   mV
//			  2_25V   	0x01    		// VBROR = 2.25V +/-67.5 mV
//			  2_55V   	0x02    		// VBROR = 2.55V +/-76.5 mV
//			  2_75V   	0x03    		// VBROR = 2.75V +/-82.5 mV
//*********************************************************************
void BROR_Init(unsigned char VBROR){
	PONCR_BRORCFG = VBROR;    			// set the BROR trigger level (VBROR)

}


//*********************************************************************
// name			: BROR_Start()
// brief		: BROR start BROR
// note			:
//*********************************************************************
void BROR_Start(){	
	PONCR_BROREN = 1;                   // start BROR
	
}


//*********************************************************************
// name			: BROR_Stop()
// brief		: stop BROR
// note			:
//*********************************************************************
void BROR_Stop(){
	PONCR_BROREN = 0;                  // stop BROR
	
}


