//*************************************************************************************
// file			: SQ7615_ADC_LVCMP.h
// version		: V1.0 2020/07/28
// brief		: ADC header file
// note			: 
//**************************************************************************************

#ifndef _SQ7615_ADC_LVCMP_H__
#define _SQ7615_ADC_LVCMP_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char ADC_Int_Flag;	        // ADC interrupt flag
extern unsigned char ADCLVCMP_Int_Flag;	    // interrupt flag of ADC if level comparison condition is met

/* ---------------------- user-defined macros ------------------------------ */

#define ADC_RefScale(x)  (x/4096)               // x fills in the value of uV

#define IRFEN_VDD         0x01
#define IRFEN_XREF        0x02

#define AMD_Stop          0x00
#define	AMD_Single        0x01
#define AMD_Repeat        0x03

#define EVSEL_ADRS        0x00
#define EVSEL_RTC_Alarm   0x01
#define EVSEL_RTC_Timer   0x02

#define EVSEL_TCA0        0x08
#define EVSEL_TCA2        0x09
#define EVSEL_TCA4        0x0A
#define EVSEL_EINT0       0x0C

#define CMP_Disable	      0x00
#define CMP_ADCLLV        0x01
#define CMP_ADCHLV        0x02
#define CMP_ADCL_BETWEEN  0x03

#define AIN0	       0x0
#define AIN1	       0x1
#define AIN2	       0x2
#define AIN3	       0x3
#define AIN4	       0x4
#define AIN5	       0x5
#define AIN6	       0x6
#define AIN7	       0x7

#define AIN8	       0x8
#define AIN9	       0x9
#define AIN10	       0xA
#define AIN11	       0xB

void ADC_Init();
void ADCLVLCMP_Init(unsigned char lvcmpsel);
void ADCLVLCMP_SetTh(uchar adcllv_Th,uchar adchlv_Th);
void ADC_Stop_and_Disable();
void ADC_IntEnable();
void ADC_IntDisable();
void ADCLVLCMP_IntEnable();

void ADC_Convert_Single();
char ADC_ConvertDone();
long ADC_Read_Value(unsigned char chsel);
void __interrupt IntADC(void);

#endif


