//*************************************************************************************
// file			: SQ7613_TCA.h
// version		: V1.2
// brief		: TCA header file
// note			:        
//**************************************************************************************
#ifndef _SQ7613_TCA_H__
#define _SQ7613_TCA_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned int captch_count;
extern unsigned int duty;
extern unsigned int period;
extern unsigned char TCA0_Int_Flag,TCA1_Int_Flag;


/* ---------------------- user-defined macros ------------------------------ */
#define d_10Hz_Count   1171   				// 1171*42.6667us = 0.05s, every 0.05s invert P2.4, so frequency is 10Hz
#define d_25Hz_Count   468
#define d_50hz_Count   234

#define TCA_count_scale 42    				// 1024/24 = 42.66 

//----------------------------------------------------------------
void TCA0_Timer_Init();						// TCA0 initialization to 16-bit timer mode
void TCA0_IntEnable();						// enable TCA0 interrupt
void TCA0_SetPeriod(unsigned int period);	// set timer counter
void TCA0_Start();							// start TCA0
void TCA0_Stop();							// stop TCA0

void TCA1_PulseMeasure_Init();				// TCA1 initialization to pulse width measurement mode
void TCA1_IntEnable();						// enable TCA1 interrupt
void TCA1_Start();							// start TCA1
void TCA1_Stop();							// stop TCA1
unsigned int TCA1_ReadSingleCapture();		// get the counter value of single edge capture mode
unsigned int TCA1_ReadDoubleCapture();		// get the counter value of double edge capture mode

void TCA5_PPG_Init();						// TCA5 initialization to PPG mode
void TCA5_Start();							// start TCA5
void TCA5_Stop();							// stop TCA5
void TCA5_SetDuty(unsigned int duty);		// set output duty cycle
void TCA5_SetPeriod(unsigned int period);	// set timer counter

void __interrupt IntTCA0(void);			// TCA0 interrupt service routine
void __interrupt IntTCA1(void);			// TCA1 interrupt service routine

#endif

