//*************************************************************************************
// file			: SQ7613_TCA0_16BIT_Timer.h
// version		: V1.1
// brief		: TCA0_16BIT_Timer header file [Only TCA0_Timer] 
// note			:        
//**************************************************************************************
#ifndef _SQ7613_TCA_H__
#define _SQ7613_TCA_H__

/* ---------------------- extern global variables ------------------------- */
extern unsigned char TCA0_Int_Flag;		// TCA0 interrupt flag



/* ---------------------- user-defined macros ------------------------------ */
#define d_10Hz_Count 1171   				// 1171*42.6667us = 0.05s, every 0.05s invert P2.4, so frequency is 10Hz
#define d_25Hz_Count 468
#define d_50hz_Count 234

//------------------------------------------------------------------
void TCA0_Timer_Init();					    // TCA0 initialization to 16-bit timer mode
void TCA0_IntEnable();					    // enable TCA0 interrupt
void TCA0_SetPeriod(unsigned int period); // set timer counter
void TCA0_Start();						    // start TCA0
void TCA0_Stop();						    // stop TCA0

void __interrupt IntTCA0(void);			// TCA0 interrupt service routine

#endif

