//*************************************************************************************
// file			: SQ7613_TCA0_16BIT_Timer.c
// version		: V1.1
// brief		: TCA0_16BIT_Timer related functions
// note			: TCA0_16BIT_Timer related functions are gathered in this subroutine [Only TCA0_Timer]
//**************************************************************************************
#include "main.h"

unsigned char TCA0_Int_Flag;				  // TCA0 interrupt flag

//*********************************************************************
// name			: TCA0_Timer_Init()
// brief		: TCA0 initialization to 16-bit timer mode
// note			: 
//*********************************************************************
void TCA0_Timer_Init(){
	
	PCKEN0_TCA0 = 1;                    	  // TCA0 Enable
	TA0MOD_TAM = 0x00;                  	  // set to 16-bit timer mode
	TA0MOD_TADBE    = 1;                	  // enable double buffer
    TA0MOD_TACK     = 0x00;                	  // set TCA0 source clock to fcgck/(2^10) = 24M/1024 = 23.437kHz => 42.6667us
	//TA0MOD_TACK     = 0x01;                 // set TCA0 source clock to fcgck/(2^6)
	//TA0MOD_TACK     = 0x02;                 // set TCA0 source clock to fcgck/(2^2)
	//TA0MOD_TACK     = 0x03;                 // set TCA0 source clock to fcgck/(2^1)

}


//*********************************************************************
// name			: TCA0_IntEnable()
// brief		: enable TCA0 interrupt
// note			: 
//*********************************************************************
void TCA0_IntEnable(){
	__ASM("DI");							  // disable all maskable interrupts
	
	IER_TCA0 = 1;                       	  // enable TCA0 interrupt
	//TA0CR_TAOVE = 0;                    	  // generate no TCA0 interrupt request when the counter overflow occurs
	TA0CR_TAOVE = 1;                    	  // generate a TCA0 interrupt request when the counter overflow occurs
	
	__ASM("EI");							  // enable all maskable interrupts
}


//*********************************************************************
// name			: TCA0_SetPeriod()
// brief		: set timer counter
// note			: 
//*********************************************************************
void TCA0_SetPeriod(unsigned int period){
	
 	TA0DRAL = period&0xFF;              	  // set timer counter
 	TA0DRAH = (period>>8)&0xFF;
	//TA0DRA = period;

}


//*********************************************************************
// name			: TCA0_Start()
// brief		: start TCA0
// note			: 
//*********************************************************************
void TCA0_Start(){
	
	TA0CR_TAS = 1;                      	  // start TCA0

}


//*********************************************************************
// name			: TCA0_Stop()
// brief		: stop TCA0
// note			: 
//*********************************************************************
void TCA0_Stop(){
	
	TA0CR_TAS = 0;                      	  // stop TCA0

}



//*********************************************************************
// name			: __interrupt IntTCA0()
// brief		: TCA0 interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTCA0(void){
	__asm("NOP");							  // no operation

	TCA0_Int_Flag = 1;						  // set TCA0_Int_Flag to 1
}

